% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gk.R
\name{dist_gk}
\alias{dist_gk}
\title{The g-and-k Distribution}
\usage{
dist_gk(A, B, g, k, c = 0.8)
}
\arguments{
\item{A}{Vector of A (location) parameters.}

\item{B}{Vector of B (scale) parameters. Must be positive.}

\item{g}{Vector of g parameters.}

\item{k}{Vector of k parameters. Must be at least -0.5.}

\item{c}{Vector of c parameters. Often fixed at 0.8 which is the default.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The g-and-k distribution is a flexible distribution often used to model univariate data.
It is particularly known for its ability to handle skewness and heavy-tailed behavior.
}
\details{
We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a g-k random variable with parameters
\code{A}, \code{B}, \code{g}, \code{k}, and \code{c}.

\strong{Support}: \eqn{(-\infty, \infty)}

\strong{Mean}: Not available in closed form.

\strong{Variance}: Not available in closed form.

\strong{Probability density function (p.d.f)}:

The g-k distribution does not have a closed-form expression for its density. Instead,
it is defined through its quantile function:

\deqn{
    Q(u) = A + B \left( 1 + c \frac{1 - \exp(-gz(u))}{1 + \exp(-gz(u))} \right) (1 + z(u)^2)^k z(u)
  }{
    Q(u) = A + B * (1 + c * ((1 - exp(-g * z(u))) / (1 + exp(-g * z(u))))) * (1 + z(u)^2)^k * z(u)
  }

where \eqn{z(u) = \Phi^{-1}(u)}, the standard normal quantile of u.

\strong{Cumulative distribution function (c.d.f)}:

The cumulative distribution function is typically evaluated numerically due to the lack
of a closed-form expression.
}
\examples{
dist <- dist_gk(A = 0, B = 1, g = 0, k = 0.5)
dist

\dontshow{if (requireNamespace("gk", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[gk:g-and-k]{gk::dgk}, \link{dist_gh}
}
