% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-copy-to.R
\name{copy_to.src_sql}
\alias{copy_to.src_sql}
\title{Copy a local data frame to a remote database}
\usage{
\method{copy_to}{src_sql}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  types = NULL,
  temporary = TRUE,
  unique_indexes = NULL,
  indexes = NULL,
  analyze = TRUE,
  ...,
  in_transaction = TRUE
)
}
\arguments{
\item{dest}{remote data source}

\item{df}{A local data frame, a \code{tbl_sql} from same source, or a \code{tbl_sql}
from another source. If from another source, all data must transition
through R in one pass, so it is only suitable for transferring small
amounts of data.}

\item{name}{name for new remote table.}

\item{overwrite}{If \code{TRUE}, will overwrite an existing table with
name \code{name}. If \code{FALSE}, will throw an error if \code{name} already
exists.}

\item{types}{a character vector giving variable types to use for the columns.
See \url{https://www.sqlite.org/datatype3.html} for available types.}

\item{temporary}{if \code{TRUE}, will create a temporary table that is
local to this connection and will be automatically deleted when the
connection expires}

\item{unique_indexes}{a list of character vectors. Each element of the list
will create a new unique index over the specified column(s). Duplicate rows
will result in failure.}

\item{indexes}{a list of character vectors. Each element of the list
will create a new index.}

\item{analyze}{if \code{TRUE} (the default), will automatically ANALYZE the
new table so that the query optimiser has useful information.}

\item{...}{other parameters passed to methods.}

\item{in_transaction}{Should the table creation be wrapped in a transaction?
This typically makes things faster, but you may want to suppress if the
database doesn't support transactions, or you're wrapping in a transaction
higher up (and your database doesn't support nested transactions.)}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[=show_query]{show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is an implementation of the dplyr \code{\link[=copy_to]{copy_to()}} generic and it mostly
a wrapper around \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}}.

It is useful for copying small amounts of data to a database for examples,
experiments, and joins. By default, it creates temporary tables which are
only visible within the current connection to the database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

df <- data.frame(x = 1:5, y = letters[5:1])
db <- copy_to(src_memdb(), df)
db

df2 <- data.frame(y = c("a", "d"), fruit = c("apple", "date"))
# copy_to() is called automatically if you set copy = TRUE
# in the join functions
db \%>\% left_join(df2, copy = TRUE)
}
\seealso{
\code{\link[=copy_inline]{copy_inline()}} to use small data in an SQL query without actually
writing to a table.
}
