% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-fetch.R
\docType{data}
\name{spec_result_fetch}
\alias{spec_result_fetch}
\title{spec_result_fetch}
\value{
\code{dbFetch()} always returns a \link{data.frame} with
as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
Passing \code{n = NA} is supported and returns an arbitrary number of rows (at least one)
as specified by the driver, but at most the remaining rows in the result set.
}
\description{
spec_result_fetch
}
\section{Failure modes}{

An attempt to fetch from a closed result set raises an error.
If the \code{n} argument is not an atomic whole number
greater or equal to -1 or Inf, an error is raised,
but a subsequent call to \code{dbFetch()} with proper \code{n} argument succeeds.

Calling \code{dbFetch()} on a result set from a data manipulation query
created by \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}} can
be fetched and return an empty data frame, with a warning.
}

\section{Specification}{

Fetching multi-row queries with one
or more columns by default returns the entire result.
Multi-row queries can also be fetched progressively
by passing a whole number (\link{integer} or
\link{numeric})
as the \code{n} argument.
A value of \link{Inf} for the \code{n} argument is supported
and also returns the full result.
If more rows than available are fetched, the result is returned in full
without warning.
If fewer rows than requested are returned, further fetches will
return a data frame with zero rows.
If zero rows are fetched, the columns of the data frame are still fully
typed.
Fetching fewer rows than available is permitted,
no warning is issued when clearing the result set.

A column named \code{row_names} is treated like any other column.
}

\seealso{
Other result specifications: 
\code{\link{spec_result_clear_result}},
\code{\link{spec_result_create_table_with_data_type}},
\code{\link{spec_result_execute}},
\code{\link{spec_result_get_query}},
\code{\link{spec_result_roundtrip}},
\code{\link{spec_result_send_query}},
\code{\link{spec_result_send_statement}}
}
\concept{result specifications}
