% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-send-statement.R
\docType{data}
\name{spec_result_send_statement}
\alias{spec_result_send_statement}
\title{spec_result_send_statement}
\value{
\code{dbSendStatement()} returns
an S4 object that inherits from \linkS4class{DBIResult}.
The result set can be used with \code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}} to
determine the number of rows affected by the query.
Once you have finished using a result, make sure to clear it
with \code{\link[=dbClearResult]{dbClearResult()}}.
An error is raised when issuing a statement over a closed
or invalid connection,
if the syntax of the statement is invalid,
or if the statement is not a non-\code{NA} string.
}
\description{
spec_result_send_statement
}
\section{Specification}{

No warnings occur under normal conditions.
When done, the DBIResult object must be cleared with a call to
\code{\link[=dbClearResult]{dbClearResult()}}.
Failure to clear the result set leads to a warning
when the connection is closed.
If the backend supports only one open result set per connection,
issuing a second query invalidates an already open result set
and raises a warning.
The newly opened result set is valid
and must be cleared with \code{dbClearResult()}.
}

