% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{roc01}
\alias{roc01}
\title{Calculate the distance between points on the ROC curve and (0,1)}
\usage{
roc01(tp, fp, tn, fn, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{fp}{(numeric) number of false positives.}

\item{tn}{(numeric) number of true negatives.}

\item{fn}{(numeric) number of false negatives.}

\item{...}{for capturing additional arguments passed by method.}
}
\description{
Calculate the distance on the ROC space between points on the ROC curve
and the point of perfect discrimination
from true positives, false positives, true negatives and false negatives.
The inputs must be vectors of equal length. To be used with
\code{method = minimize_metric}. \cr
\cr
sensitivity = tp / (tp + fn) \cr
specificity = tn / (tn + fp) \cr
roc01 = sqrt((1 - sensitivity)^2 + (1 - specificity)^2) \cr
}
\examples{
roc01(10, 5, 20, 10)
roc01(c(10, 8), c(5, 7), c(20, 12), c(10, 18))
oc <- cutpointr(suicide, dsi, suicide,
  method = minimize_metric, metric = roc01)
plot_roc(oc)
}
\seealso{
Other metric functions: 
\code{\link{F1_score}()},
\code{\link{Jaccard}()},
\code{\link{abs_d_ppv_npv}()},
\code{\link{abs_d_sens_spec}()},
\code{\link{accuracy}()},
\code{\link{cohens_kappa}()},
\code{\link{cutpoint}()},
\code{\link{false_omission_rate}()},
\code{\link{metric_constrain}()},
\code{\link{misclassification_cost}()},
\code{\link{npv}()},
\code{\link{odds_ratio}()},
\code{\link{p_chisquared}()},
\code{\link{plr}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{prod_ppv_npv}()},
\code{\link{prod_sens_spec}()},
\code{\link{recall}()},
\code{\link{risk_ratio}()},
\code{\link{sensitivity}()},
\code{\link{specificity}()},
\code{\link{sum_ppv_npv}()},
\code{\link{sum_sens_spec}()},
\code{\link{total_utility}()},
\code{\link{tpr}()},
\code{\link{tp}()},
\code{\link{youden}()}
}
\concept{metric functions}
