% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_test.R
\name{coef_test}
\alias{coef_test}
\title{Test all or selected regression coefficients in a fitted model}
\usage{
coef_test(
  obj,
  vcov,
  test = "Satterthwaite",
  alternative = c("two-sided", "greater", "less"),
  coefs = "All",
  null_constants = 0,
  p_values = TRUE,
  ...
)
}
\arguments{
\item{obj}{Fitted model for which to calculate t-tests.}

\item{vcov}{Variance covariance matrix estimated using \code{vcovCR} or a
character string specifying which small-sample adjustment should be used to
calculate the variance-covariance.}

\item{test}{Character vector specifying which small-sample corrections to
calculate. \code{"z"} returns a z test (i.e., using a standard normal
reference distribution). \code{"naive-t"} returns a t test with \code{m -
1} degrees of freedom, where \code{m} is the number of unique clusters.
\code{"naive-tp"} returns a t test with \code{m - p} degrees of freedom,
where \code{p} is the number of regression coefficients in \code{obj}.
\code{"Satterthwaite"} returns a Satterthwaite correction.
\code{"saddlepoint"} returns a saddlepoint correction. Default is
\code{"Satterthwaite"}.}

\item{alternative}{Character string specifying the alternative hypothesis,
with options "two-sided" (the default), "greater" or "less".}

\item{coefs}{Character, integer, or logical vector specifying which
coefficients should be tested. The default value \code{"All"} will test all
estimated coefficients.}

\item{null_constants}{vector of null values for each coefficient to test.
Must have length equal to the number of coefficients specified in
\code{coefs}. Default is \code{0}, in which case the null values are taken
to be zero.}

\item{p_values}{Logical indicating whether to report p-values. The default
value is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{vcovCR}}, which are only
needed if \code{vcov} is a character string.}
}
\value{
A data frame containing estimated regression coefficients, standard
  errors, specified values of null hypotheses, and test results. For the
  Satterthwaite approximation, degrees of freedom and a p-value are reported.
  For the saddlepoint approximation, the saddlepoint and a p-value are
  reported.
}
\description{
\code{coef_test} reports one- or two-sided t-tests for each coefficient
estimate in a fitted linear regression model, using a sandwich estimator for
the standard errors and (optionally) a small sample correction for the
p-value. Available small-sample corrections include Satterthwaite
approximation or a saddlepoint approximation. Coefficients can be tested
against non-zero null values by specifying \code{null_constants}.
}
\examples{

data("ChickWeight", package = "datasets")
lm_fit <- lm(weight ~ Diet  * Time, data = ChickWeight)
diet_index <- grepl("Diet.:Time", names(coef(lm_fit)))
coef_test(lm_fit, vcov = "CR2", cluster = ChickWeight$Chick, coefs = diet_index)

V_CR2 <- vcovCR(lm_fit, cluster = ChickWeight$Chick, type = "CR2")
coef_test(lm_fit, vcov = V_CR2, coefs = diet_index)

# non-inferiority test whether time-by-diet interaction effects are 2 or greater
coef_test(lm_fit, vcov = V_CR2, coefs = diet_index, null_constants = 2, alternative = "greater")

}
\seealso{
\code{\link{vcovCR}}
}
