% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_ard_groups.R
\name{rename_ard_groups}
\alias{rename_ard_groups}
\alias{rename_ard_groups_shift}
\alias{rename_ard_groups_reverse}
\title{Rename ARD Group Columns}
\usage{
rename_ard_groups_shift(x, shift = -1)

rename_ard_groups_reverse(x)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'.}

\item{shift}{(\code{integer})\cr
an integer specifying how many values to shift the group IDs,
e.g. \code{shift=-1} renames \code{group2} to \code{group1}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Functions for renaming group columns names in ARDs.
}
\examples{
ard <- ard_continuous(ADSL, by = c(SEX, ARM), variables = AGE)

# Example 1 ----------------------------------
rename_ard_groups_shift(ard, shift = -1)

# Example 2 ----------------------------------
rename_ard_groups_reverse(ard)
}
