% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibratR.R
\name{calibrate}
\alias{calibrate}
\title{calibrate}
\usage{
calibrate(actual, predicted, model_idx = c(1, 2, 3, 4, 5),
  evaluate_no_CV_error = TRUE, evaluate_CV_error = TRUE, folds = 10,
  n_seeds = 30, nCores = 4)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{model_idx}{which calibration models should be implemented, 1=hist_scaled, 2=hist_transformed, 3=BBQ_scaled, 4=BBQ_transformed, 5=GUESS, Default: c(1, 2, 3, 4, 5)}

\item{evaluate_no_CV_error}{computes internal errors for calibration models that were trained on all available \code{actual}/\code{predicted} tuples. Testing is performed with the same set. Be careful to interpret those error values, as they are not cross-validated. Default: TRUE}

\item{evaluate_CV_error}{computes cross-validation error. \code{folds} times cross validation is repeated \code{n_seeds} times with changing seeds. The trained models and the their calibration and discrimination errors are returned.
Evaluation of CV errors can take some time to compute, depending on the number of repetitions specified in \code{n_seeds}, Default: TRUE}

\item{folds}{number of folds in the cross-validation of the calibration model. If \code{folds} is set to 1, no CV is performed and \code{summary_CV} can be calculated. Default: 10}

\item{n_seeds}{\code{n_seeds} determines how often random data set partition is repeated with varying seed. If \code{folds} is 1, \code{n_seeds} should be set to 1, too. Default: 30}

\item{nCores}{\code{nCores} how many cores should be used during parallelisation. Default: 4}
}
\value{
A list object with the following components:
\item{calibration_models}{a list of all trained calibration models, which can be used in the \code{\link{predict_calibratR}} method.}
\item{summary_CV}{a list containing information on the CV errors of the implemented models}
\item{summary_no_CV}{a list containing information on the internal errors of the implemented models}
\item{predictions}{calibrated predictions for the original \code{predicted} values}
\item{n_seeds}{number of random data set partitions into training and test set for \code{folds}-times CV}
}
\description{
Builds selected calibration models on the supplied trainings values \code{actual} and \code{predicted} and returns them
to the user. New test instances can be calibrated using the \code{\link{predict_calibratR}} function.
Returns cross-validated calibration and discrimination error values for the models if \code{evaluate_CV_error} is set to TRUE. Repeated cross-Validation can be time-consuming.
}
\details{
parallised execution of random data set splits for the Cross-Validation procedure over \code{n_seeds}
}
\examples{
 ## Loading dataset in environment
 data(example)
 actual <- example$actual
 predicted <- example$predicted

 ## Create calibration models
 calibration_model <- calibrate(actual, predicted,
                              model_idx = c(1,2),
                              FALSE, FALSE, folds = 10, n_seeds = 1, nCores = 2)
}
\author{
Johanna Schwarz
}
