% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{class}
\name{gprior-class}
\alias{gprior-class}
\title{Class "gprior"}
\description{
An object pertaining to a coefficient prior
}
\section{Objects from the Class}{
 A \code{gprior} object holds descriptions
and subfunctions pertaining to coefficient priors. Functions such as
\code{\link{bms}} or \code{\link{zlm}} rely on this class to 'convert' the
output of OLS results into posterior expressions for a Bayesian Linear
Model. Post-processing functions such as \code{\link{density.bma}} also
resort to gprior objects.\cr There are currently three coefficient prior
structures built into the BMS package, generated by the following functions
(cf. Feldkircher and Zeugner, 2009) : \cr \code{gprior.constg.init}: creates
a Zellner's g-prior object with constant \code{g}.\cr
\code{gprior.eblocal.init}: creates an Empricial Bayes Zellner's g-prior.\cr
\code{gprior.hyperg.init}: creates a hyper g-prior with a Beta-prior on the
shrinkage parameter.\cr The following describes the necessary slots
}

\examples{


data(datafls)
mm1=bms(datafls[,1:10], g="EBL")
gg=mm1$gprior.info # is the g-prior object, augmented with some posterior statistics

mm2=bms(datafls[,1:10], g=gg) #produces the same result

mm3=bms(datafls[,1:10], g=BMS:::.gprior.eblocal.init) 
#this passes BMS's internal Empirical Bayes g-prior object as the coefficient prior 
# - any other obejct might be used as well



}
\references{
Feldkircher, M. and S. Zeugner (2009): Benchmark Priors
Revisited: On Adaptive Shrinkage and the Supermodel Effect in Bayesian Model
Averaging, IMF Working Paper 09/202.
}
\seealso{
\code{\link{bms}} and \code{\link{zlm}} for creating \code{bma} or
\code{zlm} objects. \cr Check the appendix of \code{vignette(BMS)} for a
more detailed description of built-in priors.\cr Check
\url{http://bms.zeugner.eu/custompriors.php} for examples.
}
\author{
Martin Feldkircher and Stefan Zeugner
}
\keyword{classes}
