% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AminoAcids.R
\name{charge}
\alias{charge}
\title{Calculates the net charge of amino acid sequences.}
\usage{
charge(seq, pH = 7.4, pK = NULL, normalize = FALSE)
}
\arguments{
\item{seq}{vector strings defining of amino acid sequences.}

\item{pH}{environmental pH.}

\item{pK}{named vector defining pK values for each charged amino acid,
where names are the single-letter amino acid character codes
\code{c("R", "H", "K", "D", "E", "C", "Y")}). If \code{NULL}, 
then the EMBOSS scale is used.}

\item{normalize}{if \code{TRUE} then divide the net charge of each amino acid 
sequence by the number of informative positions. Non-informative 
position are defined by the presence any character in 
\code{c("X", "-", ".", "*")}. If \code{FALSE} then return the raw
net charge.}
}
\value{
A vector of net charges for the sequence(s).
}
\description{
\code{charge} calculates the net charge of amino acid sequences using 
the method of Moore, 1985, with exclusion of the C-terminus and N-terminus charges.
}
\examples{
seq <- c("CARDRSTPWRRGIASTTVRTSW", "XXTQMYVRT") 
# Unnormalized charge
charge(seq)
# Normalized charge
charge(seq, normalize=TRUE)

# Use the Murray et al, 2006 scores from the seqinr package
library(seqinr)
data(pK)
x <- setNames(pK[["Murray"]], rownames(pK))
# Calculate charge
charge(seq, pK=x)

}
\references{
\enumerate{
  \item  Moore DS. Amino acid and peptide net charges: A simple calculational procedure. 
           Biochem Educ. 13, 10-11 (1985).
  \item  \url{https://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html}
  }
}
\seealso{
For additional pK scales see \code{\link[seqinr]{pK}}.
}
