% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateTPM.R
\name{calculateTPM}
\alias{calculateTPM}
\alias{calculateTPM,ANY-method}
\alias{calculateTPM,SummarizedExperiment-method}
\alias{calculateTPM,SingleCellExperiment-method}
\title{Calculate TPMs}
\usage{
calculateTPM(x, ...)

\S4method{calculateTPM}{ANY}(x, lengths = NULL, ...)

\S4method{calculateTPM}{SummarizedExperiment}(x, ..., assay.type = "counts", exprs_values = NULL)

\S4method{calculateTPM}{SingleCellExperiment}(x, lengths = NULL, size.factors = NULL, ...)
}
\arguments{
\item{x}{A numeric matrix of counts where features are rows and cells are columns.

Alternatively, a \linkS4class{SummarizedExperiment} or a \linkS4class{SingleCellExperiment} containing such counts.}

\item{...}{For the generic, arguments to pass to specific methods.

For the ANY method, further arguments to pass to \code{\link{calculateCPM}}.

For the SummarizedExperiment method, further arguments to pass to the ANY method.

For the SingleCellExperiment method, further arguments to pass to the SummarizedExperiment method.}

\item{lengths}{Numeric vector providing the effective length for each feature in \code{x}.
Alternatively \code{NULL}, see Details.}

\item{assay.type}{A string specifying the assay of \code{x} containing the count matrix.}

\item{exprs_values}{Soft-deprecated equivalents to the arguments above.}

\item{size.factors}{A numeric vector containing size factors to adjust the library sizes.
If \code{NULL}, the library sizes are used directly.}
}
\value{
A numeric matrix of TPM values with the same dimensions as \code{x} (unless \code{subset.row} is specified).
}
\description{
Calculate transcripts-per-million (TPM) values for expression from feature-level counts.
}
\details{
For read count data, this function assumes uniform coverage along the (effective) length of the transcript.
Thus, the number of transcripts for a gene is proportional to the read count divided by the transcript length.
Here, the division is done before calculation of the library size to compute per-million values,
where \code{\link{calculateFPKM}} will only divide by the length after library size normalization.

For UMI count data, this function should be run with \code{lengths=NULL}, i.e., no division by the effective length.
This is because the number of UMIs is a direct (albeit biased) estimate of the number of transcripts.
}
\examples{
example_sce <- mockSCE()
eff_len <- runif(nrow(example_sce), 500, 2000)
tout <- calculateTPM(example_sce, lengths = eff_len)
str(tout)

}
\seealso{
\code{\link{calculateCPM}}, on which this function is based.
}
\author{
Aaron Lun, based on code by Davis McCarthy
}
