% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{ResidualMatrix-class}
\alias{ResidualMatrix-class}
\alias{ResidualMatrix}
\alias{dimnames<-,ResidualMatrix,ANY-method}
\alias{t,ResidualMatrix-method}
\alias{[,ResidualMatrix,ANY,ANY,ANY-method}
\alias{colSums,ResidualMatrix-method}
\alias{rowSums,ResidualMatrix-method}
\alias{colMeans,ResidualMatrix-method}
\alias{rowMeans,ResidualMatrix-method}
\alias{\%*\%,ANY,ResidualMatrix-method}
\alias{\%*\%,ResidualMatrix,ANY-method}
\alias{\%*\%,ResidualMatrix,ResidualMatrix-method}
\alias{crossprod,ResidualMatrix,missing-method}
\alias{crossprod,ResidualMatrix,ANY-method}
\alias{crossprod,ANY,ResidualMatrix-method}
\alias{crossprod,ResidualMatrix,ResidualMatrix-method}
\alias{tcrossprod,ResidualMatrix,missing-method}
\alias{tcrossprod,ResidualMatrix,ANY-method}
\alias{tcrossprod,ANY,ResidualMatrix-method}
\alias{tcrossprod,ResidualMatrix,ResidualMatrix-method}
\title{The ResidualMatrix class}
\description{
The ResidualMatrix class supports delayed calculation of the residuals from a linear model fit.
This serves as a light-weight representation of what would otherwise be a large dense matrix in memory.
It also enables efficient matrix multiplication based on features of the the original matrix (e.g., sparsity).
}
\section{Construction}{

\code{ResidualMatrix(x, design=NULL, keep=NULL)} returns a ResidualMatrix object, given:
\itemize{
\item \code{x}, a matrix-like object.
This can alternatively be a ResidualMatrixSeed, in which case \code{design} and \code{keep} are ignored.
\item \code{design}, a numeric matrix containing the experimental design,
to be used for linear model fitting on each \emph{column} of \code{x}.
This defaults to an intercept-only matrix.
\item \code{keep}, an integer vector specifying the columns of \code{design} to \emph{not} regress out.
By default, all columns of \code{design} are regressed out.
\item \code{restrict}, an integer or logical vector specifying the rows of \code{x} to use for model fitting.
If \code{NULL}, all rows of \code{x} are used.
}

When \code{keep=NULL}, the ResidualMatrix contains values equivalent to \code{lm.fit(x=design, y=x)$residuals}.
}

\section{Methods}{

In the following code chunks, \code{x} is a ResidualMatrix object:
\itemize{ 
\item \code{x[i, j, .., drop=FALSE]} will return a ResidualMatrix object for the specified row and column subsets,
or a numeric vector if either \code{i} or \code{j} are of length 1.
\item \code{t(x)} will return a ResidualMatrix object with transposed contents.
\item \code{dimnames(x) <- value} will return a ResidualMatrix object where the rows and columns are renamed by \code{value},
a list of two character vectors (or \code{NULL}).
}

\code{\link{colSums}(x)}, \code{\link{colMeans}(x)}, \code{\link{rowSums}(x)} and \code{\link{rowMeans}(x)}
will return the relevant statistics for a ResidualMatrix \code{x}.

\code{\%*\%}, \code{\link{crossprod}} and \code{\link{tcrossprod}} can also be applied
where one or both of the arguments are ResidualMatrix objects.

ResidualMatrix objects are derived from \linkS4class{DelayedMatrix} objects and support all of valid operations on the latter.
All operations not listed here will use the underlying \pkg{DelayedArray} machinery.
Unary or binary operations will generally create a new DelayedMatrix instance containing a \linkS4class{ResidualMatrixSeed}.
}

\examples{
design <- model.matrix(~gl(5, 50))

library(Matrix)
y0 <- rsparsematrix(nrow(design), 200, 0.1)
y <- ResidualMatrix(y0, design)
y

# For comparison:
fit <- lm.fit(x=design, y=as.matrix(y0))
DelayedArray(fit$residuals)

# Keeping some of the factors:
y2 <- ResidualMatrix(y0, design, keep=1:2)
y2
DelayedArray(fit$residuals + design[,1:2] \%*\% fit$coefficients[1:2,])

# Matrix multiplication:
crossprod(y)
tcrossprod(y)
y \%*\% rnorm(200)

}
\author{
Aaron Lun
}
