% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/601-getCPI.R
\name{getCPI}
\alias{getCPI}
\title{Generating Compound-Protein Interaction Descriptors}
\usage{
getCPI(drugmat, protmat, type = c("combine", "tensorprod"))
}
\arguments{
\item{drugmat}{The compound descriptor matrix.}

\item{protmat}{The protein descriptor matrix.}

\item{type}{The interaction type, one or two of
\code{"combine"} and \code{"tensorprod"}.}
}
\value{
A matrix containing the compound-protein interaction descriptors
}
\description{
Generating Compound-Protein Interaction Descriptors
}
\details{
This function calculates the compound-protein interaction descriptors
by three types of interaction:
\itemize{
\item \code{combine} - combine the two descriptor matrix,
result has \code{(p1 + p2)} columns
\item \code{tensorprod} - calculate column-by-column
(pseudo)-tensor product type interactions, result has
\code{(p1 * p2)} columns
}
}
\examples{
x = matrix(1:10, ncol = 2)
y = matrix(1:15, ncol = 3)

getCPI(x, y, 'combine')
getCPI(x, y, 'tensorprod')
getCPI(x, y, type = c('combine', 'tensorprod'))
getCPI(x, y, type = c('tensorprod', 'combine'))

}
\seealso{
See \code{\link{getPPI}} for generating
protein-protein interaction descriptors.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{compound-protein}
\keyword{cpi}
\keyword{getCPI}
\keyword{interaction}
