% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/GsvaMethodParam.R
\docType{class}
\name{GsvaMethodParam-class}
\alias{GsvaMethodParam-class}
\title{\code{GsvaMethodParam} class}
\description{
Virtual superclass of method parameter classes supported by \code{GSVA}.

A virtual superclass of the \code{GSVA} packages' method-specific
parameter classes.
}
\details{
\code{GSVA} implements four single-sample gene set analysis methods: PLAGE,
combined z-scores, ssGSEA, and GSVA.  All of them take at least an expression
data matrix and one or many gene sets as input.  This virtual class provides
the necessary slots for this minimum parameter set and serves as all \code{GSVA}
method parameter classes,

The \code{GSVA} package implements four single-sample gene set analysis
methods (PLAGE, combined z-scores, ssGSEA, and GSVA) and a respective
method-specific parameter class that is used to invoke each of them with a
matching set of parameters.
}
\seealso{
\code{\linkS4class{GsvaExprData}},
\code{\linkS4class{GsvaGeneSets}},
\code{\linkS4class{zscoreParam}},
\code{\linkS4class{plageParam}},
\code{\linkS4class{ssgseaParam}},
\code{\linkS4class{gsvaParam}}

[\code{plageParam}][\code{zscoreParam}][\code{ssgseaParam}][\code{gsvaParam}]
}
