% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makespline.R
\name{makespline}
\alias{makespline}
\title{Monotonic Spline}
\usage{
makespline(x, y, newX = NULL, nKnots = 6, lower_bound = 10^-3)
}
\arguments{
\item{x}{The predictor variable.}

\item{y}{The response variable.  Must be the same length as \code{x}.}

\item{newX}{The points at which to return the value on the fitted spline.
If not specified \code{x} is used.}

\item{nKnots}{The number of knots to use in fitting the spline.}

\item{lower_bound}{The spline cannot drop below this value.}
}
\value{
Returns a vector of values containing the value of the fit at each
point \code{newX}.
}
\description{
Fits a monotonic cubic spline to the data provided, using the penalized
constrained least squares method from the \code{mgcv} package.
}
\details{
This uses the \code{pcls} function from the \pkg{mgcv} package to produce
the fit.  The monotonicity constraint is enforced using \code{mono.con} from
the same package. The \code{lower_bound} argument is only used on the rare
occasions when the fitting function becomes negative or arbitrarily close to
zero.  If this does occur \code{lower_bound} is added everywhere to ensure
that no one length is given essentially infinite weighting.
}
\examples{
y <- c( rbinom(50,p=0.4,size=1), rbinom(50,p=0.6,size=1) )
x <- 1:100
plot(x,y)
p <- makespline(x,y)
lines(x,p)

}
\references{
Package \pkg{mgcv}.  In particular this function is a
modification of an example given in the man page for \code{pcls}.
}
\author{
Matthew D. Young \email{myoung@wehi.edu.au}.
}
