% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{importAllelicCounts}
\alias{importAllelicCounts}
\title{Import allelic counts as a SummarizedExperiment}
\usage{
importAllelicCounts(
  coldata,
  a1,
  a2,
  format = c("wide", "assays"),
  tx2gene = NULL,
  ...
)
}
\arguments{
\item{coldata}{a data.frame as used in \code{tximeta}}

\item{a1}{the symbol for the effect allele}

\item{a2}{the symbol for the non-effect allele}

\item{format}{either \code{"wide"} or \code{"assays"} for whether
to combine the allelic counts as columns (wide) or put the allelic
count information in different assay slots (assays).
For wide output, the data for the non-effect allele (a2) comes first,
then the effect allele (a1), e.g. \code{[a2 | a1]}. The \code{ref} level
of the factor variable \code{se$allele} will be \code{"a2"}
(so by default comparisons will be: a1 vs a2).
For assays output, all of the original matrices are renamed with a prefix,
either \code{a1-} or \code{a2-}.}

\item{tx2gene}{optional, a data.frame with first column indicating
transcripts, second column indicating genes (or any other transcript
grouping). Either this should include the \code{a1} and \code{a2}
suffix for the transcripts and genes, or those will be added internally,
if it is detected that the first transcript does not have these suffices.
For example if \code{_alt} or \code{_ref}, or \code{_M} or \code{_P}
(as indicated by the \code{a1} and \code{a2} arguments) are not present
in the table, the table rows will be duplicated with those suffices
added on behalf of the user.
If not provided, the output object will be transcript-level.
Note: do not attempt to set the \code{txOut} argument, it will
conflict with internal calls to downstream functions.
Note: if the a1/a2 suffices are not at the end of the transcript name
in the quantification files, e.g. \code{ENST123_M|<metadata>},
then \code{ignoreAfterBar=TRUE} can be used to match regardless of
the string following \code{|} in the quantification files.}

\item{...}{any arguments to pass to tximeta}
}
\value{
a SummarizedExperiment, with allele counts (and other data)
combined into a wide matrix \code{[a2 | a1]}, or as assays (a1, then a2).
The original strings associated with a1 and a2 are stored in the
metadata of the object, in the \code{alleles} list element.
Note the \code{ref} level of \code{se$allele} will be \code{"a2"}, 
such that comparisons by default will be a1 vs a2 (effect vs non-effect).
}
\description{
Read in Salmon quantification of allelic counts from a
diploid transcriptome. Assumes that diploid transcripts
are marked with the following suffix: an underscore and
a consistent symbol for each of the two alleles,
e.g. \code{ENST123_M} and \code{ENST123_P},
or \code{ENST123_alt} and \code{ENST123_ref}.
There must be exactly two alleles for each transcript, 
and the \code{--keep-duplicates} option should be used in
Salmon indexing to avoid removing transcripts with identical sequence.
The output object has half the number of transcripts,
with the two alleles either stored in a \code{"wide"} object,
or as re-named \code{"assays"}. Note carefully that the symbol
provided to \code{a1} is used as the effect allele,
and \code{a2} is used as the non-effect allele
(see the \code{format} argument description and Value
description below).
}
\details{
Requires the tximeta package.
\code{skipMeta=TRUE} is used, as it is assumed
the diploid transcriptome does not match any reference
transcript collection. This may change in future iterations
of the function, depending on developments in upstream
software.
}
