% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{dispersionFunction}
\alias{dispersionFunction}
\alias{dispersionFunction<-}
\alias{dispersionFunction,DESeqDataSet-method}
\alias{dispersionFunction<-,DESeqDataSet,function-method}
\title{Accessors for the 'dispersionFunction' slot of a DESeqDataSet object.}
\usage{
dispersionFunction(object, ...)

dispersionFunction(object, ...) <- value

\S4method{dispersionFunction}{DESeqDataSet}(object)

\S4method{dispersionFunction}{DESeqDataSet,`function`}(object) <- value
}
\arguments{
\item{object}{a \code{DESeqDataSet} object.}

\item{...}{additional arguments}

\item{value}{a \code{function}}
}
\description{
The dispersion function is calculated by \code{\link{estimateDispersions}} and
used by \code{\link{varianceStabilizingTransformation}}. Parametric dispersion
fits store the coefficients of the fit as attributes in this slot.
}
\details{
Using this setter function will also overwrite \code{mcols(object)$dispFit}
and the estimate of the variance of dispersion residuals.
}
\examples{

dds <- makeExampleDESeqDataSet(m=4)
dds <- estimateSizeFactors(dds)
dds <- estimateDispersions(dds)
dispersionFunction(dds)

}
\seealso{
\code{\link{estimateDispersions}}
}
