% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chimeras.R
\name{isBimera}
\alias{isBimera}
\title{Determine if input sequence is a bimera of putative parent sequences.}
\usage{
isBimera(
  sq,
  parents,
  allowOneOff = FALSE,
  minOneOffParentDistance = 4,
  maxShift = 16
)
}
\arguments{
\item{sq}{(Required). A \code{character(1)}.
The sequence being evaluated as a possible bimera.}

\item{parents}{(Required). Character vector.
A vector of possible "parent" sequence that could form the left and right
sides of the bimera.}

\item{allowOneOff}{(Optional). A \code{logical(1)}. Default is FALSE.
If FALSE, sq will be identified as a bimera if it is one mismatch or indel away 
from an exact bimera.}

\item{minOneOffParentDistance}{(Optional). A \code{numeric(1)}. Default is 4.
Only sequences with at least this many mismatches to sq are considered as possible
"parents" when flagging one-off bimeras. There is no such screen when identifying
exact bimeras.}

\item{maxShift}{(Optional). A \code{numeric(1)}. Default is 16.
Maximum shift allowed when aligning sequences to potential "parents".}
}
\value{
\code{logical(1)}.
 TRUE if sq is a bimera of two of the parents. Otherwise FALSE.
}
\description{
This function attempts to find an exact bimera of the parent sequences that
matches the input sequence. A bimera is a two-parent chimera, in which the
left side is made up of one parent sequence, and the right-side made up of
a second parent sequence. If an exact bimera is found TRUE is returned, 
otherwise FALSE. Bimeras that are one-off from exact are also identified if
the allowOneOff argument is TRUE.
}
\examples{
derep1 = derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
sqs1 <- getSequences(derep1)
isBimera(sqs1[[20]], sqs1[1:10])

}
\seealso{
\code{\link{isBimeraDenovo}}, \code{\link{removeBimeraDenovo}}
}
