/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef SHORTCUTSEDITOR_H
#define SHORTCUTSEDITOR_H

#include <QDialog>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QPushButton>
#include <QMap>
#include <QKeySequence>

class ShortcutGrabber;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class ShortcutsEditor : public QDialog
{
  Q_OBJECT
  private:
    QTreeWidget*     m_treeWgt;
    ShortcutGrabber* m_grabShortcutDlg;
    QPushButton*     m_okBtn;
    QPushButton*     m_cancelBtn;
    QPushButton*     m_defaultsBtn;
    QPushButton*     m_clearShortcutBtn;

    QMap< QString, QList<QKeySequence> > m_shortcuts;

  private:
    void init();

  public:
    ShortcutsEditor(QWidget *parent = 0);
    ~ShortcutsEditor();

  public slots:
    void grabShortcutDlg(QTreeWidgetItem*, int);
    void applyChanges();
    void defaults();
    void clearCurrentShortcut();
    void currentItemChanged(QTreeWidgetItem*, QTreeWidgetItem*);
};

#endif
