//
// C++ Implementation: qcPartsys
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "qcpartsys.hpp"

qcPartsys::qcPartsys(QObject *parent,
                       int num, int initial_num,
                       float _create_rate, int _turn_to_face,
                       float sz, float bsphere_size,
                       ssgaParticleCreateFunc _particle_create,
                       ssgaParticleUpdateFunc _particle_update ,
                       ssgaParticleDeleteFunc _particle_delete )
: QObject(parent), ssgaParticleSystem (num, initial_num,
                       _create_rate, _turn_to_face,
                       sz, bsphere_size,
                       _particle_create,
                       _particle_update ,
                       _particle_delete )
{
}

qcPartsys::~qcPartsys()
{
}

void qcPartsys::slot_update( float dt )
{
    ssgaParticleSystem::update(dt);
}

void qcPartsys::droplet_create ( ssgaParticleSystem *, int, ssgaParticle *p )
{
  float c = ((float)(rand()%100)/100.0f) * (256.0f-163.0f)/255.0f ;

  sgSetVec4 ( p -> col, 96.0f/255.0f+c, 147.0f/255.0f+c, 163.0f/255.0f+c, 0.5);
  sgSetVec3 ( p -> pos, -2.4f, -0.1f, 1.9f ) ;
  sgSetVec3 ( p -> vel,
             -(float)(rand()%1000)/200.0f,
              (float)(rand()%1000 - 500)/400.0f,
              (float)(rand()%1000)/1000.0f + 3.0f ) ;
  sgAddScaledVec3 ( p -> pos, p -> vel, (float)(rand()%1000)/20000.0f ) ;
  sgSetVec3 ( p -> acc, 0, 0, -9.8f ) ;
  p -> time_to_live = 1 ;
}
