/***************************************************************************
                          mainwindow.hpp  -  description
                             -------------------
    begin                : Fri JAN  12 16:54:22 CET 2007
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

/**
  *@author Harald Krippel
  */

#include <QMainWindow>
#include <QHash>
#include <QStackedWidget>
#include "listviews.hpp"
#include "main.h"
#include "glcontrol.hpp"

class QAction;
class QTreeView;
class QListWidget;
class QMenu;
class GLWidget;
class OpmlTree;
//class StackedWidget;
class NetworkAccessManager;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();
    static NetworkAccessManager *networkAccessManager();
public slots:
    void opmlitemClicked(QTreeWidgetItem *item,  int column);
    void mode_stop();

private slots:
    bool save();
    void open();
    bool newProject();
    void loadFile(QString fileName);
    void loadPlugins();
    void print();
    void preferences();
    void undo();
    void cut();
    void about();
    void aboutPlugins();
    void aboutCapabilities();
    void closeEvent(QCloseEvent *event);
    void openRecentFile();
    void slotFullScreen();
    void slotFrontView();
    void slotDebugMode();
    void slotToolsEditCam();
    void slotToolsTranslate();
    void slotToolsRotate();
    void slotToolsScale();
    void slotToolsPlay();
    void slotToolsPause();
    void slotToolsStop();

private:
    void createActions();
    void createMenus();
    void createToolBars();
    void createStatusBar();
    void createDockWindows();
    void readSettings();
    void writeSettings();
    bool maybeSave();
    void populateMenus(QObject *plugin);
    void addToMenu(QObject *plugin, const QStringList &texts, QMenu *menu,
                   const char *member, QActionGroup *actionGroup = 0);
        
    void setCurrentFile(const QString &fileName);
    void updateRecentFileActions();
    QString strippedName(const QString &fullFileName);


    GLWidget *glwidget;
    Glcontrol *gl;
    OpmlTree *opmlTree;
    

    /** file_menu contains all items of the menubar entry of */
    QMenu *fileMenu;
    QMenu *editMenu;
    QMenu *viewMenu;
    QMenu *toolMenu;
    QMenu *helpMenu;

    QToolBar *fileToolBar;
    QToolBar *toolToolBar;


    QAction *fileNewAct;
    QAction *fileOpenAct;
//    QAction *fileOpenRecentAct;
    QAction *fileSaveAct;
//    QAction *fileSaveAsAct;
//    QAction *fileCloseAct;
    QAction *filePrintAct;
    QAction *fileQuitAct;
    QAction *filePrefAct;

    QActionGroup * toolsEditGroup;
    QActionGroup * toolsPlayGroup;

    QAction* viewProjectAct;
    QAction* viewDialogAct;

    QAction* toolsEditCamAct;
    QAction* toolsTranslateAct;
    QAction* toolsRotateAct;
    QAction* toolsScaleAct;
    QAction* toolsPlayAct;
    QAction* toolsStopAct;
    QAction* toolsPauseAct;

    QAction *editUndoAct;
    QAction *editCutAct;
//    QAction *editCopyAct;
//    QAction *editPasteAct;

//    QAction *viewToolBarAct;
//    QAction *viewStatusBarAct;
    QAction *viewFullScreenAct;
    QAction* viewFrontScreenAct;
    QAction* viewDebugAct;

    QAction *helpAboutAppAct;
    QAction *helpaboutQtAct;
    QAction *aboutPluginsAct;
    QAction *aboutCapabilitiesAct;
    QAction *separatorAct;

    enum { MaxRecentFiles = 5 };
    QAction *recentFileActs[MaxRecentFiles];
    
    QHash<QString, int> stackNameForItem;
    QStackedWidget *stack;
    FolderListItem *tmpItem;
    QString doc_url;
    bool modified;
//    QTextEdit *msg_report;
    QDir pluginsDir;
    QStringList pluginFileNames;
    bool modestop;

    static NetworkAccessManager *s_networkAccessManager;
};

#endif
