# Pyzo - The Interactive editor for scientific Python

[![PyPI Version](https://img.shields.io/pypi/v/pyzo.svg)](https://pypi.python.org/pypi/pyzo/)
[![CI](https://github.com/pyzo/pyzo/actions/workflows/ci.yml/badge.svg)](https://github.com/pyzo/pyzo/actions/workflows/ci.yml)

Website: [pyzo.org](http://pyzo.org)


### Description

Pyzo is a cross-platform Python IDE focused on
interactivity and introspection, which makes it very suitable for
scientific computing. Its practical design is aimed at simplicity and
efficiency.

It consists of two main components, the editor and the shell, and uses
a set of pluggable tools to help the programmer in various ways. Some
example tools are source structure, project manager, interactive help,
workspace ...

Pyzo is written in (pure) Python 3 and uses the Qt GUI toolkit. Binaries
are provided for all major operating system. After installing Pyzo, it
can be used to execute code on any Python version available on your
system (Python 2.4 - 3.x, including Pypy).


### Installation

Pyzo runs on Python3 and needs PySide2 or PyQt5. On a modern
OS these should be easy to obtain. One can then install Pyzo with
`python3 -m pip install pyzo`

We also provide [binaries](https://github.com/pyzo/pyzo/releases) for Windows, Linux and MacOS.


### License

Pyzo is free and open source, licensed under the 2-clause BSD.


### Contributions

If you want to help out, create an issue or pull request on Github.


### More information

* main website: https://pyzo.org
* code repository: https://github.com/pyzo/pyzo
* mailing list: https://groups.google.com/group/pyzo
