# Copyright (c) 2006-2024 Broadcom. All Rights Reserved.
# Broadcom Confidential. The term "Broadcom" refers to Broadcom Inc.
# and/or its subsidiaries.

# ******* WARNING - AUTO GENERATED CODE - DO NOT EDIT *******

from typing import NoReturn
from typing import Optional

from pyVmomi.vim import ExtensibleManagedObject
from pyVmomi.vim import Task

from pyVmomi.vmodl import DynamicData
from pyVmomi.vmodl import MethodFault

from pyVmomi.vim.host import DiskPartitionInfo
from pyVmomi.vim.host import FcoeConfig
from pyVmomi.vim.host import FileSystemVolumeInfo
from pyVmomi.vim.host import HbaCreateSpec
from pyVmomi.vim.host import InternetScsiHba
from pyVmomi.vim.host import MultipathInfo
from pyVmomi.vim.host import MultipathStateInfo
from pyVmomi.vim.host import NasVolume
from pyVmomi.vim.host import NvmeConnectSpec
from pyVmomi.vim.host import NvmeDisconnectSpec
from pyVmomi.vim.host import NvmeDiscoverSpec
from pyVmomi.vim.host import NvmeDiscoveryLog
from pyVmomi.vim.host import PathSelectionPolicyOption
from pyVmomi.vim.host import ScsiDisk
from pyVmomi.vim.host import StorageArrayTypePolicyOption
from pyVmomi.vim.host import StorageDeviceInfo
from pyVmomi.vim.host import UnresolvedVmfsResolutionResult
from pyVmomi.vim.host import UnresolvedVmfsResolutionSpec
from pyVmomi.vim.host import UnresolvedVmfsVolume
from pyVmomi.vim.host import VffsVolume
from pyVmomi.vim.host import VmfsVolume

class StorageSystem(ExtensibleManagedObject):
   class VmfsVolumeResult(DynamicData):
      key: str
      fault: Optional[MethodFault] = None

   class ScsiLunResult(DynamicData):
      key: str
      fault: Optional[MethodFault] = None

   class DiskLocatorLedResult(DynamicData):
      key: str
      fault: MethodFault

   @property
   def storageDeviceInfo(self) -> Optional[StorageDeviceInfo]: ...
   @property
   def fileSystemVolumeInfo(self) -> FileSystemVolumeInfo: ...
   @property
   def systemFile(self) -> list[str]: ...
   @property
   def multipathStateInfo(self) -> Optional[MultipathStateInfo]: ...

   def RetrieveDiskPartitionInfo(self, devicePath: list[str]) -> list[DiskPartitionInfo]: ...
   def ComputeDiskPartitionInfo(self, devicePath: str, layout: DiskPartitionInfo.Layout, partitionFormat: Optional[str]) -> DiskPartitionInfo: ...
   def ComputeDiskPartitionInfoForResize(self, partition: ScsiDisk.Partition, blockRange: DiskPartitionInfo.BlockRange, partitionFormat: Optional[str]) -> DiskPartitionInfo: ...
   def UpdateDiskPartitions(self, devicePath: str, spec: DiskPartitionInfo.Specification) -> NoReturn: ...
   def FormatVmfs(self, createSpec: VmfsVolume.Specification) -> VmfsVolume: ...
   def MountVmfsVolume(self, vmfsUuid: str) -> NoReturn: ...
   def UnmountVmfsVolume(self, vmfsUuid: str) -> NoReturn: ...
   def UnmountVmfsVolumeEx(self, vmfsUuid: list[str]) -> Task: ...
   def MountVmfsVolumeEx(self, vmfsUuid: list[str]) -> Task: ...
   def UnmapVmfsVolumeEx(self, vmfsUuid: list[str]) -> Task: ...
   def DeleteVmfsVolumeState(self, vmfsUuid: str) -> NoReturn: ...
   def RescanVmfs(self) -> NoReturn: ...
   def AttachVmfsExtent(self, vmfsPath: str, extent: ScsiDisk.Partition) -> NoReturn: ...
   def ExpandVmfsExtent(self, vmfsPath: str, extent: ScsiDisk.Partition) -> NoReturn: ...
   def UpgradeVmfs(self, vmfsPath: str) -> NoReturn: ...
   def UpgradeVmLayout(self) -> NoReturn: ...
   def QueryUnresolvedVmfsVolume(self) -> list[UnresolvedVmfsVolume]: ...
   def ResolveMultipleUnresolvedVmfsVolumes(self, resolutionSpec: list[UnresolvedVmfsResolutionSpec]) -> list[UnresolvedVmfsResolutionResult]: ...
   def ResolveMultipleUnresolvedVmfsVolumesEx(self, resolutionSpec: list[UnresolvedVmfsResolutionSpec]) -> Task: ...
   def UnmountForceMountedVmfsVolume(self, vmfsUuid: str) -> NoReturn: ...
   def RescanHba(self, hbaDevice: str) -> NoReturn: ...
   def RescanAllHba(self) -> NoReturn: ...
   def UpdateSoftwareInternetScsiEnabled(self, enabled: bool) -> NoReturn: ...
   def UpdateInternetScsiDiscoveryProperties(self, iScsiHbaDevice: str, discoveryProperties: InternetScsiHba.DiscoveryProperties) -> NoReturn: ...
   def UpdateInternetScsiAuthenticationProperties(self, iScsiHbaDevice: str, authenticationProperties: InternetScsiHba.AuthenticationProperties, targetSet: Optional[InternetScsiHba.TargetSet]) -> NoReturn: ...
   def UpdateInternetScsiDigestProperties(self, iScsiHbaDevice: str, targetSet: Optional[InternetScsiHba.TargetSet], digestProperties: InternetScsiHba.DigestProperties) -> NoReturn: ...
   def UpdateInternetScsiAdvancedOptions(self, iScsiHbaDevice: str, targetSet: Optional[InternetScsiHba.TargetSet], options: list[InternetScsiHba.ParamValue]) -> NoReturn: ...
   def UpdateInternetScsiIPProperties(self, iScsiHbaDevice: str, ipProperties: InternetScsiHba.IPProperties) -> NoReturn: ...
   def UpdateInternetScsiName(self, iScsiHbaDevice: str, iScsiName: str) -> NoReturn: ...
   def UpdateInternetScsiAlias(self, iScsiHbaDevice: str, iScsiAlias: str) -> NoReturn: ...
   def AddInternetScsiSendTargets(self, iScsiHbaDevice: str, targets: list[InternetScsiHba.SendTarget]) -> NoReturn: ...
   def RemoveInternetScsiSendTargets(self, iScsiHbaDevice: str, targets: list[InternetScsiHba.SendTarget], force: Optional[bool]) -> NoReturn: ...
   def AddInternetScsiStaticTargets(self, iScsiHbaDevice: str, targets: list[InternetScsiHba.StaticTarget]) -> NoReturn: ...
   def RemoveInternetScsiStaticTargets(self, iScsiHbaDevice: str, targets: list[InternetScsiHba.StaticTarget]) -> NoReturn: ...
   def EnableMultipathPath(self, pathName: str) -> NoReturn: ...
   def DisableMultipathPath(self, pathName: str) -> NoReturn: ...
   def SetMultipathLunPolicy(self, lunId: str, policy: MultipathInfo.LogicalUnitPolicy) -> NoReturn: ...
   def UpdateHppMultipathLunPolicy(self, lunId: str, policy: MultipathInfo.HppLogicalUnitPolicy) -> NoReturn: ...
   def QueryPathSelectionPolicyOptions(self) -> list[PathSelectionPolicyOption]: ...
   def QueryStorageArrayTypePolicyOptions(self) -> list[StorageArrayTypePolicyOption]: ...
   def UpdateScsiLunDisplayName(self, lunUuid: str, displayName: str) -> NoReturn: ...
   def DetachScsiLun(self, lunUuid: str) -> NoReturn: ...
   def DetachScsiLunEx(self, lunUuid: list[str]) -> Task: ...
   def DeleteScsiLunState(self, lunCanonicalName: str) -> NoReturn: ...
   def AttachScsiLun(self, lunUuid: str) -> NoReturn: ...
   def AttachScsiLunEx(self, lunUuid: list[str]) -> Task: ...
   def Refresh(self) -> NoReturn: ...
   def DiscoverFcoeHbas(self, fcoeSpec: FcoeConfig.FcoeSpecification) -> NoReturn: ...
   def MarkForRemoval(self, hbaName: str, remove: bool) -> NoReturn: ...
   def FormatVffs(self, createSpec: VffsVolume.Specification) -> VffsVolume: ...
   def ExtendVffs(self, vffsPath: str, devicePath: str, spec: Optional[DiskPartitionInfo.Specification]) -> NoReturn: ...
   def DestroyVffs(self, vffsPath: str) -> NoReturn: ...
   def MountVffsVolume(self, vffsUuid: str) -> NoReturn: ...
   def UnmountVffsVolume(self, vffsUuid: str) -> NoReturn: ...
   def DeleteVffsVolumeState(self, vffsUuid: str) -> NoReturn: ...
   def RescanVffs(self) -> NoReturn: ...
   def QueryAvailableSsds(self, vffsPath: Optional[str]) -> list[ScsiDisk]: ...
   def SetNFSUser(self, user: str, password: str) -> NoReturn: ...
   def ChangeNFSUserPassword(self, password: str) -> NoReturn: ...
   def QueryNFSUser(self) -> Optional[NasVolume.UserInfo]: ...
   def ClearNFSUser(self) -> NoReturn: ...
   def TurnDiskLocatorLedOn(self, scsiDiskUuids: list[str]) -> Task: ...
   def TurnDiskLocatorLedOff(self, scsiDiskUuids: list[str]) -> Task: ...
   def MarkAsSsd(self, scsiDiskUuid: str) -> Task: ...
   def MarkAsNonSsd(self, scsiDiskUuid: str) -> Task: ...
   def MarkAsLocal(self, scsiDiskUuid: str) -> Task: ...
   def MarkAsNonLocal(self, scsiDiskUuid: str) -> Task: ...
   def UpdateVmfsUnmapPriority(self, vmfsUuid: str, unmapPriority: str) -> NoReturn: ...
   def UpdateVmfsUnmapBandwidth(self, vmfsUuid: str, unmapBandwidthSpec: VmfsVolume.UnmapBandwidthSpec) -> NoReturn: ...
   def QueryVmfsConfigOption(self) -> list[VmfsVolume.ConfigOption]: ...
   def MarkPerenniallyReserved(self, lunUuid: str, state: bool) -> NoReturn: ...
   def MarkPerenniallyReservedEx(self, lunUuid: list[str], state: bool) -> Task: ...
   def CreateNvmeOverRdmaAdapter(self, rdmaDeviceName: str) -> NoReturn: ...
   def RemoveNvmeOverRdmaAdapter(self, hbaDeviceName: str) -> NoReturn: ...
   def CreateSoftwareAdapter(self, spec: HbaCreateSpec) -> NoReturn: ...
   def RemoveSoftwareAdapter(self, hbaDeviceName: str) -> NoReturn: ...
   def DiscoverNvmeControllers(self, discoverSpec: NvmeDiscoverSpec) -> NvmeDiscoveryLog: ...
   def ConnectNvmeController(self, connectSpec: NvmeConnectSpec) -> NoReturn: ...
   def DisconnectNvmeController(self, disconnectSpec: NvmeDisconnectSpec) -> NoReturn: ...
   def ConnectNvmeControllerEx(self, connectSpec: list[NvmeConnectSpec]) -> Task: ...
   def DisconnectNvmeControllerEx(self, disconnectSpec: list[NvmeDisconnectSpec]) -> Task: ...
