# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sitemanager.aio import SiteManagerMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteManagerMgmtSitesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteManagerMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sites_get(self, resource_group):
        response = await self.client.sites.get(
            resource_group_name=resource_group.name,
            site_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sites_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.sites.begin_create_or_update(
                resource_group_name=resource_group.name,
                site_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "description": "str",
                        "displayName": "str",
                        "labels": {"str": "str"},
                        "provisioningState": "str",
                        "siteAddress": {
                            "city": "str",
                            "country": "str",
                            "postalCode": "str",
                            "stateOrProvince": "str",
                            "streetAddress1": "str",
                            "streetAddress2": "str",
                        },
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sites_update(self, resource_group):
        response = await self.client.sites.update(
            resource_group_name=resource_group.name,
            site_name="str",
            properties={
                "properties": {
                    "description": "str",
                    "displayName": "str",
                    "labels": {"str": "str"},
                    "siteAddress": {
                        "city": "str",
                        "country": "str",
                        "postalCode": "str",
                        "stateOrProvince": "str",
                        "streetAddress1": "str",
                        "streetAddress2": "str",
                    },
                }
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sites_delete(self, resource_group):
        response = await self.client.sites.delete(
            resource_group_name=resource_group.name,
            site_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sites_list_by_resource_group(self, resource_group):
        response = self.client.sites.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
