# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DesiredDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Desired direction for an experiment metric value."""

    INCREASE = "Increase"
    """An increase to the metric value is desired. E.g., Success rate, Total revenue."""
    DECREASE = "Decrease"
    """A decrease to the metric value is desired. E.g., Error rate, Latency."""
    NEUTRAL = "Neutral"
    """Neither an increase nor a decrease to the metric value is desired, or the desired direction
    depends on other factors. E.g., Number of video play attempts, Number of user feedbacks"""


class DiagnosticCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The diagnostic error codes."""

    FAILED_SCHEMA_VALIDATION = "FailedSchemaValidation"
    """The metric definition does not conform to the required schema."""
    INVALID_EVENT_CONDITION = "InvalidEventCondition"
    """The filter condition is invalid."""
    UNSUPPORTED_EVENT_CONDITION = "UnsupportedEventCondition"
    """The filter condition is valid but not currently supported."""
    INVALID_EXPERIMENT_METRIC_DEFINITION = "InvalidExperimentMetricDefinition"
    """The provided metric definition is invalid.
    For example, defining a metric to calculate the average of a numeric property but
    including a filter condition that compares it to a string value creates a type mismatch."""


class ExperimentMetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """How the metric definition calculates metric values from event data."""

    EVENT_COUNT = "EventCount"
    """Counts the occurrences of an event. Experiment analysis accounts for unequal traffic
    allocation."""
    USER_COUNT = "UserCount"
    """Counts the number of unique users who encounter an event. Experiment analysis accounts for
    unequal traffic allocation."""
    EVENT_RATE = "EventRate"
    """Calculates the percentage of events that satisfy a specified condition."""
    USER_RATE = "UserRate"
    """Calculates the percentage of users who encounter a start event and subsequently encounter an
    end event. Users must encounter the start event before the end event to be counted."""
    SUM = "Sum"
    """Calculates the sum of a specified event property. Experiment analysis accounts for unequal
    traffic allocation."""
    AVERAGE = "Average"
    """Calculates the average value of a specified event property."""
    PERCENTILE = "Percentile"
    """Calculates a specified percentile of an event property."""


class LifecycleStage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Lifecycle stages of an experiment metric, determining whether the metric is included in
    experiment analysis.
    """

    ACTIVE = "Active"
    """The metric is included in experiment analysis."""
    INACTIVE = "Inactive"
    """The metric is excluded from experiment analysis but remains available for future use."""
