# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hardwaresecuritymodules.aio import HardwareSecurityModulesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHardwareSecurityModulesMgmtCloudHsmClusterPrivateEndpointConnectionsOperationsAsync(
    AzureMgmtRecordedTestCase
):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HardwareSecurityModulesMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cloud_hsm_cluster_private_endpoint_connections_get(self, resource_group):
        response = await self.client.cloud_hsm_cluster_private_endpoint_connections.get(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            pe_connection_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cloud_hsm_cluster_private_endpoint_connections_create(self, resource_group):
        response = await self.client.cloud_hsm_cluster_private_endpoint_connections.create(
            resource_group_name=resource_group.name,
            cloud_hsm_cluster_name="str",
            pe_connection_name="str",
            properties={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "privateLinkServiceConnectionState": {
                        "actionsRequired": "str",
                        "description": "str",
                        "status": "str",
                    },
                    "groupIds": ["str"],
                    "privateEndpoint": {"id": "str"},
                    "provisioningState": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cloud_hsm_cluster_private_endpoint_connections_begin_delete(self, resource_group):
        response = await (
            await self.client.cloud_hsm_cluster_private_endpoint_connections.begin_delete(
                resource_group_name=resource_group.name,
                cloud_hsm_cluster_name="str",
                pe_connection_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
