# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.disconnectedoperations.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.disconnectedoperations.models.SystemData
    """


class Artifact(ProxyResource):
    """Disconnected operations artifact resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.disconnectedoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.disconnectedoperations.models.ArtifactProperties
    """

    properties: Optional["_models.ArtifactProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ArtifactProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ArtifactDownloadResult(_Model):
    """The artifact download properties.

    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.disconnectedoperations.models.ResourceProvisioningState
    :ivar artifact_order: The artifact display order. Required.
    :vartype artifact_order: int
    :ivar title: The artifact title. Required.
    :vartype title: str
    :ivar description: The artifact description. Required.
    :vartype description: str
    :ivar size: The artifact size in MB.
    :vartype size: int
    :ivar download_link: The download URI. Required.
    :vartype download_link: str
    :ivar link_expiry: The download link expiry time. Required.
    :vartype link_expiry: ~datetime.datetime
    """

    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    artifact_order: int = rest_field(name="artifactOrder", visibility=["read"])
    """The artifact display order. Required."""
    title: str = rest_field(visibility=["read"])
    """The artifact title. Required."""
    description: str = rest_field(visibility=["read"])
    """The artifact description. Required."""
    size: Optional[int] = rest_field(visibility=["read"])
    """The artifact size in MB."""
    download_link: str = rest_field(name="downloadLink", visibility=["read"])
    """The download URI. Required."""
    link_expiry: datetime.datetime = rest_field(name="linkExpiry", visibility=["read"], format="rfc3339")
    """The download link expiry time. Required."""


class ArtifactProperties(_Model):
    """The artifact properties.

    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.disconnectedoperations.models.ResourceProvisioningState
    :ivar artifact_order: The artifact display order. Required.
    :vartype artifact_order: int
    :ivar title: The artifact title. Required.
    :vartype title: str
    :ivar description: The artifact description. Required.
    :vartype description: str
    :ivar size: The artifact size in MB.
    :vartype size: int
    """

    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    artifact_order: int = rest_field(name="artifactOrder", visibility=["read"])
    """The artifact display order. Required."""
    title: str = rest_field(visibility=["read"])
    """The artifact title. Required."""
    description: str = rest_field(visibility=["read"])
    """The artifact description. Required."""
    size: Optional[int] = rest_field(visibility=["read"])
    """The artifact size in MB."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.disconnectedoperations.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DisconnectedOperation(TrackedResource):
    """Disconnected operation resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.disconnectedoperations.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.disconnectedoperations.models.DisconnectedOperationProperties
    """

    properties: Optional["_models.DisconnectedOperationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.DisconnectedOperationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DisconnectedOperationDeploymentManifest(_Model):
    """The disconnected operation manifest.

    :ivar resource_id: The resource identifier of the disconnected operations resource. Required.
    :vartype resource_id: str
    :ivar resource_name: The resource name. Required.
    :vartype resource_name: str
    :ivar stamp_id: The unique GUID of the stamp. Required.
    :vartype stamp_id: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar billing_model: The billing model. Required. "Capacity"
    :vartype billing_model: str or ~azure.mgmt.disconnectedoperations.models.BillingModel
    :ivar connection_intent: The connection intent. Required. Known values are: "Connected" and
     "Disconnected".
    :vartype connection_intent: str or ~azure.mgmt.disconnectedoperations.models.ConnectionIntent
    :ivar cloud: The cloud in which the resource is registered.
    :vartype cloud: str
    """

    resource_id: str = rest_field(name="resourceId", visibility=["read"])
    """The resource identifier of the disconnected operations resource. Required."""
    resource_name: str = rest_field(name="resourceName", visibility=["read"])
    """The resource name. Required."""
    stamp_id: str = rest_field(name="stampId", visibility=["read"])
    """The unique GUID of the stamp. Required."""
    location: str = rest_field(visibility=["read"])
    """The resource location. Required."""
    billing_model: Union[str, "_models.BillingModel"] = rest_field(name="billingModel", visibility=["read"])
    """The billing model. Required. \"Capacity\""""
    connection_intent: Union[str, "_models.ConnectionIntent"] = rest_field(name="connectionIntent", visibility=["read"])
    """The connection intent. Required. Known values are: \"Connected\" and \"Disconnected\"."""
    cloud: Optional[str] = rest_field(visibility=["read"])
    """The cloud in which the resource is registered."""


class DisconnectedOperationProperties(_Model):
    """The disconnected operation properties.

    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.disconnectedoperations.models.ResourceProvisioningState
    :ivar stamp_id: The unique GUID of the stamp. Required.
    :vartype stamp_id: str
    :ivar billing_model: The billing model. Required. "Capacity"
    :vartype billing_model: str or ~azure.mgmt.disconnectedoperations.models.BillingModel
    :ivar connection_intent: The connection intent. Required. Known values are: "Connected" and
     "Disconnected".
    :vartype connection_intent: str or ~azure.mgmt.disconnectedoperations.models.ConnectionIntent
    :ivar connection_status: The connection status. Known values are: "Connected" and
     "Disconnected".
    :vartype connection_status: str or ~azure.mgmt.disconnectedoperations.models.ConnectionStatus
    :ivar registration_status: The registration intent. Known values are: "Registered" and
     "Unregistered".
    :vartype registration_status: str or
     ~azure.mgmt.disconnectedoperations.models.RegistrationStatus
    :ivar device_version: The device version.
    :vartype device_version: str
    """

    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    stamp_id: str = rest_field(name="stampId", visibility=["read"])
    """The unique GUID of the stamp. Required."""
    billing_model: Union[str, "_models.BillingModel"] = rest_field(name="billingModel", visibility=["read"])
    """The billing model. Required. \"Capacity\""""
    connection_intent: Union[str, "_models.ConnectionIntent"] = rest_field(
        name="connectionIntent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The connection intent. Required. Known values are: \"Connected\" and \"Disconnected\"."""
    connection_status: Optional[Union[str, "_models.ConnectionStatus"]] = rest_field(
        name="connectionStatus", visibility=["read"]
    )
    """The connection status. Known values are: \"Connected\" and \"Disconnected\"."""
    registration_status: Optional[Union[str, "_models.RegistrationStatus"]] = rest_field(
        name="registrationStatus", visibility=["read", "update"]
    )
    """The registration intent. Known values are: \"Registered\" and \"Unregistered\"."""
    device_version: Optional[str] = rest_field(name="deviceVersion", visibility=["read", "update"])
    """The device version."""

    @overload
    def __init__(
        self,
        *,
        connection_intent: Union[str, "_models.ConnectionIntent"],
        registration_status: Optional[Union[str, "_models.RegistrationStatus"]] = None,
        device_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DisconnectedOperationUpdate(_Model):
    """The type used for update operations of the DisconnectedOperation.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.disconnectedoperations.models.DisconnectedOperationUpdateProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.DisconnectedOperationUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.DisconnectedOperationUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DisconnectedOperationUpdateProperties(_Model):
    """The updatable properties of the DisconnectedOperation.

    :ivar connection_intent: The connection intent. Known values are: "Connected" and
     "Disconnected".
    :vartype connection_intent: str or ~azure.mgmt.disconnectedoperations.models.ConnectionIntent
    :ivar registration_status: The registration intent. Known values are: "Registered" and
     "Unregistered".
    :vartype registration_status: str or
     ~azure.mgmt.disconnectedoperations.models.RegistrationStatus
    :ivar device_version: The device version.
    :vartype device_version: str
    """

    connection_intent: Optional[Union[str, "_models.ConnectionIntent"]] = rest_field(
        name="connectionIntent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The connection intent. Known values are: \"Connected\" and \"Disconnected\"."""
    registration_status: Optional[Union[str, "_models.RegistrationStatus"]] = rest_field(
        name="registrationStatus", visibility=["read", "update"]
    )
    """The registration intent. Known values are: \"Registered\" and \"Unregistered\"."""
    device_version: Optional[str] = rest_field(name="deviceVersion", visibility=["read", "update"])
    """The device version."""

    @overload
    def __init__(
        self,
        *,
        connection_intent: Optional[Union[str, "_models.ConnectionIntent"]] = None,
        registration_status: Optional[Union[str, "_models.RegistrationStatus"]] = None,
        device_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.disconnectedoperations.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.disconnectedoperations.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.disconnectedoperations.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Image(ProxyResource):
    """Holds the release information of a disconnected operations image.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.disconnectedoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.disconnectedoperations.models.ImageProperties
    """

    properties: Optional["_models.ImageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ImageProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageDownloadResult(_Model):
    """The image download properties.

    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.disconnectedoperations.models.ResourceProvisioningState
    :ivar release_version: The version of the package in the format 1.1.1. Required.
    :vartype release_version: str
    :ivar release_display_name: The release name. Required.
    :vartype release_display_name: str
    :ivar release_notes: The release notes. Required.
    :vartype release_notes: str
    :ivar release_date: The release date. Required.
    :vartype release_date: ~datetime.date
    :ivar release_type: The release type. Required. Known values are: "Install" and "Update".
    :vartype release_type: str or ~azure.mgmt.disconnectedoperations.models.ReleaseType
    :ivar compatible_versions: The versions that are compatible for this update package.
    :vartype compatible_versions: list[str]
    :ivar transaction_id: The unique identifier of the download. Required.
    :vartype transaction_id: str
    :ivar download_link: The download URI. Required.
    :vartype download_link: str
    :ivar link_expiry: The download link expiry time. Required.
    :vartype link_expiry: ~datetime.datetime
    """

    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    release_version: str = rest_field(name="releaseVersion", visibility=["read"])
    """The version of the package in the format 1.1.1. Required."""
    release_display_name: str = rest_field(name="releaseDisplayName", visibility=["read"])
    """The release name. Required."""
    release_notes: str = rest_field(name="releaseNotes", visibility=["read"])
    """The release notes. Required."""
    release_date: datetime.date = rest_field(name="releaseDate", visibility=["read"])
    """The release date. Required."""
    release_type: Union[str, "_models.ReleaseType"] = rest_field(name="releaseType", visibility=["read"])
    """The release type. Required. Known values are: \"Install\" and \"Update\"."""
    compatible_versions: Optional[list[str]] = rest_field(name="compatibleVersions", visibility=["read"])
    """The versions that are compatible for this update package."""
    transaction_id: str = rest_field(name="transactionId", visibility=["read"])
    """The unique identifier of the download. Required."""
    download_link: str = rest_field(name="downloadLink", visibility=["read"])
    """The download URI. Required."""
    link_expiry: datetime.datetime = rest_field(name="linkExpiry", visibility=["read"], format="rfc3339")
    """The download link expiry time. Required."""


class ImageProperties(_Model):
    """The image properties.

    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.disconnectedoperations.models.ResourceProvisioningState
    :ivar release_version: The version of the package in the format 1.1.1. Required.
    :vartype release_version: str
    :ivar release_display_name: The release name. Required.
    :vartype release_display_name: str
    :ivar release_notes: The release notes. Required.
    :vartype release_notes: str
    :ivar release_date: The release date. Required.
    :vartype release_date: ~datetime.date
    :ivar release_type: The release type. Required. Known values are: "Install" and "Update".
    :vartype release_type: str or ~azure.mgmt.disconnectedoperations.models.ReleaseType
    :ivar compatible_versions: The versions that are compatible for this update package.
    :vartype compatible_versions: list[str]
    """

    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    release_version: str = rest_field(name="releaseVersion", visibility=["read"])
    """The version of the package in the format 1.1.1. Required."""
    release_display_name: str = rest_field(name="releaseDisplayName", visibility=["read"])
    """The release name. Required."""
    release_notes: str = rest_field(name="releaseNotes", visibility=["read"])
    """The release notes. Required."""
    release_date: datetime.date = rest_field(name="releaseDate", visibility=["read"])
    """The release date. Required."""
    release_type: Union[str, "_models.ReleaseType"] = rest_field(name="releaseType", visibility=["read"])
    """The release type. Required. Known values are: \"Install\" and \"Update\"."""
    compatible_versions: Optional[list[str]] = rest_field(name="compatibleVersions", visibility=["read"])
    """The versions that are compatible for this update package."""


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.disconnectedoperations.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.disconnectedoperations.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
