# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.devtestlabs import DevTestLabsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDevTestLabsLabsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DevTestLabsClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.labs.list_by_subscription(
            api_version="2018-09-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.labs.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2018-09-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.labs.get(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.labs.begin_create_or_update(
            resource_group_name=resource_group.name,
            name="str",
            lab={
                "announcement": {
                    "enabled": "str",
                    "expirationDate": "2020-02-20 00:00:00",
                    "expired": bool,
                    "markdown": "str",
                    "provisioningState": "str",
                    "title": "str",
                    "uniqueIdentifier": "str",
                },
                "artifactsStorageAccount": "str",
                "createdDate": "2020-02-20 00:00:00",
                "defaultPremiumStorageAccount": "str",
                "defaultStorageAccount": "str",
                "environmentPermission": "str",
                "extendedProperties": {"str": "str"},
                "id": "str",
                "labStorageType": "str",
                "loadBalancerId": "str",
                "location": "str",
                "mandatoryArtifactsResourceIdsLinux": ["str"],
                "mandatoryArtifactsResourceIdsWindows": ["str"],
                "name": "str",
                "networkSecurityGroupId": "str",
                "premiumDataDiskStorageAccount": "str",
                "premiumDataDisks": "str",
                "provisioningState": "str",
                "publicIpId": "str",
                "support": {"enabled": "str", "markdown": "str"},
                "tags": {"str": "str"},
                "type": "str",
                "uniqueIdentifier": "str",
                "vaultName": "str",
                "vmCreationResourceGroup": "str",
            },
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.labs.begin_delete(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.labs.update(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_claim_any_vm(self, resource_group):
        response = self.client.labs.begin_claim_any_vm(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_environment(self, resource_group):
        response = self.client.labs.begin_create_environment(
            resource_group_name=resource_group.name,
            name="str",
            lab_virtual_machine_creation_parameter={
                "allowClaim": False,
                "artifacts": [
                    {
                        "artifactId": "str",
                        "artifactTitle": "str",
                        "deploymentStatusMessage": "str",
                        "installTime": "2020-02-20 00:00:00",
                        "parameters": [{"name": "str", "value": "str"}],
                        "status": "str",
                        "vmExtensionStatusMessage": "str",
                    }
                ],
                "bulkCreationParameters": {"instanceCount": 0},
                "createdDate": "2020-02-20 00:00:00",
                "customImageId": "str",
                "dataDiskParameters": [
                    {
                        "attachNewDataDiskOptions": {"diskName": "str", "diskSizeGiB": 0, "diskType": "str"},
                        "existingLabDiskId": "str",
                        "hostCaching": "str",
                    }
                ],
                "disallowPublicIpAddress": False,
                "environmentId": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "galleryImageReference": {
                    "offer": "str",
                    "osType": "str",
                    "publisher": "str",
                    "sku": "str",
                    "version": "str",
                },
                "isAuthenticationWithSshKey": bool,
                "labSubnetName": "str",
                "labVirtualNetworkId": "str",
                "location": "str",
                "name": "str",
                "networkInterface": {
                    "dnsName": "str",
                    "privateIpAddress": "str",
                    "publicIpAddress": "str",
                    "publicIpAddressId": "str",
                    "rdpAuthority": "str",
                    "sharedPublicIpAddressConfiguration": {
                        "inboundNatRules": [{"backendPort": 0, "frontendPort": 0, "transportProtocol": "str"}]
                    },
                    "sshAuthority": "str",
                    "subnetId": "str",
                    "virtualNetworkId": "str",
                },
                "notes": "str",
                "ownerObjectId": "dynamicValue",
                "ownerUserPrincipalName": "str",
                "password": "str",
                "planId": "str",
                "scheduleParameters": [
                    {
                        "dailyRecurrence": {"time": "str"},
                        "hourlyRecurrence": {"minute": 0},
                        "location": "str",
                        "name": "str",
                        "notificationSettings": {
                            "emailRecipient": "str",
                            "notificationLocale": "str",
                            "status": "str",
                            "timeInMinutes": 0,
                            "webhookUrl": "str",
                        },
                        "status": "str",
                        "tags": {"str": "str"},
                        "targetResourceId": "str",
                        "taskType": "str",
                        "timeZoneId": "str",
                        "weeklyRecurrence": {"time": "str", "weekdays": ["str"]},
                    }
                ],
                "size": "str",
                "sshKey": "str",
                "storageType": "labStorageType",
                "tags": {"str": "str"},
                "userName": "str",
            },
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_export_resource_usage(self, resource_group):
        response = self.client.labs.begin_export_resource_usage(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_generate_upload_uri(self, resource_group):
        response = self.client.labs.generate_upload_uri(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_import_virtual_machine(self, resource_group):
        response = self.client.labs.begin_import_virtual_machine(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_vhds(self, resource_group):
        response = self.client.labs.list_vhds(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2018-09-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
