# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dataprotection.aio import DataProtectionMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataProtectionMgmtResourceGuardsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataProtectionMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_default_delete_resource_guard_proxy_requests_object(self, resource_group):
        response = await self.client.resource_guards.get_default_delete_resource_guard_proxy_requests_object(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            request_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_delete_resource_guard_proxy_requests_objects(self, resource_group):
        response = self.client.resource_guards.get_delete_resource_guard_proxy_requests_objects(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get(self, resource_group):
        response = await self.client.resource_guards.get(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_put(self, resource_group):
        response = await self.client.resource_guards.put(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            parameters={
                "location": "str",
                "eTag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "allowAutoApprovals": bool,
                    "description": "str",
                    "provisioningState": "str",
                    "resourceGuardOperations": [{"requestResourceType": "str", "vaultCriticalOperation": "str"}],
                    "vaultCriticalOperationExclusionList": ["str"],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_patch(self, resource_group):
        response = await self.client.resource_guards.patch(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            parameters={"tags": {"str": "str"}},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_delete(self, resource_group):
        response = await self.client.resource_guards.delete(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_resources_in_resource_group(self, resource_group):
        response = self.client.resource_guards.get_resources_in_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_resources_in_subscription(self, resource_group):
        response = self.client.resource_guards.get_resources_in_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_default_disable_soft_delete_requests_object(self, resource_group):
        response = await self.client.resource_guards.get_default_disable_soft_delete_requests_object(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            request_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_disable_soft_delete_requests_objects(self, resource_group):
        response = self.client.resource_guards.get_disable_soft_delete_requests_objects(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_default_update_protected_item_requests_object(self, resource_group):
        response = await self.client.resource_guards.get_default_update_protected_item_requests_object(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            request_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_update_protected_item_requests_objects(self, resource_group):
        response = self.client.resource_guards.get_update_protected_item_requests_objects(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_default_update_protection_policy_requests_object(self, resource_group):
        response = await self.client.resource_guards.get_default_update_protection_policy_requests_object(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            request_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_update_protection_policy_requests_objects(self, resource_group):
        response = self.client.resource_guards.get_update_protection_policy_requests_objects(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_default_delete_protected_item_requests_object(self, resource_group):
        response = await self.client.resource_guards.get_default_delete_protected_item_requests_object(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            request_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_delete_protected_item_requests_objects(self, resource_group):
        response = self.client.resource_guards.get_delete_protected_item_requests_objects(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_default_backup_security_pin_requests_object(self, resource_group):
        response = await self.client.resource_guards.get_default_backup_security_pin_requests_object(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
            request_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resource_guards_get_backup_security_pin_requests_objects(self, resource_group):
        response = self.client.resource_guards.get_backup_security_pin_requests_objects(
            resource_group_name=resource_group.name,
            resource_guards_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
