# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AccessKeys(_serialization.Model):
    """Namespace/ServiceBus Connection String.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_connection_string: Primary connection string of the created namespace
     authorization rule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the created namespace
     authorization rule.
    :vartype secondary_connection_string: str
    :ivar alias_primary_connection_string: Primary connection string of the alias if GEO DR is
     enabled.
    :vartype alias_primary_connection_string: str
    :ivar alias_secondary_connection_string: Secondary  connection string of the alias if GEO DR is
     enabled.
    :vartype alias_secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the authorization rule.
    :vartype key_name: str
    """

    _validation = {
        "primary_connection_string": {"readonly": True},
        "secondary_connection_string": {"readonly": True},
        "alias_primary_connection_string": {"readonly": True},
        "alias_secondary_connection_string": {"readonly": True},
        "primary_key": {"readonly": True},
        "secondary_key": {"readonly": True},
        "key_name": {"readonly": True},
    }

    _attribute_map = {
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
        "alias_primary_connection_string": {"key": "aliasPrimaryConnectionString", "type": "str"},
        "alias_secondary_connection_string": {"key": "aliasSecondaryConnectionString", "type": "str"},
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_connection_string: Optional[str] = None
        self.secondary_connection_string: Optional[str] = None
        self.alias_primary_connection_string: Optional[str] = None
        self.alias_secondary_connection_string: Optional[str] = None
        self.primary_key: Optional[str] = None
        self.secondary_key: Optional[str] = None
        self.key_name: Optional[str] = None


class Action(_serialization.Model):
    """Represents the filter actions which are allowed for the transformation of a message that have
    been matched by a filter expression.

    :ivar sql_expression: SQL expression. e.g. MyProperty='ABC'.
    :vartype sql_expression: str
    :ivar compatibility_level: This property is reserved for future use. An integer value showing
     the compatibility level, currently hard-coded to 20.
    :vartype compatibility_level: int
    :ivar requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :vartype requires_preprocessing: bool
    """

    _attribute_map = {
        "sql_expression": {"key": "sqlExpression", "type": "str"},
        "compatibility_level": {"key": "compatibilityLevel", "type": "int"},
        "requires_preprocessing": {"key": "requiresPreprocessing", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sql_expression: Optional[str] = None,
        compatibility_level: Optional[int] = None,
        requires_preprocessing: bool = True,
        **kwargs: Any
    ) -> None:
        """
        :keyword sql_expression: SQL expression. e.g. MyProperty='ABC'.
        :paramtype sql_expression: str
        :keyword compatibility_level: This property is reserved for future use. An integer value
         showing the compatibility level, currently hard-coded to 20.
        :paramtype compatibility_level: int
        :keyword requires_preprocessing: Value that indicates whether the rule action requires
         preprocessing.
        :paramtype requires_preprocessing: bool
        """
        super().__init__(**kwargs)
        self.sql_expression = sql_expression
        self.compatibility_level = compatibility_level
        self.requires_preprocessing = requires_preprocessing


class ProxyResource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location: Optional[str] = None


class ArmDisasterRecovery(ProxyResource):
    """Single item in List or Get Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar provisioning_state: Provisioning state of the Alias(Disaster Recovery configuration) -
     possible values 'Accepted' or 'Succeeded' or 'Failed'. Known values are: "Accepted",
     "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.ProvisioningStateDR
    :ivar pending_replication_operations_count: Number of entities pending to be replicated.
    :vartype pending_replication_operations_count: int
    :ivar partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is part
     of GEO DR pairing.
    :vartype partner_namespace: str
    :ivar alternate_name: Primary/Secondary eventhub namespace name, which is part of GEO DR
     pairing.
    :vartype alternate_name: str
    :ivar role: role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating'
     or 'Secondary'. Known values are: "Primary", "PrimaryNotReplicating", and "Secondary".
    :vartype role: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.RoleDisasterRecovery
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "pending_replication_operations_count": {"readonly": True},
        "role": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "pending_replication_operations_count": {"key": "properties.pendingReplicationOperationsCount", "type": "int"},
        "partner_namespace": {"key": "properties.partnerNamespace", "type": "str"},
        "alternate_name": {"key": "properties.alternateName", "type": "str"},
        "role": {"key": "properties.role", "type": "str"},
    }

    def __init__(
        self, *, partner_namespace: Optional[str] = None, alternate_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is
         part of GEO DR pairing.
        :paramtype partner_namespace: str
        :keyword alternate_name: Primary/Secondary eventhub namespace name, which is part of GEO DR
         pairing.
        :paramtype alternate_name: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningStateDR"]] = None
        self.pending_replication_operations_count: Optional[int] = None
        self.partner_namespace = partner_namespace
        self.alternate_name = alternate_name
        self.role: Optional[Union[str, "_models.RoleDisasterRecovery"]] = None


class ArmDisasterRecoveryListResult(_serialization.Model):
    """The result of the List Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Alias(Disaster Recovery configurations).
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.ArmDisasterRecovery]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Alias(Disaster Recovery configuration).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ArmDisasterRecovery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ArmDisasterRecovery"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Alias(Disaster Recovery configurations).
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.ArmDisasterRecovery]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class CheckNameAvailability(_serialization.Model):
    """Description of a Check Name availability request properties.

    All required parameters must be populated in order to send to server.

    :ivar name: The Name to check the namespace name availability and The namespace name can
     contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must
     end with a letter or number. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The Name to check the namespace name availability and The namespace name can
         contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must
         end with a letter or number. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(_serialization.Model):
    """Description of a Check Name availability request properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: The detailed info regarding the reason associated with the namespace.
    :vartype message: str
    :ivar name_available: Value indicating namespace is availability, true if the namespace is
     available; otherwise, false.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability of a namespace. Known values are: "None",
     "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown", and
     "TooManyNamespaceInCurrentSubscription".
    :vartype reason: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.UnavailableReason
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.UnavailableReason"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Value indicating namespace is availability, true if the namespace is
         available; otherwise, false.
        :paramtype name_available: bool
        :keyword reason: The reason for unavailability of a namespace. Known values are: "None",
         "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown", and
         "TooManyNamespaceInCurrentSubscription".
        :paramtype reason: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.UnavailableReason
        """
        super().__init__(**kwargs)
        self.message: Optional[str] = None
        self.name_available = name_available
        self.reason = reason


class ConnectionState(_serialization.Model):
    """ConnectionState information.

    :ivar status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
     and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateLinkConnectionStatus
    :ivar description: Description of the connection state.
    :vartype description: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateLinkConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
         and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateLinkConnectionStatus
        :keyword description: Description of the connection state.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description


class CorrelationFilter(_serialization.Model):
    """Represents the correlation filter expression.

    :ivar properties: dictionary object for custom filters.
    :vartype properties: dict[str, str]
    :ivar correlation_id: Identifier of the correlation.
    :vartype correlation_id: str
    :ivar message_id: Identifier of the message.
    :vartype message_id: str
    :ivar to: Address to send to.
    :vartype to: str
    :ivar reply_to: Address of the queue to reply to.
    :vartype reply_to: str
    :ivar label: Application specific label.
    :vartype label: str
    :ivar session_id: Session identifier.
    :vartype session_id: str
    :ivar reply_to_session_id: Session identifier to reply to.
    :vartype reply_to_session_id: str
    :ivar content_type: Content type of the message.
    :vartype content_type: str
    :ivar requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :vartype requires_preprocessing: bool
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "{str}"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "message_id": {"key": "messageId", "type": "str"},
        "to": {"key": "to", "type": "str"},
        "reply_to": {"key": "replyTo", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "session_id": {"key": "sessionId", "type": "str"},
        "reply_to_session_id": {"key": "replyToSessionId", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "requires_preprocessing": {"key": "requiresPreprocessing", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional[Dict[str, str]] = None,
        correlation_id: Optional[str] = None,
        message_id: Optional[str] = None,
        to: Optional[str] = None,
        reply_to: Optional[str] = None,
        label: Optional[str] = None,
        session_id: Optional[str] = None,
        reply_to_session_id: Optional[str] = None,
        content_type: Optional[str] = None,
        requires_preprocessing: bool = True,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: dictionary object for custom filters.
        :paramtype properties: dict[str, str]
        :keyword correlation_id: Identifier of the correlation.
        :paramtype correlation_id: str
        :keyword message_id: Identifier of the message.
        :paramtype message_id: str
        :keyword to: Address to send to.
        :paramtype to: str
        :keyword reply_to: Address of the queue to reply to.
        :paramtype reply_to: str
        :keyword label: Application specific label.
        :paramtype label: str
        :keyword session_id: Session identifier.
        :paramtype session_id: str
        :keyword reply_to_session_id: Session identifier to reply to.
        :paramtype reply_to_session_id: str
        :keyword content_type: Content type of the message.
        :paramtype content_type: str
        :keyword requires_preprocessing: Value that indicates whether the rule action requires
         preprocessing.
        :paramtype requires_preprocessing: bool
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.correlation_id = correlation_id
        self.message_id = message_id
        self.to = to
        self.reply_to = reply_to
        self.label = label
        self.session_id = session_id
        self.reply_to_session_id = reply_to_session_id
        self.content_type = content_type
        self.requires_preprocessing = requires_preprocessing


class Encryption(_serialization.Model):
    """Properties to configure Encryption.

    :ivar key_vault_properties: Properties of KeyVault.
    :vartype key_vault_properties:
     list[~azure.mgmt.servicebus.v2022_10_01_preview.models.KeyVaultProperties]
    :ivar key_source: Enumerates the possible value of keySource for Encryption. Default value is
     "Microsoft.KeyVault".
    :vartype key_source: str
    :ivar require_infrastructure_encryption: Enable Infrastructure Encryption (Double Encryption).
    :vartype require_infrastructure_encryption: bool
    """

    _attribute_map = {
        "key_vault_properties": {"key": "keyVaultProperties", "type": "[KeyVaultProperties]"},
        "key_source": {"key": "keySource", "type": "str"},
        "require_infrastructure_encryption": {"key": "requireInfrastructureEncryption", "type": "bool"},
    }

    def __init__(
        self,
        *,
        key_vault_properties: Optional[List["_models.KeyVaultProperties"]] = None,
        key_source: Literal["Microsoft.KeyVault"] = "Microsoft.KeyVault",
        require_infrastructure_encryption: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_properties: Properties of KeyVault.
        :paramtype key_vault_properties:
         list[~azure.mgmt.servicebus.v2022_10_01_preview.models.KeyVaultProperties]
        :keyword key_source: Enumerates the possible value of keySource for Encryption. Default value
         is "Microsoft.KeyVault".
        :paramtype key_source: str
        :keyword require_infrastructure_encryption: Enable Infrastructure Encryption (Double
         Encryption).
        :paramtype require_infrastructure_encryption: bool
        """
        super().__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.key_source = key_source
        self.require_infrastructure_encryption = require_infrastructure_encryption


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorResponse(_serialization.Model):
    """The resource management error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.servicebus.v2022_10_01_preview.models.ErrorResponseError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseError"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.servicebus.v2022_10_01_preview.models.ErrorResponseError
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseError(_serialization.Model):
    """The error object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.servicebus.v2022_10_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorResponse"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class FailoverProperties(_serialization.Model):
    """Safe failover is to indicate the service should wait for pending replication to finish before
    switching to the secondary.

    :ivar is_safe_failover: Safe failover is to indicate the service should wait for pending
     replication to finish before switching to the secondary.
    :vartype is_safe_failover: bool
    """

    _attribute_map = {
        "is_safe_failover": {"key": "properties.IsSafeFailover", "type": "bool"},
    }

    def __init__(self, *, is_safe_failover: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_safe_failover: Safe failover is to indicate the service should wait for pending
         replication to finish before switching to the secondary.
        :paramtype is_safe_failover: bool
        """
        super().__init__(**kwargs)
        self.is_safe_failover = is_safe_failover


class Identity(_serialization.Model):
    """Properties to configure User Assigned Identities for Bring your Own Keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: ObjectId from the KeyVault.
    :vartype principal_id: str
    :ivar tenant_id: TenantId from the KeyVault.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: Properties for User Assigned Identities.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: Properties for User Assigned Identities.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class KeyVaultProperties(_serialization.Model):
    """Properties to configure keyVault Properties.

    :ivar key_name: Name of the Key from KeyVault.
    :vartype key_name: str
    :ivar key_vault_uri: Uri of KeyVault.
    :vartype key_vault_uri: str
    :ivar key_version: Version of KeyVault.
    :vartype key_version: str
    :ivar identity:
    :vartype identity:
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.UserAssignedIdentityProperties
    """

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
        "identity": {"key": "identity", "type": "UserAssignedIdentityProperties"},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        key_version: Optional[str] = None,
        identity: Optional["_models.UserAssignedIdentityProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_name: Name of the Key from KeyVault.
        :paramtype key_name: str
        :keyword key_vault_uri: Uri of KeyVault.
        :paramtype key_vault_uri: str
        :keyword key_version: Version of KeyVault.
        :paramtype key_version: str
        :keyword identity:
        :paramtype identity:
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.UserAssignedIdentityProperties
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_vault_uri = key_vault_uri
        self.key_version = key_version
        self.identity = identity


class MessageCountDetails(_serialization.Model):
    """Message Count Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar active_message_count: Number of active messages in the queue, topic, or subscription.
    :vartype active_message_count: int
    :ivar dead_letter_message_count: Number of messages that are dead lettered.
    :vartype dead_letter_message_count: int
    :ivar scheduled_message_count: Number of scheduled messages.
    :vartype scheduled_message_count: int
    :ivar transfer_message_count: Number of messages transferred to another queue, topic, or
     subscription.
    :vartype transfer_message_count: int
    :ivar transfer_dead_letter_message_count: Number of messages transferred into dead letters.
    :vartype transfer_dead_letter_message_count: int
    """

    _validation = {
        "active_message_count": {"readonly": True},
        "dead_letter_message_count": {"readonly": True},
        "scheduled_message_count": {"readonly": True},
        "transfer_message_count": {"readonly": True},
        "transfer_dead_letter_message_count": {"readonly": True},
    }

    _attribute_map = {
        "active_message_count": {"key": "activeMessageCount", "type": "int"},
        "dead_letter_message_count": {"key": "deadLetterMessageCount", "type": "int"},
        "scheduled_message_count": {"key": "scheduledMessageCount", "type": "int"},
        "transfer_message_count": {"key": "transferMessageCount", "type": "int"},
        "transfer_dead_letter_message_count": {"key": "transferDeadLetterMessageCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.active_message_count: Optional[int] = None
        self.dead_letter_message_count: Optional[int] = None
        self.scheduled_message_count: Optional[int] = None
        self.transfer_message_count: Optional[int] = None
        self.transfer_dead_letter_message_count: Optional[int] = None


class MigrationConfigListResult(_serialization.Model):
    """The result of the List migrationConfigurations operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Migration Configs.
    :vartype value:
     list[~azure.mgmt.servicebus.v2022_10_01_preview.models.MigrationConfigProperties]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of migrationConfigurations.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MigrationConfigProperties]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.MigrationConfigProperties"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Migration Configs.
        :paramtype value:
         list[~azure.mgmt.servicebus.v2022_10_01_preview.models.MigrationConfigProperties]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class MigrationConfigProperties(ProxyResource):
    """Single item in List or Get Migration Config operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar provisioning_state: Provisioning state of Migration Configuration.
    :vartype provisioning_state: str
    :ivar pending_replication_operations_count: Number of entities pending to be replicated.
    :vartype pending_replication_operations_count: int
    :ivar target_namespace: Existing premium Namespace ARM Id name which has no entities, will be
     used for migration.
    :vartype target_namespace: str
    :ivar post_migration_name: Name to access Standard Namespace after migration.
    :vartype post_migration_name: str
    :ivar migration_state: State in which Standard to Premium Migration is, possible values :
     Unknown, Reverting, Completing, Initiating, Syncing, Active.
    :vartype migration_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "pending_replication_operations_count": {"readonly": True},
        "migration_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "pending_replication_operations_count": {"key": "properties.pendingReplicationOperationsCount", "type": "int"},
        "target_namespace": {"key": "properties.targetNamespace", "type": "str"},
        "post_migration_name": {"key": "properties.postMigrationName", "type": "str"},
        "migration_state": {"key": "properties.migrationState", "type": "str"},
    }

    def __init__(
        self, *, target_namespace: Optional[str] = None, post_migration_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword target_namespace: Existing premium Namespace ARM Id name which has no entities, will
         be used for migration.
        :paramtype target_namespace: str
        :keyword post_migration_name: Name to access Standard Namespace after migration.
        :paramtype post_migration_name: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.provisioning_state: Optional[str] = None
        self.pending_replication_operations_count: Optional[int] = None
        self.target_namespace = target_namespace
        self.post_migration_name = post_migration_name
        self.migration_state: Optional[str] = None


class NetworkRuleSet(ProxyResource):
    """Description of NetworkRuleSet resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar trusted_service_access_enabled: Value that indicates whether Trusted Service Access is
     Enabled or not.
    :vartype trusted_service_access_enabled: bool
    :ivar default_action: Default Action for Network Rule Set. Known values are: "Allow" and
     "Deny".
    :vartype default_action: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.DefaultAction
    :ivar virtual_network_rules: List VirtualNetwork Rules.
    :vartype virtual_network_rules:
     list[~azure.mgmt.servicebus.v2022_10_01_preview.models.NWRuleSetVirtualNetworkRules]
    :ivar ip_rules: List of IpRules.
    :vartype ip_rules: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.NWRuleSetIpRules]
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.PublicNetworkAccessFlag
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "trusted_service_access_enabled": {"key": "properties.trustedServiceAccessEnabled", "type": "bool"},
        "default_action": {"key": "properties.defaultAction", "type": "str"},
        "virtual_network_rules": {"key": "properties.virtualNetworkRules", "type": "[NWRuleSetVirtualNetworkRules]"},
        "ip_rules": {"key": "properties.ipRules", "type": "[NWRuleSetIpRules]"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        trusted_service_access_enabled: Optional[bool] = None,
        default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        virtual_network_rules: Optional[List["_models.NWRuleSetVirtualNetworkRules"]] = None,
        ip_rules: Optional[List["_models.NWRuleSetIpRules"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccessFlag"] = "Enabled",
        **kwargs: Any
    ) -> None:
        """
        :keyword trusted_service_access_enabled: Value that indicates whether Trusted Service Access is
         Enabled or not.
        :paramtype trusted_service_access_enabled: bool
        :keyword default_action: Default Action for Network Rule Set. Known values are: "Allow" and
         "Deny".
        :paramtype default_action: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.DefaultAction
        :keyword virtual_network_rules: List VirtualNetwork Rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.servicebus.v2022_10_01_preview.models.NWRuleSetVirtualNetworkRules]
        :keyword ip_rules: List of IpRules.
        :paramtype ip_rules: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.NWRuleSetIpRules]
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.PublicNetworkAccessFlag
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.trusted_service_access_enabled = trusted_service_access_enabled
        self.default_action = default_action
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.public_network_access = public_network_access


class NetworkRuleSetListResult(_serialization.Model):
    """The response of the List NetworkRuleSet operation.

    :ivar value: Result of the List NetworkRuleSet operation.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.NetworkRuleSet]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of NetworkRuleSet.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkRuleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkRuleSet"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List NetworkRuleSet operation.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.NetworkRuleSet]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of NetworkRuleSet.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NWRuleSetIpRules(_serialization.Model):
    """Description of NetWorkRuleSet - IpRules resource.

    :ivar ip_mask: IP Mask.
    :vartype ip_mask: str
    :ivar action: The IP Filter Action. "Allow"
    :vartype action: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.NetworkRuleIPAction
    """

    _attribute_map = {
        "ip_mask": {"key": "ipMask", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Union[str, "_models.NetworkRuleIPAction"] = "Allow",
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_mask: IP Mask.
        :paramtype ip_mask: str
        :keyword action: The IP Filter Action. "Allow"
        :paramtype action: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.NetworkRuleIPAction
        """
        super().__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class NWRuleSetVirtualNetworkRules(_serialization.Model):
    """Description of VirtualNetworkRules - NetworkRules resource.

    :ivar subnet: Subnet properties.
    :vartype subnet: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Subnet
    :ivar ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing VNet
     Service Endpoint.
    :vartype ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "Subnet"},
        "ignore_missing_vnet_service_endpoint": {"key": "ignoreMissingVnetServiceEndpoint", "type": "bool"},
    }

    def __init__(
        self,
        *,
        subnet: Optional["_models.Subnet"] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet: Subnet properties.
        :paramtype subnet: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Subnet
        :keyword ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing
         VNet Service Endpoint.
        :paramtype ignore_missing_vnet_service_endpoint: bool
        """
        super().__init__(**kwargs)
        self.subnet = subnet
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint


class Operation(_serialization.Model):
    """A Service Bus REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.servicebus.v2022_10_01_preview.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: JSON
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~azure.mgmt.servicebus.v2022_10_01_preview.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Properties of the operation.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """Operation display payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """Result of the request to list ServiceBus operations. It contains a list of operations and a URL
    link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ServiceBus operations supported by the Microsoft.ServiceBus resource
     provider.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class PrivateEndpoint(_serialization.Model):
    """PrivateEndpoint information.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM identifier for Private Endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(ProxyResource):
    """Properties of the PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar private_endpoint: The Private Endpoint resource for this Connection.
    :vartype private_endpoint: ~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Details about the state of the connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.ConnectionState
    :ivar provisioning_state: Provisioning state of the Private Endpoint Connection. Known values
     are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.EndPointProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "ConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.ConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.EndPointProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The Private Endpoint resource for this Connection.
        :paramtype private_endpoint: ~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Details about the state of the connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.ConnectionState
        :keyword provisioning_state: Provisioning state of the Private Endpoint Connection. Known
         values are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_state: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.EndPointProvisioningState
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :ivar value: A collection of private endpoint connection resources.
    :vartype value:
     list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpointConnection]
    :ivar next_link: A link for the next page of private endpoint connection resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private endpoint connection resources.
        :paramtype value:
         list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpointConnection]
        :keyword next_link: A link for the next page of private endpoint connection resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(_serialization.Model):
    """Information of the private link resource.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar group_id:
    :vartype group_id: str
    :ivar required_members: Required Members.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required Zone Names.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified identifier of the resource.
        :paramtype id: str
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword group_id:
        :paramtype group_id: str
        :keyword required_members: Required Members.
        :paramtype required_members: list[str]
        :keyword required_zone_names: Required Zone Names.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourcesListResult(_serialization.Model):
    """Result of the List private link resources operation.

    :ivar value: A collection of private link resources.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateLinkResource]
    :ivar next_link: A link for the next page of private link resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private link resources.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateLinkResource]
        :keyword next_link: A link for the next page of private link resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegenerateAccessKeyParameters(_serialization.Model):
    """Parameters supplied to the Regenerate Authorization Rule operation, specifies which key needs
    to be reset.

    All required parameters must be populated in order to send to server.

    :ivar key_type: The access key to regenerate. Required. Known values are: "PrimaryKey" and
     "SecondaryKey".
    :vartype key_type: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.KeyType
    :ivar key: Optional, if the key value provided, is reset for KeyType value or autogenerate Key
     value set for keyType.
    :vartype key: str
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key_type: Union[str, "_models.KeyType"], key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_type: The access key to regenerate. Required. Known values are: "PrimaryKey" and
         "SecondaryKey".
        :paramtype key_type: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.KeyType
        :keyword key: Optional, if the key value provided, is reset for KeyType value or autogenerate
         Key value set for keyType.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.key_type = key_type
        self.key = key


class Resource(_serialization.Model):
    """The Resource definition for other than namespace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ResourceNamespacePatch(Resource):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class Rule(ProxyResource):
    """Description of Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar action: Represents the filter actions which are allowed for the transformation of a
     message that have been matched by a filter expression.
    :vartype action: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Action
    :ivar filter_type: Filter type that is evaluated against a BrokeredMessage. Known values are:
     "SqlFilter" and "CorrelationFilter".
    :vartype filter_type: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.FilterType
    :ivar sql_filter: Properties of sqlFilter.
    :vartype sql_filter: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SqlFilter
    :ivar correlation_filter: Properties of correlationFilter.
    :vartype correlation_filter:
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.CorrelationFilter
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "action": {"key": "properties.action", "type": "Action"},
        "filter_type": {"key": "properties.filterType", "type": "str"},
        "sql_filter": {"key": "properties.sqlFilter", "type": "SqlFilter"},
        "correlation_filter": {"key": "properties.correlationFilter", "type": "CorrelationFilter"},
    }

    def __init__(
        self,
        *,
        action: Optional["_models.Action"] = None,
        filter_type: Optional[Union[str, "_models.FilterType"]] = None,
        sql_filter: Optional["_models.SqlFilter"] = None,
        correlation_filter: Optional["_models.CorrelationFilter"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Represents the filter actions which are allowed for the transformation of a
         message that have been matched by a filter expression.
        :paramtype action: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Action
        :keyword filter_type: Filter type that is evaluated against a BrokeredMessage. Known values
         are: "SqlFilter" and "CorrelationFilter".
        :paramtype filter_type: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.FilterType
        :keyword sql_filter: Properties of sqlFilter.
        :paramtype sql_filter: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SqlFilter
        :keyword correlation_filter: Properties of correlationFilter.
        :paramtype correlation_filter:
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.CorrelationFilter
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.action = action
        self.filter_type = filter_type
        self.sql_filter = sql_filter
        self.correlation_filter = correlation_filter


class RuleListResult(_serialization.Model):
    """The response of the List rule operation.

    :ivar value: Result of the List Rules operation.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.Rule]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Rule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Rule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Rules operation.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.Rule]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SBAuthorizationRule(ProxyResource):
    """Description of a namespace authorization rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar rights: The rights associated with the rule.
    :vartype rights: list[str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.AccessRights]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "rights": {"key": "properties.rights", "type": "[str]"},
    }

    def __init__(self, *, rights: Optional[List[Union[str, "_models.AccessRights"]]] = None, **kwargs: Any) -> None:
        """
        :keyword rights: The rights associated with the rule.
        :paramtype rights: list[str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.AccessRights]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.rights = rights


class SBAuthorizationRuleListResult(_serialization.Model):
    """The response to the List Namespace operation.

    :ivar value: Result of the List Authorization Rules operation.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBAuthorizationRule]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Authorization Rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SBAuthorizationRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SBAuthorizationRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Authorization Rules operation.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBAuthorizationRule]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Authorization Rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SBClientAffineProperties(_serialization.Model):
    """Properties specific to client affine subscriptions.

    :ivar client_id: Indicates the Client ID of the application that created the client-affine
     subscription.
    :vartype client_id: str
    :ivar is_durable: For client-affine subscriptions, this value indicates whether the
     subscription is durable or not.
    :vartype is_durable: bool
    :ivar is_shared: For client-affine subscriptions, this value indicates whether the subscription
     is shared or not.
    :vartype is_shared: bool
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "is_durable": {"key": "isDurable", "type": "bool"},
        "is_shared": {"key": "isShared", "type": "bool"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        is_durable: Optional[bool] = None,
        is_shared: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_id: Indicates the Client ID of the application that created the client-affine
         subscription.
        :paramtype client_id: str
        :keyword is_durable: For client-affine subscriptions, this value indicates whether the
         subscription is durable or not.
        :paramtype is_durable: bool
        :keyword is_shared: For client-affine subscriptions, this value indicates whether the
         subscription is shared or not.
        :paramtype is_shared: bool
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.is_durable = is_durable
        self.is_shared = is_shared


class TrackedResource(Resource):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The Geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The Geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class SBNamespace(TrackedResource):
    """Description of a namespace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The Geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Properties of SKU.
    :vartype sku: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SBSku
    :ivar identity: Properties of BYOK Identity description.
    :vartype identity: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Identity
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
     Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.TlsVersion
    :ivar provisioning_state: Provisioning state of the namespace.
    :vartype provisioning_state: str
    :ivar status: Status of the namespace.
    :vartype status: str
    :ivar created_at: The time the namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :ivar zone_redundant: Enabling this property creates a Premium Service Bus Namespace in regions
     supported availability zones.
    :vartype zone_redundant: bool
    :ivar encryption: Properties of BYOK Encryption description.
    :vartype encryption: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Encryption
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpointConnection]
    :ivar disable_local_auth: This property disables SAS authentication for the Service Bus
     namespace.
    :vartype disable_local_auth: bool
    :ivar alternate_name: Alternate name for namespace.
    :vartype alternate_name: str
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.PublicNetworkAccess
    :ivar premium_messaging_partitions: The number of partitions of a Service Bus namespace. This
     property is only applicable to Premium SKU namespaces. The default value is 1 and possible
     values are 1, 2 and 4.
    :vartype premium_messaging_partitions: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "service_bus_endpoint": {"readonly": True},
        "metric_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SBSku"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "service_bus_endpoint": {"key": "properties.serviceBusEndpoint", "type": "str"},
        "metric_id": {"key": "properties.metricId", "type": "str"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "alternate_name": {"key": "properties.alternateName", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "premium_messaging_partitions": {"key": "properties.premiumMessagingPartitions", "type": "int"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SBSku"] = None,
        identity: Optional["_models.Identity"] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        zone_redundant: Optional[bool] = None,
        encryption: Optional["_models.Encryption"] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        disable_local_auth: Optional[bool] = None,
        alternate_name: Optional[str] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        premium_messaging_partitions: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The Geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Properties of SKU.
        :paramtype sku: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SBSku
        :keyword identity: Properties of BYOK Identity description.
        :paramtype identity: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Identity
        :keyword minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
         Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.TlsVersion
        :keyword zone_redundant: Enabling this property creates a Premium Service Bus Namespace in
         regions supported availability zones.
        :paramtype zone_redundant: bool
        :keyword encryption: Properties of BYOK Encryption description.
        :paramtype encryption: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Encryption
        :keyword private_endpoint_connections: List of private endpoint connections.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpointConnection]
        :keyword disable_local_auth: This property disables SAS authentication for the Service Bus
         namespace.
        :paramtype disable_local_auth: bool
        :keyword alternate_name: Alternate name for namespace.
        :paramtype alternate_name: str
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.PublicNetworkAccess
        :keyword premium_messaging_partitions: The number of partitions of a Service Bus namespace.
         This property is only applicable to Premium SKU namespaces. The default value is 1 and possible
         values are 1, 2 and 4.
        :paramtype premium_messaging_partitions: int
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.system_data: Optional["_models.SystemData"] = None
        self.minimum_tls_version = minimum_tls_version
        self.provisioning_state: Optional[str] = None
        self.status: Optional[str] = None
        self.created_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.service_bus_endpoint: Optional[str] = None
        self.metric_id: Optional[str] = None
        self.zone_redundant = zone_redundant
        self.encryption = encryption
        self.private_endpoint_connections = private_endpoint_connections
        self.disable_local_auth = disable_local_auth
        self.alternate_name = alternate_name
        self.public_network_access = public_network_access
        self.premium_messaging_partitions = premium_messaging_partitions


class SBNamespaceListResult(_serialization.Model):
    """The response of the List Namespace operation.

    :ivar value: Result of the List Namespace operation.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBNamespace]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Namespaces.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SBNamespace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SBNamespace"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Namespace operation.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBNamespace]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Namespaces.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SBNamespaceUpdateParameters(ResourceNamespacePatch):
    """Description of a namespace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Properties of SKU.
    :vartype sku: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SBSku
    :ivar identity: Properties of BYOK Identity description.
    :vartype identity: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Identity
    :ivar provisioning_state: Provisioning state of the namespace.
    :vartype provisioning_state: str
    :ivar status: Status of the namespace.
    :vartype status: str
    :ivar created_at: The time the namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :ivar encryption: Properties of BYOK Encryption description.
    :vartype encryption: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Encryption
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpointConnection]
    :ivar disable_local_auth: This property disables SAS authentication for the Service Bus
     namespace.
    :vartype disable_local_auth: bool
    :ivar alternate_name: Alternate name for namespace.
    :vartype alternate_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "service_bus_endpoint": {"readonly": True},
        "metric_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SBSku"},
        "identity": {"key": "identity", "type": "Identity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "service_bus_endpoint": {"key": "properties.serviceBusEndpoint", "type": "str"},
        "metric_id": {"key": "properties.metricId", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "alternate_name": {"key": "properties.alternateName", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SBSku"] = None,
        identity: Optional["_models.Identity"] = None,
        encryption: Optional["_models.Encryption"] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        disable_local_auth: Optional[bool] = None,
        alternate_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Properties of SKU.
        :paramtype sku: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SBSku
        :keyword identity: Properties of BYOK Identity description.
        :paramtype identity: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Identity
        :keyword encryption: Properties of BYOK Encryption description.
        :paramtype encryption: ~azure.mgmt.servicebus.v2022_10_01_preview.models.Encryption
        :keyword private_endpoint_connections: List of private endpoint connections.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.servicebus.v2022_10_01_preview.models.PrivateEndpointConnection]
        :keyword disable_local_auth: This property disables SAS authentication for the Service Bus
         namespace.
        :paramtype disable_local_auth: bool
        :keyword alternate_name: Alternate name for namespace.
        :paramtype alternate_name: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.provisioning_state: Optional[str] = None
        self.status: Optional[str] = None
        self.created_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.service_bus_endpoint: Optional[str] = None
        self.metric_id: Optional[str] = None
        self.encryption = encryption
        self.private_endpoint_connections = private_endpoint_connections
        self.disable_local_auth = disable_local_auth
        self.alternate_name = alternate_name


class SBQueue(ProxyResource):
    """Description of queue Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar count_details: Message Count Details.
    :vartype count_details: ~azure.mgmt.servicebus.v2022_10_01_preview.models.MessageCountDetails
    :ivar created_at: The exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar accessed_at: Last time a message was sent, or the last time there was a receive request
     to this queue.
    :vartype accessed_at: ~datetime.datetime
    :ivar size_in_bytes: The size of the queue, in bytes.
    :vartype size_in_bytes: int
    :ivar message_count: The number of messages in the queue.
    :vartype message_count: int
    :ivar lock_duration: ISO 8601 timespan duration of a peek-lock; that is, the amount of time
     that the message is locked for other receivers. The maximum value for LockDuration is 5
     minutes; the default value is 1 minute.
    :vartype lock_duration: ~datetime.timedelta
    :ivar max_size_in_megabytes: The maximum size of the queue in megabytes, which is the size of
     memory allocated for the queue. Default is 1024.
    :vartype max_size_in_megabytes: int
    :ivar max_message_size_in_kilobytes: Maximum size (in KB) of the message payload that can be
     accepted by the queue. This property is only used in Premium today and default is 1024.
    :vartype max_message_size_in_kilobytes: int
    :ivar requires_duplicate_detection: A value indicating if this queue requires duplicate
     detection.
    :vartype requires_duplicate_detection: bool
    :ivar requires_session: A value that indicates whether the queue supports the concept of
     sessions.
    :vartype requires_session: bool
    :ivar default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :vartype default_message_time_to_live: ~datetime.timedelta
    :ivar dead_lettering_on_message_expiration: A value that indicates whether this queue has dead
     letter support when a message expires.
    :vartype dead_lettering_on_message_expiration: bool
    :ivar duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :vartype duplicate_detection_history_time_window: ~datetime.timedelta
    :ivar max_delivery_count: The maximum delivery count. A message is automatically deadlettered
     after this number of deliveries. default value is 10.
    :vartype max_delivery_count: int
    :ivar status: Enumerates the possible values for the status of a messaging entity. Known values
     are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
     "Deleting", "Renaming", and "Unknown".
    :vartype status: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.EntityStatus
    :ivar enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :vartype enable_batched_operations: bool
    :ivar auto_delete_on_idle: ISO 8061 timeSpan idle interval after which the queue is
     automatically deleted. The minimum duration is 5 minutes.
    :vartype auto_delete_on_idle: ~datetime.timedelta
    :ivar enable_partitioning: A value that indicates whether the queue is to be partitioned across
     multiple message brokers.
    :vartype enable_partitioning: bool
    :ivar enable_express: A value that indicates whether Express Entities are enabled. An express
     queue holds a message in memory temporarily before writing it to persistent storage.
    :vartype enable_express: bool
    :ivar forward_to: Queue/Topic name to forward the messages.
    :vartype forward_to: str
    :ivar forward_dead_lettered_messages_to: Queue/Topic name to forward the Dead Letter message.
    :vartype forward_dead_lettered_messages_to: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "count_details": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "accessed_at": {"readonly": True},
        "size_in_bytes": {"readonly": True},
        "message_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "count_details": {"key": "properties.countDetails", "type": "MessageCountDetails"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "accessed_at": {"key": "properties.accessedAt", "type": "iso-8601"},
        "size_in_bytes": {"key": "properties.sizeInBytes", "type": "int"},
        "message_count": {"key": "properties.messageCount", "type": "int"},
        "lock_duration": {"key": "properties.lockDuration", "type": "duration"},
        "max_size_in_megabytes": {"key": "properties.maxSizeInMegabytes", "type": "int"},
        "max_message_size_in_kilobytes": {"key": "properties.maxMessageSizeInKilobytes", "type": "int"},
        "requires_duplicate_detection": {"key": "properties.requiresDuplicateDetection", "type": "bool"},
        "requires_session": {"key": "properties.requiresSession", "type": "bool"},
        "default_message_time_to_live": {"key": "properties.defaultMessageTimeToLive", "type": "duration"},
        "dead_lettering_on_message_expiration": {"key": "properties.deadLetteringOnMessageExpiration", "type": "bool"},
        "duplicate_detection_history_time_window": {
            "key": "properties.duplicateDetectionHistoryTimeWindow",
            "type": "duration",
        },
        "max_delivery_count": {"key": "properties.maxDeliveryCount", "type": "int"},
        "status": {"key": "properties.status", "type": "str"},
        "enable_batched_operations": {"key": "properties.enableBatchedOperations", "type": "bool"},
        "auto_delete_on_idle": {"key": "properties.autoDeleteOnIdle", "type": "duration"},
        "enable_partitioning": {"key": "properties.enablePartitioning", "type": "bool"},
        "enable_express": {"key": "properties.enableExpress", "type": "bool"},
        "forward_to": {"key": "properties.forwardTo", "type": "str"},
        "forward_dead_lettered_messages_to": {"key": "properties.forwardDeadLetteredMessagesTo", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        lock_duration: Optional[datetime.timedelta] = None,
        max_size_in_megabytes: Optional[int] = None,
        max_message_size_in_kilobytes: Optional[int] = None,
        requires_duplicate_detection: Optional[bool] = None,
        requires_session: Optional[bool] = None,
        default_message_time_to_live: Optional[datetime.timedelta] = None,
        dead_lettering_on_message_expiration: Optional[bool] = None,
        duplicate_detection_history_time_window: Optional[datetime.timedelta] = None,
        max_delivery_count: Optional[int] = None,
        status: Optional[Union[str, "_models.EntityStatus"]] = None,
        enable_batched_operations: Optional[bool] = None,
        auto_delete_on_idle: Optional[datetime.timedelta] = None,
        enable_partitioning: Optional[bool] = None,
        enable_express: Optional[bool] = None,
        forward_to: Optional[str] = None,
        forward_dead_lettered_messages_to: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lock_duration: ISO 8601 timespan duration of a peek-lock; that is, the amount of time
         that the message is locked for other receivers. The maximum value for LockDuration is 5
         minutes; the default value is 1 minute.
        :paramtype lock_duration: ~datetime.timedelta
        :keyword max_size_in_megabytes: The maximum size of the queue in megabytes, which is the size
         of memory allocated for the queue. Default is 1024.
        :paramtype max_size_in_megabytes: int
        :keyword max_message_size_in_kilobytes: Maximum size (in KB) of the message payload that can be
         accepted by the queue. This property is only used in Premium today and default is 1024.
        :paramtype max_message_size_in_kilobytes: int
        :keyword requires_duplicate_detection: A value indicating if this queue requires duplicate
         detection.
        :paramtype requires_duplicate_detection: bool
        :keyword requires_session: A value that indicates whether the queue supports the concept of
         sessions.
        :paramtype requires_session: bool
        :keyword default_message_time_to_live: ISO 8601 default message timespan to live value. This is
         the duration after which the message expires, starting from when the message is sent to Service
         Bus. This is the default value used when TimeToLive is not set on a message itself.
        :paramtype default_message_time_to_live: ~datetime.timedelta
        :keyword dead_lettering_on_message_expiration: A value that indicates whether this queue has
         dead letter support when a message expires.
        :paramtype dead_lettering_on_message_expiration: bool
        :keyword duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
         duration of the duplicate detection history. The default value is 10 minutes.
        :paramtype duplicate_detection_history_time_window: ~datetime.timedelta
        :keyword max_delivery_count: The maximum delivery count. A message is automatically
         deadlettered after this number of deliveries. default value is 10.
        :paramtype max_delivery_count: int
        :keyword status: Enumerates the possible values for the status of a messaging entity. Known
         values are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
         "Deleting", "Renaming", and "Unknown".
        :paramtype status: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.EntityStatus
        :keyword enable_batched_operations: Value that indicates whether server-side batched operations
         are enabled.
        :paramtype enable_batched_operations: bool
        :keyword auto_delete_on_idle: ISO 8061 timeSpan idle interval after which the queue is
         automatically deleted. The minimum duration is 5 minutes.
        :paramtype auto_delete_on_idle: ~datetime.timedelta
        :keyword enable_partitioning: A value that indicates whether the queue is to be partitioned
         across multiple message brokers.
        :paramtype enable_partitioning: bool
        :keyword enable_express: A value that indicates whether Express Entities are enabled. An
         express queue holds a message in memory temporarily before writing it to persistent storage.
        :paramtype enable_express: bool
        :keyword forward_to: Queue/Topic name to forward the messages.
        :paramtype forward_to: str
        :keyword forward_dead_lettered_messages_to: Queue/Topic name to forward the Dead Letter
         message.
        :paramtype forward_dead_lettered_messages_to: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.count_details: Optional["_models.MessageCountDetails"] = None
        self.created_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.accessed_at: Optional[datetime.datetime] = None
        self.size_in_bytes: Optional[int] = None
        self.message_count: Optional[int] = None
        self.lock_duration = lock_duration
        self.max_size_in_megabytes = max_size_in_megabytes
        self.max_message_size_in_kilobytes = max_message_size_in_kilobytes
        self.requires_duplicate_detection = requires_duplicate_detection
        self.requires_session = requires_session
        self.default_message_time_to_live = default_message_time_to_live
        self.dead_lettering_on_message_expiration = dead_lettering_on_message_expiration
        self.duplicate_detection_history_time_window = duplicate_detection_history_time_window
        self.max_delivery_count = max_delivery_count
        self.status = status
        self.enable_batched_operations = enable_batched_operations
        self.auto_delete_on_idle = auto_delete_on_idle
        self.enable_partitioning = enable_partitioning
        self.enable_express = enable_express
        self.forward_to = forward_to
        self.forward_dead_lettered_messages_to = forward_dead_lettered_messages_to


class SBQueueListResult(_serialization.Model):
    """The response to the List Queues operation.

    :ivar value: Result of the List Queues operation.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBQueue]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of queues.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SBQueue]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SBQueue"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Queues operation.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBQueue]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of queues.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SBSku(_serialization.Model):
    """SKU of the namespace.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of this SKU. Required. Known values are: "Basic", "Standard", and "Premium".
    :vartype name: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.SkuName
    :ivar tier: The billing tier of this particular SKU. Known values are: "Basic", "Standard", and
     "Premium".
    :vartype tier: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.SkuTier
    :ivar capacity: Messaging units for your service bus premium namespace. Valid capacities are
     {1, 2, 4, 8, 16} multiples of your properties.premiumMessagingPartitions setting. For example,
     If properties.premiumMessagingPartitions is 1 then possible capacity values are 1, 2, 4, 8, and
     16. If properties.premiumMessagingPartitions is 4 then possible capacity values are 4, 8, 16,
     32 and 64.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of this SKU. Required. Known values are: "Basic", "Standard", and
         "Premium".
        :paramtype name: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.SkuName
        :keyword tier: The billing tier of this particular SKU. Known values are: "Basic", "Standard",
         and "Premium".
        :paramtype tier: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.SkuTier
        :keyword capacity: Messaging units for your service bus premium namespace. Valid capacities are
         {1, 2, 4, 8, 16} multiples of your properties.premiumMessagingPartitions setting. For example,
         If properties.premiumMessagingPartitions is 1 then possible capacity values are 1, 2, 4, 8, and
         16. If properties.premiumMessagingPartitions is 4 then possible capacity values are 4, 8, 16,
         32 and 64.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class SBSubscription(ProxyResource):
    """Description of subscription resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar message_count: Number of messages.
    :vartype message_count: int
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar accessed_at: Last time there was a receive request to this subscription.
    :vartype accessed_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar count_details: Message count details.
    :vartype count_details: ~azure.mgmt.servicebus.v2022_10_01_preview.models.MessageCountDetails
    :ivar lock_duration: ISO 8061 lock duration timespan for the subscription. The default value is
     1 minute.
    :vartype lock_duration: ~datetime.timedelta
    :ivar requires_session: Value indicating if a subscription supports the concept of sessions.
    :vartype requires_session: bool
    :ivar default_message_time_to_live: ISO 8061 Default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :vartype default_message_time_to_live: ~datetime.timedelta
    :ivar dead_lettering_on_filter_evaluation_exceptions: Value that indicates whether a
     subscription has dead letter support on filter evaluation exceptions.
    :vartype dead_lettering_on_filter_evaluation_exceptions: bool
    :ivar dead_lettering_on_message_expiration: Value that indicates whether a subscription has
     dead letter support when a message expires.
    :vartype dead_lettering_on_message_expiration: bool
    :ivar duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :vartype duplicate_detection_history_time_window: ~datetime.timedelta
    :ivar max_delivery_count: Number of maximum deliveries.
    :vartype max_delivery_count: int
    :ivar status: Enumerates the possible values for the status of a messaging entity. Known values
     are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
     "Deleting", "Renaming", and "Unknown".
    :vartype status: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.EntityStatus
    :ivar enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :vartype enable_batched_operations: bool
    :ivar auto_delete_on_idle: ISO 8061 timeSpan idle interval after which the topic is
     automatically deleted. The minimum duration is 5 minutes.
    :vartype auto_delete_on_idle: ~datetime.timedelta
    :ivar forward_to: Queue/Topic name to forward the messages.
    :vartype forward_to: str
    :ivar forward_dead_lettered_messages_to: Queue/Topic name to forward the Dead Letter message.
    :vartype forward_dead_lettered_messages_to: str
    :ivar is_client_affine: Value that indicates whether the subscription has an affinity to the
     client id.
    :vartype is_client_affine: bool
    :ivar client_affine_properties: Properties specific to client affine subscriptions.
    :vartype client_affine_properties:
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.SBClientAffineProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "message_count": {"readonly": True},
        "created_at": {"readonly": True},
        "accessed_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "count_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "message_count": {"key": "properties.messageCount", "type": "int"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "accessed_at": {"key": "properties.accessedAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "count_details": {"key": "properties.countDetails", "type": "MessageCountDetails"},
        "lock_duration": {"key": "properties.lockDuration", "type": "duration"},
        "requires_session": {"key": "properties.requiresSession", "type": "bool"},
        "default_message_time_to_live": {"key": "properties.defaultMessageTimeToLive", "type": "duration"},
        "dead_lettering_on_filter_evaluation_exceptions": {
            "key": "properties.deadLetteringOnFilterEvaluationExceptions",
            "type": "bool",
        },
        "dead_lettering_on_message_expiration": {"key": "properties.deadLetteringOnMessageExpiration", "type": "bool"},
        "duplicate_detection_history_time_window": {
            "key": "properties.duplicateDetectionHistoryTimeWindow",
            "type": "duration",
        },
        "max_delivery_count": {"key": "properties.maxDeliveryCount", "type": "int"},
        "status": {"key": "properties.status", "type": "str"},
        "enable_batched_operations": {"key": "properties.enableBatchedOperations", "type": "bool"},
        "auto_delete_on_idle": {"key": "properties.autoDeleteOnIdle", "type": "duration"},
        "forward_to": {"key": "properties.forwardTo", "type": "str"},
        "forward_dead_lettered_messages_to": {"key": "properties.forwardDeadLetteredMessagesTo", "type": "str"},
        "is_client_affine": {"key": "properties.isClientAffine", "type": "bool"},
        "client_affine_properties": {"key": "properties.clientAffineProperties", "type": "SBClientAffineProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        lock_duration: Optional[datetime.timedelta] = None,
        requires_session: Optional[bool] = None,
        default_message_time_to_live: Optional[datetime.timedelta] = None,
        dead_lettering_on_filter_evaluation_exceptions: Optional[bool] = None,
        dead_lettering_on_message_expiration: Optional[bool] = None,
        duplicate_detection_history_time_window: Optional[datetime.timedelta] = None,
        max_delivery_count: Optional[int] = None,
        status: Optional[Union[str, "_models.EntityStatus"]] = None,
        enable_batched_operations: Optional[bool] = None,
        auto_delete_on_idle: Optional[datetime.timedelta] = None,
        forward_to: Optional[str] = None,
        forward_dead_lettered_messages_to: Optional[str] = None,
        is_client_affine: Optional[bool] = None,
        client_affine_properties: Optional["_models.SBClientAffineProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lock_duration: ISO 8061 lock duration timespan for the subscription. The default value
         is 1 minute.
        :paramtype lock_duration: ~datetime.timedelta
        :keyword requires_session: Value indicating if a subscription supports the concept of sessions.
        :paramtype requires_session: bool
        :keyword default_message_time_to_live: ISO 8061 Default message timespan to live value. This is
         the duration after which the message expires, starting from when the message is sent to Service
         Bus. This is the default value used when TimeToLive is not set on a message itself.
        :paramtype default_message_time_to_live: ~datetime.timedelta
        :keyword dead_lettering_on_filter_evaluation_exceptions: Value that indicates whether a
         subscription has dead letter support on filter evaluation exceptions.
        :paramtype dead_lettering_on_filter_evaluation_exceptions: bool
        :keyword dead_lettering_on_message_expiration: Value that indicates whether a subscription has
         dead letter support when a message expires.
        :paramtype dead_lettering_on_message_expiration: bool
        :keyword duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
         duration of the duplicate detection history. The default value is 10 minutes.
        :paramtype duplicate_detection_history_time_window: ~datetime.timedelta
        :keyword max_delivery_count: Number of maximum deliveries.
        :paramtype max_delivery_count: int
        :keyword status: Enumerates the possible values for the status of a messaging entity. Known
         values are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
         "Deleting", "Renaming", and "Unknown".
        :paramtype status: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.EntityStatus
        :keyword enable_batched_operations: Value that indicates whether server-side batched operations
         are enabled.
        :paramtype enable_batched_operations: bool
        :keyword auto_delete_on_idle: ISO 8061 timeSpan idle interval after which the topic is
         automatically deleted. The minimum duration is 5 minutes.
        :paramtype auto_delete_on_idle: ~datetime.timedelta
        :keyword forward_to: Queue/Topic name to forward the messages.
        :paramtype forward_to: str
        :keyword forward_dead_lettered_messages_to: Queue/Topic name to forward the Dead Letter
         message.
        :paramtype forward_dead_lettered_messages_to: str
        :keyword is_client_affine: Value that indicates whether the subscription has an affinity to the
         client id.
        :paramtype is_client_affine: bool
        :keyword client_affine_properties: Properties specific to client affine subscriptions.
        :paramtype client_affine_properties:
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.SBClientAffineProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.message_count: Optional[int] = None
        self.created_at: Optional[datetime.datetime] = None
        self.accessed_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.count_details: Optional["_models.MessageCountDetails"] = None
        self.lock_duration = lock_duration
        self.requires_session = requires_session
        self.default_message_time_to_live = default_message_time_to_live
        self.dead_lettering_on_filter_evaluation_exceptions = dead_lettering_on_filter_evaluation_exceptions
        self.dead_lettering_on_message_expiration = dead_lettering_on_message_expiration
        self.duplicate_detection_history_time_window = duplicate_detection_history_time_window
        self.max_delivery_count = max_delivery_count
        self.status = status
        self.enable_batched_operations = enable_batched_operations
        self.auto_delete_on_idle = auto_delete_on_idle
        self.forward_to = forward_to
        self.forward_dead_lettered_messages_to = forward_dead_lettered_messages_to
        self.is_client_affine = is_client_affine
        self.client_affine_properties = client_affine_properties


class SBSubscriptionListResult(_serialization.Model):
    """The response to the List Subscriptions operation.

    :ivar value: Result of the List Subscriptions operation.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBSubscription]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of subscriptions.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SBSubscription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SBSubscription"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Subscriptions operation.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBSubscription]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of subscriptions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SBTopic(ProxyResource):
    """Description of topic resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.servicebus.v2022_10_01_preview.models.SystemData
    :ivar size_in_bytes: Size of the topic, in bytes.
    :vartype size_in_bytes: int
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar accessed_at: Last time the message was sent, or a request was received, for this topic.
    :vartype accessed_at: ~datetime.datetime
    :ivar subscription_count: Number of subscriptions.
    :vartype subscription_count: int
    :ivar count_details: Message count details.
    :vartype count_details: ~azure.mgmt.servicebus.v2022_10_01_preview.models.MessageCountDetails
    :ivar default_message_time_to_live: ISO 8601 Default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :vartype default_message_time_to_live: ~datetime.timedelta
    :ivar max_size_in_megabytes: Maximum size of the topic in megabytes, which is the size of the
     memory allocated for the topic. Default is 1024.
    :vartype max_size_in_megabytes: int
    :ivar max_message_size_in_kilobytes: Maximum size (in KB) of the message payload that can be
     accepted by the topic. This property is only used in Premium today and default is 1024.
    :vartype max_message_size_in_kilobytes: int
    :ivar requires_duplicate_detection: Value indicating if this topic requires duplicate
     detection.
    :vartype requires_duplicate_detection: bool
    :ivar duplicate_detection_history_time_window: ISO8601 timespan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :vartype duplicate_detection_history_time_window: ~datetime.timedelta
    :ivar enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :vartype enable_batched_operations: bool
    :ivar status: Enumerates the possible values for the status of a messaging entity. Known values
     are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
     "Deleting", "Renaming", and "Unknown".
    :vartype status: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.EntityStatus
    :ivar support_ordering: Value that indicates whether the topic supports ordering.
    :vartype support_ordering: bool
    :ivar auto_delete_on_idle: ISO 8601 timespan idle interval after which the topic is
     automatically deleted. The minimum duration is 5 minutes.
    :vartype auto_delete_on_idle: ~datetime.timedelta
    :ivar enable_partitioning: Value that indicates whether the topic to be partitioned across
     multiple message brokers is enabled.
    :vartype enable_partitioning: bool
    :ivar enable_express: Value that indicates whether Express Entities are enabled. An express
     topic holds a message in memory temporarily before writing it to persistent storage.
    :vartype enable_express: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "size_in_bytes": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "accessed_at": {"readonly": True},
        "subscription_count": {"readonly": True},
        "count_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "size_in_bytes": {"key": "properties.sizeInBytes", "type": "int"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "accessed_at": {"key": "properties.accessedAt", "type": "iso-8601"},
        "subscription_count": {"key": "properties.subscriptionCount", "type": "int"},
        "count_details": {"key": "properties.countDetails", "type": "MessageCountDetails"},
        "default_message_time_to_live": {"key": "properties.defaultMessageTimeToLive", "type": "duration"},
        "max_size_in_megabytes": {"key": "properties.maxSizeInMegabytes", "type": "int"},
        "max_message_size_in_kilobytes": {"key": "properties.maxMessageSizeInKilobytes", "type": "int"},
        "requires_duplicate_detection": {"key": "properties.requiresDuplicateDetection", "type": "bool"},
        "duplicate_detection_history_time_window": {
            "key": "properties.duplicateDetectionHistoryTimeWindow",
            "type": "duration",
        },
        "enable_batched_operations": {"key": "properties.enableBatchedOperations", "type": "bool"},
        "status": {"key": "properties.status", "type": "str"},
        "support_ordering": {"key": "properties.supportOrdering", "type": "bool"},
        "auto_delete_on_idle": {"key": "properties.autoDeleteOnIdle", "type": "duration"},
        "enable_partitioning": {"key": "properties.enablePartitioning", "type": "bool"},
        "enable_express": {"key": "properties.enableExpress", "type": "bool"},
    }

    def __init__(
        self,
        *,
        default_message_time_to_live: Optional[datetime.timedelta] = None,
        max_size_in_megabytes: Optional[int] = None,
        max_message_size_in_kilobytes: Optional[int] = None,
        requires_duplicate_detection: Optional[bool] = None,
        duplicate_detection_history_time_window: Optional[datetime.timedelta] = None,
        enable_batched_operations: Optional[bool] = None,
        status: Optional[Union[str, "_models.EntityStatus"]] = None,
        support_ordering: Optional[bool] = None,
        auto_delete_on_idle: Optional[datetime.timedelta] = None,
        enable_partitioning: Optional[bool] = None,
        enable_express: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_message_time_to_live: ISO 8601 Default message timespan to live value. This is
         the duration after which the message expires, starting from when the message is sent to Service
         Bus. This is the default value used when TimeToLive is not set on a message itself.
        :paramtype default_message_time_to_live: ~datetime.timedelta
        :keyword max_size_in_megabytes: Maximum size of the topic in megabytes, which is the size of
         the memory allocated for the topic. Default is 1024.
        :paramtype max_size_in_megabytes: int
        :keyword max_message_size_in_kilobytes: Maximum size (in KB) of the message payload that can be
         accepted by the topic. This property is only used in Premium today and default is 1024.
        :paramtype max_message_size_in_kilobytes: int
        :keyword requires_duplicate_detection: Value indicating if this topic requires duplicate
         detection.
        :paramtype requires_duplicate_detection: bool
        :keyword duplicate_detection_history_time_window: ISO8601 timespan structure that defines the
         duration of the duplicate detection history. The default value is 10 minutes.
        :paramtype duplicate_detection_history_time_window: ~datetime.timedelta
        :keyword enable_batched_operations: Value that indicates whether server-side batched operations
         are enabled.
        :paramtype enable_batched_operations: bool
        :keyword status: Enumerates the possible values for the status of a messaging entity. Known
         values are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
         "Deleting", "Renaming", and "Unknown".
        :paramtype status: str or ~azure.mgmt.servicebus.v2022_10_01_preview.models.EntityStatus
        :keyword support_ordering: Value that indicates whether the topic supports ordering.
        :paramtype support_ordering: bool
        :keyword auto_delete_on_idle: ISO 8601 timespan idle interval after which the topic is
         automatically deleted. The minimum duration is 5 minutes.
        :paramtype auto_delete_on_idle: ~datetime.timedelta
        :keyword enable_partitioning: Value that indicates whether the topic to be partitioned across
         multiple message brokers is enabled.
        :paramtype enable_partitioning: bool
        :keyword enable_express: Value that indicates whether Express Entities are enabled. An express
         topic holds a message in memory temporarily before writing it to persistent storage.
        :paramtype enable_express: bool
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.size_in_bytes: Optional[int] = None
        self.created_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.accessed_at: Optional[datetime.datetime] = None
        self.subscription_count: Optional[int] = None
        self.count_details: Optional["_models.MessageCountDetails"] = None
        self.default_message_time_to_live = default_message_time_to_live
        self.max_size_in_megabytes = max_size_in_megabytes
        self.max_message_size_in_kilobytes = max_message_size_in_kilobytes
        self.requires_duplicate_detection = requires_duplicate_detection
        self.duplicate_detection_history_time_window = duplicate_detection_history_time_window
        self.enable_batched_operations = enable_batched_operations
        self.status = status
        self.support_ordering = support_ordering
        self.auto_delete_on_idle = auto_delete_on_idle
        self.enable_partitioning = enable_partitioning
        self.enable_express = enable_express


class SBTopicListResult(_serialization.Model):
    """The response to the List Topics operation.

    :ivar value: Result of the List Topics operation.
    :vartype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBTopic]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of topics.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SBTopic]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SBTopic"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Topics operation.
        :paramtype value: list[~azure.mgmt.servicebus.v2022_10_01_preview.models.SBTopic]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of topics.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SqlFilter(_serialization.Model):
    """Represents a filter which is a composition of an expression and an action that is executed in
    the pub/sub pipeline.

    :ivar sql_expression: The SQL expression. e.g. MyProperty='ABC'.
    :vartype sql_expression: str
    :ivar compatibility_level: This property is reserved for future use. An integer value showing
     the compatibility level, currently hard-coded to 20.
    :vartype compatibility_level: int
    :ivar requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :vartype requires_preprocessing: bool
    """

    _attribute_map = {
        "sql_expression": {"key": "sqlExpression", "type": "str"},
        "compatibility_level": {"key": "compatibilityLevel", "type": "int"},
        "requires_preprocessing": {"key": "requiresPreprocessing", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sql_expression: Optional[str] = None,
        compatibility_level: Optional[int] = None,
        requires_preprocessing: bool = True,
        **kwargs: Any
    ) -> None:
        """
        :keyword sql_expression: The SQL expression. e.g. MyProperty='ABC'.
        :paramtype sql_expression: str
        :keyword compatibility_level: This property is reserved for future use. An integer value
         showing the compatibility level, currently hard-coded to 20.
        :paramtype compatibility_level: int
        :keyword requires_preprocessing: Value that indicates whether the rule action requires
         preprocessing.
        :paramtype requires_preprocessing: bool
        """
        super().__init__(**kwargs)
        self.sql_expression = sql_expression
        self.compatibility_level = compatibility_level
        self.requires_preprocessing = requires_preprocessing


class SqlRuleAction(Action):
    """Represents set of actions written in SQL language-based syntax that is performed against a
    ServiceBus.Messaging.BrokeredMessage.

    :ivar sql_expression: SQL expression. e.g. MyProperty='ABC'.
    :vartype sql_expression: str
    :ivar compatibility_level: This property is reserved for future use. An integer value showing
     the compatibility level, currently hard-coded to 20.
    :vartype compatibility_level: int
    :ivar requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :vartype requires_preprocessing: bool
    """


class Subnet(_serialization.Model):
    """Properties supplied for Subnet.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of Virtual Network Subnet. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of Virtual Network Subnet. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.servicebus.v2022_10_01_preview.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.servicebus.v2022_10_01_preview.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """Recognized Dictionary value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class UserAssignedIdentityProperties(_serialization.Model):
    """UserAssignedIdentityProperties.

    :ivar user_assigned_identity: ARM ID of user Identity selected for encryption.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(self, *, user_assigned_identity: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_assigned_identity: ARM ID of user Identity selected for encryption.
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity
