# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class JsonFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """JsonFormat."""

    JSON = "json"
    """`The JavaScript Object Notation Data Interchange Format <https://tools.ietf.org/html/rfc8259>`_"""


class TimezoneOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TimezoneOptions."""

    NONE = "none"
    """Do not include zoneinfo or transitions in the result."""
    ZONE_INFO = "zoneInfo"
    """Include additional time zone info in the result."""
    TRANSITIONS = "transitions"
    """Include transition information in the result (The number of transitions is currently capped at
    250)."""
    ALL = "all"
    """Include both zoneinfo and transitions in the result."""
