# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ActivationKeyResult(_serialization.Model):
    """The resource containing the Azure Stack activation key.

    :ivar activation_key: Azure Stack activation key.
    :vartype activation_key: str
    """

    _attribute_map = {
        "activation_key": {"key": "activationKey", "type": "str"},
    }

    def __init__(self, *, activation_key: Optional[str] = None, **kwargs):
        """
        :keyword activation_key: Azure Stack activation key.
        :paramtype activation_key: str
        """
        super().__init__(**kwargs)
        self.activation_key = activation_key


class CloudManifestFileDeploymentData(_serialization.Model):
    """Cloud specific manifest data for AzureStack deployment.

    :ivar external_dsms_certificates: Dsms external certificates.
    :vartype external_dsms_certificates: str
    :ivar custom_cloud_verification_key: Signing verification public key.
    :vartype custom_cloud_verification_key: str
    :ivar custom_cloud_arm_endpoint: ARM endpoint.
    :vartype custom_cloud_arm_endpoint: str
    :ivar external_dsms_endpoint: Dsms endpoint.
    :vartype external_dsms_endpoint: str
    """

    _attribute_map = {
        "external_dsms_certificates": {"key": "externalDsmsCertificates", "type": "str"},
        "custom_cloud_verification_key": {"key": "customCloudVerificationKey", "type": "str"},
        "custom_cloud_arm_endpoint": {"key": "customEnvironmentEndpoints.customCloudArmEndpoint", "type": "str"},
        "external_dsms_endpoint": {"key": "customEnvironmentEndpoints.externalDsmsEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        external_dsms_certificates: Optional[str] = None,
        custom_cloud_verification_key: Optional[str] = None,
        custom_cloud_arm_endpoint: Optional[str] = None,
        external_dsms_endpoint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword external_dsms_certificates: Dsms external certificates.
        :paramtype external_dsms_certificates: str
        :keyword custom_cloud_verification_key: Signing verification public key.
        :paramtype custom_cloud_verification_key: str
        :keyword custom_cloud_arm_endpoint: ARM endpoint.
        :paramtype custom_cloud_arm_endpoint: str
        :keyword external_dsms_endpoint: Dsms endpoint.
        :paramtype external_dsms_endpoint: str
        """
        super().__init__(**kwargs)
        self.external_dsms_certificates = external_dsms_certificates
        self.custom_cloud_verification_key = custom_cloud_verification_key
        self.custom_cloud_arm_endpoint = custom_cloud_arm_endpoint
        self.external_dsms_endpoint = external_dsms_endpoint


class CloudManifestFileProperties(_serialization.Model):
    """Cloud specific manifest JSON properties.

    :ivar deployment_data: Cloud specific manifest data.
    :vartype deployment_data: ~azure.mgmt.azurestack.models.CloudManifestFileDeploymentData
    :ivar signature: Signature of the cloud specific manifest data.
    :vartype signature: str
    """

    _attribute_map = {
        "deployment_data": {"key": "deploymentData", "type": "CloudManifestFileDeploymentData"},
        "signature": {"key": "signature", "type": "str"},
    }

    def __init__(
        self,
        *,
        deployment_data: Optional["_models.CloudManifestFileDeploymentData"] = None,
        signature: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword deployment_data: Cloud specific manifest data.
        :paramtype deployment_data: ~azure.mgmt.azurestack.models.CloudManifestFileDeploymentData
        :keyword signature: Signature of the cloud specific manifest data.
        :paramtype signature: str
        """
        super().__init__(**kwargs)
        self.deployment_data = deployment_data
        self.signature = signature


class Resource(_serialization.Model):
    """Base resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ID of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of Resource.
    :vartype type: str
    :ivar etag: The entity tag used for optimistic concurrency when modifying the resource.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs):
        """
        :keyword etag: The entity tag used for optimistic concurrency when modifying the resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = etag


class CloudManifestFileResponse(Resource):
    """Cloud specific manifest GET response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ID of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of Resource.
    :vartype type: str
    :ivar etag: The entity tag used for optimistic concurrency when modifying the resource.
    :vartype etag: str
    :ivar properties: Cloud specific manifest data.
    :vartype properties: ~azure.mgmt.azurestack.models.CloudManifestFileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "CloudManifestFileProperties"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        properties: Optional["_models.CloudManifestFileProperties"] = None,
        **kwargs
    ):
        """
        :keyword etag: The entity tag used for optimistic concurrency when modifying the resource.
        :paramtype etag: str
        :keyword properties: Cloud specific manifest data.
        :paramtype properties: ~azure.mgmt.azurestack.models.CloudManifestFileProperties
        """
        super().__init__(etag=etag, **kwargs)
        self.properties = properties


class Compatibility(_serialization.Model):
    """Product compatibility.

    :ivar is_compatible: Tells if product is compatible with current device.
    :vartype is_compatible: bool
    :ivar message: Short error message if any compatibility issues are found.
    :vartype message: str
    :ivar description: Full error message if any compatibility issues are found.
    :vartype description: str
    :ivar issues: List of all issues found.
    :vartype issues: list[str or ~azure.mgmt.azurestack.models.CompatibilityIssue]
    """

    _attribute_map = {
        "is_compatible": {"key": "isCompatible", "type": "bool"},
        "message": {"key": "message", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "issues": {"key": "issues", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        is_compatible: Optional[bool] = None,
        message: Optional[str] = None,
        description: Optional[str] = None,
        issues: Optional[List[Union[str, "_models.CompatibilityIssue"]]] = None,
        **kwargs
    ):
        """
        :keyword is_compatible: Tells if product is compatible with current device.
        :paramtype is_compatible: bool
        :keyword message: Short error message if any compatibility issues are found.
        :paramtype message: str
        :keyword description: Full error message if any compatibility issues are found.
        :paramtype description: str
        :keyword issues: List of all issues found.
        :paramtype issues: list[str or ~azure.mgmt.azurestack.models.CompatibilityIssue]
        """
        super().__init__(**kwargs)
        self.is_compatible = is_compatible
        self.message = message
        self.description = description
        self.issues = issues


class CustomerSubscription(Resource):
    """Customer subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ID of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of Resource.
    :vartype type: str
    :ivar etag: The entity tag used for optimistic concurrency when modifying the resource.
    :vartype etag: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, tenant_id: Optional[str] = None, **kwargs):
        """
        :keyword etag: The entity tag used for optimistic concurrency when modifying the resource.
        :paramtype etag: str
        :keyword tenant_id: Tenant Id.
        :paramtype tenant_id: str
        """
        super().__init__(etag=etag, **kwargs)
        self.tenant_id = tenant_id


class CustomerSubscriptionList(_serialization.Model):
    """Pageable list of customer subscriptions.

    :ivar next_link: URI to the next page.
    :vartype next_link: str
    :ivar value: List of customer subscriptions.
    :vartype value: list[~azure.mgmt.azurestack.models.CustomerSubscription]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[CustomerSubscription]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.CustomerSubscription"]] = None, **kwargs
    ):
        """
        :keyword next_link: URI to the next page.
        :paramtype next_link: str
        :keyword value: List of customer subscriptions.
        :paramtype value: list[~azure.mgmt.azurestack.models.CustomerSubscription]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataDiskImage(_serialization.Model):
    """Data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: The LUN.
    :vartype lun: int
    :ivar source_blob_sas_uri: SAS key for source blob.
    :vartype source_blob_sas_uri: str
    """

    _validation = {
        "lun": {"readonly": True},
        "source_blob_sas_uri": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "source_blob_sas_uri": {"key": "sourceBlobSasUri", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.lun = None
        self.source_blob_sas_uri = None


class DeploymentLicenseRequest(_serialization.Model):
    """Request details for generating a deployment license.

    :ivar verification_version: Signing verification public key version.
    :vartype verification_version: str
    """

    _attribute_map = {
        "verification_version": {"key": "verificationVersion", "type": "str"},
    }

    def __init__(self, *, verification_version: Optional[str] = None, **kwargs):
        """
        :keyword verification_version: Signing verification public key version.
        :paramtype verification_version: str
        """
        super().__init__(**kwargs)
        self.verification_version = verification_version


class DeploymentLicenseResponse(_serialization.Model):
    """A license that can be used to deploy an Azure Stack device.

    :ivar temporary_license_chain: A license chain that can be used to temporarily activate an
     Azure Stack device.
    :vartype temporary_license_chain: list[str]
    :ivar signature: Signature of the license chain.
    :vartype signature: str
    """

    _attribute_map = {
        "temporary_license_chain": {"key": "temporaryLicenseChain", "type": "[str]"},
        "signature": {"key": "signature", "type": "str"},
    }

    def __init__(
        self, *, temporary_license_chain: Optional[List[str]] = None, signature: Optional[str] = None, **kwargs
    ):
        """
        :keyword temporary_license_chain: A license chain that can be used to temporarily activate an
         Azure Stack device.
        :paramtype temporary_license_chain: list[str]
        :keyword signature: Signature of the license chain.
        :paramtype signature: str
        """
        super().__init__(**kwargs)
        self.temporary_license_chain = temporary_license_chain
        self.signature = signature


class DeviceConfiguration(_serialization.Model):
    """Device Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_version: Version of the device.
    :vartype device_version: str
    :ivar identity_system: Identity system of the device. Known values are: "AzureAD" and "ADFS".
    :vartype identity_system: str or ~azure.mgmt.azurestack.models.Category
    """

    _validation = {
        "device_version": {"readonly": True},
        "identity_system": {"readonly": True},
    }

    _attribute_map = {
        "device_version": {"key": "deviceVersion", "type": "str"},
        "identity_system": {"key": "identitySystem", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.device_version = None
        self.identity_system = None


class Display(_serialization.Model):
    """Contains the localized display information for this particular operation or action.

    :ivar provider: The localized, friendly version of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized, friendly version of the resource type related to this action or
     operation; the resource type should match the public documentation for the resource provider.
    :vartype resource: str
    :ivar operation: The localized, friendly name for the operation. Use the name as it will
     displayed to the user.
    :vartype operation: str
    :ivar description: The localized, friendly description for the operation. The description will
     be displayed to the user. It should be thorough and concise for used in both tooltips and
     detailed views.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The localized, friendly version of the resource provider name.
        :paramtype provider: str
        :keyword resource: The localized, friendly version of the resource type related to this action
         or operation; the resource type should match the public documentation for the resource
         provider.
        :paramtype resource: str
        :keyword operation: The localized, friendly name for the operation. Use the name as it will
         displayed to the user.
        :paramtype operation: str
        :keyword description: The localized, friendly description for the operation. The description
         will be displayed to the user. It should be thorough and concise for used in both tooltips and
         detailed views.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ErrorDetails(_serialization.Model):
    """The details of the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class ErrorResponse(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message.

    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.azurestack.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs):
        """
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.azurestack.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedProduct(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Extended description about the product required for installing it into Azure Stack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar gallery_package_blob_sas_uri: The URI to the .azpkg file that provides information
     required for showing product in the gallery.
    :vartype gallery_package_blob_sas_uri: str
    :ivar product_kind: Specifies the kind of the product (virtualMachine or
     virtualMachineExtension).
    :vartype product_kind: str
    :ivar compute_role: Specifies kind of compute role included in the package. Known values are:
     "None", "IaaS", and "PaaS".
    :vartype compute_role: str or ~azure.mgmt.azurestack.models.ComputeRole
    :ivar is_system_extension: Specifies if product is a Virtual Machine Extension.
    :vartype is_system_extension: bool
    :ivar support_multiple_extensions: Indicates if specified product supports multiple extensions.
    :vartype support_multiple_extensions: bool
    :ivar version_properties_version: Specifies product version.
    :vartype version_properties_version: str
    :ivar vm_os_type: Specifies operating system used by the product. Known values are: "None",
     "Windows", and "Linux".
    :vartype vm_os_type: str or ~azure.mgmt.azurestack.models.OperatingSystem
    :ivar vm_scale_set_enabled: Indicates if virtual machine Scale Set is enabled in the specified
     product.
    :vartype vm_scale_set_enabled: bool
    :ivar uri: The URI.
    :vartype uri: str
    :ivar version: Specifies product version.
    :vartype version: str
    :ivar os_disk_image: OS disk image used by product.
    :vartype os_disk_image: ~azure.mgmt.azurestack.models.OsDiskImage
    :ivar data_disk_images: List of attached data disks.
    :vartype data_disk_images: list[~azure.mgmt.azurestack.models.DataDiskImage]
    """

    _validation = {
        "gallery_package_blob_sas_uri": {"readonly": True},
        "product_kind": {"readonly": True},
        "compute_role": {"readonly": True},
        "is_system_extension": {"readonly": True},
        "support_multiple_extensions": {"readonly": True},
        "version_properties_version": {"readonly": True},
        "vm_os_type": {"readonly": True},
        "vm_scale_set_enabled": {"readonly": True},
        "uri": {"readonly": True},
        "version": {"readonly": True},
        "os_disk_image": {"readonly": True},
        "data_disk_images": {"readonly": True},
    }

    _attribute_map = {
        "gallery_package_blob_sas_uri": {"key": "galleryPackageBlobSasUri", "type": "str"},
        "product_kind": {"key": "productKind", "type": "str"},
        "compute_role": {"key": "properties.computeRole", "type": "str"},
        "is_system_extension": {"key": "properties.isSystemExtension", "type": "bool"},
        "support_multiple_extensions": {"key": "properties.supportMultipleExtensions", "type": "bool"},
        "version_properties_version": {"key": "properties.version", "type": "str"},
        "vm_os_type": {"key": "properties.vmOsType", "type": "str"},
        "vm_scale_set_enabled": {"key": "properties.vmScaleSetEnabled", "type": "bool"},
        "uri": {"key": "properties.sourceBlob.uri", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "os_disk_image": {"key": "properties.osDiskImage", "type": "OsDiskImage"},
        "data_disk_images": {"key": "properties.dataDiskImages", "type": "[DataDiskImage]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.gallery_package_blob_sas_uri = None
        self.product_kind = None
        self.compute_role = None
        self.is_system_extension = None
        self.support_multiple_extensions = None
        self.version_properties_version = None
        self.vm_os_type = None
        self.vm_scale_set_enabled = None
        self.uri = None
        self.version = None
        self.os_disk_image = None
        self.data_disk_images = None


class VirtualMachineProductProperties(_serialization.Model):
    """Product information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Specifies product version.
    :vartype version: str
    :ivar os_disk_image: OS disk image used by product.
    :vartype os_disk_image: ~azure.mgmt.azurestack.models.OsDiskImage
    :ivar data_disk_images: List of attached data disks.
    :vartype data_disk_images: list[~azure.mgmt.azurestack.models.DataDiskImage]
    """

    _validation = {
        "version": {"readonly": True},
        "os_disk_image": {"readonly": True},
        "data_disk_images": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "os_disk_image": {"key": "osDiskImage", "type": "OsDiskImage"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[DataDiskImage]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.os_disk_image = None
        self.data_disk_images = None


class VirtualMachineExtensionProductProperties(_serialization.Model):
    """Product information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compute_role: Specifies kind of compute role included in the package. Known values are:
     "None", "IaaS", and "PaaS".
    :vartype compute_role: str or ~azure.mgmt.azurestack.models.ComputeRole
    :ivar is_system_extension: Specifies if product is a Virtual Machine Extension.
    :vartype is_system_extension: bool
    :ivar support_multiple_extensions: Indicates if specified product supports multiple extensions.
    :vartype support_multiple_extensions: bool
    :ivar version: Specifies product version.
    :vartype version: str
    :ivar vm_os_type: Specifies operating system used by the product. Known values are: "None",
     "Windows", and "Linux".
    :vartype vm_os_type: str or ~azure.mgmt.azurestack.models.OperatingSystem
    :ivar vm_scale_set_enabled: Indicates if virtual machine Scale Set is enabled in the specified
     product.
    :vartype vm_scale_set_enabled: bool
    :ivar uri: The URI.
    :vartype uri: str
    """

    _validation = {
        "compute_role": {"readonly": True},
        "is_system_extension": {"readonly": True},
        "support_multiple_extensions": {"readonly": True},
        "version": {"readonly": True},
        "vm_os_type": {"readonly": True},
        "vm_scale_set_enabled": {"readonly": True},
        "uri": {"readonly": True},
    }

    _attribute_map = {
        "compute_role": {"key": "computeRole", "type": "str"},
        "is_system_extension": {"key": "isSystemExtension", "type": "bool"},
        "support_multiple_extensions": {"key": "supportMultipleExtensions", "type": "bool"},
        "version": {"key": "version", "type": "str"},
        "vm_os_type": {"key": "vmOsType", "type": "str"},
        "vm_scale_set_enabled": {"key": "vmScaleSetEnabled", "type": "bool"},
        "uri": {"key": "sourceBlob.uri", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.compute_role = None
        self.is_system_extension = None
        self.support_multiple_extensions = None
        self.version = None
        self.vm_os_type = None
        self.vm_scale_set_enabled = None
        self.uri = None


class ExtendedProductProperties(VirtualMachineExtensionProductProperties, VirtualMachineProductProperties):
    """Product information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_disk_image: OS disk image used by product.
    :vartype os_disk_image: ~azure.mgmt.azurestack.models.OsDiskImage
    :ivar data_disk_images: List of attached data disks.
    :vartype data_disk_images: list[~azure.mgmt.azurestack.models.DataDiskImage]
    :ivar compute_role: Specifies kind of compute role included in the package. Known values are:
     "None", "IaaS", and "PaaS".
    :vartype compute_role: str or ~azure.mgmt.azurestack.models.ComputeRole
    :ivar is_system_extension: Specifies if product is a Virtual Machine Extension.
    :vartype is_system_extension: bool
    :ivar support_multiple_extensions: Indicates if specified product supports multiple extensions.
    :vartype support_multiple_extensions: bool
    :ivar version: Specifies product version.
    :vartype version: str
    :ivar vm_os_type: Specifies operating system used by the product. Known values are: "None",
     "Windows", and "Linux".
    :vartype vm_os_type: str or ~azure.mgmt.azurestack.models.OperatingSystem
    :ivar vm_scale_set_enabled: Indicates if virtual machine Scale Set is enabled in the specified
     product.
    :vartype vm_scale_set_enabled: bool
    :ivar uri: The URI.
    :vartype uri: str
    """

    _validation = {
        "os_disk_image": {"readonly": True},
        "data_disk_images": {"readonly": True},
        "compute_role": {"readonly": True},
        "is_system_extension": {"readonly": True},
        "support_multiple_extensions": {"readonly": True},
        "version": {"readonly": True},
        "vm_os_type": {"readonly": True},
        "vm_scale_set_enabled": {"readonly": True},
        "uri": {"readonly": True},
    }

    _attribute_map = {
        "os_disk_image": {"key": "osDiskImage", "type": "OsDiskImage"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[DataDiskImage]"},
        "compute_role": {"key": "computeRole", "type": "str"},
        "is_system_extension": {"key": "isSystemExtension", "type": "bool"},
        "support_multiple_extensions": {"key": "supportMultipleExtensions", "type": "bool"},
        "version": {"key": "version", "type": "str"},
        "vm_os_type": {"key": "vmOsType", "type": "str"},
        "vm_scale_set_enabled": {"key": "vmScaleSetEnabled", "type": "bool"},
        "uri": {"key": "sourceBlob.uri", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.os_disk_image = None
        self.data_disk_images = None
        self.compute_role = None
        self.is_system_extension = None
        self.support_multiple_extensions = None
        self.version = None
        self.vm_os_type = None
        self.vm_scale_set_enabled = None
        self.uri = None


class IconUris(_serialization.Model):
    """Links to product icons.

    :ivar large: URI to large icon.
    :vartype large: str
    :ivar wide: URI to wide icon.
    :vartype wide: str
    :ivar medium: URI to medium icon.
    :vartype medium: str
    :ivar small: URI to small icon.
    :vartype small: str
    :ivar hero: URI to hero icon.
    :vartype hero: str
    """

    _attribute_map = {
        "large": {"key": "large", "type": "str"},
        "wide": {"key": "wide", "type": "str"},
        "medium": {"key": "medium", "type": "str"},
        "small": {"key": "small", "type": "str"},
        "hero": {"key": "hero", "type": "str"},
    }

    def __init__(
        self,
        *,
        large: Optional[str] = None,
        wide: Optional[str] = None,
        medium: Optional[str] = None,
        small: Optional[str] = None,
        hero: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword large: URI to large icon.
        :paramtype large: str
        :keyword wide: URI to wide icon.
        :paramtype wide: str
        :keyword medium: URI to medium icon.
        :paramtype medium: str
        :keyword small: URI to small icon.
        :paramtype small: str
        :keyword hero: URI to hero icon.
        :paramtype hero: str
        """
        super().__init__(**kwargs)
        self.large = large
        self.wide = wide
        self.medium = medium
        self.small = small
        self.hero = hero


class MarketplaceProductLogUpdate(_serialization.Model):
    """Update details for product log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation: Operation to log.
    :vartype operation: str
    :ivar status: Operation status to log.
    :vartype status: str
    :ivar error: Error related to the operation.
    :vartype error: str
    :ivar details: Error details related to operation.
    :vartype details: str
    """

    _validation = {
        "operation": {"readonly": True},
        "status": {"readonly": True},
        "error": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.operation = None
        self.status = None
        self.error = None
        self.details = None


class Operation(_serialization.Model):
    """Describes the supported REST operation.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: Contains the localized display information for this particular operation or
     action.
    :vartype display: ~azure.mgmt.azurestack.models.Display
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "Display"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.Display"] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the operation being performed on this particular object.
        :paramtype name: str
        :keyword display: Contains the localized display information for this particular operation or
         action.
        :paramtype display: ~azure.mgmt.azurestack.models.Display
        :keyword origin: The intended executor of the operation.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class OperationList(_serialization.Model):
    """List of Operations.

    :ivar value: Array of operations.
    :vartype value: list[~azure.mgmt.azurestack.models.Operation]
    :ivar next_link: URI to the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: Array of operations.
        :paramtype value: list[~azure.mgmt.azurestack.models.Operation]
        :keyword next_link: URI to the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OsDiskImage(_serialization.Model):
    """OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operating_system: OS operating system type. Known values are: "None", "Windows", and
     "Linux".
    :vartype operating_system: str or ~azure.mgmt.azurestack.models.OperatingSystem
    :ivar source_blob_sas_uri: SAS key for source blob.
    :vartype source_blob_sas_uri: str
    """

    _validation = {
        "operating_system": {"readonly": True},
        "source_blob_sas_uri": {"readonly": True},
    }

    _attribute_map = {
        "operating_system": {"key": "operatingSystem", "type": "str"},
        "source_blob_sas_uri": {"key": "sourceBlobSasUri", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.operating_system = None
        self.source_blob_sas_uri = None


class Product(Resource):  # pylint: disable=too-many-instance-attributes
    """Product information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ID of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of Resource.
    :vartype type: str
    :ivar etag: The entity tag used for optimistic concurrency when modifying the resource.
    :vartype etag: str
    :ivar display_name: The display name of the product.
    :vartype display_name: str
    :ivar description: The description of the product.
    :vartype description: str
    :ivar publisher_display_name: The user-friendly name of the product publisher.
    :vartype publisher_display_name: str
    :ivar publisher_identifier: Publisher identifier.
    :vartype publisher_identifier: str
    :ivar offer: The offer representing the product.
    :vartype offer: str
    :ivar offer_version: The version of the product offer.
    :vartype offer_version: str
    :ivar sku: The product SKU.
    :vartype sku: str
    :ivar billing_part_number: The part number used for billing purposes.
    :vartype billing_part_number: str
    :ivar vm_extension_type: The type of the Virtual Machine Extension.
    :vartype vm_extension_type: str
    :ivar gallery_item_identity: The identifier of the gallery item corresponding to the product.
    :vartype gallery_item_identity: str
    :ivar icon_uris: Additional links available for this product.
    :vartype icon_uris: ~azure.mgmt.azurestack.models.IconUris
    :ivar links: Additional links available for this product.
    :vartype links: list[~azure.mgmt.azurestack.models.ProductLink]
    :ivar legal_terms: The legal terms.
    :vartype legal_terms: str
    :ivar privacy_policy: The privacy policy.
    :vartype privacy_policy: str
    :ivar payload_length: The length of product content.
    :vartype payload_length: int
    :ivar product_kind: The kind of the product (virtualMachine or virtualMachineExtension).
    :vartype product_kind: str
    :ivar product_properties: Additional properties for the product.
    :vartype product_properties: ~azure.mgmt.azurestack.models.ProductProperties
    :ivar compatibility: Product compatibility with current device.
    :vartype compatibility: ~azure.mgmt.azurestack.models.Compatibility
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "publisher_display_name": {"key": "properties.publisherDisplayName", "type": "str"},
        "publisher_identifier": {"key": "properties.publisherIdentifier", "type": "str"},
        "offer": {"key": "properties.offer", "type": "str"},
        "offer_version": {"key": "properties.offerVersion", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
        "billing_part_number": {"key": "properties.billingPartNumber", "type": "str"},
        "vm_extension_type": {"key": "properties.vmExtensionType", "type": "str"},
        "gallery_item_identity": {"key": "properties.galleryItemIdentity", "type": "str"},
        "icon_uris": {"key": "properties.iconUris", "type": "IconUris"},
        "links": {"key": "properties.links", "type": "[ProductLink]"},
        "legal_terms": {"key": "properties.legalTerms", "type": "str"},
        "privacy_policy": {"key": "properties.privacyPolicy", "type": "str"},
        "payload_length": {"key": "properties.payloadLength", "type": "int"},
        "product_kind": {"key": "properties.productKind", "type": "str"},
        "product_properties": {"key": "properties.productProperties", "type": "ProductProperties"},
        "compatibility": {"key": "properties.compatibility", "type": "Compatibility"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        publisher_display_name: Optional[str] = None,
        publisher_identifier: Optional[str] = None,
        offer: Optional[str] = None,
        offer_version: Optional[str] = None,
        sku: Optional[str] = None,
        billing_part_number: Optional[str] = None,
        vm_extension_type: Optional[str] = None,
        gallery_item_identity: Optional[str] = None,
        icon_uris: Optional["_models.IconUris"] = None,
        links: Optional[List["_models.ProductLink"]] = None,
        legal_terms: Optional[str] = None,
        privacy_policy: Optional[str] = None,
        payload_length: Optional[int] = None,
        product_kind: Optional[str] = None,
        product_properties: Optional["_models.ProductProperties"] = None,
        compatibility: Optional["_models.Compatibility"] = None,
        **kwargs
    ):
        """
        :keyword etag: The entity tag used for optimistic concurrency when modifying the resource.
        :paramtype etag: str
        :keyword display_name: The display name of the product.
        :paramtype display_name: str
        :keyword description: The description of the product.
        :paramtype description: str
        :keyword publisher_display_name: The user-friendly name of the product publisher.
        :paramtype publisher_display_name: str
        :keyword publisher_identifier: Publisher identifier.
        :paramtype publisher_identifier: str
        :keyword offer: The offer representing the product.
        :paramtype offer: str
        :keyword offer_version: The version of the product offer.
        :paramtype offer_version: str
        :keyword sku: The product SKU.
        :paramtype sku: str
        :keyword billing_part_number: The part number used for billing purposes.
        :paramtype billing_part_number: str
        :keyword vm_extension_type: The type of the Virtual Machine Extension.
        :paramtype vm_extension_type: str
        :keyword gallery_item_identity: The identifier of the gallery item corresponding to the
         product.
        :paramtype gallery_item_identity: str
        :keyword icon_uris: Additional links available for this product.
        :paramtype icon_uris: ~azure.mgmt.azurestack.models.IconUris
        :keyword links: Additional links available for this product.
        :paramtype links: list[~azure.mgmt.azurestack.models.ProductLink]
        :keyword legal_terms: The legal terms.
        :paramtype legal_terms: str
        :keyword privacy_policy: The privacy policy.
        :paramtype privacy_policy: str
        :keyword payload_length: The length of product content.
        :paramtype payload_length: int
        :keyword product_kind: The kind of the product (virtualMachine or virtualMachineExtension).
        :paramtype product_kind: str
        :keyword product_properties: Additional properties for the product.
        :paramtype product_properties: ~azure.mgmt.azurestack.models.ProductProperties
        :keyword compatibility: Product compatibility with current device.
        :paramtype compatibility: ~azure.mgmt.azurestack.models.Compatibility
        """
        super().__init__(etag=etag, **kwargs)
        self.display_name = display_name
        self.description = description
        self.publisher_display_name = publisher_display_name
        self.publisher_identifier = publisher_identifier
        self.offer = offer
        self.offer_version = offer_version
        self.sku = sku
        self.billing_part_number = billing_part_number
        self.vm_extension_type = vm_extension_type
        self.gallery_item_identity = gallery_item_identity
        self.icon_uris = icon_uris
        self.links = links
        self.legal_terms = legal_terms
        self.privacy_policy = privacy_policy
        self.payload_length = payload_length
        self.product_kind = product_kind
        self.product_properties = product_properties
        self.compatibility = compatibility


class ProductLink(_serialization.Model):
    """Link with additional information about a product.

    :ivar display_name: The description of the link.
    :vartype display_name: str
    :ivar uri: The URI corresponding to the link.
    :vartype uri: str
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, display_name: Optional[str] = None, uri: Optional[str] = None, **kwargs):
        """
        :keyword display_name: The description of the link.
        :paramtype display_name: str
        :keyword uri: The URI corresponding to the link.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.uri = uri


class ProductList(_serialization.Model):
    """Pageable list of products.

    :ivar next_link: URI to the next page.
    :vartype next_link: str
    :ivar value: List of products.
    :vartype value: list[~azure.mgmt.azurestack.models.Product]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Product]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, value: Optional[List["_models.Product"]] = None, **kwargs):
        """
        :keyword next_link: URI to the next page.
        :paramtype next_link: str
        :keyword value: List of products.
        :paramtype value: list[~azure.mgmt.azurestack.models.Product]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ProductLog(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Product action log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Log ID.
    :vartype id: str
    :ivar product_id: Logged product ID.
    :vartype product_id: str
    :ivar subscription_id: Logged subscription ID.
    :vartype subscription_id: str
    :ivar registration_name: Logged registration name.
    :vartype registration_name: str
    :ivar resource_group_name: Logged resource group name.
    :vartype resource_group_name: str
    :ivar operation: Logged operation.
    :vartype operation: str
    :ivar start_date: Operation start datetime.
    :vartype start_date: str
    :ivar end_date: Operation end datetime.
    :vartype end_date: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error: Operation error data.
    :vartype error: str
    :ivar details: Operation error details.
    :vartype details: str
    """

    _validation = {
        "id": {"readonly": True},
        "product_id": {"readonly": True},
        "subscription_id": {"readonly": True},
        "registration_name": {"readonly": True},
        "resource_group_name": {"readonly": True},
        "operation": {"readonly": True},
        "start_date": {"readonly": True},
        "end_date": {"readonly": True},
        "status": {"readonly": True},
        "error": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "product_id": {"key": "productId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "registration_name": {"key": "registrationName", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "start_date": {"key": "startDate", "type": "str"},
        "end_date": {"key": "endDate", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.product_id = None
        self.subscription_id = None
        self.registration_name = None
        self.resource_group_name = None
        self.operation = None
        self.start_date = None
        self.end_date = None
        self.status = None
        self.error = None
        self.details = None


class ProductProperties(_serialization.Model):
    """Additional properties of the product.

    :ivar version: The version.
    :vartype version: str
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, version: Optional[str] = None, **kwargs):
        """
        :keyword version: The version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.version = version


class TrackedResource(_serialization.Model):
    """Base resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: ID of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of Resource.
    :vartype type: str
    :ivar location: Location of the resource. Required. "global"
    :vartype location: str or ~azure.mgmt.azurestack.models.Location
    :ivar tags: Custom tags for the resource.
    :vartype tags: dict[str, str]
    :ivar etag: The entity tag used for optimistic concurrency when modifying the resource.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Union[str, "_models.Location"],
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the resource. Required. "global"
        :paramtype location: str or ~azure.mgmt.azurestack.models.Location
        :keyword tags: Custom tags for the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: The entity tag used for optimistic concurrency when modifying the resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.etag = etag


class Registration(TrackedResource):
    """Registration information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: ID of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of Resource.
    :vartype type: str
    :ivar location: Location of the resource. Required. "global"
    :vartype location: str or ~azure.mgmt.azurestack.models.Location
    :ivar tags: Custom tags for the resource.
    :vartype tags: dict[str, str]
    :ivar etag: The entity tag used for optimistic concurrency when modifying the resource.
    :vartype etag: str
    :ivar object_id: The object identifier associated with the Azure Stack connecting to Azure.
    :vartype object_id: str
    :ivar cloud_id: The identifier of the registered Azure Stack.
    :vartype cloud_id: str
    :ivar billing_model: Specifies the billing mode for the Azure Stack registration.
    :vartype billing_model: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "object_id": {"key": "properties.objectId", "type": "str"},
        "cloud_id": {"key": "properties.cloudId", "type": "str"},
        "billing_model": {"key": "properties.billingModel", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Union[str, "_models.Location"],
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        object_id: Optional[str] = None,
        cloud_id: Optional[str] = None,
        billing_model: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the resource. Required. "global"
        :paramtype location: str or ~azure.mgmt.azurestack.models.Location
        :keyword tags: Custom tags for the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: The entity tag used for optimistic concurrency when modifying the resource.
        :paramtype etag: str
        :keyword object_id: The object identifier associated with the Azure Stack connecting to Azure.
        :paramtype object_id: str
        :keyword cloud_id: The identifier of the registered Azure Stack.
        :paramtype cloud_id: str
        :keyword billing_model: Specifies the billing mode for the Azure Stack registration.
        :paramtype billing_model: str
        """
        super().__init__(location=location, tags=tags, etag=etag, **kwargs)
        self.object_id = object_id
        self.cloud_id = cloud_id
        self.billing_model = billing_model


class RegistrationList(_serialization.Model):
    """Pageable list of registrations.

    :ivar next_link: URI to the next page.
    :vartype next_link: str
    :ivar value: List of Registrations.
    :vartype value: list[~azure.mgmt.azurestack.models.Registration]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Registration]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Registration"]] = None, **kwargs
    ):
        """
        :keyword next_link: URI to the next page.
        :paramtype next_link: str
        :keyword value: List of Registrations.
        :paramtype value: list[~azure.mgmt.azurestack.models.Registration]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class RegistrationParameter(_serialization.Model):
    """Registration resource.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Location of the resource. Required. "global"
    :vartype location: str or ~azure.mgmt.azurestack.models.Location
    :ivar registration_token: The token identifying registered Azure Stack. Required.
    :vartype registration_token: str
    """

    _validation = {
        "location": {"required": True},
        "registration_token": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "registration_token": {"key": "properties.registrationToken", "type": "str"},
    }

    def __init__(self, *, location: Union[str, "_models.Location"], registration_token: str, **kwargs):
        """
        :keyword location: Location of the resource. Required. "global"
        :paramtype location: str or ~azure.mgmt.azurestack.models.Location
        :keyword registration_token: The token identifying registered Azure Stack. Required.
        :paramtype registration_token: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.registration_token = registration_token
