# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class InfoField(_serialization.Model):
    """Key-value pairs of instance details in the legacy format.

    :ivar project: Identifies the name of the instance provisioned by the user.
    :vartype project: str
    """

    _attribute_map = {
        "project": {"key": "project", "type": "str"},
    }

    def __init__(self, *, project: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword project: Identifies the name of the instance provisioned by the user.
        :paramtype project: str
        """
        super().__init__(**kwargs)
        self.project = project


class MeterInfo(_serialization.Model):
    """Detailed information about the meter.

    :ivar meter_id: The unique identifier of the resource.
    :vartype meter_id: str
    :ivar meter_name: The name of the meter, within the given meter category.
    :vartype meter_name: str
    :ivar meter_category: The category of the meter, e.g., 'Cloud services', 'Networking', etc..
    :vartype meter_category: str
    :ivar meter_sub_category: The subcategory of the meter, e.g., 'A6 Cloud services',
     'ExpressRoute (IXP)', etc..
    :vartype meter_sub_category: str
    :ivar unit: The unit in which the meter consumption is charged, e.g., 'Hours', 'GB', etc.
    :vartype unit: str
    :ivar meter_tags: Provides additional meter data. 'Third Party' indicates a meter with no
     discount. Blanks indicate First Party.
    :vartype meter_tags: list[str]
    :ivar meter_region: The region in which the Azure service is available.
    :vartype meter_region: str
    :ivar meter_rates: The list of key/value pairs for the meter rates, in the format 'key':'value'
     where key = the meter quantity, and value = the corresponding price.
    :vartype meter_rates: dict[str, float]
    :ivar effective_date: Indicates the date from which the meter rate is effective.
    :vartype effective_date: ~datetime.datetime
    :ivar included_quantity: The resource quantity that is included in the offer at no cost.
     Consumption beyond this quantity will be charged.
    :vartype included_quantity: float
    """

    _attribute_map = {
        "meter_id": {"key": "MeterId", "type": "str"},
        "meter_name": {"key": "MeterName", "type": "str"},
        "meter_category": {"key": "MeterCategory", "type": "str"},
        "meter_sub_category": {"key": "MeterSubCategory", "type": "str"},
        "unit": {"key": "Unit", "type": "str"},
        "meter_tags": {"key": "MeterTags", "type": "[str]"},
        "meter_region": {"key": "MeterRegion", "type": "str"},
        "meter_rates": {"key": "MeterRates", "type": "{float}"},
        "effective_date": {"key": "EffectiveDate", "type": "iso-8601"},
        "included_quantity": {"key": "IncludedQuantity", "type": "float"},
    }

    def __init__(
        self,
        *,
        meter_id: Optional[str] = None,
        meter_name: Optional[str] = None,
        meter_category: Optional[str] = None,
        meter_sub_category: Optional[str] = None,
        unit: Optional[str] = None,
        meter_tags: Optional[List[str]] = None,
        meter_region: Optional[str] = None,
        meter_rates: Optional[Dict[str, float]] = None,
        effective_date: Optional[datetime.datetime] = None,
        included_quantity: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword meter_id: The unique identifier of the resource.
        :paramtype meter_id: str
        :keyword meter_name: The name of the meter, within the given meter category.
        :paramtype meter_name: str
        :keyword meter_category: The category of the meter, e.g., 'Cloud services', 'Networking', etc..
        :paramtype meter_category: str
        :keyword meter_sub_category: The subcategory of the meter, e.g., 'A6 Cloud services',
         'ExpressRoute (IXP)', etc..
        :paramtype meter_sub_category: str
        :keyword unit: The unit in which the meter consumption is charged, e.g., 'Hours', 'GB', etc.
        :paramtype unit: str
        :keyword meter_tags: Provides additional meter data. 'Third Party' indicates a meter with no
         discount. Blanks indicate First Party.
        :paramtype meter_tags: list[str]
        :keyword meter_region: The region in which the Azure service is available.
        :paramtype meter_region: str
        :keyword meter_rates: The list of key/value pairs for the meter rates, in the format
         'key':'value' where key = the meter quantity, and value = the corresponding price.
        :paramtype meter_rates: dict[str, float]
        :keyword effective_date: Indicates the date from which the meter rate is effective.
        :paramtype effective_date: ~datetime.datetime
        :keyword included_quantity: The resource quantity that is included in the offer at no cost.
         Consumption beyond this quantity will be charged.
        :paramtype included_quantity: float
        """
        super().__init__(**kwargs)
        self.meter_id = meter_id
        self.meter_name = meter_name
        self.meter_category = meter_category
        self.meter_sub_category = meter_sub_category
        self.unit = unit
        self.meter_tags = meter_tags
        self.meter_region = meter_region
        self.meter_rates = meter_rates
        self.effective_date = effective_date
        self.included_quantity = included_quantity


class OfferTermInfo(_serialization.Model):
    """Describes the offer term.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MonetaryCommitment, MonetaryCredit, RecurringCharge

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the offer term. Required. Known values are: "Recurring Charge", "Monetary
     Commitment", and "Monetary Credit".
    :vartype name: str or ~azure.mgmt.commerce.models.OfferTermInfoEnum
    :ivar effective_date: Indicates the date from which the offer term is effective.
    :vartype effective_date: ~datetime.datetime
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "effective_date": {"key": "EffectiveDate", "type": "iso-8601"},
    }

    _subtype_map = {
        "name": {
            "Monetary Commitment": "MonetaryCommitment",
            "Monetary Credit": "MonetaryCredit",
            "Recurring Charge": "RecurringCharge",
        }
    }

    def __init__(self, *, effective_date: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword effective_date: Indicates the date from which the offer term is effective.
        :paramtype effective_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.effective_date = effective_date


class MonetaryCommitment(OfferTermInfo):
    """Indicates that a monetary commitment is required for this offer.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the offer term. Required. Known values are: "Recurring Charge", "Monetary
     Commitment", and "Monetary Credit".
    :vartype name: str or ~azure.mgmt.commerce.models.OfferTermInfoEnum
    :ivar effective_date: Indicates the date from which the offer term is effective.
    :vartype effective_date: ~datetime.datetime
    :ivar tiered_discount: The list of key/value pairs for the tiered meter rates, in the format
     'key':'value' where key = price, and value = the corresponding discount percentage. This field
     is used only by offer terms of type 'Monetary Commitment'.
    :vartype tiered_discount: dict[str, float]
    :ivar excluded_meter_ids: An array of meter ids that are excluded from the given offer terms.
    :vartype excluded_meter_ids: list[str]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "effective_date": {"key": "EffectiveDate", "type": "iso-8601"},
        "tiered_discount": {"key": "TieredDiscount", "type": "{float}"},
        "excluded_meter_ids": {"key": "ExcludedMeterIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        effective_date: Optional[datetime.datetime] = None,
        tiered_discount: Optional[Dict[str, float]] = None,
        excluded_meter_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword effective_date: Indicates the date from which the offer term is effective.
        :paramtype effective_date: ~datetime.datetime
        :keyword tiered_discount: The list of key/value pairs for the tiered meter rates, in the format
         'key':'value' where key = price, and value = the corresponding discount percentage. This field
         is used only by offer terms of type 'Monetary Commitment'.
        :paramtype tiered_discount: dict[str, float]
        :keyword excluded_meter_ids: An array of meter ids that are excluded from the given offer
         terms.
        :paramtype excluded_meter_ids: list[str]
        """
        super().__init__(effective_date=effective_date, **kwargs)
        self.name: str = "Monetary Commitment"
        self.tiered_discount = tiered_discount
        self.excluded_meter_ids = excluded_meter_ids


class MonetaryCredit(OfferTermInfo):
    """Indicates that this is a monetary credit offer.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the offer term. Required. Known values are: "Recurring Charge", "Monetary
     Commitment", and "Monetary Credit".
    :vartype name: str or ~azure.mgmt.commerce.models.OfferTermInfoEnum
    :ivar effective_date: Indicates the date from which the offer term is effective.
    :vartype effective_date: ~datetime.datetime
    :ivar credit: The amount of credit provided under the terms of the given offer level.
    :vartype credit: float
    :ivar excluded_meter_ids: An array of meter ids that are excluded from the given offer terms.
    :vartype excluded_meter_ids: list[str]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "effective_date": {"key": "EffectiveDate", "type": "iso-8601"},
        "credit": {"key": "Credit", "type": "float"},
        "excluded_meter_ids": {"key": "ExcludedMeterIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        effective_date: Optional[datetime.datetime] = None,
        credit: Optional[float] = None,
        excluded_meter_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword effective_date: Indicates the date from which the offer term is effective.
        :paramtype effective_date: ~datetime.datetime
        :keyword credit: The amount of credit provided under the terms of the given offer level.
        :paramtype credit: float
        :keyword excluded_meter_ids: An array of meter ids that are excluded from the given offer
         terms.
        :paramtype excluded_meter_ids: list[str]
        """
        super().__init__(effective_date=effective_date, **kwargs)
        self.name: str = "Monetary Credit"
        self.credit = credit
        self.excluded_meter_ids = excluded_meter_ids


class RateCardQueryParameters(_serialization.Model):
    """Parameters that are used in the odata $filter query parameter for providing RateCard
    information.

    All required parameters must be populated in order to send to Azure.

    :ivar offer_durable_id: The Offer ID parameter consists of the 'MS-AZR-' prefix, plus the Offer
     ID number (e.g., MS-AZR-0026P). See
     https://azure.microsoft.com/en-us/support/legal/offer-details/ for more information on the list
     of available Offer IDs, country/region availability, and billing currency. Required.
    :vartype offer_durable_id: str
    :ivar currency: The currency in which the rates need to be provided. Required.
    :vartype currency: str
    :ivar locale: The culture in which the resource metadata needs to be localized. Required.
    :vartype locale: str
    :ivar region_info: 2 letter ISO code where the offer was purchased. Required.
    :vartype region_info: str
    """

    _validation = {
        "offer_durable_id": {"required": True, "pattern": r"^MS-AZR-\d{4}P(-\d{4}P)*$"},
        "currency": {"required": True},
        "locale": {"required": True},
        "region_info": {"required": True},
    }

    _attribute_map = {
        "offer_durable_id": {"key": "OfferDurableId", "type": "str"},
        "currency": {"key": "Currency", "type": "str"},
        "locale": {"key": "Locale", "type": "str"},
        "region_info": {"key": "RegionInfo", "type": "str"},
    }

    def __init__(self, *, offer_durable_id: str, currency: str, locale: str, region_info: str, **kwargs: Any) -> None:
        """
        :keyword offer_durable_id: The Offer ID parameter consists of the 'MS-AZR-' prefix, plus the
         Offer ID number (e.g., MS-AZR-0026P). See
         https://azure.microsoft.com/en-us/support/legal/offer-details/ for more information on the list
         of available Offer IDs, country/region availability, and billing currency. Required.
        :paramtype offer_durable_id: str
        :keyword currency: The currency in which the rates need to be provided. Required.
        :paramtype currency: str
        :keyword locale: The culture in which the resource metadata needs to be localized. Required.
        :paramtype locale: str
        :keyword region_info: 2 letter ISO code where the offer was purchased. Required.
        :paramtype region_info: str
        """
        super().__init__(**kwargs)
        self.offer_durable_id = offer_durable_id
        self.currency = currency
        self.locale = locale
        self.region_info = region_info


class RecurringCharge(OfferTermInfo):
    """Indicates a recurring charge is present for this offer.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the offer term. Required. Known values are: "Recurring Charge", "Monetary
     Commitment", and "Monetary Credit".
    :vartype name: str or ~azure.mgmt.commerce.models.OfferTermInfoEnum
    :ivar effective_date: Indicates the date from which the offer term is effective.
    :vartype effective_date: ~datetime.datetime
    :ivar recurring_charge: The amount of recurring charge as per the offer term.
    :vartype recurring_charge: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "effective_date": {"key": "EffectiveDate", "type": "iso-8601"},
        "recurring_charge": {"key": "RecurringCharge", "type": "int"},
    }

    def __init__(
        self,
        *,
        effective_date: Optional[datetime.datetime] = None,
        recurring_charge: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword effective_date: Indicates the date from which the offer term is effective.
        :paramtype effective_date: ~datetime.datetime
        :keyword recurring_charge: The amount of recurring charge as per the offer term.
        :paramtype recurring_charge: int
        """
        super().__init__(effective_date=effective_date, **kwargs)
        self.name: str = "Recurring Charge"
        self.recurring_charge = recurring_charge


class ResourceRateCardInfo(_serialization.Model):
    """Price and Metadata information for resources.

    :ivar currency: The currency in which the rates are provided.
    :vartype currency: str
    :ivar locale: The culture in which the resource information is localized.
    :vartype locale: str
    :ivar is_tax_included: All rates are pretax, so this will always be returned as 'false'.
    :vartype is_tax_included: bool
    :ivar offer_terms: A list of offer terms.
    :vartype offer_terms: list[~azure.mgmt.commerce.models.OfferTermInfo]
    :ivar meters: A list of meters.
    :vartype meters: list[~azure.mgmt.commerce.models.MeterInfo]
    """

    _attribute_map = {
        "currency": {"key": "Currency", "type": "str"},
        "locale": {"key": "Locale", "type": "str"},
        "is_tax_included": {"key": "IsTaxIncluded", "type": "bool"},
        "offer_terms": {"key": "OfferTerms", "type": "[OfferTermInfo]"},
        "meters": {"key": "Meters", "type": "[MeterInfo]"},
    }

    def __init__(
        self,
        *,
        currency: Optional[str] = None,
        locale: Optional[str] = None,
        is_tax_included: Optional[bool] = None,
        offer_terms: Optional[List["_models.OfferTermInfo"]] = None,
        meters: Optional[List["_models.MeterInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword currency: The currency in which the rates are provided.
        :paramtype currency: str
        :keyword locale: The culture in which the resource information is localized.
        :paramtype locale: str
        :keyword is_tax_included: All rates are pretax, so this will always be returned as 'false'.
        :paramtype is_tax_included: bool
        :keyword offer_terms: A list of offer terms.
        :paramtype offer_terms: list[~azure.mgmt.commerce.models.OfferTermInfo]
        :keyword meters: A list of meters.
        :paramtype meters: list[~azure.mgmt.commerce.models.MeterInfo]
        """
        super().__init__(**kwargs)
        self.currency = currency
        self.locale = locale
        self.is_tax_included = is_tax_included
        self.offer_terms = offer_terms
        self.meters = meters


class UsageAggregation(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes the usageAggregation.

    :ivar id: Unique Id for the usage aggregate.
    :vartype id: str
    :ivar name: Name of the usage aggregate.
    :vartype name: str
    :ivar type: Type of the resource being returned.
    :vartype type: str
    :ivar subscription_id: The subscription identifier for the Azure user.
    :vartype subscription_id: str
    :ivar meter_id: Unique ID for the resource that was consumed (aka ResourceID).
    :vartype meter_id: str
    :ivar usage_start_time: UTC start time for the usage bucket to which this usage aggregate
     belongs.
    :vartype usage_start_time: ~datetime.datetime
    :ivar usage_end_time: UTC end time for the usage bucket to which this usage aggregate belongs.
    :vartype usage_end_time: ~datetime.datetime
    :ivar quantity: The amount of the resource consumption that occurred in this time frame.
    :vartype quantity: float
    :ivar unit: The unit in which the usage for this resource is being counted, e.g. Hours, GB.
    :vartype unit: str
    :ivar meter_name: Friendly name of the resource being consumed.
    :vartype meter_name: str
    :ivar meter_category: Category of the consumed resource.
    :vartype meter_category: str
    :ivar meter_sub_category: Sub-category of the consumed resource.
    :vartype meter_sub_category: str
    :ivar meter_region: Region of the meterId used for billing purposes.
    :vartype meter_region: str
    :ivar info_fields: Key-value pairs of instance details (legacy format).
    :vartype info_fields: ~azure.mgmt.commerce.models.InfoField
    :ivar instance_data: Key-value pairs of instance details represented as a string.
    :vartype instance_data: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "meter_id": {"key": "properties.meterId", "type": "str"},
        "usage_start_time": {"key": "properties.usageStartTime", "type": "iso-8601"},
        "usage_end_time": {"key": "properties.usageEndTime", "type": "iso-8601"},
        "quantity": {"key": "properties.quantity", "type": "float"},
        "unit": {"key": "properties.unit", "type": "str"},
        "meter_name": {"key": "properties.meterName", "type": "str"},
        "meter_category": {"key": "properties.meterCategory", "type": "str"},
        "meter_sub_category": {"key": "properties.meterSubCategory", "type": "str"},
        "meter_region": {"key": "properties.meterRegion", "type": "str"},
        "info_fields": {"key": "properties.infoFields", "type": "InfoField"},
        "instance_data": {"key": "properties.instanceData", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        subscription_id: Optional[str] = None,
        meter_id: Optional[str] = None,
        usage_start_time: Optional[datetime.datetime] = None,
        usage_end_time: Optional[datetime.datetime] = None,
        quantity: Optional[float] = None,
        unit: Optional[str] = None,
        meter_name: Optional[str] = None,
        meter_category: Optional[str] = None,
        meter_sub_category: Optional[str] = None,
        meter_region: Optional[str] = None,
        info_fields: Optional["_models.InfoField"] = None,
        instance_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique Id for the usage aggregate.
        :paramtype id: str
        :keyword name: Name of the usage aggregate.
        :paramtype name: str
        :keyword type: Type of the resource being returned.
        :paramtype type: str
        :keyword subscription_id: The subscription identifier for the Azure user.
        :paramtype subscription_id: str
        :keyword meter_id: Unique ID for the resource that was consumed (aka ResourceID).
        :paramtype meter_id: str
        :keyword usage_start_time: UTC start time for the usage bucket to which this usage aggregate
         belongs.
        :paramtype usage_start_time: ~datetime.datetime
        :keyword usage_end_time: UTC end time for the usage bucket to which this usage aggregate
         belongs.
        :paramtype usage_end_time: ~datetime.datetime
        :keyword quantity: The amount of the resource consumption that occurred in this time frame.
        :paramtype quantity: float
        :keyword unit: The unit in which the usage for this resource is being counted, e.g. Hours, GB.
        :paramtype unit: str
        :keyword meter_name: Friendly name of the resource being consumed.
        :paramtype meter_name: str
        :keyword meter_category: Category of the consumed resource.
        :paramtype meter_category: str
        :keyword meter_sub_category: Sub-category of the consumed resource.
        :paramtype meter_sub_category: str
        :keyword meter_region: Region of the meterId used for billing purposes.
        :paramtype meter_region: str
        :keyword info_fields: Key-value pairs of instance details (legacy format).
        :paramtype info_fields: ~azure.mgmt.commerce.models.InfoField
        :keyword instance_data: Key-value pairs of instance details represented as a string.
        :paramtype instance_data: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.subscription_id = subscription_id
        self.meter_id = meter_id
        self.usage_start_time = usage_start_time
        self.usage_end_time = usage_end_time
        self.quantity = quantity
        self.unit = unit
        self.meter_name = meter_name
        self.meter_category = meter_category
        self.meter_sub_category = meter_sub_category
        self.meter_region = meter_region
        self.info_fields = info_fields
        self.instance_data = instance_data


class UsageAggregationListResult(_serialization.Model):
    """The Get UsageAggregates operation response.

    :ivar value: Gets or sets details for the requested aggregation.
    :vartype value: list[~azure.mgmt.commerce.models.UsageAggregation]
    :ivar next_link: Gets or sets the link to the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[UsageAggregation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.UsageAggregation"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets details for the requested aggregation.
        :paramtype value: list[~azure.mgmt.commerce.models.UsageAggregation]
        :keyword next_link: Gets or sets the link to the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
