# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class BatchRequest(_serialization.Model):
    """Definition for the input batch translation request.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Source of the input documents. Required.
    :vartype source: ~azure.ai.translation.document.models.SourceInput
    :ivar targets: Location of the destination for the output. Required.
    :vartype targets: list[~azure.ai.translation.document.models.TargetInput]
    :ivar storage_type: Storage type of the input documents source string. Known values are:
     "Folder" and "File".
    :vartype storage_type: str or ~azure.ai.translation.document.models.StorageInputType
    """

    _validation = {
        "source": {"required": True},
        "targets": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "SourceInput"},
        "targets": {"key": "targets", "type": "[TargetInput]"},
        "storage_type": {"key": "storageType", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: "_models.SourceInput",
        targets: List["_models.TargetInput"],
        storage_type: Optional[Union[str, "_models.StorageInputType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Source of the input documents. Required.
        :paramtype source: ~azure.ai.translation.document.models.SourceInput
        :keyword targets: Location of the destination for the output. Required.
        :paramtype targets: list[~azure.ai.translation.document.models.TargetInput]
        :keyword storage_type: Storage type of the input documents source string. Known values are:
         "Folder" and "File".
        :paramtype storage_type: str or ~azure.ai.translation.document.models.StorageInputType
        """
        super().__init__(**kwargs)
        self.source = source
        self.targets = targets
        self.storage_type = storage_type


class DocumentFilter(_serialization.Model):
    """DocumentFilter.

    :ivar prefix: A case-sensitive prefix string to filter documents in the source path for
     translation.
     For example, when using a Azure storage blob Uri, use the prefix to restrict sub folders for
     translation.
    :vartype prefix: str
    :ivar suffix: A case-sensitive suffix string to filter documents in the source path for
     translation.
     This is most often use for file extensions.
    :vartype suffix: str
    """

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "suffix": {"key": "suffix", "type": "str"},
    }

    def __init__(self, *, prefix: Optional[str] = None, suffix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword prefix: A case-sensitive prefix string to filter documents in the source path for
         translation.
         For example, when using a Azure storage blob Uri, use the prefix to restrict sub folders for
         translation.
        :paramtype prefix: str
        :keyword suffix: A case-sensitive suffix string to filter documents in the source path for
         translation.
         This is most often use for file extensions.
        :paramtype suffix: str
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.suffix = suffix


class DocumentsStatus(_serialization.Model):
    """Documents Status Response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The detail status of individual documents. Required.
    :vartype value: list[~azure.ai.translation.document.models.DocumentStatus]
    :ivar next_link: Url for the next page.  Null if no more pages available.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DocumentStatus]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DocumentStatus"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The detail status of individual documents. Required.
        :paramtype value: list[~azure.ai.translation.document.models.DocumentStatus]
        :keyword next_link: Url for the next page.  Null if no more pages available.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DocumentStatus(_serialization.Model):
    """Document Status Response.

    All required parameters must be populated in order to send to Azure.

    :ivar path: Location of the document or folder.
    :vartype path: str
    :ivar source_path: Location of the source document. Required.
    :vartype source_path: str
    :ivar created_date_time_utc: Operation created date time. Required.
    :vartype created_date_time_utc: ~datetime.datetime
    :ivar last_action_date_time_utc: Date time in which the operation's status has been updated.
     Required.
    :vartype last_action_date_time_utc: ~datetime.datetime
    :ivar status: List of possible statuses for job or document. Required. Known values are:
     "NotStarted", "Running", "Succeeded", "Failed", "Cancelled", "Cancelling", and
     "ValidationFailed".
    :vartype status: str or ~azure.ai.translation.document.models.Status
    :ivar to: To language. Required.
    :vartype to: str
    :ivar error: This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details.
    :vartype error: ~azure.ai.translation.document.models.TranslationError
    :ivar progress: Progress of the translation if available. Required.
    :vartype progress: float
    :ivar id: Document Id. Required.
    :vartype id: str
    :ivar character_charged: Character charged by the API.
    :vartype character_charged: int
    """

    _validation = {
        "source_path": {"required": True},
        "created_date_time_utc": {"required": True},
        "last_action_date_time_utc": {"required": True},
        "status": {"required": True},
        "to": {"required": True},
        "progress": {"required": True, "maximum": 1, "minimum": 0},
        "id": {"required": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "source_path": {"key": "sourcePath", "type": "str"},
        "created_date_time_utc": {"key": "createdDateTimeUtc", "type": "iso-8601"},
        "last_action_date_time_utc": {"key": "lastActionDateTimeUtc", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "to": {"key": "to", "type": "str"},
        "error": {"key": "error", "type": "TranslationError"},
        "progress": {"key": "progress", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "character_charged": {"key": "characterCharged", "type": "int"},
    }

    def __init__(
        self,
        *,
        source_path: str,
        created_date_time_utc: datetime.datetime,
        last_action_date_time_utc: datetime.datetime,
        status: Union[str, "_models.Status"],
        to: str,
        progress: float,
        id: str,  # pylint: disable=redefined-builtin
        path: Optional[str] = None,
        error: Optional["_models.TranslationError"] = None,
        character_charged: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: Location of the document or folder.
        :paramtype path: str
        :keyword source_path: Location of the source document. Required.
        :paramtype source_path: str
        :keyword created_date_time_utc: Operation created date time. Required.
        :paramtype created_date_time_utc: ~datetime.datetime
        :keyword last_action_date_time_utc: Date time in which the operation's status has been updated.
         Required.
        :paramtype last_action_date_time_utc: ~datetime.datetime
        :keyword status: List of possible statuses for job or document. Required. Known values are:
         "NotStarted", "Running", "Succeeded", "Failed", "Cancelled", "Cancelling", and
         "ValidationFailed".
        :paramtype status: str or ~azure.ai.translation.document.models.Status
        :keyword to: To language. Required.
        :paramtype to: str
        :keyword error: This contains an outer error with error code, message, details, target and an
         inner error with more descriptive details.
        :paramtype error: ~azure.ai.translation.document.models.TranslationError
        :keyword progress: Progress of the translation if available. Required.
        :paramtype progress: float
        :keyword id: Document Id. Required.
        :paramtype id: str
        :keyword character_charged: Character charged by the API.
        :paramtype character_charged: int
        """
        super().__init__(**kwargs)
        self.path = path
        self.source_path = source_path
        self.created_date_time_utc = created_date_time_utc
        self.last_action_date_time_utc = last_action_date_time_utc
        self.status = status
        self.to = to
        self.error = error
        self.progress = progress
        self.id = id
        self.character_charged = character_charged


class FileFormat(_serialization.Model):
    """FileFormat.

    All required parameters must be populated in order to send to Azure.

    :ivar format: Name of the format. Required.
    :vartype format: str
    :ivar file_extensions: Supported file extension for this format. Required.
    :vartype file_extensions: list[str]
    :ivar content_types: Supported Content-Types for this format. Required.
    :vartype content_types: list[str]
    :ivar default_version: Default version if none is specified.
    :vartype default_version: str
    :ivar versions: Supported Version.
    :vartype versions: list[str]
    """

    _validation = {
        "format": {"required": True},
        "file_extensions": {"required": True},
        "content_types": {"required": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "file_extensions": {"key": "fileExtensions", "type": "[str]"},
        "content_types": {"key": "contentTypes", "type": "[str]"},
        "default_version": {"key": "defaultVersion", "type": "str"},
        "versions": {"key": "versions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        format: str,
        file_extensions: List[str],
        content_types: List[str],
        default_version: Optional[str] = None,
        versions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword format: Name of the format. Required.
        :paramtype format: str
        :keyword file_extensions: Supported file extension for this format. Required.
        :paramtype file_extensions: list[str]
        :keyword content_types: Supported Content-Types for this format. Required.
        :paramtype content_types: list[str]
        :keyword default_version: Default version if none is specified.
        :paramtype default_version: str
        :keyword versions: Supported Version.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.format = format
        self.file_extensions = file_extensions
        self.content_types = content_types
        self.default_version = default_version
        self.versions = versions


class Glossary(_serialization.Model):
    """Glossary / translation memory for the request.

    All required parameters must be populated in order to send to Azure.

    :ivar glossary_url: Location of the glossary.
     We will use the file extension to extract the formatting if the format parameter is not
     supplied.

     If the translation language pair is not present in the glossary, it will not be applied.
     Required.
    :vartype glossary_url: str
    :ivar format: Format. Required.
    :vartype format: str
    :ivar version: Optional Version.  If not specified, default is used.
    :vartype version: str
    :ivar storage_source: Storage Source. "AzureBlob"
    :vartype storage_source: str or ~azure.ai.translation.document.models.StorageSource
    """

    _validation = {
        "glossary_url": {"required": True},
        "format": {"required": True},
    }

    _attribute_map = {
        "glossary_url": {"key": "glossaryUrl", "type": "str"},
        "format": {"key": "format", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "storage_source": {"key": "storageSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        glossary_url: str,
        format: str,
        version: Optional[str] = None,
        storage_source: Optional[Union[str, "_models.StorageSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword glossary_url: Location of the glossary.
         We will use the file extension to extract the formatting if the format parameter is not
         supplied.

         If the translation language pair is not present in the glossary, it will not be applied.
         Required.
        :paramtype glossary_url: str
        :keyword format: Format. Required.
        :paramtype format: str
        :keyword version: Optional Version.  If not specified, default is used.
        :paramtype version: str
        :keyword storage_source: Storage Source. "AzureBlob"
        :paramtype storage_source: str or ~azure.ai.translation.document.models.StorageSource
        """
        super().__init__(**kwargs)
        self.glossary_url = glossary_url
        self.format = format
        self.version = version
        self.storage_source = storage_source


class InnerTranslationError(_serialization.Model):
    """New Inner Error format which conforms to Cognitive Services API Guidelines which is available
    at
    https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
    This contains required properties ErrorCode, message and optional properties target,
    details(key value pair), inner error(this can be nested).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Gets code error string. Required.
    :vartype code: str
    :ivar message: Gets high level error message. Required.
    :vartype message: str
    :ivar target: Gets the source of the error.
     For example it would be "documents" or "document id" in case of invalid document.
    :vartype target: str
    :ivar inner_error: New Inner Error format which conforms to Cognitive Services API Guidelines
     which is available at
     https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
     This contains required properties ErrorCode, message and optional properties target,
     details(key value pair), inner error(this can be nested).
    :vartype inner_error: ~azure.ai.translation.document.models.InnerTranslationError
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "inner_error": {"key": "innerError", "type": "InnerTranslationError"},
    }

    def __init__(
        self, *, code: str, message: str, inner_error: Optional["_models.InnerTranslationError"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Gets code error string. Required.
        :paramtype code: str
        :keyword message: Gets high level error message. Required.
        :paramtype message: str
        :keyword inner_error: New Inner Error format which conforms to Cognitive Services API
         Guidelines which is available at
         https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
         This contains required properties ErrorCode, message and optional properties target,
         details(key value pair), inner error(this can be nested).
        :paramtype inner_error: ~azure.ai.translation.document.models.InnerTranslationError
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.inner_error = inner_error


class SourceInput(_serialization.Model):
    """Source of the input documents.

    All required parameters must be populated in order to send to Azure.

    :ivar source_url: Location of the folder / container or single file with your documents.
     Required.
    :vartype source_url: str
    :ivar filter:
    :vartype filter: ~azure.ai.translation.document.models.DocumentFilter
    :ivar language: Language code
     If none is specified, we will perform auto detect on the document.
    :vartype language: str
    :ivar storage_source: Storage Source. "AzureBlob"
    :vartype storage_source: str or ~azure.ai.translation.document.models.StorageSource
    """

    _validation = {
        "source_url": {"required": True},
    }

    _attribute_map = {
        "source_url": {"key": "sourceUrl", "type": "str"},
        "filter": {"key": "filter", "type": "DocumentFilter"},
        "language": {"key": "language", "type": "str"},
        "storage_source": {"key": "storageSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_url: str,
        filter: Optional["_models.DocumentFilter"] = None,  # pylint: disable=redefined-builtin
        language: Optional[str] = None,
        storage_source: Optional[Union[str, "_models.StorageSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_url: Location of the folder / container or single file with your documents.
         Required.
        :paramtype source_url: str
        :keyword filter:
        :paramtype filter: ~azure.ai.translation.document.models.DocumentFilter
        :keyword language: Language code
         If none is specified, we will perform auto detect on the document.
        :paramtype language: str
        :keyword storage_source: Storage Source. "AzureBlob"
        :paramtype storage_source: str or ~azure.ai.translation.document.models.StorageSource
        """
        super().__init__(**kwargs)
        self.source_url = source_url
        self.filter = filter
        self.language = language
        self.storage_source = storage_source


class StartTranslationDetails(_serialization.Model):
    """Translation job submission batch request.

    All required parameters must be populated in order to send to Azure.

    :ivar inputs: The input list of documents or folders containing documents. Required.
    :vartype inputs: list[~azure.ai.translation.document.models.BatchRequest]
    """

    _validation = {
        "inputs": {"required": True},
    }

    _attribute_map = {
        "inputs": {"key": "inputs", "type": "[BatchRequest]"},
    }

    def __init__(self, *, inputs: List["_models.BatchRequest"], **kwargs: Any) -> None:
        """
        :keyword inputs: The input list of documents or folders containing documents. Required.
        :paramtype inputs: list[~azure.ai.translation.document.models.BatchRequest]
        """
        super().__init__(**kwargs)
        self.inputs = inputs


class StatusSummary(_serialization.Model):
    """StatusSummary.

    All required parameters must be populated in order to send to Azure.

    :ivar total: Total count. Required.
    :vartype total: int
    :ivar failed: Failed count. Required.
    :vartype failed: int
    :ivar success: Number of Success. Required.
    :vartype success: int
    :ivar in_progress: Number of in progress. Required.
    :vartype in_progress: int
    :ivar not_yet_started: Count of not yet started. Required.
    :vartype not_yet_started: int
    :ivar cancelled: Number of cancelled. Required.
    :vartype cancelled: int
    :ivar total_character_charged: Total characters charged by the API. Required.
    :vartype total_character_charged: int
    """

    _validation = {
        "total": {"required": True},
        "failed": {"required": True},
        "success": {"required": True},
        "in_progress": {"required": True},
        "not_yet_started": {"required": True},
        "cancelled": {"required": True},
        "total_character_charged": {"required": True},
    }

    _attribute_map = {
        "total": {"key": "total", "type": "int"},
        "failed": {"key": "failed", "type": "int"},
        "success": {"key": "success", "type": "int"},
        "in_progress": {"key": "inProgress", "type": "int"},
        "not_yet_started": {"key": "notYetStarted", "type": "int"},
        "cancelled": {"key": "cancelled", "type": "int"},
        "total_character_charged": {"key": "totalCharacterCharged", "type": "int"},
    }

    def __init__(
        self,
        *,
        total: int,
        failed: int,
        success: int,
        in_progress: int,
        not_yet_started: int,
        cancelled: int,
        total_character_charged: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword total: Total count. Required.
        :paramtype total: int
        :keyword failed: Failed count. Required.
        :paramtype failed: int
        :keyword success: Number of Success. Required.
        :paramtype success: int
        :keyword in_progress: Number of in progress. Required.
        :paramtype in_progress: int
        :keyword not_yet_started: Count of not yet started. Required.
        :paramtype not_yet_started: int
        :keyword cancelled: Number of cancelled. Required.
        :paramtype cancelled: int
        :keyword total_character_charged: Total characters charged by the API. Required.
        :paramtype total_character_charged: int
        """
        super().__init__(**kwargs)
        self.total = total
        self.failed = failed
        self.success = success
        self.in_progress = in_progress
        self.not_yet_started = not_yet_started
        self.cancelled = cancelled
        self.total_character_charged = total_character_charged


class SupportedFileFormats(_serialization.Model):
    """Base type for List return in our api.

    All required parameters must be populated in order to send to Azure.

    :ivar value: list of objects. Required.
    :vartype value: list[~azure.ai.translation.document.models.FileFormat]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FileFormat]"},
    }

    def __init__(self, *, value: List["_models.FileFormat"], **kwargs: Any) -> None:
        """
        :keyword value: list of objects. Required.
        :paramtype value: list[~azure.ai.translation.document.models.FileFormat]
        """
        super().__init__(**kwargs)
        self.value = value


class SupportedStorageSources(_serialization.Model):
    """Base type for List return in our api.

    All required parameters must be populated in order to send to Azure.

    :ivar value: list of objects. Required.
    :vartype value: list[str or ~azure.ai.translation.document.models.StorageSource]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, *, value: List[Union[str, "_models.StorageSource"]], **kwargs: Any) -> None:
        """
        :keyword value: list of objects. Required.
        :paramtype value: list[str or ~azure.ai.translation.document.models.StorageSource]
        """
        super().__init__(**kwargs)
        self.value = value


class TargetInput(_serialization.Model):
    """Destination for the finished translated documents.

    All required parameters must be populated in order to send to Azure.

    :ivar target_url: Location of the folder / container with your documents. Required.
    :vartype target_url: str
    :ivar category: Category / custom system for translation request.
    :vartype category: str
    :ivar language: Target Language. Required.
    :vartype language: str
    :ivar glossaries: List of Glossary.
    :vartype glossaries: list[~azure.ai.translation.document.models.Glossary]
    :ivar storage_source: Storage Source. "AzureBlob"
    :vartype storage_source: str or ~azure.ai.translation.document.models.StorageSource
    """

    _validation = {
        "target_url": {"required": True},
        "language": {"required": True},
    }

    _attribute_map = {
        "target_url": {"key": "targetUrl", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "language": {"key": "language", "type": "str"},
        "glossaries": {"key": "glossaries", "type": "[Glossary]"},
        "storage_source": {"key": "storageSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_url: str,
        language: str,
        category: Optional[str] = None,
        glossaries: Optional[List["_models.Glossary"]] = None,
        storage_source: Optional[Union[str, "_models.StorageSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_url: Location of the folder / container with your documents. Required.
        :paramtype target_url: str
        :keyword category: Category / custom system for translation request.
        :paramtype category: str
        :keyword language: Target Language. Required.
        :paramtype language: str
        :keyword glossaries: List of Glossary.
        :paramtype glossaries: list[~azure.ai.translation.document.models.Glossary]
        :keyword storage_source: Storage Source. "AzureBlob"
        :paramtype storage_source: str or ~azure.ai.translation.document.models.StorageSource
        """
        super().__init__(**kwargs)
        self.target_url = target_url
        self.category = category
        self.language = language
        self.glossaries = glossaries
        self.storage_source = storage_source


class TranslationError(_serialization.Model):
    """This contains an outer error with error code, message, details, target and an inner error with
    more descriptive details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Enums containing high level error codes. Required. Known values are:
     "InvalidRequest", "InvalidArgument", "InternalServerError", "ServiceUnavailable",
     "ResourceNotFound", "Unauthorized", and "RequestRateTooHigh".
    :vartype code: str or ~azure.ai.translation.document.models.TranslationErrorCode
    :ivar message: Gets high level error message. Required.
    :vartype message: str
    :ivar target: Gets the source of the error.
     For example it would be "documents" or "document id" in case of invalid document.
    :vartype target: str
    :ivar inner_error: New Inner Error format which conforms to Cognitive Services API Guidelines
     which is available at
     https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
     This contains required properties ErrorCode, message and optional properties target,
     details(key value pair), inner error(this can be nested).
    :vartype inner_error: ~azure.ai.translation.document.models.InnerTranslationError
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "inner_error": {"key": "innerError", "type": "InnerTranslationError"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.TranslationErrorCode"],
        message: str,
        inner_error: Optional["_models.InnerTranslationError"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Enums containing high level error codes. Required. Known values are:
         "InvalidRequest", "InvalidArgument", "InternalServerError", "ServiceUnavailable",
         "ResourceNotFound", "Unauthorized", and "RequestRateTooHigh".
        :paramtype code: str or ~azure.ai.translation.document.models.TranslationErrorCode
        :keyword message: Gets high level error message. Required.
        :paramtype message: str
        :keyword inner_error: New Inner Error format which conforms to Cognitive Services API
         Guidelines which is available at
         https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
         This contains required properties ErrorCode, message and optional properties target,
         details(key value pair), inner error(this can be nested).
        :paramtype inner_error: ~azure.ai.translation.document.models.InnerTranslationError
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.inner_error = inner_error


class TranslationErrorResponse(_serialization.Model):
    """Contains unified error information used for HTTP responses across any Cognitive Service.
    Instances
    can be created either through Microsoft.CloudAI.Containers.HttpStatusExceptionV2 or by
    returning it directly from
    a controller.

    :ivar error: This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details.
    :vartype error: ~azure.ai.translation.document.models.TranslationError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "TranslationError"},
    }

    def __init__(self, *, error: Optional["_models.TranslationError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: This contains an outer error with error code, message, details, target and an
         inner error with more descriptive details.
        :paramtype error: ~azure.ai.translation.document.models.TranslationError
        """
        super().__init__(**kwargs)
        self.error = error


class TranslationsStatus(_serialization.Model):
    """Translation job Status Response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The summary status of individual operation. Required.
    :vartype value: list[~azure.ai.translation.document.models.TranslationStatus]
    :ivar next_link: Url for the next page.  Null if no more pages available.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TranslationStatus]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.TranslationStatus"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The summary status of individual operation. Required.
        :paramtype value: list[~azure.ai.translation.document.models.TranslationStatus]
        :keyword next_link: Url for the next page.  Null if no more pages available.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TranslationStatus(_serialization.Model):
    """Translation job status response.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of the operation. Required.
    :vartype id: str
    :ivar created_date_time_utc: Operation created date time. Required.
    :vartype created_date_time_utc: ~datetime.datetime
    :ivar last_action_date_time_utc: Date time in which the operation's status has been updated.
     Required.
    :vartype last_action_date_time_utc: ~datetime.datetime
    :ivar status: List of possible statuses for job or document. Required. Known values are:
     "NotStarted", "Running", "Succeeded", "Failed", "Cancelled", "Cancelling", and
     "ValidationFailed".
    :vartype status: str or ~azure.ai.translation.document.models.Status
    :ivar error: This contains an outer error with error code, message, details, target and an
     inner error with more descriptive details.
    :vartype error: ~azure.ai.translation.document.models.TranslationError
    :ivar summary: Required.
    :vartype summary: ~azure.ai.translation.document.models.StatusSummary
    """

    _validation = {
        "id": {"required": True},
        "created_date_time_utc": {"required": True},
        "last_action_date_time_utc": {"required": True},
        "status": {"required": True},
        "summary": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "created_date_time_utc": {"key": "createdDateTimeUtc", "type": "iso-8601"},
        "last_action_date_time_utc": {"key": "lastActionDateTimeUtc", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "TranslationError"},
        "summary": {"key": "summary", "type": "StatusSummary"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        created_date_time_utc: datetime.datetime,
        last_action_date_time_utc: datetime.datetime,
        status: Union[str, "_models.Status"],
        summary: "_models.StatusSummary",
        error: Optional["_models.TranslationError"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the operation. Required.
        :paramtype id: str
        :keyword created_date_time_utc: Operation created date time. Required.
        :paramtype created_date_time_utc: ~datetime.datetime
        :keyword last_action_date_time_utc: Date time in which the operation's status has been updated.
         Required.
        :paramtype last_action_date_time_utc: ~datetime.datetime
        :keyword status: List of possible statuses for job or document. Required. Known values are:
         "NotStarted", "Running", "Succeeded", "Failed", "Cancelled", "Cancelling", and
         "ValidationFailed".
        :paramtype status: str or ~azure.ai.translation.document.models.Status
        :keyword error: This contains an outer error with error code, message, details, target and an
         inner error with more descriptive details.
        :paramtype error: ~azure.ai.translation.document.models.TranslationError
        :keyword summary: Required.
        :paramtype summary: ~azure.ai.translation.document.models.StatusSummary
        """
        super().__init__(**kwargs)
        self.id = id
        self.created_date_time_utc = created_date_time_utc
        self.last_action_date_time_utc = last_action_date_time_utc
        self.status = status
        self.error = error
        self.summary = summary
