# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CommunicationDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Direction of communication."""

    INBOUND = "inbound"
    OUTBOUND = "outbound"


class CommunicationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Communication type."""

    WEB = "web"
    PHONE = "phone"


class PreferredContactMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Preferred contact method."""

    EMAIL = "email"
    PHONE = "phone"


class SeverityLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value that indicates the urgency of the case, which in turn determines the response time
    according to the service level agreement of the technical support plan you have with Azure.
    Note: 'Highest critical impact', also known as the 'Emergency - Severe impact' level in the
    Azure portal is reserved only for our Premium customers.
    """

    MINIMAL = "minimal"
    MODERATE = "moderate"
    CRITICAL = "critical"
    HIGHESTCRITICALIMPACT = "highestcriticalimpact"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status to be updated on the ticket."""

    OPEN = "open"
    CLOSED = "closed"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of resource."""

    MICROSOFT_SUPPORT_SUPPORT_TICKETS = "Microsoft.Support/supportTickets"
    MICROSOFT_SUPPORT_COMMUNICATIONS = "Microsoft.Support/communications"
