# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ImportanceLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Importance level of the insight."""

    CRITICAL = "Critical"
    """A critical insight has been found after running the diagnostic."""
    WARNING = "Warning"
    """A warning insight has been found after running the diagnostic."""
    INFORMATION = "Information"
    """An information insight has been found after running the diagnostic."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of diagnostic provisioning."""

    SUCCEEDED = "Succeeded"
    """All Diagnostics in the Batch succeeded."""
    PARTIAL_COMPLETE = "PartialComplete"
    """Some Diagnostics are still running or failed."""
    FAILED = "Failed"
    """All Diagnostics failed to run."""
    CANCELED = "Canceled"
    """When Diagnostic request gets canceled."""


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Denotes the status of the diagnostic resource."""

    FAILED = "Failed"
    """Diagnostic creation failed."""
    MISSING_INPUTS = "MissingInputs"
    """Request is missing required inputs to run."""
    RUNNING = "Running"
    """Diagnostic is still running."""
    SUCCEEDED = "Succeeded"
    """Diagnostic creation succeeded."""
    TIMEOUT = "Timeout"
    """Diagnostic was timed out."""
