# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._record_sets_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_all_by_dns_zone_request,
    build_list_by_dns_zone_request,
    build_list_by_type_request,
    build_update_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class RecordSetsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.dns.v2023_07_01_preview.aio.DnsManagementClient`'s
        :attr:`record_sets` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @overload
    async def update(
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        parameters: _models.RecordSet,
        if_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RecordSet:
        """Updates a record set within a DNS zone.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param parameters: Parameters supplied to the Update operation. Required.
        :type parameters: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :param if_match: The etag of the record set. Omit this value to always overwrite the current
         record set. Specify the last-seen etag value to prevent accidentally overwriting concurrent
         changes. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecordSet or the result of cls(response)
        :rtype: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        parameters: IO,
        if_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RecordSet:
        """Updates a record set within a DNS zone.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param parameters: Parameters supplied to the Update operation. Required.
        :type parameters: IO
        :param if_match: The etag of the record set. Omit this value to always overwrite the current
         record set. Specify the last-seen etag value to prevent accidentally overwriting concurrent
         changes. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecordSet or the result of cls(response)
        :rtype: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        parameters: Union[_models.RecordSet, IO],
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.RecordSet:
        """Updates a record set within a DNS zone.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param parameters: Parameters supplied to the Update operation. Is either a RecordSet type or a
         IO type. Required.
        :type parameters: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet or IO
        :param if_match: The etag of the record set. Omit this value to always overwrite the current
         record set. Specify the last-seen etag value to prevent accidentally overwriting concurrent
         changes. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecordSet or the result of cls(response)
        :rtype: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2023-07-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RecordSet] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "RecordSet")

        request = build_update_request(
            resource_group_name=resource_group_name,
            zone_name=zone_name,
            relative_record_set_name=relative_record_set_name,
            record_type=record_type,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RecordSet", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}"
    }

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        parameters: _models.RecordSet,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RecordSet:
        """Creates or updates a record set within a DNS zone. Record sets of type SOA can be updated but
        not created (they are created when the DNS zone is created).

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param parameters: Parameters supplied to the CreateOrUpdate operation. Required.
        :type parameters: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :param if_match: The etag of the record set. Omit this value to always overwrite the current
         record set. Specify the last-seen etag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :param if_none_match: Set to '*' to allow a new record set to be created, but to prevent
         updating an existing record set. Other values will be ignored. Default value is None.
        :type if_none_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecordSet or the result of cls(response)
        :rtype: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        parameters: IO,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RecordSet:
        """Creates or updates a record set within a DNS zone. Record sets of type SOA can be updated but
        not created (they are created when the DNS zone is created).

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param parameters: Parameters supplied to the CreateOrUpdate operation. Required.
        :type parameters: IO
        :param if_match: The etag of the record set. Omit this value to always overwrite the current
         record set. Specify the last-seen etag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :param if_none_match: Set to '*' to allow a new record set to be created, but to prevent
         updating an existing record set. Other values will be ignored. Default value is None.
        :type if_none_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecordSet or the result of cls(response)
        :rtype: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        parameters: Union[_models.RecordSet, IO],
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.RecordSet:
        """Creates or updates a record set within a DNS zone. Record sets of type SOA can be updated but
        not created (they are created when the DNS zone is created).

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param parameters: Parameters supplied to the CreateOrUpdate operation. Is either a RecordSet
         type or a IO type. Required.
        :type parameters: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet or IO
        :param if_match: The etag of the record set. Omit this value to always overwrite the current
         record set. Specify the last-seen etag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :param if_none_match: Set to '*' to allow a new record set to be created, but to prevent
         updating an existing record set. Other values will be ignored. Default value is None.
        :type if_none_match: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecordSet or the result of cls(response)
        :rtype: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2023-07-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RecordSet] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "RecordSet")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            zone_name=zone_name,
            relative_record_set_name=relative_record_set_name,
            record_type=record_type,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            if_none_match=if_none_match,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("RecordSet", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RecordSet", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a record set from a DNS zone. This operation cannot be undone. Record sets of type SOA
        cannot be deleted (they are deleted when the DNS zone is deleted).

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param if_match: The etag of the record set. Omit this value to always delete the current
         record set. Specify the last-seen etag value to prevent accidentally deleting any concurrent
         changes. Default value is None.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2023-07-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            zone_name=zone_name,
            relative_record_set_name=relative_record_set_name,
            record_type=record_type,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}"
    }

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        zone_name: str,
        relative_record_set_name: str,
        record_type: Union[str, _models.RecordType],
        **kwargs: Any
    ) -> _models.RecordSet:
        """Gets a record set.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param relative_record_set_name: The name of the record set, relative to the name of the zone.
         Required.
        :type relative_record_set_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecordSet or the result of cls(response)
        :rtype: ~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2023-07-01-preview")
        )
        cls: ClsType[_models.RecordSet] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            zone_name=zone_name,
            relative_record_set_name=relative_record_set_name,
            record_type=record_type,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RecordSet", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}"
    }

    @distributed_trace
    def list_by_type(
        self,
        resource_group_name: str,
        zone_name: str,
        record_type: Union[str, _models.RecordType],
        top: Optional[int] = None,
        recordsetnamesuffix: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecordSet"]:
        """Lists the record sets of a specified type in a DNS zone.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param record_type: The type of DNS record in this record set. Known values are: "A", "AAAA",
         "CAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV", "TXT", "TLSA", "DS", and "NAPTR". Required.
        :type record_type: str or ~azure.mgmt.dns.v2023_07_01_preview.models.RecordType
        :param top: The maximum number of record sets to return. If not specified, returns up to 100
         record sets. Default value is None.
        :type top: int
        :param recordsetnamesuffix: The suffix label of the record set name that has to be used to
         filter the record set enumerations. If this parameter is specified, Enumeration will return
         only records that end with .:code:`<recordSetNameSuffix>`. Default value is None.
        :type recordsetnamesuffix: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecordSet or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2023-07-01-preview")
        )
        cls: ClsType[_models.RecordSetListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_type_request(
                    resource_group_name=resource_group_name,
                    zone_name=zone_name,
                    record_type=record_type,
                    subscription_id=self._config.subscription_id,
                    top=top,
                    recordsetnamesuffix=recordsetnamesuffix,
                    api_version=api_version,
                    template_url=self.list_by_type.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecordSetListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_type.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}"
    }

    @distributed_trace
    def list_by_dns_zone(
        self,
        resource_group_name: str,
        zone_name: str,
        top: Optional[int] = None,
        recordsetnamesuffix: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecordSet"]:
        """Lists all record sets in a DNS zone.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param top: The maximum number of record sets to return. If not specified, returns up to 100
         record sets. Default value is None.
        :type top: int
        :param recordsetnamesuffix: The suffix label of the record set name that has to be used to
         filter the record set enumerations. If this parameter is specified, Enumeration will return
         only records that end with .:code:`<recordSetNameSuffix>`. Default value is None.
        :type recordsetnamesuffix: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecordSet or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2023-07-01-preview")
        )
        cls: ClsType[_models.RecordSetListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_dns_zone_request(
                    resource_group_name=resource_group_name,
                    zone_name=zone_name,
                    subscription_id=self._config.subscription_id,
                    top=top,
                    recordsetnamesuffix=recordsetnamesuffix,
                    api_version=api_version,
                    template_url=self.list_by_dns_zone.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecordSetListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_dns_zone.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/recordsets"
    }

    @distributed_trace
    def list_all_by_dns_zone(
        self,
        resource_group_name: str,
        zone_name: str,
        top: Optional[int] = None,
        record_set_name_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecordSet"]:
        """Lists all record sets in a DNS zone.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param zone_name: The name of the DNS zone (without a terminating dot). Required.
        :type zone_name: str
        :param top: The maximum number of record sets to return. If not specified, returns up to 100
         record sets. Default value is None.
        :type top: int
        :param record_set_name_suffix: The suffix label of the record set name that has to be used to
         filter the record set enumerations. If this parameter is specified, Enumeration will return
         only records that end with .:code:`<recordSetNameSuffix>`. Default value is None.
        :type record_set_name_suffix: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecordSet or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dns.v2023_07_01_preview.models.RecordSet]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2023-07-01-preview")
        )
        cls: ClsType[_models.RecordSetListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_all_by_dns_zone_request(
                    resource_group_name=resource_group_name,
                    zone_name=zone_name,
                    subscription_id=self._config.subscription_id,
                    top=top,
                    record_set_name_suffix=record_set_name_suffix,
                    api_version=api_version,
                    template_url=self.list_all_by_dns_zone.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecordSetListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_all_by_dns_zone.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/all"
    }
