# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class DataContainer(_serialization.Model):
    """Information about a container with data for a given resource.

    All required parameters must be populated in order to send to Azure.

    :ivar workspace: Log Analytics workspace information. Required.
    :vartype workspace: ~azure.mgmt.monitor.v2018_11_27_preview.models.WorkspaceInfo
    """

    _validation = {
        "workspace": {"required": True},
    }

    _attribute_map = {
        "workspace": {"key": "workspace", "type": "WorkspaceInfo"},
    }

    def __init__(self, *, workspace: "_models.WorkspaceInfo", **kwargs: Any) -> None:
        """
        :keyword workspace: Log Analytics workspace information. Required.
        :paramtype workspace: ~azure.mgmt.monitor.v2018_11_27_preview.models.WorkspaceInfo
        """
        super().__init__(**kwargs)
        self.workspace = workspace


class Error(_serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Error code identifying the specific error. Required.
    :vartype code: str
    :ivar message: Error message in the caller's locale.
    :vartype message: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: str, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code identifying the specific error. Required.
        :paramtype code: str
        :keyword message: Error message in the caller's locale.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ProxyResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ResponseWithError(_serialization.Model):
    """An error response from the API.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Error information. Required.
    :vartype error: ~azure.mgmt.monitor.v2018_11_27_preview.models.Error
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, *, error: "_models.Error", **kwargs: Any) -> None:
        """
        :keyword error: Error information. Required.
        :paramtype error: ~azure.mgmt.monitor.v2018_11_27_preview.models.Error
        """
        super().__init__(**kwargs)
        self.error = error


class VMInsightsOnboardingStatus(ProxyResource):
    """VM Insights onboarding status for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar resource_id: Azure Resource Manager identifier of the resource whose onboarding status is
     being represented.
    :vartype resource_id: str
    :ivar onboarding_status: The onboarding status for the resource. Note that, a higher level
     scope, e.g., resource group or subscription, is considered onboarded if at least one resource
     under it is onboarded. Known values are: "onboarded", "notOnboarded", and "unknown".
    :vartype onboarding_status: str or
     ~azure.mgmt.monitor.v2018_11_27_preview.models.OnboardingStatus
    :ivar data_status: The status of VM Insights data from the resource. When reported as
     ``present`` the data array will contain information about the data containers to which data for
     the specified resource is being routed. Known values are: "present" and "notPresent".
    :vartype data_status: str or ~azure.mgmt.monitor.v2018_11_27_preview.models.DataStatus
    :ivar data: Containers that currently store VM Insights data for the specified resource.
    :vartype data: list[~azure.mgmt.monitor.v2018_11_27_preview.models.DataContainer]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "onboarding_status": {"key": "properties.onboardingStatus", "type": "str"},
        "data_status": {"key": "properties.dataStatus", "type": "str"},
        "data": {"key": "properties.data", "type": "[DataContainer]"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        onboarding_status: Optional[Union[str, "_models.OnboardingStatus"]] = None,
        data_status: Optional[Union[str, "_models.DataStatus"]] = None,
        data: Optional[List["_models.DataContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Azure Resource Manager identifier of the resource whose onboarding status
         is being represented.
        :paramtype resource_id: str
        :keyword onboarding_status: The onboarding status for the resource. Note that, a higher level
         scope, e.g., resource group or subscription, is considered onboarded if at least one resource
         under it is onboarded. Known values are: "onboarded", "notOnboarded", and "unknown".
        :paramtype onboarding_status: str or
         ~azure.mgmt.monitor.v2018_11_27_preview.models.OnboardingStatus
        :keyword data_status: The status of VM Insights data from the resource. When reported as
         ``present`` the data array will contain information about the data containers to which data for
         the specified resource is being routed. Known values are: "present" and "notPresent".
        :paramtype data_status: str or ~azure.mgmt.monitor.v2018_11_27_preview.models.DataStatus
        :keyword data: Containers that currently store VM Insights data for the specified resource.
        :paramtype data: list[~azure.mgmt.monitor.v2018_11_27_preview.models.DataContainer]
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.onboarding_status = onboarding_status
        self.data_status = data_status
        self.data = data


class WorkspaceInfo(_serialization.Model):
    """Information about a Log Analytics Workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure Resource Manager identifier of the Log Analytics Workspace. Required.
    :vartype id: str
    :ivar location: Location of the Log Analytics workspace. Required.
    :vartype location: str
    :ivar customer_id: Log Analytics workspace identifier. Required.
    :vartype customer_id: str
    """

    _validation = {
        "id": {"required": True},
        "location": {"required": True},
        "customer_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "customer_id": {"key": "properties.customerId", "type": "str"},
    }

    def __init__(
        self, *, id: str, location: str, customer_id: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Azure Resource Manager identifier of the Log Analytics Workspace. Required.
        :paramtype id: str
        :keyword location: Location of the Log Analytics workspace. Required.
        :paramtype location: str
        :keyword customer_id: Log Analytics workspace identifier. Required.
        :paramtype customer_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.location = location
        self.customer_id = customer_id
