# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.hdinsight import HDInsightManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hdinsight
# USAGE
    python create_hd_insight_cluster_with_autoscale_config.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HDInsightManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.clusters.begin_create(
        resource_group_name="rg1",
        cluster_name="cluster1",
        parameters={
            "properties": {
                "clusterDefinition": {
                    "componentVersion": {"Hadoop": "2.7"},
                    "configurations": {
                        "gateway": {
                            "restAuthCredential.isEnabled": True,
                            "restAuthCredential.password": "**********",
                            "restAuthCredential.username": "admin",
                        }
                    },
                    "kind": "hadoop",
                },
                "clusterVersion": "3.6",
                "computeProfile": {
                    "roles": [
                        {
                            "autoscale": {
                                "capacity": None,
                                "recurrence": {
                                    "schedule": [
                                        {
                                            "days": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
                                            "timeAndCapacity": {
                                                "maxInstanceCount": 3,
                                                "minInstanceCount": 3,
                                                "time": "09:00",
                                            },
                                        },
                                        {
                                            "days": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
                                            "timeAndCapacity": {
                                                "maxInstanceCount": 6,
                                                "minInstanceCount": 6,
                                                "time": "18:00",
                                            },
                                        },
                                        {
                                            "days": ["Saturday", "Sunday"],
                                            "timeAndCapacity": {
                                                "maxInstanceCount": 2,
                                                "minInstanceCount": 2,
                                                "time": "09:00",
                                            },
                                        },
                                        {
                                            "days": ["Saturday", "Sunday"],
                                            "timeAndCapacity": {
                                                "maxInstanceCount": 4,
                                                "minInstanceCount": 4,
                                                "time": "18:00",
                                            },
                                        },
                                    ],
                                    "timeZone": "China Standard Time",
                                },
                            },
                            "dataDisksGroups": None,
                            "hardwareProfile": {"vmSize": "Standard_D4_V2"},
                            "name": "workernode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "**********", "username": "sshuser"}
                            },
                            "scriptActions": [],
                            "targetInstanceCount": 4,
                            "virtualNetworkProfile": None,
                        }
                    ]
                },
                "osType": "Linux",
                "storageProfile": {
                    "storageaccounts": [
                        {
                            "container": "hdinsight-autoscale-tes-2019-06-18t05-49-16-591z",
                            "isDefault": True,
                            "key": "storagekey",
                            "name": "mystorage.blob.core.windows.net",
                        }
                    ]
                },
                "tier": "Standard",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/hdinsight/resource-manager/Microsoft.HDInsight/stable/2021-06-01/examples/CreateHDInsightClusterWithAutoscaleConfig.json
if __name__ == "__main__":
    main()
