# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of storage accessed on the storage account."""

    GENERAL_PURPOSE_STORAGE = "GeneralPurposeStorage"
    BLOB_STORAGE = "BlobStorage"


class AddonState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Addon Provisioning State."""

    INVALID = "Invalid"
    CREATING = "Creating"
    CREATED = "Created"
    UPDATING = "Updating"
    RECONFIGURING = "Reconfiguring"
    FAILED = "Failed"
    DELETING = "Deleting"


class AddonType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Addon type."""

    IOT_EDGE = "IotEdge"
    ARC_FOR_KUBERNETES = "ArcForKubernetes"


class AlertSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity of the alert."""

    INFORMATIONAL = "Informational"
    WARNING = "Warning"
    CRITICAL = "Critical"


class AuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The authentication type."""

    INVALID = "Invalid"
    AZURE_ACTIVE_DIRECTORY = "AzureActiveDirectory"


class AzureContainerDataFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage format used for the file represented by the share."""

    BLOCK_BLOB = "BlockBlob"
    PAGE_BLOB = "PageBlob"
    AZURE_FILE = "AzureFile"


class ClientPermissionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of access to be allowed for the client."""

    NO_ACCESS = "NoAccess"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"


class ContainerStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current status of the container."""

    OK = "OK"
    OFFLINE = "Offline"
    UNKNOWN = "Unknown"
    UPDATING = "Updating"
    NEEDS_ATTENTION = "NeedsAttention"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DataBoxEdgeDeviceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The etag for the devices."""

    AZURE_DATA_BOX_GATEWAY = "AzureDataBoxGateway"
    AZURE_STACK_EDGE = "AzureStackEdge"
    AZURE_STACK_HUB = "AzureStackHub"
    AZURE_MODULAR_DATA_CENTRE = "AzureModularDataCentre"


class DataBoxEdgeDeviceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the Data Box Edge/Gateway device."""

    READY_TO_SETUP = "ReadyToSetup"
    ONLINE = "Online"
    OFFLINE = "Offline"
    NEEDS_ATTENTION = "NeedsAttention"
    DISCONNECTED = "Disconnected"
    PARTIALLY_DISCONNECTED = "PartiallyDisconnected"
    MAINTENANCE = "Maintenance"


class DataPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data policy of the share."""

    CLOUD = "Cloud"
    LOCAL = "Local"


class DayOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DayOfWeek."""

    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"


class DeviceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the Data Box Edge/Gateway device."""

    DATA_BOX_EDGE_DEVICE = "DataBoxEdgeDevice"


class DownloadPhase(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The download phase."""

    UNKNOWN = "Unknown"
    INITIALIZING = "Initializing"
    DOWNLOADING = "Downloading"
    VERIFYING = "Verifying"


class EncryptionAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The algorithm used to encrypt "Value"."""

    NONE = "None"
    AES256 = "AES256"
    RSAES_PKCS1_V1_5 = "RSAES_PKCS1_v_1_5"


class HostPlatformType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Platform where the runtime is hosted."""

    KUBERNETES_CLUSTER = "KubernetesCluster"
    LINUX_VM = "LinuxVM"


class InstallRebootBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if updates are available and at least one of the updates needs a reboot."""

    NEVER_REBOOTS = "NeverReboots"
    REQUIRES_REBOOT = "RequiresReboot"
    REQUEST_REBOOT = "RequestReboot"


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the job."""

    INVALID = "Invalid"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PAUSED = "Paused"
    SCHEDULED = "Scheduled"


class JobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the job."""

    INVALID = "Invalid"
    SCAN_FOR_UPDATES = "ScanForUpdates"
    DOWNLOAD_UPDATES = "DownloadUpdates"
    INSTALL_UPDATES = "InstallUpdates"
    REFRESH_SHARE = "RefreshShare"
    REFRESH_CONTAINER = "RefreshContainer"
    BACKUP = "Backup"
    RESTORE = "Restore"
    TRIGGER_SUPPORT_PACKAGE = "TriggerSupportPackage"


class KubernetesNodeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Node type - Master/Worker."""

    INVALID = "Invalid"
    MASTER = "Master"
    WORKER = "Worker"


class KubernetesState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of Kubernetes deployment."""

    INVALID = "Invalid"
    CREATING = "Creating"
    CREATED = "Created"
    UPDATING = "Updating"
    RECONFIGURING = "Reconfiguring"
    FAILED = "Failed"
    DELETING = "Deleting"


class MetricAggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric aggregation type."""

    NOT_SPECIFIED = "NotSpecified"
    NONE = "None"
    AVERAGE = "Average"
    MINIMUM = "Minimum"
    MAXIMUM = "Maximum"
    TOTAL = "Total"
    COUNT = "Count"


class MetricCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric category."""

    CAPACITY = "Capacity"
    TRANSACTION = "Transaction"


class MetricUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric units."""

    NOT_SPECIFIED = "NotSpecified"
    PERCENT = "Percent"
    COUNT = "Count"
    SECONDS = "Seconds"
    MILLISECONDS = "Milliseconds"
    BYTES = "Bytes"
    BYTES_PER_SECOND = "BytesPerSecond"
    COUNT_PER_SECOND = "CountPerSecond"


class MonitoringStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current monitoring status of the share."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class MountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mounting type."""

    VOLUME = "Volume"
    HOST_PATH = "HostPath"


class MsiIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity type."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class NetworkAdapterDHCPStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Value indicating whether this adapter has DHCP enabled."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class NetworkAdapterRDMAStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Value indicating whether this adapter is RDMA capable."""

    INCAPABLE = "Incapable"
    CAPABLE = "Capable"


class NetworkAdapterStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Value indicating whether this adapter is valid."""

    INACTIVE = "Inactive"
    ACTIVE = "Active"


class NetworkGroup(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The network group."""

    NONE = "None"
    NON_RDMA = "NonRDMA"
    RDMA = "RDMA"


class NodeStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the individual node."""

    UNKNOWN = "Unknown"
    UP = "Up"
    DOWN = "Down"
    REBOOTING = "Rebooting"
    SHUTTING_DOWN = "ShuttingDown"


class OrderState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the order as per the allowed status types."""

    UNTRACKED = "Untracked"
    AWAITING_FULFILMENT = "AwaitingFulfilment"
    AWAITING_PREPARATION = "AwaitingPreparation"
    AWAITING_SHIPMENT = "AwaitingShipment"
    SHIPPED = "Shipped"
    ARRIVING = "Arriving"
    DELIVERED = "Delivered"
    REPLACEMENT_REQUESTED = "ReplacementRequested"
    LOST_DEVICE = "LostDevice"
    DECLINED = "Declined"
    RETURN_INITIATED = "ReturnInitiated"
    AWAITING_RETURN_SHIPMENT = "AwaitingReturnShipment"
    SHIPPED_BACK = "ShippedBack"
    COLLECTED_AT_MICROSOFT = "CollectedAtMicrosoft"
    AWAITING_PICKUP = "AwaitingPickup"
    PICKUP_COMPLETED = "PickupCompleted"
    AWAITING_DROP = "AwaitingDrop"


class PlatformType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Host OS supported by the Arc addon."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class PosixComplianceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If provisioned storage is posix compliant."""

    INVALID = "Invalid"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ResourceMoveStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Denotes whether move operation is in progress."""

    NONE = "None"
    RESOURCE_MOVE_IN_PROGRESS = "ResourceMoveInProgress"
    RESOURCE_MOVE_FAILED = "ResourceMoveFailed"


class RoleStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Local Edge Management Status."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class RoleTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RoleTypes."""

    IOT = "IOT"
    ASA = "ASA"
    FUNCTIONS = "Functions"
    COGNITIVE = "Cognitive"
    MEC = "MEC"
    CLOUD_EDGE_MANAGEMENT = "CloudEdgeManagement"
    KUBERNETES = "Kubernetes"


class ShareAccessProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Access protocol to be used by the share."""

    SMB = "SMB"
    NFS = "NFS"


class ShareAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of access to be allowed on the share for this user."""

    CHANGE = "Change"
    READ = "Read"
    CUSTOM = "Custom"


class ShareStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current status of the share."""

    OFFLINE = "Offline"
    UNKNOWN = "Unknown"
    OK = "OK"
    UPDATING = "Updating"
    NEEDS_ATTENTION = "NeedsAttention"


class ShipmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ShipmentType."""

    NOT_APPLICABLE = "NotApplicable"
    SHIPPED_TO_CUSTOMER = "ShippedToCustomer"
    SELF_PICKUP = "SelfPickup"


class SkuAvailability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Links to the next set of results."""

    AVAILABLE = "Available"
    UNAVAILABLE = "Unavailable"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Sku name."""

    GATEWAY = "Gateway"
    EDGE = "Edge"
    TEA1_NODE = "TEA_1Node"
    TEA1_NODE_UPS = "TEA_1Node_UPS"
    TEA1_NODE_HEATER = "TEA_1Node_Heater"
    TEA1_NODE_UPS_HEATER = "TEA_1Node_UPS_Heater"
    TEA4_NODE_HEATER = "TEA_4Node_Heater"
    TEA4_NODE_UPS_HEATER = "TEA_4Node_UPS_Heater"
    TMA = "TMA"
    TDC = "TDC"
    TCA_SMALL = "TCA_Small"
    GPU = "GPU"
    TCA_LARGE = "TCA_Large"
    EDGE_P_BASE = "EdgeP_Base"
    EDGE_P_HIGH = "EdgeP_High"
    EDGE_PR_BASE = "EdgePR_Base"
    EDGE_PR_BASE_UPS = "EdgePR_Base_UPS"
    EDGE_MR_MINI = "EdgeMR_Mini"
    RCA_SMALL = "RCA_Small"
    RCA_LARGE = "RCA_Large"
    RDC = "RDC"


class SkuSignupOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sku can be signed up by customer or not."""

    NONE = "None"
    AVAILABLE = "Available"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Sku tier."""

    STANDARD = "Standard"


class SkuVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Availability of the Sku as preview/stable."""

    STABLE = "Stable"
    PREVIEW = "Preview"


class SSLStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Signifies whether SSL needs to be enabled or not."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class StorageAccountStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current status of the storage account."""

    OK = "OK"
    OFFLINE = "Offline"
    UNKNOWN = "Unknown"
    UPDATING = "Updating"
    NEEDS_ATTENTION = "NeedsAttention"


class SubscriptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SubscriptionState."""

    REGISTERED = "Registered"
    WARNED = "Warned"
    SUSPENDED = "Suspended"
    DELETED = "Deleted"
    UNREGISTERED = "Unregistered"


class TimeGrain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TimeGrain."""

    PT1_M = "PT1M"
    PT5_M = "PT5M"
    PT15_M = "PT15M"
    PT30_M = "PT30M"
    PT1_H = "PT1H"
    PT6_H = "PT6H"
    PT12_H = "PT12H"
    PT1_D = "PT1D"


class TriggerEventType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Trigger Kind."""

    FILE_EVENT = "FileEvent"
    PERIODIC_TIMER_EVENT = "PeriodicTimerEvent"


class UpdateOperation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current update operation."""

    NONE = "None"
    SCAN = "Scan"
    DOWNLOAD = "Download"
    INSTALL = "Install"


class UpdateOperationStage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current stage of the update operation."""

    UNKNOWN = "Unknown"
    INITIAL = "Initial"
    SCAN_STARTED = "ScanStarted"
    SCAN_COMPLETE = "ScanComplete"
    SCAN_FAILED = "ScanFailed"
    DOWNLOAD_STARTED = "DownloadStarted"
    DOWNLOAD_COMPLETE = "DownloadComplete"
    DOWNLOAD_FAILED = "DownloadFailed"
    INSTALL_STARTED = "InstallStarted"
    INSTALL_COMPLETE = "InstallComplete"
    INSTALL_FAILED = "InstallFailed"
    REBOOT_INITIATED = "RebootInitiated"
    SUCCESS = "Success"
    FAILURE = "Failure"
    RESCAN_STARTED = "RescanStarted"
    RESCAN_COMPLETE = "RescanComplete"
    RESCAN_FAILED = "RescanFailed"


class UserType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the user."""

    SHARE = "Share"
    LOCAL_MANAGEMENT = "LocalManagement"
    ARM = "ARM"
