# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class BaseImageDependency(_serialization.Model):
    """Properties that describe a base image dependency.

    :ivar type: The type of the base image dependency. Known values are: "BuildTime" and "RunTime".
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageDependencyType
    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "registry": {"key": "registry", "type": "str"},
        "repository": {"key": "repository", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "digest": {"key": "digest", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.BaseImageDependencyType"]] = None,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the base image dependency. Known values are: "BuildTime" and
         "RunTime".
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageDependencyType
        :keyword registry: The registry login server.
        :paramtype registry: str
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword digest: The sha256-based digest of the image manifest.
        :paramtype digest: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class ProxyResource(_serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than
    required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Build(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Build resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar build_id: The unique identifier for the build.
    :vartype build_id: str
    :ivar status: The current status of the build. Known values are: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
    :vartype status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStatus
    :ivar last_updated_time: The last updated time for the build.
    :vartype last_updated_time: ~datetime.datetime
    :ivar build_type: The type of build. Known values are: "AutoBuild" and "QuickBuild".
    :vartype build_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildType
    :ivar create_time: The time the build was created.
    :vartype create_time: ~datetime.datetime
    :ivar start_time: The time the build started.
    :vartype start_time: ~datetime.datetime
    :ivar finish_time: The time the build finished.
    :vartype finish_time: ~datetime.datetime
    :ivar output_images: The list of all images that were generated from the build.
    :vartype output_images:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageDescriptor]
    :ivar build_task: The build task with which the build was started.
    :vartype build_task: str
    :ivar image_update_trigger: The image update trigger that caused the build.
    :vartype image_update_trigger:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageUpdateTrigger
    :ivar git_commit_trigger: The git commit trigger that caused the build.
    :vartype git_commit_trigger:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.GitCommitTrigger
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    :ivar platform: The platform properties against which the build will happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :ivar provisioning_state: The provisioning state of a build. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "build_id": {"key": "properties.buildId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "build_type": {"key": "properties.buildType", "type": "str"},
        "create_time": {"key": "properties.createTime", "type": "iso-8601"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "finish_time": {"key": "properties.finishTime", "type": "iso-8601"},
        "output_images": {"key": "properties.outputImages", "type": "[ImageDescriptor]"},
        "build_task": {"key": "properties.buildTask", "type": "str"},
        "image_update_trigger": {"key": "properties.imageUpdateTrigger", "type": "ImageUpdateTrigger"},
        "git_commit_trigger": {"key": "properties.gitCommitTrigger", "type": "GitCommitTrigger"},
        "is_archive_enabled": {"key": "properties.isArchiveEnabled", "type": "bool"},
        "platform": {"key": "properties.platform", "type": "PlatformProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        build_id: Optional[str] = None,
        status: Optional[Union[str, "_models.BuildStatus"]] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        build_type: Optional[Union[str, "_models.BuildType"]] = None,
        create_time: Optional[datetime.datetime] = None,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_images: Optional[List["_models.ImageDescriptor"]] = None,
        build_task: Optional[str] = None,
        image_update_trigger: Optional["_models.ImageUpdateTrigger"] = None,
        git_commit_trigger: Optional["_models.GitCommitTrigger"] = None,
        is_archive_enabled: bool = False,
        platform: Optional["_models.PlatformProperties"] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword build_id: The unique identifier for the build.
        :paramtype build_id: str
        :keyword status: The current status of the build. Known values are: "Queued", "Started",
         "Running", "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStatus
        :keyword last_updated_time: The last updated time for the build.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword build_type: The type of build. Known values are: "AutoBuild" and "QuickBuild".
        :paramtype build_type: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildType
        :keyword create_time: The time the build was created.
        :paramtype create_time: ~datetime.datetime
        :keyword start_time: The time the build started.
        :paramtype start_time: ~datetime.datetime
        :keyword finish_time: The time the build finished.
        :paramtype finish_time: ~datetime.datetime
        :keyword output_images: The list of all images that were generated from the build.
        :paramtype output_images:
         list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageDescriptor]
        :keyword build_task: The build task with which the build was started.
        :paramtype build_task: str
        :keyword image_update_trigger: The image update trigger that caused the build.
        :paramtype image_update_trigger:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageUpdateTrigger
        :keyword git_commit_trigger: The git commit trigger that caused the build.
        :paramtype git_commit_trigger:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.GitCommitTrigger
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        :keyword platform: The platform properties against which the build will happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
        :keyword provisioning_state: The provisioning state of a build. Known values are: "Creating",
         "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.build_id = build_id
        self.status = status
        self.last_updated_time = last_updated_time
        self.build_type = build_type
        self.create_time = create_time
        self.start_time = start_time
        self.finish_time = finish_time
        self.output_images = output_images
        self.build_task = build_task
        self.image_update_trigger = image_update_trigger
        self.git_commit_trigger = git_commit_trigger
        self.is_archive_enabled = is_archive_enabled
        self.platform = platform
        self.provisioning_state = provisioning_state


class BuildArgument(_serialization.Model):
    """Properties of a build argument.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the argument. Required. "DockerBuildArgument"
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgumentType
    :ivar name: The name of the argument. Required.
    :vartype name: str
    :ivar value: The value of the argument. Required.
    :vartype value: str
    :ivar is_secret: Flag to indicate whether the argument represents a secret and want to be
     removed from build logs.
    :vartype is_secret: bool
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "is_secret": {"key": "isSecret", "type": "bool"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.BuildArgumentType"],
        name: str,
        value: str,
        is_secret: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the argument. Required. "DockerBuildArgument"
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgumentType
        :keyword name: The name of the argument. Required.
        :paramtype name: str
        :keyword value: The value of the argument. Required.
        :paramtype value: str
        :keyword is_secret: Flag to indicate whether the argument represents a secret and want to be
         removed from build logs.
        :paramtype is_secret: bool
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name
        self.value = value
        self.is_secret = is_secret


class BuildArgumentList(_serialization.Model):
    """The list of build arguments for a build step.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildArgument]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BuildArgument"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildFilter(_serialization.Model):
    """Properties that are enabled for Odata querying.

    :ivar build_id: The unique identifier for the build.
    :vartype build_id: str
    :ivar build_type: The type of build. Known values are: "AutoBuild" and "QuickBuild".
    :vartype build_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildType
    :ivar status: The current status of the build. Known values are: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
    :vartype status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStatus
    :ivar create_time: The create time for a build.
    :vartype create_time: ~datetime.datetime
    :ivar finish_time: The time the build finished.
    :vartype finish_time: ~datetime.datetime
    :ivar output_image_manifests: The list of comma-separated image manifests that were generated
     from the build.
    :vartype output_image_manifests: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    :ivar build_task_name: The name of the build task that the build corresponds to.
    :vartype build_task_name: str
    """

    _attribute_map = {
        "build_id": {"key": "buildId", "type": "str"},
        "build_type": {"key": "buildType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "create_time": {"key": "createTime", "type": "iso-8601"},
        "finish_time": {"key": "finishTime", "type": "iso-8601"},
        "output_image_manifests": {"key": "outputImageManifests", "type": "str"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "build_task_name": {"key": "buildTaskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        build_id: Optional[str] = None,
        build_type: Optional[Union[str, "_models.BuildType"]] = None,
        status: Optional[Union[str, "_models.BuildStatus"]] = None,
        create_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_image_manifests: Optional[str] = None,
        is_archive_enabled: Optional[bool] = None,
        build_task_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword build_id: The unique identifier for the build.
        :paramtype build_id: str
        :keyword build_type: The type of build. Known values are: "AutoBuild" and "QuickBuild".
        :paramtype build_type: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildType
        :keyword status: The current status of the build. Known values are: "Queued", "Started",
         "Running", "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStatus
        :keyword create_time: The create time for a build.
        :paramtype create_time: ~datetime.datetime
        :keyword finish_time: The time the build finished.
        :paramtype finish_time: ~datetime.datetime
        :keyword output_image_manifests: The list of comma-separated image manifests that were
         generated from the build.
        :paramtype output_image_manifests: str
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        :keyword build_task_name: The name of the build task that the build corresponds to.
        :paramtype build_task_name: str
        """
        super().__init__(**kwargs)
        self.build_id = build_id
        self.build_type = build_type
        self.status = status
        self.create_time = create_time
        self.finish_time = finish_time
        self.output_image_manifests = output_image_manifests
        self.is_archive_enabled = is_archive_enabled
        self.build_task_name = build_task_name


class BuildGetLogResult(_serialization.Model):
    """The result of get log link operation.

    :ivar log_link: The link to logs for a azure container registry build.
    :vartype log_link: str
    """

    _attribute_map = {
        "log_link": {"key": "logLink", "type": "str"},
    }

    def __init__(self, *, log_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword log_link: The link to logs for a azure container registry build.
        :paramtype log_link: str
        """
        super().__init__(**kwargs)
        self.log_link = log_link


class BuildListResult(_serialization.Model):
    """Collection of builds.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.Build]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Build]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Build"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.Build]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildStep(ProxyResource):
    """Build step resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: The properties of a build step.
    :vartype properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "BuildStepProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BuildStepProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a build step.
        :paramtype properties:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BuildStepList(_serialization.Model):
    """The collection of build items.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStep]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildStep]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BuildStep"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStep]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildStepProperties(_serialization.Model):
    """Base properties for any build step.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildStep

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The provisioning state of the build step. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    :ivar type: The type of the step. Required. "Docker"
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "type": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"Docker": "DockerBuildStep"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.type: Optional[str] = None


class BuildStepPropertiesUpdateParameters(_serialization.Model):
    """The properties for updating a build step.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildStepUpdateParameters

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the step. Required. "Docker"
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    """

    _validation = {
        "type": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"Docker": "DockerBuildStepUpdateParameters"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class BuildStepUpdateParameters(_serialization.Model):
    """The parameters for updating a build step.

    :ivar properties: The properties for updating a build step.
    :vartype properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepPropertiesUpdateParameters
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "BuildStepPropertiesUpdateParameters"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.BuildStepPropertiesUpdateParameters"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The properties for updating a build step.
        :paramtype properties:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepPropertiesUpdateParameters
        :keyword tags: The ARM resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class Resource(_serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class BuildTask(Resource):  # pylint: disable=too-many-instance-attributes
    """The build task that has the resource properties and all build items. The build task will have
    all information to schedule a build against it.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the build task. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    :ivar creation_date: The creation date of build task.
    :vartype creation_date: ~datetime.datetime
    :ivar alias: The alternative updatable name for a build task.
    :vartype alias: str
    :ivar status: The current status of build task. Known values are: "Disabled" and "Enabled".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTaskStatus
    :ivar source_repository: The properties that describes the source(code) for the build task.
    :vartype source_repository:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceRepositoryProperties
    :ivar platform: The platform properties against which the build has to happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :ivar timeout: Build timeout in seconds.
    :vartype timeout: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "creation_date": {"readonly": True},
        "timeout": {"maximum": 28800, "minimum": 300},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "alias": {"key": "properties.alias", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "source_repository": {"key": "properties.sourceRepository", "type": "SourceRepositoryProperties"},
        "platform": {"key": "properties.platform", "type": "PlatformProperties"},
        "timeout": {"key": "properties.timeout", "type": "int"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        alias: Optional[str] = None,
        status: Optional[Union[str, "_models.BuildTaskStatus"]] = None,
        source_repository: Optional["_models.SourceRepositoryProperties"] = None,
        platform: Optional["_models.PlatformProperties"] = None,
        timeout: int = 3600,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword alias: The alternative updatable name for a build task.
        :paramtype alias: str
        :keyword status: The current status of build task. Known values are: "Disabled" and "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTaskStatus
        :keyword source_repository: The properties that describes the source(code) for the build task.
        :paramtype source_repository:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceRepositoryProperties
        :keyword platform: The platform properties against which the build has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
        :keyword timeout: Build timeout in seconds.
        :paramtype timeout: int
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.creation_date = None
        self.alias = alias
        self.status = status
        self.source_repository = source_repository
        self.platform = platform
        self.timeout = timeout


class QueueBuildRequest(_serialization.Model):
    """The queue build request parameters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BuildTaskBuildRequest, QuickBuildRequest

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the build request. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"BuildTask": "BuildTaskBuildRequest", "QuickBuild": "QuickBuildRequest"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class BuildTaskBuildRequest(QueueBuildRequest):
    """The queue build parameters based on a build task.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the build request. Required.
    :vartype type: str
    :ivar build_task_name: The name of build task against which build has to be queued. Required.
    :vartype build_task_name: str
    """

    _validation = {
        "type": {"required": True, "readonly": True},
        "build_task_name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "build_task_name": {"key": "buildTaskName", "type": "str"},
    }

    def __init__(self, *, build_task_name: str, **kwargs: Any) -> None:
        """
        :keyword build_task_name: The name of build task against which build has to be queued.
         Required.
        :paramtype build_task_name: str
        """
        super().__init__(**kwargs)
        self.type: str = "BuildTask"
        self.build_task_name = build_task_name


class BuildTaskFilter(_serialization.Model):
    """The filter that can be used for listing build tasks.

    :ivar alias: The alternative name for build task.
    :vartype alias: str
    """

    _attribute_map = {
        "alias": {"key": "alias", "type": "str"},
    }

    def __init__(self, *, alias: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword alias: The alternative name for build task.
        :paramtype alias: str
        """
        super().__init__(**kwargs)
        self.alias = alias


class BuildTaskListResult(_serialization.Model):
    """The collection of build tasks.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTask]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildTask]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BuildTask"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTask]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildTaskUpdateParameters(_serialization.Model):
    """The parameters for updating a build task.

    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar alias: The alternative updatable name for a build task.
    :vartype alias: str
    :ivar status: The current status of build task. Known values are: "Disabled" and "Enabled".
    :vartype status: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTaskStatus
    :ivar platform: The platform properties against which the build has to happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :ivar timeout: Build timeout in seconds.
    :vartype timeout: int
    :ivar source_repository: The properties that describes the source(code) for the build task.
    :vartype source_repository:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceRepositoryUpdateParameters
    """

    _validation = {
        "timeout": {"maximum": 28800, "minimum": 300},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "alias": {"key": "properties.alias", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "platform": {"key": "properties.platform", "type": "PlatformProperties"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "source_repository": {"key": "properties.sourceRepository", "type": "SourceRepositoryUpdateParameters"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        alias: Optional[str] = None,
        status: Optional[Union[str, "_models.BuildTaskStatus"]] = None,
        platform: Optional["_models.PlatformProperties"] = None,
        timeout: Optional[int] = None,
        source_repository: Optional["_models.SourceRepositoryUpdateParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword alias: The alternative updatable name for a build task.
        :paramtype alias: str
        :keyword status: The current status of build task. Known values are: "Disabled" and "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTaskStatus
        :keyword platform: The platform properties against which the build has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
        :keyword timeout: Build timeout in seconds.
        :paramtype timeout: int
        :keyword source_repository: The properties that describes the source(code) for the build task.
        :paramtype source_repository:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceRepositoryUpdateParameters
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.alias = alias
        self.status = status
        self.platform = platform
        self.timeout = timeout
        self.source_repository = source_repository


class BuildUpdateParameters(_serialization.Model):
    """The set of build properties that can be updated.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    """

    _attribute_map = {
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
    }

    def __init__(self, *, is_archive_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_archive_enabled = is_archive_enabled


class DockerBuildStep(BuildStepProperties):  # pylint: disable=too-many-instance-attributes
    """The Docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The provisioning state of the build step. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.ProvisioningState
    :ivar type: The type of the step. Required. "Docker"
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    :ivar branch: The repository branch name.
    :vartype branch: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source control root.
    :vartype docker_file_path: str
    :ivar context_path: The relative context path for a docker build in the source.
    :vartype context_path: str
    :ivar build_arguments: The custom arguments for building this build step.
    :vartype build_arguments:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageDependency]
    :ivar base_image_trigger: The type of the auto trigger for base image dependency updates. Known
     values are: "All", "Runtime", and "None".
    :vartype base_image_trigger: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageTriggerType
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "type": {"required": True, "readonly": True},
        "base_image_dependencies": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "branch": {"key": "branch", "type": "str"},
        "image_names": {"key": "imageNames", "type": "[str]"},
        "is_push_enabled": {"key": "isPushEnabled", "type": "bool"},
        "no_cache": {"key": "noCache", "type": "bool"},
        "docker_file_path": {"key": "dockerFilePath", "type": "str"},
        "context_path": {"key": "contextPath", "type": "str"},
        "build_arguments": {"key": "buildArguments", "type": "[BuildArgument]"},
        "base_image_dependencies": {"key": "baseImageDependencies", "type": "[BaseImageDependency]"},
        "base_image_trigger": {"key": "baseImageTrigger", "type": "str"},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: bool = True,
        no_cache: bool = False,
        docker_file_path: Optional[str] = None,
        context_path: Optional[str] = None,
        build_arguments: Optional[List["_models.BuildArgument"]] = None,
        base_image_trigger: Optional[Union[str, "_models.BaseImageTriggerType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword branch: The repository branch name.
        :paramtype branch: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: The Docker file path relative to the source control root.
        :paramtype docker_file_path: str
        :keyword context_path: The relative context path for a docker build in the source.
        :paramtype context_path: str
        :keyword build_arguments: The custom arguments for building this build step.
        :paramtype build_arguments:
         list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
        :keyword base_image_trigger: The type of the auto trigger for base image dependency updates.
         Known values are: "All", "Runtime", and "None".
        :paramtype base_image_trigger: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageTriggerType
        """
        super().__init__(**kwargs)
        self.type: str = "Docker"
        self.branch = branch
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.context_path = context_path
        self.build_arguments = build_arguments
        self.base_image_dependencies = None
        self.base_image_trigger = base_image_trigger


class DockerBuildStepUpdateParameters(BuildStepPropertiesUpdateParameters):
    """The properties for updating a docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the step. Required. "Docker"
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildStepType
    :ivar branch: The repository branch name.
    :vartype branch: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source control root.
    :vartype docker_file_path: str
    :ivar context_path: The relative context path for a docker build in the source.
    :vartype context_path: str
    :ivar build_arguments: The custom arguments for building this build step.
    :vartype build_arguments:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :ivar base_image_trigger: The type of the auto trigger for base image dependency updates. Known
     values are: "All", "Runtime", and "None".
    :vartype base_image_trigger: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageTriggerType
    """

    _validation = {
        "type": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "branch": {"key": "branch", "type": "str"},
        "image_names": {"key": "imageNames", "type": "[str]"},
        "is_push_enabled": {"key": "isPushEnabled", "type": "bool"},
        "no_cache": {"key": "noCache", "type": "bool"},
        "docker_file_path": {"key": "dockerFilePath", "type": "str"},
        "context_path": {"key": "contextPath", "type": "str"},
        "build_arguments": {"key": "buildArguments", "type": "[BuildArgument]"},
        "base_image_trigger": {"key": "baseImageTrigger", "type": "str"},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: Optional[bool] = None,
        no_cache: Optional[bool] = None,
        docker_file_path: Optional[str] = None,
        context_path: Optional[str] = None,
        build_arguments: Optional[List["_models.BuildArgument"]] = None,
        base_image_trigger: Optional[Union[str, "_models.BaseImageTriggerType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword branch: The repository branch name.
        :paramtype branch: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: The Docker file path relative to the source control root.
        :paramtype docker_file_path: str
        :keyword context_path: The relative context path for a docker build in the source.
        :paramtype context_path: str
        :keyword build_arguments: The custom arguments for building this build step.
        :paramtype build_arguments:
         list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
        :keyword base_image_trigger: The type of the auto trigger for base image dependency updates.
         Known values are: "All", "Runtime", and "None".
        :paramtype base_image_trigger: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BaseImageTriggerType
        """
        super().__init__(**kwargs)
        self.type: str = "Docker"
        self.branch = branch
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.context_path = context_path
        self.build_arguments = build_arguments
        self.base_image_trigger = base_image_trigger


class GitCommitTrigger(_serialization.Model):
    """The git commit trigger that caused a build.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar commit_id: The unique ID that identifies a commit.
    :vartype commit_id: str
    :ivar repository_url: The repository URL.
    :vartype repository_url: str
    :ivar branch_name: The branch name in the repository.
    :vartype branch_name: str
    :ivar provider_type: The source control provider type.
    :vartype provider_type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_id": {"key": "commitId", "type": "str"},
        "repository_url": {"key": "repositoryUrl", "type": "str"},
        "branch_name": {"key": "branchName", "type": "str"},
        "provider_type": {"key": "providerType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_id: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch_name: Optional[str] = None,
        provider_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The unique ID of the trigger.
        :paramtype id: str
        :keyword commit_id: The unique ID that identifies a commit.
        :paramtype commit_id: str
        :keyword repository_url: The repository URL.
        :paramtype repository_url: str
        :keyword branch_name: The branch name in the repository.
        :paramtype branch_name: str
        :keyword provider_type: The source control provider type.
        :paramtype provider_type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.commit_id = commit_id
        self.repository_url = repository_url
        self.branch_name = branch_name
        self.provider_type = provider_type


class ImageDescriptor(_serialization.Model):
    """Properties for a registry image.

    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    _attribute_map = {
        "registry": {"key": "registry", "type": "str"},
        "repository": {"key": "repository", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "digest": {"key": "digest", "type": "str"},
    }

    def __init__(
        self,
        *,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword registry: The registry login server.
        :paramtype registry: str
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword digest: The sha256-based digest of the image manifest.
        :paramtype digest: str
        """
        super().__init__(**kwargs)
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class ImageUpdateTrigger(_serialization.Model):
    """The image update trigger that caused a build.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar timestamp: The timestamp when the image update happened.
    :vartype timestamp: ~datetime.datetime
    :ivar images: The list of image updates that caused the build.
    :vartype images: list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageDescriptor]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "images": {"key": "images", "type": "[ImageDescriptor]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        timestamp: Optional[datetime.datetime] = None,
        images: Optional[List["_models.ImageDescriptor"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The unique ID of the trigger.
        :paramtype id: str
        :keyword timestamp: The timestamp when the image update happened.
        :paramtype timestamp: ~datetime.datetime
        :keyword images: The list of image updates that caused the build.
        :paramtype images:
         list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.ImageDescriptor]
        """
        super().__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.images = images


class PlatformProperties(_serialization.Model):
    """The platform properties against which the build has to happen.

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: The operating system type required for the build. Required. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.OsType
    :ivar cpu: The CPU configuration in terms of number of cores required for the build.
    :vartype cpu: int
    """

    _validation = {
        "os_type": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "cpu": {"key": "cpu", "type": "int"},
    }

    def __init__(self, *, os_type: Union[str, "_models.OsType"], cpu: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword os_type: The operating system type required for the build. Required. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.OsType
        :keyword cpu: The CPU configuration in terms of number of cores required for the build.
        :paramtype cpu: int
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.cpu = cpu


class QuickBuildRequest(QueueBuildRequest):
    """The queue build request parameters for a quick build.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the build request. Required.
    :vartype type: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar source_location: The URL(absolute or relative) of the source that needs to be built. For
     Docker build, it can be an URL to a tar or github repository as supported by Docker.
     If it is relative URL, the relative path should be obtained from calling getSourceUploadUrl
     API. Required.
    :vartype source_location: str
    :ivar build_arguments: The collection of build arguments to be used.
    :vartype build_arguments:
     list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar timeout: Build timeout in seconds.
    :vartype timeout: int
    :ivar platform: The platform properties against which the build will happen. Required.
    :vartype platform: ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :ivar docker_file_path: The Docker file path relative to the source location. Required.
    :vartype docker_file_path: str
    """

    _validation = {
        "type": {"required": True, "readonly": True},
        "source_location": {"required": True},
        "timeout": {"maximum": 28800, "minimum": 300},
        "platform": {"required": True},
        "docker_file_path": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "image_names": {"key": "imageNames", "type": "[str]"},
        "source_location": {"key": "sourceLocation", "type": "str"},
        "build_arguments": {"key": "buildArguments", "type": "[BuildArgument]"},
        "is_push_enabled": {"key": "isPushEnabled", "type": "bool"},
        "no_cache": {"key": "noCache", "type": "bool"},
        "timeout": {"key": "timeout", "type": "int"},
        "platform": {"key": "platform", "type": "PlatformProperties"},
        "docker_file_path": {"key": "dockerFilePath", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_location: str,
        platform: "_models.PlatformProperties",
        docker_file_path: str,
        image_names: Optional[List[str]] = None,
        build_arguments: Optional[List["_models.BuildArgument"]] = None,
        is_push_enabled: bool = True,
        no_cache: bool = False,
        timeout: int = 3600,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword source_location: The URL(absolute or relative) of the source that needs to be built.
         For Docker build, it can be an URL to a tar or github repository as supported by Docker.
         If it is relative URL, the relative path should be obtained from calling getSourceUploadUrl
         API. Required.
        :paramtype source_location: str
        :keyword build_arguments: The collection of build arguments to be used.
        :paramtype build_arguments:
         list[~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildArgument]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword timeout: Build timeout in seconds.
        :paramtype timeout: int
        :keyword platform: The platform properties against which the build will happen. Required.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
        :keyword docker_file_path: The Docker file path relative to the source location. Required.
        :paramtype docker_file_path: str
        """
        super().__init__(**kwargs)
        self.type: str = "QuickBuild"
        self.image_names = image_names
        self.source_location = source_location
        self.build_arguments = build_arguments
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.timeout = timeout
        self.platform = platform
        self.docker_file_path = docker_file_path


class SourceControlAuthInfo(_serialization.Model):
    """The authorization properties for accessing the source code repository.

    All required parameters must be populated in order to send to Azure.

    :ivar token_type: The type of Auth token. Known values are: "PAT" and "OAuth".
    :vartype token_type: str or ~azure.mgmt.containerregistry.v2018_02_01_preview.models.TokenType
    :ivar token: The access token used to access the source control provider. Required.
    :vartype token: str
    :ivar refresh_token: The refresh token used to refresh the access token.
    :vartype refresh_token: str
    :ivar scope: The scope of the access token.
    :vartype scope: str
    :ivar expires_in: Time in seconds that the token remains valid.
    :vartype expires_in: int
    """

    _validation = {
        "token": {"required": True},
    }

    _attribute_map = {
        "token_type": {"key": "tokenType", "type": "str"},
        "token": {"key": "token", "type": "str"},
        "refresh_token": {"key": "refreshToken", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "expires_in": {"key": "expiresIn", "type": "int"},
    }

    def __init__(
        self,
        *,
        token: str,
        token_type: Optional[Union[str, "_models.TokenType"]] = None,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword token_type: The type of Auth token. Known values are: "PAT" and "OAuth".
        :paramtype token_type: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.TokenType
        :keyword token: The access token used to access the source control provider. Required.
        :paramtype token: str
        :keyword refresh_token: The refresh token used to refresh the access token.
        :paramtype refresh_token: str
        :keyword scope: The scope of the access token.
        :paramtype scope: str
        :keyword expires_in: Time in seconds that the token remains valid.
        :paramtype expires_in: int
        """
        super().__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class SourceRepositoryProperties(_serialization.Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to Azure.

    :ivar source_control_type: The type of source control service. Required. Known values are:
     "Github" and "VisualStudioTeamService".
    :vartype source_control_type: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlType
    :ivar repository_url: The full URL to the source code repository. Required.
    :vartype repository_url: str
    :ivar is_commit_trigger_enabled: The value of this property indicates whether the source
     control commit trigger is enabled or not.
    :vartype is_commit_trigger_enabled: bool
    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository.
    :vartype source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlAuthInfo
    """

    _validation = {
        "source_control_type": {"required": True},
        "repository_url": {"required": True},
    }

    _attribute_map = {
        "source_control_type": {"key": "sourceControlType", "type": "str"},
        "repository_url": {"key": "repositoryUrl", "type": "str"},
        "is_commit_trigger_enabled": {"key": "isCommitTriggerEnabled", "type": "bool"},
        "source_control_auth_properties": {"key": "sourceControlAuthProperties", "type": "SourceControlAuthInfo"},
    }

    def __init__(
        self,
        *,
        source_control_type: Union[str, "_models.SourceControlType"],
        repository_url: str,
        is_commit_trigger_enabled: bool = False,
        source_control_auth_properties: Optional["_models.SourceControlAuthInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_control_type: The type of source control service. Required. Known values are:
         "Github" and "VisualStudioTeamService".
        :paramtype source_control_type: str or
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlType
        :keyword repository_url: The full URL to the source code repository. Required.
        :paramtype repository_url: str
        :keyword is_commit_trigger_enabled: The value of this property indicates whether the source
         control commit trigger is enabled or not.
        :paramtype is_commit_trigger_enabled: bool
        :keyword source_control_auth_properties: The authorization properties for accessing the source
         code repository.
        :paramtype source_control_auth_properties:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlAuthInfo
        """
        super().__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.is_commit_trigger_enabled = is_commit_trigger_enabled
        self.source_control_auth_properties = source_control_auth_properties


class SourceRepositoryUpdateParameters(_serialization.Model):
    """The properties for updating the source code repository configuration.

    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository.
    :vartype source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlAuthInfo
    :ivar is_commit_trigger_enabled: The value of this property indicates whether the source
     control commit trigger is enabled or not.
    :vartype is_commit_trigger_enabled: bool
    """

    _attribute_map = {
        "source_control_auth_properties": {"key": "sourceControlAuthProperties", "type": "SourceControlAuthInfo"},
        "is_commit_trigger_enabled": {"key": "isCommitTriggerEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        source_control_auth_properties: Optional["_models.SourceControlAuthInfo"] = None,
        is_commit_trigger_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_control_auth_properties: The authorization properties for accessing the source
         code repository.
        :paramtype source_control_auth_properties:
         ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceControlAuthInfo
        :keyword is_commit_trigger_enabled: The value of this property indicates whether the source
         control commit trigger is enabled or not.
        :paramtype is_commit_trigger_enabled: bool
        """
        super().__init__(**kwargs)
        self.source_control_auth_properties = source_control_auth_properties
        self.is_commit_trigger_enabled = is_commit_trigger_enabled


class SourceUploadDefinition(_serialization.Model):
    """The properties of a response to source upload request.

    :ivar upload_url: The URL where the client can upload the source.
    :vartype upload_url: str
    :ivar relative_path: The relative path to the source. This is used to submit the subsequent
     queue build request.
    :vartype relative_path: str
    """

    _attribute_map = {
        "upload_url": {"key": "uploadUrl", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
    }

    def __init__(self, *, upload_url: Optional[str] = None, relative_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword upload_url: The URL where the client can upload the source.
        :paramtype upload_url: str
        :keyword relative_path: The relative path to the source. This is used to submit the subsequent
         queue build request.
        :paramtype relative_path: str
        """
        super().__init__(**kwargs)
        self.upload_url = upload_url
        self.relative_path = relative_path
