# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.automation import AutomationClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-automation
# USAGE
    python update_source_control_patch.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AutomationClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.source_control.update(
        resource_group_name="rg",
        automation_account_name="sampleAccount9",
        source_control_name="sampleSourceControl",
        parameters={
            "properties": {
                "autoSync": True,
                "branch": "master",
                "description": "my description",
                "folderPath": "/folderOne/folderTwo",
                "publishRunbook": True,
                "securityToken": {
                    "accessToken": "3a326f7a0dcd343ea58fee21f2fd5fb4c1234567",
                    "tokenType": "PersonalAccessToken",
                },
            }
        },
    )
    print(response)


# x-ms-original-file: specification/automation/resource-manager/Microsoft.Automation/stable/2022-08-08/examples/sourceControl/updateSourceControl_patch.json
if __name__ == "__main__":
    main()
