# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Assessment(_serialization.Model):
    """A class represent the assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the assessment.
    :vartype name: str
    :ivar severity: The severity level of this assessment. Known values are: "High", "Medium", and
     "Low".
    :vartype severity: str or ~azure.mgmt.appcomplianceautomation.models.AssessmentSeverity
    :ivar description: The description of the assessment.
    :vartype description: str
    :ivar remediation: The remediation of the assessment.
    :vartype remediation: str
    :ivar is_pass: Indicates whether all the resource(s) are compliant. Known values are: "True"
     and "False".
    :vartype is_pass: str or ~azure.mgmt.appcomplianceautomation.models.IsPass
    :ivar policy_id: The policy id mapping to this assessment.
    :vartype policy_id: str
    :ivar resource_list: List of resource assessments.
    :vartype resource_list: list[~azure.mgmt.appcomplianceautomation.models.AssessmentResource]
    """

    _validation = {
        "name": {"readonly": True},
        "severity": {"readonly": True},
        "description": {"readonly": True},
        "remediation": {"readonly": True},
        "is_pass": {"readonly": True},
        "policy_id": {"readonly": True},
        "resource_list": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "remediation": {"key": "remediation", "type": "str"},
        "is_pass": {"key": "isPass", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "resource_list": {"key": "resourceList", "type": "[AssessmentResource]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.severity = None
        self.description = None
        self.remediation = None
        self.is_pass = None
        self.policy_id = None
        self.resource_list = None


class AssessmentResource(_serialization.Model):
    """A class represent the assessment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: The Id of the resource.
    :vartype resource_id: str
    :ivar resource_status: Resource status. Known values are: "Healthy", "Unhealthy", and
     "NotApplicable".
    :vartype resource_status: str or ~azure.mgmt.appcomplianceautomation.models.ResourceStatus
    :ivar reason: The reason for the N/A resource.
    :vartype reason: str
    :ivar status_change_date: The status change date for the resource. For unavailable date, set it
     as N/A.
    :vartype status_change_date: str
    """

    _validation = {
        "resource_id": {"readonly": True},
        "resource_status": {"readonly": True},
        "reason": {"readonly": True},
        "status_change_date": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "resource_status": {"key": "resourceStatus", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "status_change_date": {"key": "statusChangeDate", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_id = None
        self.resource_status = None
        self.reason = None
        self.status_change_date = None


class Category(_serialization.Model):
    """A class represent the compliance category.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar category_name: The name of the compliance category. e.g. "Operational Security".
    :vartype category_name: str
    :ivar category_type: The category type. Known values are: "FullyAutomated",
     "PartiallyAutomated", and "Manual".
    :vartype category_type: str or ~azure.mgmt.appcomplianceautomation.models.CategoryType
    :ivar category_status: Category status. Known values are: "Healthy" and "Unhealthy".
    :vartype category_status: str or ~azure.mgmt.appcomplianceautomation.models.CategoryStatus
    :ivar control_families: List of control families.
    :vartype control_families: list[~azure.mgmt.appcomplianceautomation.models.ControlFamily]
    """

    _validation = {
        "category_name": {"readonly": True},
        "category_type": {"readonly": True},
        "category_status": {"readonly": True},
        "control_families": {"readonly": True},
    }

    _attribute_map = {
        "category_name": {"key": "categoryName", "type": "str"},
        "category_type": {"key": "categoryType", "type": "str"},
        "category_status": {"key": "categoryStatus", "type": "str"},
        "control_families": {"key": "controlFamilies", "type": "[ControlFamily]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.category_name = None
        self.category_type = None
        self.category_status = None
        self.control_families = None


class ComplianceReportItem(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Object that includes all the content for single compliance result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar category_name: The category name.
    :vartype category_name: str
    :ivar control_id: The control Id - e.g. "1".
    :vartype control_id: str
    :ivar control_name: The control name.
    :vartype control_name: str
    :ivar control_type: The control type. Known values are: "FullyAutomated", "PartiallyAutomated",
     and "Manual".
    :vartype control_type: str or ~azure.mgmt.appcomplianceautomation.models.ControlType
    :ivar compliance_state: The compliance result's status. Known values are: "Healthy" and
     "Unhealthy".
    :vartype compliance_state: str or ~azure.mgmt.appcomplianceautomation.models.ComplianceState
    :ivar policy_id: The compliance result mapped policy Id.
    :vartype policy_id: str
    :ivar policy_display_name: The policy's display name.
    :vartype policy_display_name: str
    :ivar policy_description: The policy's detail description.
    :vartype policy_description: str
    :ivar subscription_id: The compliance result mapped subscription Id.
    :vartype subscription_id: str
    :ivar resource_group: The compliance result mapped resource group.
    :vartype resource_group: str
    :ivar resource_type: The compliance result mapped resource type.
    :vartype resource_type: str
    :ivar resource_id: The compliance result mapped resource Id - e.g.
     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
    :vartype resource_id: str
    :ivar status_change_date: The compliance result last changed date - e.g.
     "2022-10-24T02:55:16.3274379Z". For unavailable date, set it as "N/A".
    :vartype status_change_date: str
    """

    _validation = {
        "category_name": {"readonly": True},
        "control_id": {"readonly": True},
        "control_name": {"readonly": True},
        "control_type": {"readonly": True},
        "compliance_state": {"readonly": True},
        "policy_id": {"readonly": True},
        "policy_display_name": {"readonly": True},
        "policy_description": {"readonly": True},
        "subscription_id": {"readonly": True},
        "resource_group": {"readonly": True},
        "resource_type": {"readonly": True},
        "resource_id": {"readonly": True},
        "status_change_date": {"readonly": True},
    }

    _attribute_map = {
        "category_name": {"key": "categoryName", "type": "str"},
        "control_id": {"key": "controlId", "type": "str"},
        "control_name": {"key": "controlName", "type": "str"},
        "control_type": {"key": "controlType", "type": "str"},
        "compliance_state": {"key": "complianceState", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "policy_display_name": {"key": "policyDisplayName", "type": "str"},
        "policy_description": {"key": "policyDescription", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "status_change_date": {"key": "statusChangeDate", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.category_name = None
        self.control_id = None
        self.control_name = None
        self.control_type = None
        self.compliance_state = None
        self.policy_id = None
        self.policy_display_name = None
        self.policy_description = None
        self.subscription_id = None
        self.resource_group = None
        self.resource_type = None
        self.resource_id = None
        self.status_change_date = None


class ComplianceResult(_serialization.Model):
    """A class represent the compliance result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_name: The name of the compliance. e.g. "M365".
    :vartype compliance_name: str
    :ivar categories: List of categories.
    :vartype categories: list[~azure.mgmt.appcomplianceautomation.models.Category]
    """

    _validation = {
        "compliance_name": {"readonly": True},
        "categories": {"readonly": True},
    }

    _attribute_map = {
        "compliance_name": {"key": "complianceName", "type": "str"},
        "categories": {"key": "categories", "type": "[Category]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.compliance_name = None
        self.categories = None


class Control(_serialization.Model):
    """A class represent the control.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar control_id: The Id of the control. e.g. "Operational Security#10".
    :vartype control_id: str
    :ivar control_short_name: The short name of the control. e.g. "Unsupported OS and Software.".
    :vartype control_short_name: str
    :ivar control_full_name: The full name of the control. e.g. "Validate that unsupported
     operating systems and software components are not in use.".
    :vartype control_full_name: str
    :ivar control_type: The control type. Known values are: "FullyAutomated", "PartiallyAutomated",
     and "Manual".
    :vartype control_type: str or ~azure.mgmt.appcomplianceautomation.models.ControlType
    :ivar control_description: The control's description.
    :vartype control_description: str
    :ivar control_description_hyper_link: The hyper link to the control's description'.
    :vartype control_description_hyper_link: str
    :ivar control_status: Control status. Known values are: "Passed", "Failed", and
     "NotApplicable".
    :vartype control_status: str or ~azure.mgmt.appcomplianceautomation.models.ControlStatus
    :ivar assessments: List of assessments.
    :vartype assessments: list[~azure.mgmt.appcomplianceautomation.models.Assessment]
    """

    _validation = {
        "control_id": {"readonly": True},
        "control_short_name": {"readonly": True},
        "control_full_name": {"readonly": True},
        "control_type": {"readonly": True},
        "control_description": {"readonly": True},
        "control_description_hyper_link": {"readonly": True},
        "control_status": {"readonly": True},
        "assessments": {"readonly": True},
    }

    _attribute_map = {
        "control_id": {"key": "controlId", "type": "str"},
        "control_short_name": {"key": "controlShortName", "type": "str"},
        "control_full_name": {"key": "controlFullName", "type": "str"},
        "control_type": {"key": "controlType", "type": "str"},
        "control_description": {"key": "controlDescription", "type": "str"},
        "control_description_hyper_link": {"key": "controlDescriptionHyperLink", "type": "str"},
        "control_status": {"key": "controlStatus", "type": "str"},
        "assessments": {"key": "assessments", "type": "[Assessment]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.control_id = None
        self.control_short_name = None
        self.control_full_name = None
        self.control_type = None
        self.control_description = None
        self.control_description_hyper_link = None
        self.control_status = None
        self.assessments = None


class ControlFamily(_serialization.Model):
    """A class represent the control family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar family_name: The name of the control family. e.g. "Malware Protection - Anti-Virus".
    :vartype family_name: str
    :ivar family_type: The control family type. Known values are: "FullyAutomated",
     "PartiallyAutomated", and "Manual".
    :vartype family_type: str or ~azure.mgmt.appcomplianceautomation.models.ControlFamilyType
    :ivar family_status: Control family status. Known values are: "Healthy" and "Unhealthy".
    :vartype family_status: str or ~azure.mgmt.appcomplianceautomation.models.ControlFamilyStatus
    :ivar controls: List of controls.
    :vartype controls: list[~azure.mgmt.appcomplianceautomation.models.Control]
    """

    _validation = {
        "family_name": {"readonly": True},
        "family_type": {"readonly": True},
        "family_status": {"readonly": True},
        "controls": {"readonly": True},
    }

    _attribute_map = {
        "family_name": {"key": "familyName", "type": "str"},
        "family_type": {"key": "familyType", "type": "str"},
        "family_status": {"key": "familyStatus", "type": "str"},
        "controls": {"key": "controls", "type": "[Control]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.family_name = None
        self.family_type = None
        self.family_status = None
        self.controls = None


class DownloadResponse(_serialization.Model):
    """Object that includes all the possible response for the download operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_list: List of the reports.
    :vartype resource_list: list[~azure.mgmt.appcomplianceautomation.models.ResourceItem]
    :ivar compliance_report: List of the compliance result.
    :vartype compliance_report:
     list[~azure.mgmt.appcomplianceautomation.models.ComplianceReportItem]
    :ivar compliance_pdf_report: compliance pdf report.
    :vartype compliance_pdf_report:
     ~azure.mgmt.appcomplianceautomation.models.DownloadResponseCompliancePdfReport
    :ivar compliance_detailed_pdf_report: compliance detailed pdf report.
    :vartype compliance_detailed_pdf_report:
     ~azure.mgmt.appcomplianceautomation.models.DownloadResponseComplianceDetailedPdfReport
    """

    _validation = {
        "resource_list": {"readonly": True},
        "compliance_report": {"readonly": True},
        "compliance_pdf_report": {"readonly": True},
        "compliance_detailed_pdf_report": {"readonly": True},
    }

    _attribute_map = {
        "resource_list": {"key": "resourceList", "type": "[ResourceItem]"},
        "compliance_report": {"key": "complianceReport", "type": "[ComplianceReportItem]"},
        "compliance_pdf_report": {"key": "compliancePdfReport", "type": "DownloadResponseCompliancePdfReport"},
        "compliance_detailed_pdf_report": {
            "key": "complianceDetailedPdfReport",
            "type": "DownloadResponseComplianceDetailedPdfReport",
        },
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_list = None
        self.compliance_report = None
        self.compliance_pdf_report = None
        self.compliance_detailed_pdf_report = None


class DownloadResponseComplianceDetailedPdfReport(_serialization.Model):
    """compliance detailed pdf report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sas_uri: uri of compliance detailed pdf report.
    :vartype sas_uri: str
    """

    _validation = {
        "sas_uri": {"readonly": True},
    }

    _attribute_map = {
        "sas_uri": {"key": "sasUri", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.sas_uri = None


class DownloadResponseCompliancePdfReport(_serialization.Model):
    """compliance pdf report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sas_uri: uri of compliance pdf report.
    :vartype sas_uri: str
    """

    _validation = {
        "sas_uri": {"readonly": True},
    }

    _attribute_map = {
        "sas_uri": {"key": "sasUri", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.sas_uri = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.appcomplianceautomation.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.appcomplianceautomation.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.appcomplianceautomation.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.appcomplianceautomation.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.appcomplianceautomation.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.appcomplianceautomation.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.appcomplianceautomation.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.appcomplianceautomation.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.appcomplianceautomation.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OverviewStatus(_serialization.Model):
    """The overview of the compliance result for one report.

    :ivar passed_count: The count of all passed full automation control.
    :vartype passed_count: int
    :ivar failed_count: The count of all failed full automation control.
    :vartype failed_count: int
    :ivar manual_count: The count of all manual control.
    :vartype manual_count: int
    """

    _attribute_map = {
        "passed_count": {"key": "passedCount", "type": "int"},
        "failed_count": {"key": "failedCount", "type": "int"},
        "manual_count": {"key": "manualCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        passed_count: Optional[int] = None,
        failed_count: Optional[int] = None,
        manual_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword passed_count: The count of all passed full automation control.
        :paramtype passed_count: int
        :keyword failed_count: The count of all failed full automation control.
        :paramtype failed_count: int
        :keyword manual_count: The count of all manual control.
        :paramtype manual_count: int
        """
        super().__init__(**kwargs)
        self.passed_count = passed_count
        self.failed_count = failed_count
        self.manual_count = manual_count


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcomplianceautomation.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcomplianceautomation.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class ReportComplianceStatus(_serialization.Model):
    """A list which includes all the compliance result for one report.

    :ivar m365: The Microsoft 365 certification name.
    :vartype m365: ~azure.mgmt.appcomplianceautomation.models.OverviewStatus
    """

    _attribute_map = {
        "m365": {"key": "m365", "type": "OverviewStatus"},
    }

    def __init__(self, *, m365: Optional["_models.OverviewStatus"] = None, **kwargs):
        """
        :keyword m365: The Microsoft 365 certification name.
        :paramtype m365: ~azure.mgmt.appcomplianceautomation.models.OverviewStatus
        """
        super().__init__(**kwargs)
        self.m365 = m365


class ReportProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Report's properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Report id in database.
    :vartype id: str
    :ivar status: Report status. Known values are: "Active", "Failed", and "Disabled".
    :vartype status: str or ~azure.mgmt.appcomplianceautomation.models.ReportStatus
    :ivar tenant_id: Report's tenant id.
    :vartype tenant_id: str
    :ivar report_name: Report name.
    :vartype report_name: str
    :ivar offer_guid: Report offer Guid.
    :vartype offer_guid: str
    :ivar time_zone: Report collection trigger time's time zone, the available list can be obtained
     by executing "Get-TimeZone -ListAvailable" in PowerShell.
     An example of valid timezone id is "Pacific Standard Time". Required.
    :vartype time_zone: str
    :ivar trigger_time: Report collection trigger time. Required.
    :vartype trigger_time: ~datetime.datetime
    :ivar next_trigger_time: Report next collection trigger time.
    :vartype next_trigger_time: ~datetime.datetime
    :ivar last_trigger_time: Report last collection trigger time.
    :vartype last_trigger_time: ~datetime.datetime
    :ivar subscriptions: List of subscription Ids.
    :vartype subscriptions: list[str]
    :ivar resources: List of resource data. Required.
    :vartype resources: list[~azure.mgmt.appcomplianceautomation.models.ResourceMetadata]
    :ivar compliance_status: Report compliance status.
    :vartype compliance_status: ~azure.mgmt.appcomplianceautomation.models.ReportComplianceStatus
    :ivar provisioning_state: Azure lifecycle management. Known values are: "Succeeded", "Failed",
     "Canceled", "Creating", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcomplianceautomation.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "status": {"readonly": True},
        "tenant_id": {"readonly": True},
        "report_name": {"readonly": True},
        "time_zone": {"required": True},
        "trigger_time": {"required": True},
        "next_trigger_time": {"readonly": True},
        "last_trigger_time": {"readonly": True},
        "subscriptions": {"readonly": True},
        "resources": {"required": True},
        "compliance_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "report_name": {"key": "reportName", "type": "str"},
        "offer_guid": {"key": "offerGuid", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "trigger_time": {"key": "triggerTime", "type": "iso-8601"},
        "next_trigger_time": {"key": "nextTriggerTime", "type": "iso-8601"},
        "last_trigger_time": {"key": "lastTriggerTime", "type": "iso-8601"},
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
        "resources": {"key": "resources", "type": "[ResourceMetadata]"},
        "compliance_status": {"key": "complianceStatus", "type": "ReportComplianceStatus"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_zone: str,
        trigger_time: datetime.datetime,
        resources: List["_models.ResourceMetadata"],
        offer_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword offer_guid: Report offer Guid.
        :paramtype offer_guid: str
        :keyword time_zone: Report collection trigger time's time zone, the available list can be
         obtained by executing "Get-TimeZone -ListAvailable" in PowerShell.
         An example of valid timezone id is "Pacific Standard Time". Required.
        :paramtype time_zone: str
        :keyword trigger_time: Report collection trigger time. Required.
        :paramtype trigger_time: ~datetime.datetime
        :keyword resources: List of resource data. Required.
        :paramtype resources: list[~azure.mgmt.appcomplianceautomation.models.ResourceMetadata]
        """
        super().__init__(**kwargs)
        self.id = None
        self.status = None
        self.tenant_id = None
        self.report_name = None
        self.offer_guid = offer_guid
        self.time_zone = time_zone
        self.trigger_time = trigger_time
        self.next_trigger_time = None
        self.last_trigger_time = None
        self.subscriptions = None
        self.resources = resources
        self.compliance_status = None
        self.provisioning_state = None


class ReportResource(ProxyResource):
    """A class represent an AppComplianceAutomation report resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcomplianceautomation.models.SystemData
    :ivar properties: Report property. Required.
    :vartype properties: ~azure.mgmt.appcomplianceautomation.models.ReportProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ReportProperties"},
    }

    def __init__(self, *, properties: "_models.ReportProperties", **kwargs):
        """
        :keyword properties: Report property. Required.
        :paramtype properties: ~azure.mgmt.appcomplianceautomation.models.ReportProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ReportResourceList(_serialization.Model):
    """Object that includes an array of resources and a possible link for next set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of the reports.
    :vartype value: list[~azure.mgmt.appcomplianceautomation.models.ReportResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ReportResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ReportResourcePatch(_serialization.Model):
    """A class represent a AppComplianceAutomation report resource update properties.

    :ivar properties: Report property.
    :vartype properties: ~azure.mgmt.appcomplianceautomation.models.ReportProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ReportProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ReportProperties"] = None, **kwargs):
        """
        :keyword properties: Report property.
        :paramtype properties: ~azure.mgmt.appcomplianceautomation.models.ReportProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ResourceItem(_serialization.Model):
    """Resource Id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: The subscription Id of this resource.
    :vartype subscription_id: str
    :ivar resource_group: The resource group name of this resource.
    :vartype resource_group: str
    :ivar resource_type: The resource type of this resource.
    :vartype resource_type: str
    :ivar resource_id: The resource Id - e.g.
     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
    :vartype resource_id: str
    """

    _validation = {
        "subscription_id": {"readonly": True},
        "resource_group": {"readonly": True},
        "resource_type": {"readonly": True},
        "resource_id": {"readonly": True},
    }

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.subscription_id = None
        self.resource_group = None
        self.resource_type = None
        self.resource_id = None


class ResourceMetadata(_serialization.Model):
    """Single resource Id's metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: Resource Id - e.g.
     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
     Required.
    :vartype resource_id: str
    :ivar resource_type: Resource type.
    :vartype resource_type: str
    :ivar resource_kind: Resource kind.
    :vartype resource_kind: str
    :ivar resource_name: Resource name.
    :vartype resource_name: str
    :ivar tags: Resource's tag type.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_kind": {"key": "resourceKind", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        resource_type: Optional[str] = None,
        resource_kind: Optional[str] = None,
        resource_name: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Resource Id - e.g.
         "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
         Required.
        :paramtype resource_id: str
        :keyword resource_type: Resource type.
        :paramtype resource_type: str
        :keyword resource_kind: Resource kind.
        :paramtype resource_kind: str
        :keyword resource_name: Resource name.
        :paramtype resource_name: str
        :keyword tags: Resource's tag type.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.resource_type = resource_type
        self.resource_kind = resource_kind
        self.resource_name = resource_name
        self.tags = tags


class SnapshotDownloadRequest(_serialization.Model):
    """Snapshot's download request.

    All required parameters must be populated in order to send to Azure.

    :ivar report_creator_tenant_id: Tenant id.
    :vartype report_creator_tenant_id: str
    :ivar download_type: Indicates the download type. Required. Known values are:
     "ComplianceReport", "CompliancePdfReport", "ComplianceDetailedPdfReport", and "ResourceList".
    :vartype download_type: str or ~azure.mgmt.appcomplianceautomation.models.DownloadType
    :ivar offer_guid: The offerGuid which mapping to the reports.
    :vartype offer_guid: str
    """

    _validation = {
        "download_type": {"required": True},
        "offer_guid": {"min_length": 1},
    }

    _attribute_map = {
        "report_creator_tenant_id": {"key": "reportCreatorTenantId", "type": "str"},
        "download_type": {"key": "downloadType", "type": "str"},
        "offer_guid": {"key": "offerGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        download_type: Union[str, "_models.DownloadType"],
        report_creator_tenant_id: Optional[str] = None,
        offer_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword report_creator_tenant_id: Tenant id.
        :paramtype report_creator_tenant_id: str
        :keyword download_type: Indicates the download type. Required. Known values are:
         "ComplianceReport", "CompliancePdfReport", "ComplianceDetailedPdfReport", and "ResourceList".
        :paramtype download_type: str or ~azure.mgmt.appcomplianceautomation.models.DownloadType
        :keyword offer_guid: The offerGuid which mapping to the reports.
        :paramtype offer_guid: str
        """
        super().__init__(**kwargs)
        self.report_creator_tenant_id = report_creator_tenant_id
        self.download_type = download_type
        self.offer_guid = offer_guid


class SnapshotProperties(_serialization.Model):
    """Snapshot's properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Snapshot id in the database.
    :vartype id: str
    :ivar snapshot_name: Snapshot name.
    :vartype snapshot_name: str
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management. Known values are: "Succeeded", "Failed",
     "Canceled", "Creating", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcomplianceautomation.models.ProvisioningState
    :ivar report_properties: The report essential info.
    :vartype report_properties: ~azure.mgmt.appcomplianceautomation.models.ReportProperties
    :ivar report_system_data: Metadata pertaining to creation and last modification of the
     resource.
    :vartype report_system_data: ~azure.mgmt.appcomplianceautomation.models.SystemData
    :ivar compliance_results: List of compliance results.
    :vartype compliance_results: list[~azure.mgmt.appcomplianceautomation.models.ComplianceResult]
    """

    _validation = {
        "id": {"readonly": True},
        "snapshot_name": {"readonly": True},
        "created_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "report_properties": {"readonly": True},
        "report_system_data": {"readonly": True},
        "compliance_results": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "snapshot_name": {"key": "snapshotName", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "report_properties": {"key": "reportProperties", "type": "ReportProperties"},
        "report_system_data": {"key": "reportSystemData", "type": "SystemData"},
        "compliance_results": {"key": "complianceResults", "type": "[ComplianceResult]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.snapshot_name = None
        self.created_at = None
        self.provisioning_state = None
        self.report_properties = None
        self.report_system_data = None
        self.compliance_results = None


class SnapshotResource(ProxyResource):
    """A class represent a AppComplianceAutomation snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcomplianceautomation.models.SystemData
    :ivar properties: Snapshot's property'.
    :vartype properties: ~azure.mgmt.appcomplianceautomation.models.SnapshotProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SnapshotProperties"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.properties = None


class SnapshotResourceList(_serialization.Model):
    """Object that includes an array of resources and a possible link for next set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of the snapshots.
    :vartype value: list[~azure.mgmt.appcomplianceautomation.models.SnapshotResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SnapshotResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.appcomplianceautomation.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.appcomplianceautomation.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.appcomplianceautomation.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.appcomplianceautomation.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
