# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ApplicationDeltaHealthPolicy(msrest.serialization.Model):
    """Defines a delta health policy used to evaluate the health of an application or one of its child entities when upgrading the cluster.

    :param default_service_type_delta_health_policy: The delta health policy used by default to
     evaluate the health of a service type when upgrading the cluster.
    :type default_service_type_delta_health_policy:
     ~azure.mgmt.servicefabric.models.ServiceTypeDeltaHealthPolicy
    :param service_type_delta_health_policies: The map with service type delta health policy per
     service type name. The map is empty by default.
    :type service_type_delta_health_policies: dict[str,
     ~azure.mgmt.servicefabric.models.ServiceTypeDeltaHealthPolicy]
    """

    _attribute_map = {
        'default_service_type_delta_health_policy': {'key': 'defaultServiceTypeDeltaHealthPolicy', 'type': 'ServiceTypeDeltaHealthPolicy'},
        'service_type_delta_health_policies': {'key': 'serviceTypeDeltaHealthPolicies', 'type': '{ServiceTypeDeltaHealthPolicy}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationDeltaHealthPolicy, self).__init__(**kwargs)
        self.default_service_type_delta_health_policy = kwargs.get('default_service_type_delta_health_policy', None)
        self.service_type_delta_health_policies = kwargs.get('service_type_delta_health_policies', None)


class ApplicationHealthPolicy(msrest.serialization.Model):
    """Defines a health policy used to evaluate the health of an application or one of its children entities.

    :param default_service_type_health_policy: The health policy used by default to evaluate the
     health of a service type.
    :type default_service_type_health_policy:
     ~azure.mgmt.servicefabric.models.ServiceTypeHealthPolicy
    :param service_type_health_policies: The map with service type health policy per service type
     name. The map is empty by default.
    :type service_type_health_policies: dict[str,
     ~azure.mgmt.servicefabric.models.ServiceTypeHealthPolicy]
    """

    _attribute_map = {
        'default_service_type_health_policy': {'key': 'defaultServiceTypeHealthPolicy', 'type': 'ServiceTypeHealthPolicy'},
        'service_type_health_policies': {'key': 'serviceTypeHealthPolicies', 'type': '{ServiceTypeHealthPolicy}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationHealthPolicy, self).__init__(**kwargs)
        self.default_service_type_health_policy = kwargs.get('default_service_type_health_policy', None)
        self.service_type_health_policies = kwargs.get('service_type_health_policies', None)


class ApplicationMetricDescription(msrest.serialization.Model):
    """Describes capacity information for a custom resource balancing metric. This can be used to limit the total consumption of this metric by the services of this application.

    :param name: The name of the metric.
    :type name: str
    :param maximum_capacity: The maximum node capacity for Service Fabric application.
     This is the maximum Load for an instance of this application on a single node. Even if the
     capacity of node is greater than this value, Service Fabric will limit the total load of
     services within the application on each node to this value.
     If set to zero, capacity for this metric is unlimited on each node.
     When creating a new application with application capacity defined, the product of MaximumNodes
     and this value must always be smaller than or equal to TotalApplicationCapacity.
     When updating existing application with application capacity, the product of MaximumNodes and
     this value must always be smaller than or equal to TotalApplicationCapacity.
    :type maximum_capacity: long
    :param reservation_capacity: The node reservation capacity for Service Fabric application.
     This is the amount of load which is reserved on nodes which have instances of this
     application.
     If MinimumNodes is specified, then the product of these values will be the capacity reserved
     in the cluster for the application.
     If set to zero, no capacity is reserved for this metric.
     When setting application capacity or when updating application capacity; this value must be
     smaller than or equal to MaximumCapacity for each metric.
    :type reservation_capacity: long
    :param total_application_capacity: The total metric capacity for Service Fabric application.
     This is the total metric capacity for this application in the cluster. Service Fabric will try
     to limit the sum of loads of services within the application to this value.
     When creating a new application with application capacity defined, the product of MaximumNodes
     and MaximumCapacity must always be smaller than or equal to this value.
    :type total_application_capacity: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'maximum_capacity': {'key': 'maximumCapacity', 'type': 'long'},
        'reservation_capacity': {'key': 'reservationCapacity', 'type': 'long'},
        'total_application_capacity': {'key': 'totalApplicationCapacity', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationMetricDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.maximum_capacity = kwargs.get('maximum_capacity', None)
        self.reservation_capacity = kwargs.get('reservation_capacity', None)
        self.total_application_capacity = kwargs.get('total_application_capacity', None)


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for proxy-only resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: It will be deprecated in New API, resource location depends on the parent
     resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.etag = None
        self.system_data = None


class ApplicationResource(ProxyResource):
    """The application resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: It will be deprecated in New API, resource location depends on the parent
     resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    :param identity: Describes the managed identities for an Azure resource.
    :type identity: ~azure.mgmt.servicefabric.models.ManagedIdentity
    :param type_version: The version of the application type as defined in the application
     manifest.
    :type type_version: str
    :param parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :type parameters: dict[str, str]
    :param upgrade_policy: Describes the policy for a monitored application upgrade.
    :type upgrade_policy: ~azure.mgmt.servicefabric.models.ApplicationUpgradePolicy
    :param minimum_nodes: The minimum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. If this property is set to zero, no capacity will be reserved.
     The value of this property cannot be more than the value of the MaximumNodes property.
    :type minimum_nodes: long
    :param maximum_nodes: The maximum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. By default, the value of this property is zero and it means
     that the services can be placed on any node.
    :type maximum_nodes: long
    :param remove_application_capacity: Remove the current application capacity settings.
    :type remove_application_capacity: bool
    :param metrics: List of application capacity metric description.
    :type metrics: list[~azure.mgmt.servicefabric.models.ApplicationMetricDescription]
    :param managed_identities: List of user assigned identities for the application, each mapped to
     a friendly name.
    :type managed_identities:
     list[~azure.mgmt.servicefabric.models.ApplicationUserAssignedIdentity]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param type_name: The application type name as defined in the application manifest.
    :type type_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'minimum_nodes': {'minimum': 0},
        'maximum_nodes': {'minimum': 0},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'type_version': {'key': 'properties.typeVersion', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'ApplicationUpgradePolicy'},
        'minimum_nodes': {'key': 'properties.minimumNodes', 'type': 'long'},
        'maximum_nodes': {'key': 'properties.maximumNodes', 'type': 'long'},
        'remove_application_capacity': {'key': 'properties.removeApplicationCapacity', 'type': 'bool'},
        'metrics': {'key': 'properties.metrics', 'type': '[ApplicationMetricDescription]'},
        'managed_identities': {'key': 'properties.managedIdentities', 'type': '[ApplicationUserAssignedIdentity]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'type_name': {'key': 'properties.typeName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.type_version = kwargs.get('type_version', None)
        self.parameters = kwargs.get('parameters', None)
        self.upgrade_policy = kwargs.get('upgrade_policy', None)
        self.minimum_nodes = kwargs.get('minimum_nodes', None)
        self.maximum_nodes = kwargs.get('maximum_nodes', 0)
        self.remove_application_capacity = kwargs.get('remove_application_capacity', None)
        self.metrics = kwargs.get('metrics', None)
        self.managed_identities = kwargs.get('managed_identities', None)
        self.provisioning_state = None
        self.type_name = kwargs.get('type_name', None)


class ApplicationResourceList(msrest.serialization.Model):
    """The list of application resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value: list[~azure.mgmt.servicefabric.models.ApplicationResource]
    :ivar next_link: URL to get the next set of application list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ApplicationResourceUpdateProperties(msrest.serialization.Model):
    """The application resource properties for patch operations.

    :param type_version: The version of the application type as defined in the application
     manifest.
    :type type_version: str
    :param parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :type parameters: dict[str, str]
    :param upgrade_policy: Describes the policy for a monitored application upgrade.
    :type upgrade_policy: ~azure.mgmt.servicefabric.models.ApplicationUpgradePolicy
    :param minimum_nodes: The minimum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. If this property is set to zero, no capacity will be reserved.
     The value of this property cannot be more than the value of the MaximumNodes property.
    :type minimum_nodes: long
    :param maximum_nodes: The maximum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. By default, the value of this property is zero and it means
     that the services can be placed on any node.
    :type maximum_nodes: long
    :param remove_application_capacity: Remove the current application capacity settings.
    :type remove_application_capacity: bool
    :param metrics: List of application capacity metric description.
    :type metrics: list[~azure.mgmt.servicefabric.models.ApplicationMetricDescription]
    :param managed_identities: List of user assigned identities for the application, each mapped to
     a friendly name.
    :type managed_identities:
     list[~azure.mgmt.servicefabric.models.ApplicationUserAssignedIdentity]
    """

    _validation = {
        'minimum_nodes': {'minimum': 0},
        'maximum_nodes': {'minimum': 0},
    }

    _attribute_map = {
        'type_version': {'key': 'typeVersion', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'upgrade_policy': {'key': 'upgradePolicy', 'type': 'ApplicationUpgradePolicy'},
        'minimum_nodes': {'key': 'minimumNodes', 'type': 'long'},
        'maximum_nodes': {'key': 'maximumNodes', 'type': 'long'},
        'remove_application_capacity': {'key': 'removeApplicationCapacity', 'type': 'bool'},
        'metrics': {'key': 'metrics', 'type': '[ApplicationMetricDescription]'},
        'managed_identities': {'key': 'managedIdentities', 'type': '[ApplicationUserAssignedIdentity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationResourceUpdateProperties, self).__init__(**kwargs)
        self.type_version = kwargs.get('type_version', None)
        self.parameters = kwargs.get('parameters', None)
        self.upgrade_policy = kwargs.get('upgrade_policy', None)
        self.minimum_nodes = kwargs.get('minimum_nodes', None)
        self.maximum_nodes = kwargs.get('maximum_nodes', 0)
        self.remove_application_capacity = kwargs.get('remove_application_capacity', None)
        self.metrics = kwargs.get('metrics', None)
        self.managed_identities = kwargs.get('managed_identities', None)


class ApplicationResourceProperties(ApplicationResourceUpdateProperties):
    """The application resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type_version: The version of the application type as defined in the application
     manifest.
    :type type_version: str
    :param parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :type parameters: dict[str, str]
    :param upgrade_policy: Describes the policy for a monitored application upgrade.
    :type upgrade_policy: ~azure.mgmt.servicefabric.models.ApplicationUpgradePolicy
    :param minimum_nodes: The minimum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. If this property is set to zero, no capacity will be reserved.
     The value of this property cannot be more than the value of the MaximumNodes property.
    :type minimum_nodes: long
    :param maximum_nodes: The maximum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. By default, the value of this property is zero and it means
     that the services can be placed on any node.
    :type maximum_nodes: long
    :param remove_application_capacity: Remove the current application capacity settings.
    :type remove_application_capacity: bool
    :param metrics: List of application capacity metric description.
    :type metrics: list[~azure.mgmt.servicefabric.models.ApplicationMetricDescription]
    :param managed_identities: List of user assigned identities for the application, each mapped to
     a friendly name.
    :type managed_identities:
     list[~azure.mgmt.servicefabric.models.ApplicationUserAssignedIdentity]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param type_name: The application type name as defined in the application manifest.
    :type type_name: str
    """

    _validation = {
        'minimum_nodes': {'minimum': 0},
        'maximum_nodes': {'minimum': 0},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'type_version': {'key': 'typeVersion', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'upgrade_policy': {'key': 'upgradePolicy', 'type': 'ApplicationUpgradePolicy'},
        'minimum_nodes': {'key': 'minimumNodes', 'type': 'long'},
        'maximum_nodes': {'key': 'maximumNodes', 'type': 'long'},
        'remove_application_capacity': {'key': 'removeApplicationCapacity', 'type': 'bool'},
        'metrics': {'key': 'metrics', 'type': '[ApplicationMetricDescription]'},
        'managed_identities': {'key': 'managedIdentities', 'type': '[ApplicationUserAssignedIdentity]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'type_name': {'key': 'typeName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationResourceProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.type_name = kwargs.get('type_name', None)


class ApplicationResourceUpdate(ProxyResource):
    """The application resource for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: It will be deprecated in New API, resource location depends on the parent
     resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    :param type_version: The version of the application type as defined in the application
     manifest.
    :type type_version: str
    :param parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :type parameters: dict[str, str]
    :param upgrade_policy: Describes the policy for a monitored application upgrade.
    :type upgrade_policy: ~azure.mgmt.servicefabric.models.ApplicationUpgradePolicy
    :param minimum_nodes: The minimum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. If this property is set to zero, no capacity will be reserved.
     The value of this property cannot be more than the value of the MaximumNodes property.
    :type minimum_nodes: long
    :param maximum_nodes: The maximum number of nodes where Service Fabric will reserve capacity
     for this application. Note that this does not mean that the services of this application will
     be placed on all of those nodes. By default, the value of this property is zero and it means
     that the services can be placed on any node.
    :type maximum_nodes: long
    :param remove_application_capacity: Remove the current application capacity settings.
    :type remove_application_capacity: bool
    :param metrics: List of application capacity metric description.
    :type metrics: list[~azure.mgmt.servicefabric.models.ApplicationMetricDescription]
    :param managed_identities: List of user assigned identities for the application, each mapped to
     a friendly name.
    :type managed_identities:
     list[~azure.mgmt.servicefabric.models.ApplicationUserAssignedIdentity]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'minimum_nodes': {'minimum': 0},
        'maximum_nodes': {'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'type_version': {'key': 'properties.typeVersion', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'ApplicationUpgradePolicy'},
        'minimum_nodes': {'key': 'properties.minimumNodes', 'type': 'long'},
        'maximum_nodes': {'key': 'properties.maximumNodes', 'type': 'long'},
        'remove_application_capacity': {'key': 'properties.removeApplicationCapacity', 'type': 'bool'},
        'metrics': {'key': 'properties.metrics', 'type': '[ApplicationMetricDescription]'},
        'managed_identities': {'key': 'properties.managedIdentities', 'type': '[ApplicationUserAssignedIdentity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationResourceUpdate, self).__init__(**kwargs)
        self.type_version = kwargs.get('type_version', None)
        self.parameters = kwargs.get('parameters', None)
        self.upgrade_policy = kwargs.get('upgrade_policy', None)
        self.minimum_nodes = kwargs.get('minimum_nodes', None)
        self.maximum_nodes = kwargs.get('maximum_nodes', 0)
        self.remove_application_capacity = kwargs.get('remove_application_capacity', None)
        self.metrics = kwargs.get('metrics', None)
        self.managed_identities = kwargs.get('managed_identities', None)


class ApplicationTypeResource(ProxyResource):
    """The application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: It will be deprecated in New API, resource location depends on the parent
     resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationTypeResource, self).__init__(**kwargs)
        self.provisioning_state = None


class ApplicationTypeResourceList(msrest.serialization.Model):
    """The list of application type names.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value: list[~azure.mgmt.servicefabric.models.ApplicationTypeResource]
    :ivar next_link: URL to get the next set of application type list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationTypeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationTypeResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ApplicationTypeVersionResource(ProxyResource):
    """An application type version resource for the specified application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: It will be deprecated in New API, resource location depends on the parent
     resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param app_package_url: The URL to the application package.
    :type app_package_url: str
    :ivar default_parameter_list: List of application type parameters that can be overridden when
     creating or updating the application.
    :vartype default_parameter_list: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'default_parameter_list': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'app_package_url': {'key': 'properties.appPackageUrl', 'type': 'str'},
        'default_parameter_list': {'key': 'properties.defaultParameterList', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationTypeVersionResource, self).__init__(**kwargs)
        self.provisioning_state = None
        self.app_package_url = kwargs.get('app_package_url', None)
        self.default_parameter_list = None


class ApplicationTypeVersionResourceList(msrest.serialization.Model):
    """The list of application type version resources for the specified application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value: list[~azure.mgmt.servicefabric.models.ApplicationTypeVersionResource]
    :ivar next_link: URL to get the next set of application type version list results if there are
     any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationTypeVersionResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationTypeVersionResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ApplicationTypeVersionsCleanupPolicy(msrest.serialization.Model):
    """ApplicationTypeVersionsCleanupPolicy.

    All required parameters must be populated in order to send to Azure.

    :param max_unused_versions_to_keep: Required. Number of unused versions per application type to
     keep.
    :type max_unused_versions_to_keep: long
    """

    _validation = {
        'max_unused_versions_to_keep': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'max_unused_versions_to_keep': {'key': 'maxUnusedVersionsToKeep', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationTypeVersionsCleanupPolicy, self).__init__(**kwargs)
        self.max_unused_versions_to_keep = kwargs['max_unused_versions_to_keep']


class ApplicationUpgradePolicy(msrest.serialization.Model):
    """Describes the policy for a monitored application upgrade.

    :param upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an
     upgrade domain and prevent loss of availability when there are unexpected issues. When this
     timeout expires, processing of the upgrade domain will proceed regardless of availability loss
     issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0
     and 42949672925 inclusive. (unsigned 32-bit integer).
    :type upgrade_replica_set_check_timeout: str
    :param force_restart: If true, then processes are forcefully restarted during upgrade even when
     the code version has not changed (the upgrade only changes configuration or data).
    :type force_restart: bool
    :param rolling_upgrade_monitoring_policy: The policy used for monitoring the application
     upgrade.
    :type rolling_upgrade_monitoring_policy:
     ~azure.mgmt.servicefabric.models.ArmRollingUpgradeMonitoringPolicy
    :param application_health_policy: Defines a health policy used to evaluate the health of an
     application or one of its children entities.
    :type application_health_policy: ~azure.mgmt.servicefabric.models.ArmApplicationHealthPolicy
    :param upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are
     UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: "Invalid",
     "UnmonitoredAuto", "UnmonitoredManual", "Monitored". Default value: "Monitored".
    :type upgrade_mode: str or ~azure.mgmt.servicefabric.models.RollingUpgradeMode
    :param recreate_application: Determines whether the application should be recreated on update.
     If value=true, the rest of the upgrade policy parameters are not allowed and it will result in
     availability loss.
    :type recreate_application: bool
    """

    _attribute_map = {
        'upgrade_replica_set_check_timeout': {'key': 'upgradeReplicaSetCheckTimeout', 'type': 'str'},
        'force_restart': {'key': 'forceRestart', 'type': 'bool'},
        'rolling_upgrade_monitoring_policy': {'key': 'rollingUpgradeMonitoringPolicy', 'type': 'ArmRollingUpgradeMonitoringPolicy'},
        'application_health_policy': {'key': 'applicationHealthPolicy', 'type': 'ArmApplicationHealthPolicy'},
        'upgrade_mode': {'key': 'upgradeMode', 'type': 'str'},
        'recreate_application': {'key': 'recreateApplication', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationUpgradePolicy, self).__init__(**kwargs)
        self.upgrade_replica_set_check_timeout = kwargs.get('upgrade_replica_set_check_timeout', None)
        self.force_restart = kwargs.get('force_restart', False)
        self.rolling_upgrade_monitoring_policy = kwargs.get('rolling_upgrade_monitoring_policy', None)
        self.application_health_policy = kwargs.get('application_health_policy', None)
        self.upgrade_mode = kwargs.get('upgrade_mode', "Monitored")
        self.recreate_application = kwargs.get('recreate_application', None)


class ApplicationUserAssignedIdentity(msrest.serialization.Model):
    """ApplicationUserAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The friendly name of user assigned identity.
    :type name: str
    :param principal_id: Required. The principal id of user assigned identity.
    :type principal_id: str
    """

    _validation = {
        'name': {'required': True},
        'principal_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationUserAssignedIdentity, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.principal_id = kwargs['principal_id']


class ArmApplicationHealthPolicy(msrest.serialization.Model):
    """Defines a health policy used to evaluate the health of an application or one of its children entities.

    :param consider_warning_as_error: Indicates whether warnings are treated with the same severity
     as errors.
    :type consider_warning_as_error: bool
    :param max_percent_unhealthy_deployed_applications: The maximum allowed percentage of unhealthy
     deployed applications. Allowed values are Byte values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed applications that can
     be unhealthy before the application is considered in error.
     This is calculated by dividing the number of unhealthy deployed applications over the number
     of nodes where the application is currently deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default
     percentage is zero.
    :type max_percent_unhealthy_deployed_applications: int
    :param default_service_type_health_policy: The health policy used by default to evaluate the
     health of a service type.
    :type default_service_type_health_policy:
     ~azure.mgmt.servicefabric.models.ArmServiceTypeHealthPolicy
    :param service_type_health_policy_map: The map with service type health policy per service type
     name. The map is empty by default.
    :type service_type_health_policy_map: dict[str,
     ~azure.mgmt.servicefabric.models.ArmServiceTypeHealthPolicy]
    """

    _attribute_map = {
        'consider_warning_as_error': {'key': 'considerWarningAsError', 'type': 'bool'},
        'max_percent_unhealthy_deployed_applications': {'key': 'maxPercentUnhealthyDeployedApplications', 'type': 'int'},
        'default_service_type_health_policy': {'key': 'defaultServiceTypeHealthPolicy', 'type': 'ArmServiceTypeHealthPolicy'},
        'service_type_health_policy_map': {'key': 'serviceTypeHealthPolicyMap', 'type': '{ArmServiceTypeHealthPolicy}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmApplicationHealthPolicy, self).__init__(**kwargs)
        self.consider_warning_as_error = kwargs.get('consider_warning_as_error', False)
        self.max_percent_unhealthy_deployed_applications = kwargs.get('max_percent_unhealthy_deployed_applications', 0)
        self.default_service_type_health_policy = kwargs.get('default_service_type_health_policy', None)
        self.service_type_health_policy_map = kwargs.get('service_type_health_policy_map', None)


class ArmRollingUpgradeMonitoringPolicy(msrest.serialization.Model):
    """The policy used for monitoring the application upgrade.

    :param failure_action: The activation Mode of the service package. Possible values include:
     "Rollback", "Manual".
    :type failure_action: str or ~azure.mgmt.servicefabric.models.ArmUpgradeFailureAction
    :param health_check_wait_duration: The amount of time to wait after completing an upgrade
     domain before applying health policies. It is first interpreted as a string representing an ISO
     8601 duration. If that fails, then it is interpreted as a number representing the total number
     of milliseconds.
    :type health_check_wait_duration: str
    :param health_check_stable_duration: The amount of time that the application or cluster must
     remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted
     as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a
     number representing the total number of milliseconds.
    :type health_check_stable_duration: str
    :param health_check_retry_timeout: The amount of time to retry health evaluation when the
     application or cluster is unhealthy before FailureAction is executed. It is first interpreted
     as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a
     number representing the total number of milliseconds.
    :type health_check_retry_timeout: str
    :param upgrade_timeout: The amount of time the overall upgrade has to complete before
     FailureAction is executed. It is first interpreted as a string representing an ISO 8601
     duration. If that fails, then it is interpreted as a number representing the total number of
     milliseconds.
    :type upgrade_timeout: str
    :param upgrade_domain_timeout: The amount of time each upgrade domain has to complete before
     FailureAction is executed. It is first interpreted as a string representing an ISO 8601
     duration. If that fails, then it is interpreted as a number representing the total number of
     milliseconds.
    :type upgrade_domain_timeout: str
    """

    _attribute_map = {
        'failure_action': {'key': 'failureAction', 'type': 'str'},
        'health_check_wait_duration': {'key': 'healthCheckWaitDuration', 'type': 'str'},
        'health_check_stable_duration': {'key': 'healthCheckStableDuration', 'type': 'str'},
        'health_check_retry_timeout': {'key': 'healthCheckRetryTimeout', 'type': 'str'},
        'upgrade_timeout': {'key': 'upgradeTimeout', 'type': 'str'},
        'upgrade_domain_timeout': {'key': 'upgradeDomainTimeout', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmRollingUpgradeMonitoringPolicy, self).__init__(**kwargs)
        self.failure_action = kwargs.get('failure_action', None)
        self.health_check_wait_duration = kwargs.get('health_check_wait_duration', "0")
        self.health_check_stable_duration = kwargs.get('health_check_stable_duration', "PT0H2M0S")
        self.health_check_retry_timeout = kwargs.get('health_check_retry_timeout', "PT0H10M0S")
        self.upgrade_timeout = kwargs.get('upgrade_timeout', "P10675199DT02H48M05.4775807S")
        self.upgrade_domain_timeout = kwargs.get('upgrade_domain_timeout', "P10675199DT02H48M05.4775807S")


class ArmServiceTypeHealthPolicy(msrest.serialization.Model):
    """Represents the health policy used to evaluate the health of services belonging to a service type.

    :param max_percent_unhealthy_services: The maximum percentage of services allowed to be
     unhealthy before your application is considered in error.
    :type max_percent_unhealthy_services: int
    :param max_percent_unhealthy_partitions_per_service: The maximum percentage of partitions per
     service allowed to be unhealthy before your application is considered in error.
    :type max_percent_unhealthy_partitions_per_service: int
    :param max_percent_unhealthy_replicas_per_partition: The maximum percentage of replicas per
     partition allowed to be unhealthy before your application is considered in error.
    :type max_percent_unhealthy_replicas_per_partition: int
    """

    _validation = {
        'max_percent_unhealthy_services': {'maximum': 100, 'minimum': 0},
        'max_percent_unhealthy_partitions_per_service': {'maximum': 100, 'minimum': 0},
        'max_percent_unhealthy_replicas_per_partition': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_unhealthy_services': {'key': 'maxPercentUnhealthyServices', 'type': 'int'},
        'max_percent_unhealthy_partitions_per_service': {'key': 'maxPercentUnhealthyPartitionsPerService', 'type': 'int'},
        'max_percent_unhealthy_replicas_per_partition': {'key': 'maxPercentUnhealthyReplicasPerPartition', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmServiceTypeHealthPolicy, self).__init__(**kwargs)
        self.max_percent_unhealthy_services = kwargs.get('max_percent_unhealthy_services', 0)
        self.max_percent_unhealthy_partitions_per_service = kwargs.get('max_percent_unhealthy_partitions_per_service', 0)
        self.max_percent_unhealthy_replicas_per_partition = kwargs.get('max_percent_unhealthy_replicas_per_partition', 0)


class AvailableOperationDisplay(msrest.serialization.Model):
    """Operation supported by the Service Fabric resource provider.

    :param provider: The name of the provider.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that can be performed.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableOperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class AzureActiveDirectory(msrest.serialization.Model):
    """The settings to enable AAD authentication on the cluster.

    :param tenant_id: Azure active directory tenant id.
    :type tenant_id: str
    :param cluster_application: Azure active directory cluster application id.
    :type cluster_application: str
    :param client_application: Azure active directory client application id.
    :type client_application: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'cluster_application': {'key': 'clusterApplication', 'type': 'str'},
        'client_application': {'key': 'clientApplication', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureActiveDirectory, self).__init__(**kwargs)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.cluster_application = kwargs.get('cluster_application', None)
        self.client_application = kwargs.get('client_application', None)


class CertificateDescription(msrest.serialization.Model):
    """Describes the certificate details.

    All required parameters must be populated in order to send to Azure.

    :param thumbprint: Required. Thumbprint of the primary certificate.
    :type thumbprint: str
    :param thumbprint_secondary: Thumbprint of the secondary certificate.
    :type thumbprint_secondary: str
    :param x509_store_name: The local certificate store location. Possible values include:
     "AddressBook", "AuthRoot", "CertificateAuthority", "Disallowed", "My", "Root", "TrustedPeople",
     "TrustedPublisher".
    :type x509_store_name: str or ~azure.mgmt.servicefabric.models.StoreName
    """

    _validation = {
        'thumbprint': {'required': True},
    }

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'thumbprint_secondary': {'key': 'thumbprintSecondary', 'type': 'str'},
        'x509_store_name': {'key': 'x509StoreName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateDescription, self).__init__(**kwargs)
        self.thumbprint = kwargs['thumbprint']
        self.thumbprint_secondary = kwargs.get('thumbprint_secondary', None)
        self.x509_store_name = kwargs.get('x509_store_name', None)


class ClientCertificateCommonName(msrest.serialization.Model):
    """Describes the client certificate details using common name.

    All required parameters must be populated in order to send to Azure.

    :param is_admin: Required. Indicates if the client certificate has admin access to the cluster.
     Non admin clients can perform only read only operations on the cluster.
    :type is_admin: bool
    :param certificate_common_name: Required. The common name of the client certificate.
    :type certificate_common_name: str
    :param certificate_issuer_thumbprint: Required. The issuer thumbprint of the client
     certificate.
    :type certificate_issuer_thumbprint: str
    """

    _validation = {
        'is_admin': {'required': True},
        'certificate_common_name': {'required': True},
        'certificate_issuer_thumbprint': {'required': True},
    }

    _attribute_map = {
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'certificate_common_name': {'key': 'certificateCommonName', 'type': 'str'},
        'certificate_issuer_thumbprint': {'key': 'certificateIssuerThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientCertificateCommonName, self).__init__(**kwargs)
        self.is_admin = kwargs['is_admin']
        self.certificate_common_name = kwargs['certificate_common_name']
        self.certificate_issuer_thumbprint = kwargs['certificate_issuer_thumbprint']


class ClientCertificateThumbprint(msrest.serialization.Model):
    """Describes the client certificate details using thumbprint.

    All required parameters must be populated in order to send to Azure.

    :param is_admin: Required. Indicates if the client certificate has admin access to the cluster.
     Non admin clients can perform only read only operations on the cluster.
    :type is_admin: bool
    :param certificate_thumbprint: Required. The thumbprint of the client certificate.
    :type certificate_thumbprint: str
    """

    _validation = {
        'is_admin': {'required': True},
        'certificate_thumbprint': {'required': True},
    }

    _attribute_map = {
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'certificate_thumbprint': {'key': 'certificateThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientCertificateThumbprint, self).__init__(**kwargs)
        self.is_admin = kwargs['is_admin']
        self.certificate_thumbprint = kwargs['certificate_thumbprint']


class Resource(msrest.serialization.Model):
    """The resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Azure resource location.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.etag = None
        self.system_data = None


class Cluster(Resource):
    """The cluster resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Azure resource location.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    :param add_on_features: The list of add-on features to enable in the cluster.
    :type add_on_features: list[str or ~azure.mgmt.servicefabric.models.AddOnFeatures]
    :ivar available_cluster_versions: The Service Fabric runtime versions available for this
     cluster.
    :vartype available_cluster_versions:
     list[~azure.mgmt.servicefabric.models.ClusterVersionDetails]
    :param azure_active_directory: The AAD authentication settings of the cluster.
    :type azure_active_directory: ~azure.mgmt.servicefabric.models.AzureActiveDirectory
    :param certificate: The certificate to use for securing the cluster. The certificate provided
     will be used for node to node security within the cluster, SSL certificate for cluster
     management endpoint and default admin client.
    :type certificate: ~azure.mgmt.servicefabric.models.CertificateDescription
    :param certificate_common_names: Describes a list of server certificates referenced by common
     name that are used to secure the cluster.
    :type certificate_common_names: ~azure.mgmt.servicefabric.models.ServerCertificateCommonNames
    :param client_certificate_common_names: The list of client certificates referenced by common
     name that are allowed to manage the cluster.
    :type client_certificate_common_names:
     list[~azure.mgmt.servicefabric.models.ClientCertificateCommonName]
    :param client_certificate_thumbprints: The list of client certificates referenced by thumbprint
     that are allowed to manage the cluster.
    :type client_certificate_thumbprints:
     list[~azure.mgmt.servicefabric.models.ClientCertificateThumbprint]
    :param cluster_code_version: The Service Fabric runtime version of the cluster. This property
     can only by set the user when **upgradeMode** is set to 'Manual'. To get list of available
     Service Fabric versions for new clusters use `ClusterVersion API <./ClusterVersion.md>`_. To
     get the list of available version for existing clusters use **availableClusterVersions**.
    :type cluster_code_version: str
    :ivar cluster_endpoint: The Azure Resource Provider endpoint. A system service in the cluster
     connects to this  endpoint.
    :vartype cluster_endpoint: str
    :ivar cluster_id: A service generated unique identifier for the cluster resource.
    :vartype cluster_id: str
    :ivar cluster_state: The current state of the cluster.
    
    
     * WaitingForNodes - Indicates that the cluster resource is created and the resource provider
     is waiting for Service Fabric VM extension to boot up and report to it.
     * Deploying - Indicates that the Service Fabric runtime is being installed on the VMs. Cluster
     resource will be in this state until the cluster boots up and system services are up.
     * BaselineUpgrade - Indicates that the cluster is upgrading to establishes the cluster
     version. This upgrade is automatically initiated when the cluster boots up for the first time.
     * UpdatingUserConfiguration - Indicates that the cluster is being upgraded with the user
     provided configuration.
     * UpdatingUserCertificate - Indicates that the cluster is being upgraded with the user
     provided certificate.
     * UpdatingInfrastructure - Indicates that the cluster is being upgraded with the latest
     Service Fabric runtime version. This happens only when the **upgradeMode** is set to
     'Automatic'.
     * EnforcingClusterVersion - Indicates that cluster is on a different version than expected and
     the cluster is being upgraded to the expected version.
     * UpgradeServiceUnreachable - Indicates that the system service in the cluster is no longer
     polling the Resource Provider. Clusters in this state cannot be managed by the Resource
     Provider.
     * AutoScale - Indicates that the ReliabilityLevel of the cluster is being adjusted.
     * Ready - Indicates that the cluster is in a stable state. Possible values include:
     "WaitingForNodes", "Deploying", "BaselineUpgrade", "UpdatingUserConfiguration",
     "UpdatingUserCertificate", "UpdatingInfrastructure", "EnforcingClusterVersion",
     "UpgradeServiceUnreachable", "AutoScale", "Ready".
    :vartype cluster_state: str or ~azure.mgmt.servicefabric.models.ClusterState
    :param diagnostics_storage_account_config: The storage account information for storing Service
     Fabric diagnostic logs.
    :type diagnostics_storage_account_config:
     ~azure.mgmt.servicefabric.models.DiagnosticsStorageAccountConfig
    :param event_store_service_enabled: Indicates if the event store service is enabled.
    :type event_store_service_enabled: bool
    :param fabric_settings: The list of custom fabric settings to configure the cluster.
    :type fabric_settings: list[~azure.mgmt.servicefabric.models.SettingsSectionDescription]
    :param management_endpoint: The http management endpoint of the cluster.
    :type management_endpoint: str
    :param node_types: The list of node types in the cluster.
    :type node_types: list[~azure.mgmt.servicefabric.models.NodeTypeDescription]
    :ivar provisioning_state: The provisioning state of the cluster resource. Possible values
     include: "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.servicefabric.models.ProvisioningState
    :param reliability_level: The reliability level sets the replica set size of system services.
     Learn about `ReliabilityLevel
     <https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity>`_.
    
    
     * None - Run the System services with a target replica set count of 1. This should only be
     used for test clusters.
     * Bronze - Run the System services with a target replica set count of 3. This should only be
     used for test clusters.
     * Silver - Run the System services with a target replica set count of 5.
     * Gold - Run the System services with a target replica set count of 7.
     * Platinum - Run the System services with a target replica set count of 9. Possible values
     include: "None", "Bronze", "Silver", "Gold", "Platinum".
    :type reliability_level: str or ~azure.mgmt.servicefabric.models.ReliabilityLevel
    :param reverse_proxy_certificate: The server certificate used by reverse proxy.
    :type reverse_proxy_certificate: ~azure.mgmt.servicefabric.models.CertificateDescription
    :param reverse_proxy_certificate_common_names: Describes a list of server certificates
     referenced by common name that are used to secure the cluster.
    :type reverse_proxy_certificate_common_names:
     ~azure.mgmt.servicefabric.models.ServerCertificateCommonNames
    :param upgrade_description: The policy to use when upgrading the cluster.
    :type upgrade_description: ~azure.mgmt.servicefabric.models.ClusterUpgradePolicy
    :param upgrade_mode: The upgrade mode of the cluster when new Service Fabric runtime version is
     available. Possible values include: "Automatic", "Manual". Default value: "Automatic".
    :type upgrade_mode: str or ~azure.mgmt.servicefabric.models.UpgradeMode
    :param application_type_versions_cleanup_policy: The policy used to clean up unused versions.
    :type application_type_versions_cleanup_policy:
     ~azure.mgmt.servicefabric.models.ApplicationTypeVersionsCleanupPolicy
    :param vm_image: The VM image VMSS has been configured with. Generic names such as Windows or
     Linux can be used.
    :type vm_image: str
    :param sf_zonal_upgrade_mode: This property controls the logical grouping of VMs in upgrade
     domains (UDs). This property can't be modified if a node type with multiple Availability Zones
     is already present in the cluster. Possible values include: "Parallel", "Hierarchical".
    :type sf_zonal_upgrade_mode: str or ~azure.mgmt.servicefabric.models.SfZonalUpgradeMode
    :param vmss_zonal_upgrade_mode: This property defines the upgrade mode for the virtual machine
     scale set, it is mandatory if a node type with multiple Availability Zones is added. Possible
     values include: "Parallel", "Hierarchical".
    :type vmss_zonal_upgrade_mode: str or ~azure.mgmt.servicefabric.models.VmssZonalUpgradeMode
    :param infrastructure_service_manager: Indicates if infrastructure service manager is enabled.
    :type infrastructure_service_manager: bool
    :param upgrade_wave: Indicates when new cluster runtime version upgrades will be applied after
     they are released. By default is Wave0. Only applies when **upgradeMode** is set to
     'Automatic'. Possible values include: "Wave0", "Wave1", "Wave2".
    :type upgrade_wave: str or ~azure.mgmt.servicefabric.models.ClusterUpgradeCadence
    :param upgrade_pause_start_timestamp_utc: Indicates the start date and time to pause automatic
     runtime version upgrades on the cluster for an specific period of time on the cluster (UTC).
    :type upgrade_pause_start_timestamp_utc: ~datetime.datetime
    :param upgrade_pause_end_timestamp_utc: Indicates the end date and time to pause automatic
     runtime version upgrades on the cluster for an specific period of time on the cluster (UTC).
    :type upgrade_pause_end_timestamp_utc: ~datetime.datetime
    :param wave_upgrade_paused: Boolean to pause automatic runtime version upgrades to the cluster.
    :type wave_upgrade_paused: bool
    :param notifications: Indicates a list of notification channels for cluster events.
    :type notifications: list[~azure.mgmt.servicefabric.models.Notification]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'available_cluster_versions': {'readonly': True},
        'cluster_endpoint': {'readonly': True},
        'cluster_id': {'readonly': True},
        'cluster_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'add_on_features': {'key': 'properties.addOnFeatures', 'type': '[str]'},
        'available_cluster_versions': {'key': 'properties.availableClusterVersions', 'type': '[ClusterVersionDetails]'},
        'azure_active_directory': {'key': 'properties.azureActiveDirectory', 'type': 'AzureActiveDirectory'},
        'certificate': {'key': 'properties.certificate', 'type': 'CertificateDescription'},
        'certificate_common_names': {'key': 'properties.certificateCommonNames', 'type': 'ServerCertificateCommonNames'},
        'client_certificate_common_names': {'key': 'properties.clientCertificateCommonNames', 'type': '[ClientCertificateCommonName]'},
        'client_certificate_thumbprints': {'key': 'properties.clientCertificateThumbprints', 'type': '[ClientCertificateThumbprint]'},
        'cluster_code_version': {'key': 'properties.clusterCodeVersion', 'type': 'str'},
        'cluster_endpoint': {'key': 'properties.clusterEndpoint', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_state': {'key': 'properties.clusterState', 'type': 'str'},
        'diagnostics_storage_account_config': {'key': 'properties.diagnosticsStorageAccountConfig', 'type': 'DiagnosticsStorageAccountConfig'},
        'event_store_service_enabled': {'key': 'properties.eventStoreServiceEnabled', 'type': 'bool'},
        'fabric_settings': {'key': 'properties.fabricSettings', 'type': '[SettingsSectionDescription]'},
        'management_endpoint': {'key': 'properties.managementEndpoint', 'type': 'str'},
        'node_types': {'key': 'properties.nodeTypes', 'type': '[NodeTypeDescription]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'reliability_level': {'key': 'properties.reliabilityLevel', 'type': 'str'},
        'reverse_proxy_certificate': {'key': 'properties.reverseProxyCertificate', 'type': 'CertificateDescription'},
        'reverse_proxy_certificate_common_names': {'key': 'properties.reverseProxyCertificateCommonNames', 'type': 'ServerCertificateCommonNames'},
        'upgrade_description': {'key': 'properties.upgradeDescription', 'type': 'ClusterUpgradePolicy'},
        'upgrade_mode': {'key': 'properties.upgradeMode', 'type': 'str'},
        'application_type_versions_cleanup_policy': {'key': 'properties.applicationTypeVersionsCleanupPolicy', 'type': 'ApplicationTypeVersionsCleanupPolicy'},
        'vm_image': {'key': 'properties.vmImage', 'type': 'str'},
        'sf_zonal_upgrade_mode': {'key': 'properties.sfZonalUpgradeMode', 'type': 'str'},
        'vmss_zonal_upgrade_mode': {'key': 'properties.vmssZonalUpgradeMode', 'type': 'str'},
        'infrastructure_service_manager': {'key': 'properties.infrastructureServiceManager', 'type': 'bool'},
        'upgrade_wave': {'key': 'properties.upgradeWave', 'type': 'str'},
        'upgrade_pause_start_timestamp_utc': {'key': 'properties.upgradePauseStartTimestampUtc', 'type': 'iso-8601'},
        'upgrade_pause_end_timestamp_utc': {'key': 'properties.upgradePauseEndTimestampUtc', 'type': 'iso-8601'},
        'wave_upgrade_paused': {'key': 'properties.waveUpgradePaused', 'type': 'bool'},
        'notifications': {'key': 'properties.notifications', 'type': '[Notification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Cluster, self).__init__(**kwargs)
        self.add_on_features = kwargs.get('add_on_features', None)
        self.available_cluster_versions = None
        self.azure_active_directory = kwargs.get('azure_active_directory', None)
        self.certificate = kwargs.get('certificate', None)
        self.certificate_common_names = kwargs.get('certificate_common_names', None)
        self.client_certificate_common_names = kwargs.get('client_certificate_common_names', None)
        self.client_certificate_thumbprints = kwargs.get('client_certificate_thumbprints', None)
        self.cluster_code_version = kwargs.get('cluster_code_version', None)
        self.cluster_endpoint = None
        self.cluster_id = None
        self.cluster_state = None
        self.diagnostics_storage_account_config = kwargs.get('diagnostics_storage_account_config', None)
        self.event_store_service_enabled = kwargs.get('event_store_service_enabled', None)
        self.fabric_settings = kwargs.get('fabric_settings', None)
        self.management_endpoint = kwargs.get('management_endpoint', None)
        self.node_types = kwargs.get('node_types', None)
        self.provisioning_state = None
        self.reliability_level = kwargs.get('reliability_level', None)
        self.reverse_proxy_certificate = kwargs.get('reverse_proxy_certificate', None)
        self.reverse_proxy_certificate_common_names = kwargs.get('reverse_proxy_certificate_common_names', None)
        self.upgrade_description = kwargs.get('upgrade_description', None)
        self.upgrade_mode = kwargs.get('upgrade_mode', "Automatic")
        self.application_type_versions_cleanup_policy = kwargs.get('application_type_versions_cleanup_policy', None)
        self.vm_image = kwargs.get('vm_image', None)
        self.sf_zonal_upgrade_mode = kwargs.get('sf_zonal_upgrade_mode', None)
        self.vmss_zonal_upgrade_mode = kwargs.get('vmss_zonal_upgrade_mode', None)
        self.infrastructure_service_manager = kwargs.get('infrastructure_service_manager', None)
        self.upgrade_wave = kwargs.get('upgrade_wave', None)
        self.upgrade_pause_start_timestamp_utc = kwargs.get('upgrade_pause_start_timestamp_utc', None)
        self.upgrade_pause_end_timestamp_utc = kwargs.get('upgrade_pause_end_timestamp_utc', None)
        self.wave_upgrade_paused = kwargs.get('wave_upgrade_paused', None)
        self.notifications = kwargs.get('notifications', None)


class ClusterCodeVersionsListResult(msrest.serialization.Model):
    """The list results of the Service Fabric runtime versions.

    :param value:
    :type value: list[~azure.mgmt.servicefabric.models.ClusterCodeVersionsResult]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ClusterCodeVersionsResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterCodeVersionsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ClusterCodeVersionsResult(msrest.serialization.Model):
    """The result of the Service Fabric runtime versions.

    :param id: The identification of the result.
    :type id: str
    :param name: The name of the result.
    :type name: str
    :param type: The result resource type.
    :type type: str
    :param code_version: The Service Fabric runtime version of the cluster.
    :type code_version: str
    :param support_expiry_utc: The date of expiry of support of the version.
    :type support_expiry_utc: str
    :param environment: Indicates if this version is for Windows or Linux operating system.
     Possible values include: "Windows", "Linux".
    :type environment: str or ~azure.mgmt.servicefabric.models.ClusterEnvironment
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'code_version': {'key': 'properties.codeVersion', 'type': 'str'},
        'support_expiry_utc': {'key': 'properties.supportExpiryUtc', 'type': 'str'},
        'environment': {'key': 'properties.environment', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterCodeVersionsResult, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.code_version = kwargs.get('code_version', None)
        self.support_expiry_utc = kwargs.get('support_expiry_utc', None)
        self.environment = kwargs.get('environment', None)


class ClusterHealthPolicy(msrest.serialization.Model):
    """Defines a health policy used to evaluate the health of the cluster or of a cluster node.

    :param max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before
     reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
    
     The percentage represents the maximum tolerated percentage of nodes that can be unhealthy
     before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy node, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy nodes over the total number
     of nodes in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default
     percentage is zero.
    
     In large clusters, some nodes will always be down or out for repairs, so this percentage
     should be configured to tolerate that.
    :type max_percent_unhealthy_nodes: int
    :param max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy
     applications before reporting an error. For example, to allow 10% of applications to be
     unhealthy, this value would be 10.
    
     The percentage represents the maximum tolerated percentage of applications that can be
     unhealthy before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy application, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy applications over the total number of
     application instances in the cluster, excluding applications of application types that are
     included in the ApplicationTypeHealthPolicyMap.
     The computation rounds up to tolerate one failure on small numbers of applications. Default
     percentage is zero.
    :type max_percent_unhealthy_applications: int
    :param application_health_policies: Defines the application health policy map used to evaluate
     the health of an application or one of its children entities.
    :type application_health_policies: dict[str,
     ~azure.mgmt.servicefabric.models.ApplicationHealthPolicy]
    """

    _validation = {
        'max_percent_unhealthy_nodes': {'maximum': 100, 'minimum': 0},
        'max_percent_unhealthy_applications': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_unhealthy_nodes': {'key': 'maxPercentUnhealthyNodes', 'type': 'int'},
        'max_percent_unhealthy_applications': {'key': 'maxPercentUnhealthyApplications', 'type': 'int'},
        'application_health_policies': {'key': 'applicationHealthPolicies', 'type': '{ApplicationHealthPolicy}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterHealthPolicy, self).__init__(**kwargs)
        self.max_percent_unhealthy_nodes = kwargs.get('max_percent_unhealthy_nodes', 0)
        self.max_percent_unhealthy_applications = kwargs.get('max_percent_unhealthy_applications', 0)
        self.application_health_policies = kwargs.get('application_health_policies', None)


class ClusterListResult(msrest.serialization.Model):
    """Cluster list results.

    :param value:
    :type value: list[~azure.mgmt.servicefabric.models.Cluster]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ClusterUpdateParameters(msrest.serialization.Model):
    """Cluster update request.

    :param tags: A set of tags. Cluster update parameters.
    :type tags: dict[str, str]
    :param add_on_features: The list of add-on features to enable in the cluster.
    :type add_on_features: list[str or ~azure.mgmt.servicefabric.models.AddOnFeatures]
    :param certificate: The certificate to use for securing the cluster. The certificate provided
     will be used for  node to node security within the cluster, SSL certificate for cluster
     management endpoint and default  admin client.
    :type certificate: ~azure.mgmt.servicefabric.models.CertificateDescription
    :param certificate_common_names: Describes a list of server certificates referenced by common
     name that are used to secure the cluster.
    :type certificate_common_names: ~azure.mgmt.servicefabric.models.ServerCertificateCommonNames
    :param client_certificate_common_names: The list of client certificates referenced by common
     name that are allowed to manage the cluster. This will overwrite the existing list.
    :type client_certificate_common_names:
     list[~azure.mgmt.servicefabric.models.ClientCertificateCommonName]
    :param client_certificate_thumbprints: The list of client certificates referenced by thumbprint
     that are allowed to manage the cluster. This will overwrite the existing list.
    :type client_certificate_thumbprints:
     list[~azure.mgmt.servicefabric.models.ClientCertificateThumbprint]
    :param cluster_code_version: The Service Fabric runtime version of the cluster. This property
     can only by set the user when **upgradeMode** is set to 'Manual'. To get list of available
     Service Fabric versions for new clusters use `ClusterVersion API <./ClusterVersion.md>`_. To
     get the list of available version for existing clusters use **availableClusterVersions**.
    :type cluster_code_version: str
    :param event_store_service_enabled: Indicates if the event store service is enabled.
    :type event_store_service_enabled: bool
    :param fabric_settings: The list of custom fabric settings to configure the cluster. This will
     overwrite the existing list.
    :type fabric_settings: list[~azure.mgmt.servicefabric.models.SettingsSectionDescription]
    :param node_types: The list of node types in the cluster. This will overwrite the existing
     list.
    :type node_types: list[~azure.mgmt.servicefabric.models.NodeTypeDescription]
    :param reliability_level: The reliability level sets the replica set size of system services.
     Learn about `ReliabilityLevel
     <https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity>`_.
    
    
     * None - Run the System services with a target replica set count of 1. This should only be
     used for test clusters.
     * Bronze - Run the System services with a target replica set count of 3. This should only be
     used for test clusters.
     * Silver - Run the System services with a target replica set count of 5.
     * Gold - Run the System services with a target replica set count of 7.
     * Platinum - Run the System services with a target replica set count of 9. Possible values
     include: "None", "Bronze", "Silver", "Gold", "Platinum".
    :type reliability_level: str or ~azure.mgmt.servicefabric.models.ReliabilityLevel
    :param reverse_proxy_certificate: The server certificate used by reverse proxy.
    :type reverse_proxy_certificate: ~azure.mgmt.servicefabric.models.CertificateDescription
    :param upgrade_description: The policy to use when upgrading the cluster.
    :type upgrade_description: ~azure.mgmt.servicefabric.models.ClusterUpgradePolicy
    :param application_type_versions_cleanup_policy: The policy used to clean up unused versions.
    :type application_type_versions_cleanup_policy:
     ~azure.mgmt.servicefabric.models.ApplicationTypeVersionsCleanupPolicy
    :param upgrade_mode: The upgrade mode of the cluster when new Service Fabric runtime version is
     available. Possible values include: "Automatic", "Manual". Default value: "Automatic".
    :type upgrade_mode: str or ~azure.mgmt.servicefabric.models.UpgradeMode
    :param sf_zonal_upgrade_mode: This property controls the logical grouping of VMs in upgrade
     domains (UDs). This property can't be modified if a node type with multiple Availability Zones
     is already present in the cluster. Possible values include: "Parallel", "Hierarchical".
    :type sf_zonal_upgrade_mode: str or ~azure.mgmt.servicefabric.models.SfZonalUpgradeMode
    :param vmss_zonal_upgrade_mode: This property defines the upgrade mode for the virtual machine
     scale set, it is mandatory if a node type with multiple Availability Zones is added. Possible
     values include: "Parallel", "Hierarchical".
    :type vmss_zonal_upgrade_mode: str or ~azure.mgmt.servicefabric.models.VmssZonalUpgradeMode
    :param infrastructure_service_manager: Indicates if infrastructure service manager is enabled.
    :type infrastructure_service_manager: bool
    :param upgrade_wave: Indicates when new cluster runtime version upgrades will be applied after
     they are released. By default is Wave0. Only applies when **upgradeMode** is set to
     'Automatic'. Possible values include: "Wave0", "Wave1", "Wave2".
    :type upgrade_wave: str or ~azure.mgmt.servicefabric.models.ClusterUpgradeCadence
    :param upgrade_pause_start_timestamp_utc: The start timestamp to pause runtime version upgrades
     on the cluster (UTC).
    :type upgrade_pause_start_timestamp_utc: ~datetime.datetime
    :param upgrade_pause_end_timestamp_utc: The end timestamp of pause runtime version upgrades on
     the cluster (UTC).
    :type upgrade_pause_end_timestamp_utc: ~datetime.datetime
    :param wave_upgrade_paused: Boolean to pause automatic runtime version upgrades to the cluster.
    :type wave_upgrade_paused: bool
    :param notifications: Indicates a list of notification channels for cluster events.
    :type notifications: list[~azure.mgmt.servicefabric.models.Notification]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'add_on_features': {'key': 'properties.addOnFeatures', 'type': '[str]'},
        'certificate': {'key': 'properties.certificate', 'type': 'CertificateDescription'},
        'certificate_common_names': {'key': 'properties.certificateCommonNames', 'type': 'ServerCertificateCommonNames'},
        'client_certificate_common_names': {'key': 'properties.clientCertificateCommonNames', 'type': '[ClientCertificateCommonName]'},
        'client_certificate_thumbprints': {'key': 'properties.clientCertificateThumbprints', 'type': '[ClientCertificateThumbprint]'},
        'cluster_code_version': {'key': 'properties.clusterCodeVersion', 'type': 'str'},
        'event_store_service_enabled': {'key': 'properties.eventStoreServiceEnabled', 'type': 'bool'},
        'fabric_settings': {'key': 'properties.fabricSettings', 'type': '[SettingsSectionDescription]'},
        'node_types': {'key': 'properties.nodeTypes', 'type': '[NodeTypeDescription]'},
        'reliability_level': {'key': 'properties.reliabilityLevel', 'type': 'str'},
        'reverse_proxy_certificate': {'key': 'properties.reverseProxyCertificate', 'type': 'CertificateDescription'},
        'upgrade_description': {'key': 'properties.upgradeDescription', 'type': 'ClusterUpgradePolicy'},
        'application_type_versions_cleanup_policy': {'key': 'properties.applicationTypeVersionsCleanupPolicy', 'type': 'ApplicationTypeVersionsCleanupPolicy'},
        'upgrade_mode': {'key': 'properties.upgradeMode', 'type': 'str'},
        'sf_zonal_upgrade_mode': {'key': 'properties.sfZonalUpgradeMode', 'type': 'str'},
        'vmss_zonal_upgrade_mode': {'key': 'properties.vmssZonalUpgradeMode', 'type': 'str'},
        'infrastructure_service_manager': {'key': 'properties.infrastructureServiceManager', 'type': 'bool'},
        'upgrade_wave': {'key': 'properties.upgradeWave', 'type': 'str'},
        'upgrade_pause_start_timestamp_utc': {'key': 'properties.upgradePauseStartTimestampUtc', 'type': 'iso-8601'},
        'upgrade_pause_end_timestamp_utc': {'key': 'properties.upgradePauseEndTimestampUtc', 'type': 'iso-8601'},
        'wave_upgrade_paused': {'key': 'properties.waveUpgradePaused', 'type': 'bool'},
        'notifications': {'key': 'properties.notifications', 'type': '[Notification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.add_on_features = kwargs.get('add_on_features', None)
        self.certificate = kwargs.get('certificate', None)
        self.certificate_common_names = kwargs.get('certificate_common_names', None)
        self.client_certificate_common_names = kwargs.get('client_certificate_common_names', None)
        self.client_certificate_thumbprints = kwargs.get('client_certificate_thumbprints', None)
        self.cluster_code_version = kwargs.get('cluster_code_version', None)
        self.event_store_service_enabled = kwargs.get('event_store_service_enabled', None)
        self.fabric_settings = kwargs.get('fabric_settings', None)
        self.node_types = kwargs.get('node_types', None)
        self.reliability_level = kwargs.get('reliability_level', None)
        self.reverse_proxy_certificate = kwargs.get('reverse_proxy_certificate', None)
        self.upgrade_description = kwargs.get('upgrade_description', None)
        self.application_type_versions_cleanup_policy = kwargs.get('application_type_versions_cleanup_policy', None)
        self.upgrade_mode = kwargs.get('upgrade_mode', "Automatic")
        self.sf_zonal_upgrade_mode = kwargs.get('sf_zonal_upgrade_mode', None)
        self.vmss_zonal_upgrade_mode = kwargs.get('vmss_zonal_upgrade_mode', None)
        self.infrastructure_service_manager = kwargs.get('infrastructure_service_manager', None)
        self.upgrade_wave = kwargs.get('upgrade_wave', None)
        self.upgrade_pause_start_timestamp_utc = kwargs.get('upgrade_pause_start_timestamp_utc', None)
        self.upgrade_pause_end_timestamp_utc = kwargs.get('upgrade_pause_end_timestamp_utc', None)
        self.wave_upgrade_paused = kwargs.get('wave_upgrade_paused', None)
        self.notifications = kwargs.get('notifications', None)


class ClusterUpgradeDeltaHealthPolicy(msrest.serialization.Model):
    """Describes the delta health policies for the cluster upgrade.

    All required parameters must be populated in order to send to Azure.

    :param max_percent_delta_unhealthy_nodes: Required. The maximum allowed percentage of nodes
     health degradation allowed during cluster upgrades.
     The delta is measured between the state of the nodes at the beginning of upgrade and the state
     of the nodes at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion to make sure the global
     state of the cluster is within tolerated limits.
    :type max_percent_delta_unhealthy_nodes: int
    :param max_percent_upgrade_domain_delta_unhealthy_nodes: Required. The maximum allowed
     percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
     The delta is measured between the state of the upgrade domain nodes at the beginning of
     upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion for all completed upgrade
     domains to make sure the state of the upgrade domains is within tolerated limits.
    :type max_percent_upgrade_domain_delta_unhealthy_nodes: int
    :param max_percent_delta_unhealthy_applications: Required. The maximum allowed percentage of
     applications health degradation allowed during cluster upgrades.
     The delta is measured between the state of the applications at the beginning of upgrade and
     the state of the applications at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion to make sure the global
     state of the cluster is within tolerated limits. System services are not included in this.
    :type max_percent_delta_unhealthy_applications: int
    :param application_delta_health_policies: Defines the application delta health policy map used
     to evaluate the health of an application or one of its child entities when upgrading the
     cluster.
    :type application_delta_health_policies: dict[str,
     ~azure.mgmt.servicefabric.models.ApplicationDeltaHealthPolicy]
    """

    _validation = {
        'max_percent_delta_unhealthy_nodes': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_upgrade_domain_delta_unhealthy_nodes': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_delta_unhealthy_applications': {'required': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_delta_unhealthy_nodes': {'key': 'maxPercentDeltaUnhealthyNodes', 'type': 'int'},
        'max_percent_upgrade_domain_delta_unhealthy_nodes': {'key': 'maxPercentUpgradeDomainDeltaUnhealthyNodes', 'type': 'int'},
        'max_percent_delta_unhealthy_applications': {'key': 'maxPercentDeltaUnhealthyApplications', 'type': 'int'},
        'application_delta_health_policies': {'key': 'applicationDeltaHealthPolicies', 'type': '{ApplicationDeltaHealthPolicy}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterUpgradeDeltaHealthPolicy, self).__init__(**kwargs)
        self.max_percent_delta_unhealthy_nodes = kwargs['max_percent_delta_unhealthy_nodes']
        self.max_percent_upgrade_domain_delta_unhealthy_nodes = kwargs['max_percent_upgrade_domain_delta_unhealthy_nodes']
        self.max_percent_delta_unhealthy_applications = kwargs['max_percent_delta_unhealthy_applications']
        self.application_delta_health_policies = kwargs.get('application_delta_health_policies', None)


class ClusterUpgradePolicy(msrest.serialization.Model):
    """Describes the policy used when upgrading the cluster.

    All required parameters must be populated in order to send to Azure.

    :param force_restart: If true, then processes are forcefully restarted during upgrade even when
     the code version has not changed (the upgrade only changes configuration or data).
    :type force_restart: bool
    :param upgrade_replica_set_check_timeout: Required. The maximum amount of time to block
     processing of an upgrade domain and prevent loss of availability when there are unexpected
     issues. When this timeout expires, processing of the upgrade domain will proceed regardless of
     availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout
     can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
    :type upgrade_replica_set_check_timeout: str
    :param health_check_wait_duration: Required. The length of time to wait after completing an
     upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in
     d.hh:mm:ss.ms format.
    :type health_check_wait_duration: str
    :param health_check_stable_duration: Required. The amount of time that the application or
     cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The
     duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
    :type health_check_stable_duration: str
    :param health_check_retry_timeout: Required. The amount of time to retry health evaluation when
     the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in
     either hh:mm:ss or in d.hh:mm:ss.ms format.
    :type health_check_retry_timeout: str
    :param upgrade_timeout: Required. The amount of time the overall upgrade has to complete before
     the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
    :type upgrade_timeout: str
    :param upgrade_domain_timeout: Required. The amount of time each upgrade domain has to complete
     before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms
     format.
    :type upgrade_domain_timeout: str
    :param health_policy: Required. The cluster health policy used when upgrading the cluster.
    :type health_policy: ~azure.mgmt.servicefabric.models.ClusterHealthPolicy
    :param delta_health_policy: The cluster delta health policy used when upgrading the cluster.
    :type delta_health_policy: ~azure.mgmt.servicefabric.models.ClusterUpgradeDeltaHealthPolicy
    """

    _validation = {
        'upgrade_replica_set_check_timeout': {'required': True},
        'health_check_wait_duration': {'required': True},
        'health_check_stable_duration': {'required': True},
        'health_check_retry_timeout': {'required': True},
        'upgrade_timeout': {'required': True},
        'upgrade_domain_timeout': {'required': True},
        'health_policy': {'required': True},
    }

    _attribute_map = {
        'force_restart': {'key': 'forceRestart', 'type': 'bool'},
        'upgrade_replica_set_check_timeout': {'key': 'upgradeReplicaSetCheckTimeout', 'type': 'str'},
        'health_check_wait_duration': {'key': 'healthCheckWaitDuration', 'type': 'str'},
        'health_check_stable_duration': {'key': 'healthCheckStableDuration', 'type': 'str'},
        'health_check_retry_timeout': {'key': 'healthCheckRetryTimeout', 'type': 'str'},
        'upgrade_timeout': {'key': 'upgradeTimeout', 'type': 'str'},
        'upgrade_domain_timeout': {'key': 'upgradeDomainTimeout', 'type': 'str'},
        'health_policy': {'key': 'healthPolicy', 'type': 'ClusterHealthPolicy'},
        'delta_health_policy': {'key': 'deltaHealthPolicy', 'type': 'ClusterUpgradeDeltaHealthPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterUpgradePolicy, self).__init__(**kwargs)
        self.force_restart = kwargs.get('force_restart', None)
        self.upgrade_replica_set_check_timeout = kwargs['upgrade_replica_set_check_timeout']
        self.health_check_wait_duration = kwargs['health_check_wait_duration']
        self.health_check_stable_duration = kwargs['health_check_stable_duration']
        self.health_check_retry_timeout = kwargs['health_check_retry_timeout']
        self.upgrade_timeout = kwargs['upgrade_timeout']
        self.upgrade_domain_timeout = kwargs['upgrade_domain_timeout']
        self.health_policy = kwargs['health_policy']
        self.delta_health_policy = kwargs.get('delta_health_policy', None)


class ClusterVersionDetails(msrest.serialization.Model):
    """The detail of the Service Fabric runtime version result.

    :param code_version: The Service Fabric runtime version of the cluster.
    :type code_version: str
    :param support_expiry_utc: The date of expiry of support of the version.
    :type support_expiry_utc: str
    :param environment: Indicates if this version is for Windows or Linux operating system.
     Possible values include: "Windows", "Linux".
    :type environment: str or ~azure.mgmt.servicefabric.models.ClusterEnvironment
    """

    _attribute_map = {
        'code_version': {'key': 'codeVersion', 'type': 'str'},
        'support_expiry_utc': {'key': 'supportExpiryUtc', 'type': 'str'},
        'environment': {'key': 'environment', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterVersionDetails, self).__init__(**kwargs)
        self.code_version = kwargs.get('code_version', None)
        self.support_expiry_utc = kwargs.get('support_expiry_utc', None)
        self.environment = kwargs.get('environment', None)


class DiagnosticsStorageAccountConfig(msrest.serialization.Model):
    """The storage account information for storing Service Fabric diagnostic logs.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_name: Required. The Azure storage account name.
    :type storage_account_name: str
    :param protected_account_key_name: Required. The protected diagnostics storage key name.
    :type protected_account_key_name: str
    :param protected_account_key_name2: The secondary protected diagnostics storage key name. If
     one of the storage account keys is rotated the cluster will fallback to using the other.
    :type protected_account_key_name2: str
    :param blob_endpoint: Required. The blob endpoint of the azure storage account.
    :type blob_endpoint: str
    :param queue_endpoint: Required. The queue endpoint of the azure storage account.
    :type queue_endpoint: str
    :param table_endpoint: Required. The table endpoint of the azure storage account.
    :type table_endpoint: str
    """

    _validation = {
        'storage_account_name': {'required': True},
        'protected_account_key_name': {'required': True},
        'blob_endpoint': {'required': True},
        'queue_endpoint': {'required': True},
        'table_endpoint': {'required': True},
    }

    _attribute_map = {
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'protected_account_key_name': {'key': 'protectedAccountKeyName', 'type': 'str'},
        'protected_account_key_name2': {'key': 'protectedAccountKeyName2', 'type': 'str'},
        'blob_endpoint': {'key': 'blobEndpoint', 'type': 'str'},
        'queue_endpoint': {'key': 'queueEndpoint', 'type': 'str'},
        'table_endpoint': {'key': 'tableEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticsStorageAccountConfig, self).__init__(**kwargs)
        self.storage_account_name = kwargs['storage_account_name']
        self.protected_account_key_name = kwargs['protected_account_key_name']
        self.protected_account_key_name2 = kwargs.get('protected_account_key_name2', None)
        self.blob_endpoint = kwargs['blob_endpoint']
        self.queue_endpoint = kwargs['queue_endpoint']
        self.table_endpoint = kwargs['table_endpoint']


class EndpointRangeDescription(msrest.serialization.Model):
    """Port range details.

    All required parameters must be populated in order to send to Azure.

    :param start_port: Required. Starting port of a range of ports.
    :type start_port: int
    :param end_port: Required. End port of a range of ports.
    :type end_port: int
    """

    _validation = {
        'start_port': {'required': True},
        'end_port': {'required': True},
    }

    _attribute_map = {
        'start_port': {'key': 'startPort', 'type': 'int'},
        'end_port': {'key': 'endPort', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointRangeDescription, self).__init__(**kwargs)
        self.start_port = kwargs['start_port']
        self.end_port = kwargs['end_port']


class ErrorModel(msrest.serialization.Model):
    """The structure of the error.

    :param error: The error details.
    :type error: ~azure.mgmt.servicefabric.models.ErrorModelError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorModelError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorModel, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorModelError(msrest.serialization.Model):
    """The error details.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorModelError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ManagedIdentity(msrest.serialization.Model):
    """Describes the managed identities for an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the managed identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the managed identity. This property will only be provided for
     a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of managed identity for the resource. Possible values include:
     "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.servicefabric.models.ManagedIdentityType
    :param user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.servicefabric.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class PartitionSchemeDescription(msrest.serialization.Model):
    """Describes how the service is partitioned.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NamedPartitionSchemeDescription, SingletonPartitionSchemeDescription, UniformInt64RangePartitionSchemeDescription.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Invalid", "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or ~azure.mgmt.servicefabric.models.PartitionScheme
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
    }

    _subtype_map = {
        'partition_scheme': {'Named': 'NamedPartitionSchemeDescription', 'Singleton': 'SingletonPartitionSchemeDescription', 'UniformInt64Range': 'UniformInt64RangePartitionSchemeDescription'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PartitionSchemeDescription, self).__init__(**kwargs)
        self.partition_scheme = None  # type: Optional[str]


class NamedPartitionSchemeDescription(PartitionSchemeDescription):
    """Describes the named partition scheme of the service.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Invalid", "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or ~azure.mgmt.servicefabric.models.PartitionScheme
    :param count: Required. The number of partitions.
    :type count: int
    :param names: Required. Array of size specified by the ‘count’ parameter, for the names of the
     partitions.
    :type names: list[str]
    """

    _validation = {
        'partition_scheme': {'required': True},
        'count': {'required': True},
        'names': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'names': {'key': 'names', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedPartitionSchemeDescription, self).__init__(**kwargs)
        self.partition_scheme = 'Named'  # type: str
        self.count = kwargs['count']
        self.names = kwargs['names']


class NodeTypeDescription(msrest.serialization.Model):
    """Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the node type.
    :type name: str
    :param placement_properties: The placement tags applied to nodes in the node type, which can be
     used to indicate where certain services (workload) should run.
    :type placement_properties: dict[str, str]
    :param capacities: The capacity tags applied to the nodes in the node type, the cluster
     resource manager uses these tags to understand how much resource a node has.
    :type capacities: dict[str, str]
    :param client_connection_endpoint_port: Required. The TCP cluster management endpoint port.
    :type client_connection_endpoint_port: int
    :param http_gateway_endpoint_port: Required. The HTTP cluster management endpoint port.
    :type http_gateway_endpoint_port: int
    :param durability_level: The durability level of the node type. Learn about `DurabilityLevel
     <https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity>`_.
    
    
     * Bronze - No privileges. This is the default.
     * Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
     * Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold
     durability can be enabled only on full node VM skus like D15_V2, G5 etc. Possible values
     include: "Bronze", "Silver", "Gold".
    :type durability_level: str or ~azure.mgmt.servicefabric.models.DurabilityLevel
    :param application_ports: The range of ports from which cluster assigned port to Service Fabric
     applications.
    :type application_ports: ~azure.mgmt.servicefabric.models.EndpointRangeDescription
    :param ephemeral_ports: The range of ephemeral ports that nodes in this node type should be
     configured with.
    :type ephemeral_ports: ~azure.mgmt.servicefabric.models.EndpointRangeDescription
    :param is_primary: Required. The node type on which system services will run. Only one node
     type should be marked as primary. Primary node type cannot be deleted or changed for existing
     clusters.
    :type is_primary: bool
    :param vm_instance_count: Required. VMInstanceCount should be 1 to n, where n indicates the
     number of VM instances corresponding to this nodeType. VMInstanceCount = 0 can be done only in
     these scenarios: NodeType is a secondary nodeType. Durability = Bronze or Durability >= Bronze
     and InfrastructureServiceManager = true. If VMInstanceCount = 0, implies the VMs for this
     nodeType will not be used for the initial cluster size computation.
    :type vm_instance_count: int
    :param reverse_proxy_endpoint_port: The endpoint used by reverse proxy.
    :type reverse_proxy_endpoint_port: int
    :param is_stateless: Indicates if the node type can only host Stateless workloads.
    :type is_stateless: bool
    :param multiple_availability_zones: Indicates if the node type is enabled to support multiple
     zones.
    :type multiple_availability_zones: bool
    """

    _validation = {
        'name': {'required': True},
        'client_connection_endpoint_port': {'required': True},
        'http_gateway_endpoint_port': {'required': True},
        'is_primary': {'required': True},
        'vm_instance_count': {'required': True, 'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'placement_properties': {'key': 'placementProperties', 'type': '{str}'},
        'capacities': {'key': 'capacities', 'type': '{str}'},
        'client_connection_endpoint_port': {'key': 'clientConnectionEndpointPort', 'type': 'int'},
        'http_gateway_endpoint_port': {'key': 'httpGatewayEndpointPort', 'type': 'int'},
        'durability_level': {'key': 'durabilityLevel', 'type': 'str'},
        'application_ports': {'key': 'applicationPorts', 'type': 'EndpointRangeDescription'},
        'ephemeral_ports': {'key': 'ephemeralPorts', 'type': 'EndpointRangeDescription'},
        'is_primary': {'key': 'isPrimary', 'type': 'bool'},
        'vm_instance_count': {'key': 'vmInstanceCount', 'type': 'int'},
        'reverse_proxy_endpoint_port': {'key': 'reverseProxyEndpointPort', 'type': 'int'},
        'is_stateless': {'key': 'isStateless', 'type': 'bool'},
        'multiple_availability_zones': {'key': 'multipleAvailabilityZones', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeTypeDescription, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.placement_properties = kwargs.get('placement_properties', None)
        self.capacities = kwargs.get('capacities', None)
        self.client_connection_endpoint_port = kwargs['client_connection_endpoint_port']
        self.http_gateway_endpoint_port = kwargs['http_gateway_endpoint_port']
        self.durability_level = kwargs.get('durability_level', None)
        self.application_ports = kwargs.get('application_ports', None)
        self.ephemeral_ports = kwargs.get('ephemeral_ports', None)
        self.is_primary = kwargs['is_primary']
        self.vm_instance_count = kwargs['vm_instance_count']
        self.reverse_proxy_endpoint_port = kwargs.get('reverse_proxy_endpoint_port', None)
        self.is_stateless = kwargs.get('is_stateless', None)
        self.multiple_availability_zones = kwargs.get('multiple_availability_zones', None)


class Notification(msrest.serialization.Model):
    """Describes the notification channel for cluster events.

    All required parameters must be populated in order to send to Azure.

    :param is_enabled: Required. Indicates if the notification is enabled.
    :type is_enabled: bool
    :param notification_category: Required. The category of notification. Possible values include:
     "WaveProgress".
    :type notification_category: str or ~azure.mgmt.servicefabric.models.NotificationCategory
    :param notification_level: Required. The level of notification. Possible values include:
     "Critical", "All".
    :type notification_level: str or ~azure.mgmt.servicefabric.models.NotificationLevel
    :param notification_targets: Required. List of targets that subscribe to the notification.
    :type notification_targets: list[~azure.mgmt.servicefabric.models.NotificationTarget]
    """

    _validation = {
        'is_enabled': {'required': True},
        'notification_category': {'required': True},
        'notification_level': {'required': True},
        'notification_targets': {'required': True},
    }

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'notification_category': {'key': 'notificationCategory', 'type': 'str'},
        'notification_level': {'key': 'notificationLevel', 'type': 'str'},
        'notification_targets': {'key': 'notificationTargets', 'type': '[NotificationTarget]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Notification, self).__init__(**kwargs)
        self.is_enabled = kwargs['is_enabled']
        self.notification_category = kwargs['notification_category']
        self.notification_level = kwargs['notification_level']
        self.notification_targets = kwargs['notification_targets']


class NotificationTarget(msrest.serialization.Model):
    """Describes the notification target properties.

    All required parameters must be populated in order to send to Azure.

    :param notification_channel: Required. The notification channel indicates the type of receivers
     subscribed to the notification, either user or subscription. Possible values include:
     "EmailUser", "EmailSubscription".
    :type notification_channel: str or ~azure.mgmt.servicefabric.models.NotificationChannel
    :param receivers: Required. List of targets that subscribe to the notification.
    :type receivers: list[str]
    """

    _validation = {
        'notification_channel': {'required': True},
        'receivers': {'required': True},
    }

    _attribute_map = {
        'notification_channel': {'key': 'notificationChannel', 'type': 'str'},
        'receivers': {'key': 'receivers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotificationTarget, self).__init__(**kwargs)
        self.notification_channel = kwargs['notification_channel']
        self.receivers = kwargs['receivers']


class OperationListResult(msrest.serialization.Model):
    """Describes the result of the request to list Service Fabric resource provider operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by the Service Fabric resource provider.
    :type value: list[~azure.mgmt.servicefabric.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class OperationResult(msrest.serialization.Model):
    """Available operation list result.

    :param name: The name of the operation.
    :type name: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.servicefabric.models.AvailableOperationDisplay
    :param origin: Origin result.
    :type origin: str
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'AvailableOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResult, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.next_link = kwargs.get('next_link', None)


class ServerCertificateCommonName(msrest.serialization.Model):
    """Describes the server certificate details using common name.

    All required parameters must be populated in order to send to Azure.

    :param certificate_common_name: Required. The common name of the server certificate.
    :type certificate_common_name: str
    :param certificate_issuer_thumbprint: Required. The issuer thumbprint of the server
     certificate.
    :type certificate_issuer_thumbprint: str
    """

    _validation = {
        'certificate_common_name': {'required': True},
        'certificate_issuer_thumbprint': {'required': True},
    }

    _attribute_map = {
        'certificate_common_name': {'key': 'certificateCommonName', 'type': 'str'},
        'certificate_issuer_thumbprint': {'key': 'certificateIssuerThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerCertificateCommonName, self).__init__(**kwargs)
        self.certificate_common_name = kwargs['certificate_common_name']
        self.certificate_issuer_thumbprint = kwargs['certificate_issuer_thumbprint']


class ServerCertificateCommonNames(msrest.serialization.Model):
    """Describes a list of server certificates referenced by common name that are used to secure the cluster.

    :param common_names: The list of server certificates referenced by common name that are used to
     secure the cluster.
    :type common_names: list[~azure.mgmt.servicefabric.models.ServerCertificateCommonName]
    :param x509_store_name: The local certificate store location. Possible values include:
     "AddressBook", "AuthRoot", "CertificateAuthority", "Disallowed", "My", "Root", "TrustedPeople",
     "TrustedPublisher".
    :type x509_store_name: str or ~azure.mgmt.servicefabric.models.StoreName
    """

    _attribute_map = {
        'common_names': {'key': 'commonNames', 'type': '[ServerCertificateCommonName]'},
        'x509_store_name': {'key': 'x509StoreName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerCertificateCommonNames, self).__init__(**kwargs)
        self.common_names = kwargs.get('common_names', None)
        self.x509_store_name = kwargs.get('x509_store_name', None)


class ServiceCorrelationDescription(msrest.serialization.Model):
    """Creates a particular correlation between services.

    All required parameters must be populated in order to send to Azure.

    :param scheme: Required. The ServiceCorrelationScheme which describes the relationship between
     this service and the service specified via ServiceName. Possible values include: "Invalid",
     "Affinity", "AlignedAffinity", "NonAlignedAffinity".
    :type scheme: str or ~azure.mgmt.servicefabric.models.ServiceCorrelationScheme
    :param service_name: Required. The name of the service that the correlation relationship is
     established with.
    :type service_name: str
    """

    _validation = {
        'scheme': {'required': True},
        'service_name': {'required': True},
    }

    _attribute_map = {
        'scheme': {'key': 'scheme', 'type': 'str'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceCorrelationDescription, self).__init__(**kwargs)
        self.scheme = kwargs['scheme']
        self.service_name = kwargs['service_name']


class ServiceLoadMetricDescription(msrest.serialization.Model):
    """Specifies a metric to load balance a service during runtime.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the metric. If the service chooses to report load during
     runtime, the load metric name should match the name that is specified in Name exactly. Note
     that metric names are case sensitive.
    :type name: str
    :param weight: The service load metric relative weight, compared to other metrics configured
     for this service, as a number. Possible values include: "Zero", "Low", "Medium", "High".
    :type weight: str or ~azure.mgmt.servicefabric.models.ServiceLoadMetricWeight
    :param primary_default_load: Used only for Stateful services. The default amount of load, as a
     number, that this service creates for this metric when it is a Primary replica.
    :type primary_default_load: int
    :param secondary_default_load: Used only for Stateful services. The default amount of load, as
     a number, that this service creates for this metric when it is a Secondary replica.
    :type secondary_default_load: int
    :param default_load: Used only for Stateless services. The default amount of load, as a number,
     that this service creates for this metric.
    :type default_load: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'str'},
        'primary_default_load': {'key': 'primaryDefaultLoad', 'type': 'int'},
        'secondary_default_load': {'key': 'secondaryDefaultLoad', 'type': 'int'},
        'default_load': {'key': 'defaultLoad', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceLoadMetricDescription, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.weight = kwargs.get('weight', None)
        self.primary_default_load = kwargs.get('primary_default_load', None)
        self.secondary_default_load = kwargs.get('secondary_default_load', None)
        self.default_load = kwargs.get('default_load', None)


class ServicePlacementPolicyDescription(msrest.serialization.Model):
    """Describes the policy to be used for placement of a Service Fabric service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: .

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server.  Possible values include: "Invalid",
     "InvalidDomain", "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :type type: str or ~azure.mgmt.servicefabric.models.ServicePlacementPolicyType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicePlacementPolicyDescription, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class ServiceResource(ProxyResource):
    """The service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: It will be deprecated in New API, resource location depends on the parent
     resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param service_kind: The kind of service (Stateless or Stateful).Constant filled by server.
     Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    :param service_type_name: The name of the service type.
    :type service_type_name: str
    :param partition_description: Describes how the service is partitioned.
    :type partition_description: ~azure.mgmt.servicefabric.models.PartitionSchemeDescription
    :param service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :type service_package_activation_mode: str or
     ~azure.mgmt.servicefabric.models.ArmServicePackageActivationMode
    :param service_dns_name: Dns name used for the service. If this is specified, then the service
     can be accessed via its DNS name instead of service name.
    :type service_dns_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'placement_constraints': {'key': 'properties.placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'properties.correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'properties.serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'properties.servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'properties.defaultMoveCost', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'service_kind': {'key': 'properties.serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'properties.serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'properties.partitionDescription', 'type': 'PartitionSchemeDescription'},
        'service_package_activation_mode': {'key': 'properties.servicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'properties.serviceDnsName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResource, self).__init__(**kwargs)
        self.placement_constraints = kwargs.get('placement_constraints', None)
        self.correlation_scheme = kwargs.get('correlation_scheme', None)
        self.service_load_metrics = kwargs.get('service_load_metrics', None)
        self.service_placement_policies = kwargs.get('service_placement_policies', None)
        self.default_move_cost = kwargs.get('default_move_cost', None)
        self.provisioning_state = None
        self.service_kind = None  # type: Optional[str]
        self.service_type_name = kwargs.get('service_type_name', None)
        self.partition_description = kwargs.get('partition_description', None)
        self.service_package_activation_mode = kwargs.get('service_package_activation_mode', None)
        self.service_dns_name = kwargs.get('service_dns_name', None)


class ServiceResourceList(msrest.serialization.Model):
    """The list of service resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value: list[~azure.mgmt.servicefabric.models.ServiceResource]
    :ivar next_link: URL to get the next set of service list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ServiceResourcePropertiesBase(msrest.serialization.Model):
    """The common service resource properties.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    """

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResourcePropertiesBase, self).__init__(**kwargs)
        self.placement_constraints = kwargs.get('placement_constraints', None)
        self.correlation_scheme = kwargs.get('correlation_scheme', None)
        self.service_load_metrics = kwargs.get('service_load_metrics', None)
        self.service_placement_policies = kwargs.get('service_placement_policies', None)
        self.default_move_cost = kwargs.get('default_move_cost', None)


class ServiceResourceProperties(ServiceResourcePropertiesBase):
    """The service resource properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceProperties, StatelessServiceProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    :param service_type_name: The name of the service type.
    :type service_type_name: str
    :param partition_description: Describes how the service is partitioned.
    :type partition_description: ~azure.mgmt.servicefabric.models.PartitionSchemeDescription
    :param service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :type service_package_activation_mode: str or
     ~azure.mgmt.servicefabric.models.ArmServicePackageActivationMode
    :param service_dns_name: Dns name used for the service. If this is specified, then the service
     can be accessed via its DNS name instead of service name.
    :type service_dns_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'PartitionSchemeDescription'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'serviceDnsName', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceProperties', 'Stateless': 'StatelessServiceProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResourceProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.service_kind = 'ServiceResourceProperties'  # type: str
        self.service_type_name = kwargs.get('service_type_name', None)
        self.partition_description = kwargs.get('partition_description', None)
        self.service_package_activation_mode = kwargs.get('service_package_activation_mode', None)
        self.service_dns_name = kwargs.get('service_dns_name', None)


class ServiceResourceUpdate(ProxyResource):
    """The service resource for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: It will be deprecated in New API, resource location depends on the parent
     resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.servicefabric.models.SystemData
    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :param service_kind: The kind of service (Stateless or Stateful).Constant filled by server.
     Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'placement_constraints': {'key': 'properties.placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'properties.correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'properties.serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'properties.servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'properties.defaultMoveCost', 'type': 'str'},
        'service_kind': {'key': 'properties.serviceKind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResourceUpdate, self).__init__(**kwargs)
        self.placement_constraints = kwargs.get('placement_constraints', None)
        self.correlation_scheme = kwargs.get('correlation_scheme', None)
        self.service_load_metrics = kwargs.get('service_load_metrics', None)
        self.service_placement_policies = kwargs.get('service_placement_policies', None)
        self.default_move_cost = kwargs.get('default_move_cost', None)
        self.service_kind = None  # type: Optional[str]


class ServiceResourceUpdateProperties(ServiceResourcePropertiesBase):
    """The service resource properties for patch operations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceUpdateProperties, StatelessServiceUpdateProperties.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceUpdateProperties', 'Stateless': 'StatelessServiceUpdateProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResourceUpdateProperties, self).__init__(**kwargs)
        self.service_kind = 'ServiceResourceUpdateProperties'  # type: str


class ServiceTypeDeltaHealthPolicy(msrest.serialization.Model):
    """Represents the delta health policy used to evaluate the health of services belonging to a service type when upgrading the cluster.

    :param max_percent_delta_unhealthy_services: The maximum allowed percentage of services health
     degradation allowed during cluster upgrades.
     The delta is measured between the state of the services at the beginning of upgrade and the
     state of the services at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion to make sure the global
     state of the cluster is within tolerated limits.
    :type max_percent_delta_unhealthy_services: int
    """

    _validation = {
        'max_percent_delta_unhealthy_services': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_delta_unhealthy_services': {'key': 'maxPercentDeltaUnhealthyServices', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTypeDeltaHealthPolicy, self).__init__(**kwargs)
        self.max_percent_delta_unhealthy_services = kwargs.get('max_percent_delta_unhealthy_services', 0)


class ServiceTypeHealthPolicy(msrest.serialization.Model):
    """Represents the health policy used to evaluate the health of services belonging to a service type.

    :param max_percent_unhealthy_services: The maximum percentage of services allowed to be
     unhealthy before your application is considered in error.
    :type max_percent_unhealthy_services: int
    """

    _validation = {
        'max_percent_unhealthy_services': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_unhealthy_services': {'key': 'maxPercentUnhealthyServices', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTypeHealthPolicy, self).__init__(**kwargs)
        self.max_percent_unhealthy_services = kwargs.get('max_percent_unhealthy_services', 0)


class SettingsParameterDescription(msrest.serialization.Model):
    """Describes a parameter in fabric settings of the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name of fabric setting.
    :type name: str
    :param value: Required. The parameter value of fabric setting.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SettingsParameterDescription, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']


class SettingsSectionDescription(msrest.serialization.Model):
    """Describes a section in the fabric settings of the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The section name of the fabric settings.
    :type name: str
    :param parameters: Required. The collection of parameters in the section.
    :type parameters: list[~azure.mgmt.servicefabric.models.SettingsParameterDescription]
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[SettingsParameterDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SettingsSectionDescription, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.parameters = kwargs['parameters']


class SingletonPartitionSchemeDescription(PartitionSchemeDescription):
    """SingletonPartitionSchemeDescription.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Invalid", "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or ~azure.mgmt.servicefabric.models.PartitionScheme
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SingletonPartitionSchemeDescription, self).__init__(**kwargs)
        self.partition_scheme = 'Singleton'  # type: str


class StatefulServiceProperties(ServiceResourceProperties):
    """The properties of a stateful service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    :param service_type_name: The name of the service type.
    :type service_type_name: str
    :param partition_description: Describes how the service is partitioned.
    :type partition_description: ~azure.mgmt.servicefabric.models.PartitionSchemeDescription
    :param service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :type service_package_activation_mode: str or
     ~azure.mgmt.servicefabric.models.ArmServicePackageActivationMode
    :param service_dns_name: Dns name used for the service. If this is specified, then the service
     can be accessed via its DNS name instead of service name.
    :type service_dns_name: str
    :param has_persisted_state: A flag indicating whether this is a persistent service which stores
     states on the local disk. If it is then the value of this property is true, if not it is false.
    :type has_persisted_state: bool
    :param target_replica_set_size: The target replica set size as a number.
    :type target_replica_set_size: int
    :param min_replica_set_size: The minimum replica set size as a number.
    :type min_replica_set_size: int
    :param replica_restart_wait_duration: The duration between when a replica goes down and when a
     new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
    :type replica_restart_wait_duration: ~datetime.datetime
    :param quorum_loss_wait_duration: The maximum duration for which a partition is allowed to be
     in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
    :type quorum_loss_wait_duration: ~datetime.datetime
    :param stand_by_replica_keep_duration: The definition on how long StandBy replicas should be
     maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
    :type stand_by_replica_keep_duration: ~datetime.datetime
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'target_replica_set_size': {'minimum': 1},
        'min_replica_set_size': {'minimum': 1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'PartitionSchemeDescription'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'serviceDnsName', 'type': 'str'},
        'has_persisted_state': {'key': 'hasPersistedState', 'type': 'bool'},
        'target_replica_set_size': {'key': 'targetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'minReplicaSetSize', 'type': 'int'},
        'replica_restart_wait_duration': {'key': 'replicaRestartWaitDuration', 'type': 'iso-8601'},
        'quorum_loss_wait_duration': {'key': 'quorumLossWaitDuration', 'type': 'iso-8601'},
        'stand_by_replica_keep_duration': {'key': 'standByReplicaKeepDuration', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatefulServiceProperties, self).__init__(**kwargs)
        self.service_kind = 'Stateful'  # type: str
        self.has_persisted_state = kwargs.get('has_persisted_state', None)
        self.target_replica_set_size = kwargs.get('target_replica_set_size', None)
        self.min_replica_set_size = kwargs.get('min_replica_set_size', None)
        self.replica_restart_wait_duration = kwargs.get('replica_restart_wait_duration', None)
        self.quorum_loss_wait_duration = kwargs.get('quorum_loss_wait_duration', None)
        self.stand_by_replica_keep_duration = kwargs.get('stand_by_replica_keep_duration', None)


class StatefulServiceUpdateProperties(ServiceResourceUpdateProperties):
    """The properties of a stateful service resource for patch operations.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    :param target_replica_set_size: The target replica set size as a number.
    :type target_replica_set_size: int
    :param min_replica_set_size: The minimum replica set size as a number.
    :type min_replica_set_size: int
    :param replica_restart_wait_duration: The duration between when a replica goes down and when a
     new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
    :type replica_restart_wait_duration: ~datetime.datetime
    :param quorum_loss_wait_duration: The maximum duration for which a partition is allowed to be
     in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
    :type quorum_loss_wait_duration: ~datetime.datetime
    :param stand_by_replica_keep_duration: The definition on how long StandBy replicas should be
     maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
    :type stand_by_replica_keep_duration: ~datetime.datetime
    """

    _validation = {
        'service_kind': {'required': True},
        'target_replica_set_size': {'minimum': 1},
        'min_replica_set_size': {'minimum': 1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'target_replica_set_size': {'key': 'targetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'minReplicaSetSize', 'type': 'int'},
        'replica_restart_wait_duration': {'key': 'replicaRestartWaitDuration', 'type': 'iso-8601'},
        'quorum_loss_wait_duration': {'key': 'quorumLossWaitDuration', 'type': 'iso-8601'},
        'stand_by_replica_keep_duration': {'key': 'standByReplicaKeepDuration', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatefulServiceUpdateProperties, self).__init__(**kwargs)
        self.service_kind = 'Stateful'  # type: str
        self.target_replica_set_size = kwargs.get('target_replica_set_size', None)
        self.min_replica_set_size = kwargs.get('min_replica_set_size', None)
        self.replica_restart_wait_duration = kwargs.get('replica_restart_wait_duration', None)
        self.quorum_loss_wait_duration = kwargs.get('quorum_loss_wait_duration', None)
        self.stand_by_replica_keep_duration = kwargs.get('stand_by_replica_keep_duration', None)


class StatelessServiceProperties(ServiceResourceProperties):
    """The properties of a stateless service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    :param service_type_name: The name of the service type.
    :type service_type_name: str
    :param partition_description: Describes how the service is partitioned.
    :type partition_description: ~azure.mgmt.servicefabric.models.PartitionSchemeDescription
    :param service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :type service_package_activation_mode: str or
     ~azure.mgmt.servicefabric.models.ArmServicePackageActivationMode
    :param service_dns_name: Dns name used for the service. If this is specified, then the service
     can be accessed via its DNS name instead of service name.
    :type service_dns_name: str
    :param instance_count: The instance count.
    :type instance_count: int
    :param instance_close_delay_duration: Delay duration for RequestDrain feature to ensures that
     the endpoint advertised by the stateless instance is removed before the delay starts prior to
     closing the instance. This delay enables existing requests to drain gracefully before the
     instance actually goes down
     (https://docs.microsoft.com/en-us/azure/service-fabric/service-fabric-application-upgrade-advanced#avoid-connection-drops-during-stateless-service-planned-downtime-preview).
     It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it
     is interpreted as a number representing the total number of milliseconds.
    :type instance_close_delay_duration: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'instance_count': {'minimum': -1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'PartitionSchemeDescription'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'serviceDnsName', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_close_delay_duration': {'key': 'instanceCloseDelayDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatelessServiceProperties, self).__init__(**kwargs)
        self.service_kind = 'Stateless'  # type: str
        self.instance_count = kwargs.get('instance_count', None)
        self.instance_close_delay_duration = kwargs.get('instance_close_delay_duration', None)


class StatelessServiceUpdateProperties(ServiceResourceUpdateProperties):
    """The properties of a stateless service resource for patch operations.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme: list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type service_load_metrics: list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Invalid", "Stateless", "Stateful".
    :type service_kind: str or ~azure.mgmt.servicefabric.models.ServiceKind
    :param instance_count: The instance count.
    :type instance_count: int
    :param instance_close_delay_duration: Delay duration for RequestDrain feature to ensures that
     the endpoint advertised by the stateless instance is removed before the delay starts prior to
     closing the instance. This delay enables existing requests to drain gracefully before the
     instance actually goes down
     (https://docs.microsoft.com/en-us/azure/service-fabric/service-fabric-application-upgrade-advanced#avoid-connection-drops-during-stateless-service-planned-downtime-preview).
     It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it
     is interpreted as a number representing the total number of milliseconds.
    :type instance_close_delay_duration: str
    """

    _validation = {
        'service_kind': {'required': True},
        'instance_count': {'minimum': -1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_close_delay_duration': {'key': 'instanceCloseDelayDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatelessServiceUpdateProperties, self).__init__(**kwargs)
        self.service_kind = 'Stateless'  # type: str
        self.instance_count = kwargs.get('instance_count', None)
        self.instance_close_delay_duration = kwargs.get('instance_close_delay_duration', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource.
    :type created_by_type: str
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource.
    :type last_modified_by_type: str
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class UniformInt64RangePartitionSchemeDescription(PartitionSchemeDescription):
    """Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Invalid", "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or ~azure.mgmt.servicefabric.models.PartitionScheme
    :param count: Required. The number of partitions.
    :type count: int
    :param low_key: Required. String indicating the lower bound of the partition key range that
     should be split between the partition ‘count’.
    :type low_key: str
    :param high_key: Required. String indicating the upper bound of the partition key range that
     should be split between the partition ‘count’.
    :type high_key: str
    """

    _validation = {
        'partition_scheme': {'required': True},
        'count': {'required': True},
        'low_key': {'required': True},
        'high_key': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'low_key': {'key': 'lowKey', 'type': 'str'},
        'high_key': {'key': 'highKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UniformInt64RangePartitionSchemeDescription, self).__init__(**kwargs)
        self.partition_scheme = 'UniformInt64Range'  # type: str
        self.count = kwargs['count']
        self.low_key = kwargs['low_key']
        self.high_key = kwargs['high_key']


class UpgradableVersionPathResult(msrest.serialization.Model):
    """The list of intermediate cluster code versions for an upgrade or downgrade. Or minimum and maximum upgradable version if no target was given.

    :param supported_path:
    :type supported_path: list[str]
    """

    _attribute_map = {
        'supported_path': {'key': 'supportedPath', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradableVersionPathResult, self).__init__(**kwargs)
        self.supported_path = kwargs.get('supported_path', None)


class UpgradableVersionsDescription(msrest.serialization.Model):
    """UpgradableVersionsDescription.

    All required parameters must be populated in order to send to Azure.

    :param target_version: Required. The target code version.
    :type target_version: str
    """

    _validation = {
        'target_version': {'required': True},
    }

    _attribute_map = {
        'target_version': {'key': 'targetVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradableVersionsDescription, self).__init__(**kwargs)
        self.target_version = kwargs['target_version']


class UserAssignedIdentity(msrest.serialization.Model):
    """UserAssignedIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
