# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class QuotaOperations(object):
    """QuotaOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.quota.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def get(
        self,
        resource_name,  # type: str
        scope,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CurrentQuotaLimitBase"
        """Get the quota limit of a resource. The response can be used to determine the remaining quota to
        calculate a new quota limit that can be submitted with a PUT request.

        :param resource_name: Resource name for a given resource provider. For example:


         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
           For Microsoft.Network PublicIPAddresses.
        :type resource_name: str
        :param scope: The target Azure resource URI. For example,
         ``/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/qms-test/providers/Microsoft.Batch/batchAccounts/testAccount/``.
         This is the target Azure resource URI for the List GET operation. If a ``{resourceName}`` is
         added after ``/quotas``\ , then it's the target Azure resource URI in the GET operation for the
         specific resource.
        :type scope: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CurrentQuotaLimitBase, or the result of cls(response)
        :rtype: ~azure.mgmt.quota.models.CurrentQuotaLimitBase
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CurrentQuotaLimitBase"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2021-03-15-preview"
        accept = "application/json"

        # Construct URL
        url = self.get.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
            'scope': self._serialize.url("scope", scope, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get.metadata = {'url': '/{scope}/providers/Microsoft.Quota/quotas/{resourceName}'}  # type: ignore

    def _create_or_update_initial(
        self,
        resource_name,  # type: str
        scope,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.CurrentQuotaLimitBase"]
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.CurrentQuotaLimitBase"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2021-03-15-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._create_or_update_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
            'scope': self._serialize.url("scope", scope, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(create_quota_request, 'CurrentQuotaLimitBase')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    _create_or_update_initial.metadata = {'url': '/{scope}/providers/Microsoft.Quota/quotas/{resourceName}'}  # type: ignore

    def begin_create_or_update(
        self,
        resource_name,  # type: str
        scope,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller["_models.CurrentQuotaLimitBase"]
        """Create or update the quota limit for the specified resource with the requested value. To update
        the quota, follow these steps:


        #. Use the GET operation for quotas and usages to determine how much quota remains for the
        specific resource and to calculate the new quota limit. These steps are detailed in `this
        example
        <https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670>`_.
        #. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:


         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
           For Microsoft.Network PublicIPAddresses.
        :type resource_name: str
        :param scope: The target Azure resource URI. For example,
         ``/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/qms-test/providers/Microsoft.Batch/batchAccounts/testAccount/``.
         This is the target Azure resource URI for the List GET operation. If a ``{resourceName}`` is
         added after ``/quotas``\ , then it's the target Azure resource URI in the GET operation for the
         specific resource.
        :type scope: str
        :param create_quota_request: Quota request payload.
        :type create_quota_request: ~azure.mgmt.quota.models.CurrentQuotaLimitBase
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either CurrentQuotaLimitBase or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CurrentQuotaLimitBase"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                resource_name=resource_name,
                scope=scope,
                create_quota_request=create_quota_request,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
            'scope': self._serialize.url("scope", scope, 'str', skip_quote=True),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_create_or_update.metadata = {'url': '/{scope}/providers/Microsoft.Quota/quotas/{resourceName}'}  # type: ignore

    def _update_initial(
        self,
        resource_name,  # type: str
        scope,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.CurrentQuotaLimitBase"]
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.CurrentQuotaLimitBase"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2021-03-15-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._update_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
            'scope': self._serialize.url("scope", scope, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(create_quota_request, 'CurrentQuotaLimitBase')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    _update_initial.metadata = {'url': '/{scope}/providers/Microsoft.Quota/quotas/{resourceName}'}  # type: ignore

    def begin_update(
        self,
        resource_name,  # type: str
        scope,  # type: str
        create_quota_request,  # type: "_models.CurrentQuotaLimitBase"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller["_models.CurrentQuotaLimitBase"]
        """Update the quota limit for a specific resource to the specified value:


        #. Use the Usages-GET and Quota-GET operations to determine the remaining quota for the
        specific resource and to calculate the new quota limit. These steps are detailed in `this
        example
        <https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670>`_.
        #. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:


         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
           For Microsoft.Network PublicIPAddresses.
        :type resource_name: str
        :param scope: The target Azure resource URI. For example,
         ``/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/qms-test/providers/Microsoft.Batch/batchAccounts/testAccount/``.
         This is the target Azure resource URI for the List GET operation. If a ``{resourceName}`` is
         added after ``/quotas``\ , then it's the target Azure resource URI in the GET operation for the
         specific resource.
        :type scope: str
        :param create_quota_request: Quota requests payload.
        :type create_quota_request: ~azure.mgmt.quota.models.CurrentQuotaLimitBase
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either CurrentQuotaLimitBase or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CurrentQuotaLimitBase"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._update_initial(
                resource_name=resource_name,
                scope=scope,
                create_quota_request=create_quota_request,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('CurrentQuotaLimitBase', pipeline_response)

            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
            'scope': self._serialize.url("scope", scope, 'str', skip_quote=True),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_update.metadata = {'url': '/{scope}/providers/Microsoft.Quota/quotas/{resourceName}'}  # type: ignore

    def list(
        self,
        scope,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.QuotaLimits"]
        """Get a list of current quota limits of all resources for the specified scope. The response from
        this GET operation can be leveraged to submit requests to update a quota.

        :param scope: The target Azure resource URI. For example,
         ``/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/qms-test/providers/Microsoft.Batch/batchAccounts/testAccount/``.
         This is the target Azure resource URI for the List GET operation. If a ``{resourceName}`` is
         added after ``/quotas``\ , then it's the target Azure resource URI in the GET operation for the
         specific resource.
        :type scope: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either QuotaLimits or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.QuotaLimits]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.QuotaLimits"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2021-03-15-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list.metadata['url']  # type: ignore
                path_format_arguments = {
                    'scope': self._serialize.url("scope", scope, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('QuotaLimits', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': '/{scope}/providers/Microsoft.Quota/quotas'}  # type: ignore
