# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AzureAsyncOperationResult(msrest.serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure.

    :param status: Status of the Azure async operation. Possible values are: 'InProgress',
     'Succeeded', and 'Failed'. Possible values include: "InProgress", "Succeeded", "Failed".
    :type status: str or ~azure.mgmt.frontdoor.models.NetworkOperationStatus
    :param error:
    :type error: ~azure.mgmt.frontdoor.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class Backend(msrest.serialization.Model):
    """Backend address of a frontDoor load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param address: Location of the backend (IP address or FQDN).
    :type address: str
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this backend is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :ivar private_endpoint_status: The Approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.frontdoor.models.PrivateEndpointStatus
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    :param http_port: The HTTP TCP port number. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The HTTPS TCP port number. Must be between 1 and 65535.
    :type https_port: int
    :param enabled_state: Whether to enable use of this backend. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.BackendEnabledState
    :param priority: Priority to use for load balancing. Higher priorities will not be used for
     load balancing if any lower priority backend is healthy.
    :type priority: int
    :param weight: Weight of this endpoint for load balancing purposes.
    :type weight: int
    :param backend_host_header: The value to use as the host header sent to the backend. If blank
     or unspecified, this defaults to the incoming host.
    :type backend_host_header: str
    """

    _validation = {
        'private_endpoint_status': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'private_link_alias': {'key': 'privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'private_endpoint_status': {'key': 'privateEndpointStatus', 'type': 'str'},
        'private_link_approval_message': {'key': 'privateLinkApprovalMessage', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'backend_host_header': {'key': 'backendHostHeader', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Backend, self).__init__(**kwargs)
        self.address = kwargs.get('address', None)
        self.private_link_alias = kwargs.get('private_link_alias', None)
        self.private_link_resource_id = kwargs.get('private_link_resource_id', None)
        self.private_link_location = kwargs.get('private_link_location', None)
        self.private_endpoint_status = None
        self.private_link_approval_message = kwargs.get('private_link_approval_message', None)
        self.http_port = kwargs.get('http_port', None)
        self.https_port = kwargs.get('https_port', None)
        self.enabled_state = kwargs.get('enabled_state', None)
        self.priority = kwargs.get('priority', None)
        self.weight = kwargs.get('weight', None)
        self.backend_host_header = kwargs.get('backend_host_header', None)


class SubResource(msrest.serialization.Model):
    """Reference to another subresource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class BackendPool(SubResource):
    """A backend pool is a collection of backends that can be routed to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param backends: The set of backends for this pool.
    :type backends: list[~azure.mgmt.frontdoor.models.Backend]
    :param load_balancing_settings: Load balancing settings for a backend pool.
    :type load_balancing_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param health_probe_settings: L7 health probe settings for a backend pool.
    :type health_probe_settings: ~azure.mgmt.frontdoor.models.SubResource
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backends': {'key': 'properties.backends', 'type': '[Backend]'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': 'SubResource'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'SubResource'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.backends = kwargs.get('backends', None)
        self.load_balancing_settings = kwargs.get('load_balancing_settings', None)
        self.health_probe_settings = kwargs.get('health_probe_settings', None)
        self.resource_state = None


class BackendPoolListResult(msrest.serialization.Model):
    """Result of the request to list Backend Pools. It contains a list of Backend Pools objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Backend Pools within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param next_link: URL to get the next set of BackendPool objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackendPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendPoolListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class BackendPoolUpdateParameters(msrest.serialization.Model):
    """A collection of backends that can be routed to.

    :param backends: The set of backends for this pool.
    :type backends: list[~azure.mgmt.frontdoor.models.Backend]
    :param load_balancing_settings: Load balancing settings for a backend pool.
    :type load_balancing_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param health_probe_settings: L7 health probe settings for a backend pool.
    :type health_probe_settings: ~azure.mgmt.frontdoor.models.SubResource
    """

    _attribute_map = {
        'backends': {'key': 'backends', 'type': '[Backend]'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': 'SubResource'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendPoolUpdateParameters, self).__init__(**kwargs)
        self.backends = kwargs.get('backends', None)
        self.load_balancing_settings = kwargs.get('load_balancing_settings', None)
        self.health_probe_settings = kwargs.get('health_probe_settings', None)


class BackendPoolProperties(BackendPoolUpdateParameters):
    """The JSON object that contains the properties required to create a Backend Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param backends: The set of backends for this pool.
    :type backends: list[~azure.mgmt.frontdoor.models.Backend]
    :param load_balancing_settings: Load balancing settings for a backend pool.
    :type load_balancing_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param health_probe_settings: L7 health probe settings for a backend pool.
    :type health_probe_settings: ~azure.mgmt.frontdoor.models.SubResource
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'backends': {'key': 'backends', 'type': '[Backend]'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': 'SubResource'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'SubResource'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendPoolProperties, self).__init__(**kwargs)
        self.resource_state = None


class BackendPoolsSettings(msrest.serialization.Model):
    """Settings that apply to all backend pools.

    :param enforce_certificate_name_check: Whether to enforce certificate name check on HTTPS
     requests to all backend pools. No effect on non-HTTPS requests. Possible values include:
     "Enabled", "Disabled". Default value: "Enabled".
    :type enforce_certificate_name_check: str or
     ~azure.mgmt.frontdoor.models.EnforceCertificateNameCheckEnabledState
    :param send_recv_timeout_seconds: Send and receive timeout on forwarding request to the
     backend. When timeout is reached, the request fails and returns.
    :type send_recv_timeout_seconds: int
    """

    _validation = {
        'send_recv_timeout_seconds': {'minimum': 16},
    }

    _attribute_map = {
        'enforce_certificate_name_check': {'key': 'enforceCertificateNameCheck', 'type': 'str'},
        'send_recv_timeout_seconds': {'key': 'sendRecvTimeoutSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendPoolsSettings, self).__init__(**kwargs)
        self.enforce_certificate_name_check = kwargs.get('enforce_certificate_name_check', "Enabled")
        self.send_recv_timeout_seconds = kwargs.get('send_recv_timeout_seconds', None)


class CacheConfiguration(msrest.serialization.Model):
    """Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.

    :param query_parameter_strip_directive: Treatment of URL query terms when forming the cache
     key. Possible values include: "StripNone", "StripAll", "StripOnly", "StripAllExcept".
    :type query_parameter_strip_directive: str or ~azure.mgmt.frontdoor.models.FrontDoorQuery
    :param query_parameters: query parameters to include or exclude (comma separated).
    :type query_parameters: str
    :param dynamic_compression: Whether to use dynamic compression for cached content. Possible
     values include: "Enabled", "Disabled".
    :type dynamic_compression: str or ~azure.mgmt.frontdoor.models.DynamicCompressionEnabled
    :param cache_duration: The duration for which the content needs to be cached. Allowed format is
     in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value
     to be no more than a year.
    :type cache_duration: ~datetime.timedelta
    """

    _attribute_map = {
        'query_parameter_strip_directive': {'key': 'queryParameterStripDirective', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': 'str'},
        'dynamic_compression': {'key': 'dynamicCompression', 'type': 'str'},
        'cache_duration': {'key': 'cacheDuration', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheConfiguration, self).__init__(**kwargs)
        self.query_parameter_strip_directive = kwargs.get('query_parameter_strip_directive', None)
        self.query_parameters = kwargs.get('query_parameters', None)
        self.dynamic_compression = kwargs.get('dynamic_compression', None)
        self.cache_duration = kwargs.get('cache_duration', None)


class CheckNameAvailabilityInput(msrest.serialization.Model):
    """Input of CheckNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The resource name to validate.
    :type name: str
    :param type: Required. The type of the resource whose name is to be validated. Possible values
     include: "Microsoft.Network/frontDoors", "Microsoft.Network/frontDoors/frontendEndpoints".
    :type type: str or ~azure.mgmt.frontdoor.models.ResourceType
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityInput, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']


class CheckNameAvailabilityOutput(msrest.serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_availability: Indicates whether the name is available. Possible values include:
     "Available", "Unavailable".
    :vartype name_availability: str or ~azure.mgmt.frontdoor.models.Availability
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        'name_availability': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_availability': {'key': 'nameAvailability', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityOutput, self).__init__(**kwargs)
        self.name_availability = None
        self.reason = None
        self.message = None


class CustomHttpsConfiguration(msrest.serialization.Model):
    """Https settings for a domain.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL certificate. Possible values
     include: "AzureKeyVault", "FrontDoor".
    :type certificate_source: str or ~azure.mgmt.frontdoor.models.FrontDoorCertificateSource
    :param protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication".
    :type protocol_type: str or ~azure.mgmt.frontdoor.models.FrontDoorTlsProtocolType
    :param minimum_tls_version: Required. The minimum TLS version required from the clients to
     establish an SSL handshake with Front Door. Possible values include: "1.0", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.frontdoor.models.MinimumTLSVersion
    :param certificate_type: Defines the type of the certificate used for secure connections to a
     frontendEndpoint. Possible values include: "Dedicated".
    :type certificate_type: str or ~azure.mgmt.frontdoor.models.FrontDoorCertificateType
    :param vault: The Key Vault containing the SSL certificate.
    :type vault: ~azure.mgmt.frontdoor.models.KeyVaultCertificateSourceParametersVault
    :param secret_name: The name of the Key Vault secret representing the full certificate PFX.
    :type secret_name: str
    :param secret_version: The version of the Key Vault secret representing the full certificate
     PFX.
    :type secret_version: str
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
        'minimum_tls_version': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'certificate_type': {'key': 'frontDoorCertificateSourceParameters.certificateType', 'type': 'str'},
        'vault': {'key': 'keyVaultCertificateSourceParameters.vault', 'type': 'KeyVaultCertificateSourceParametersVault'},
        'secret_name': {'key': 'keyVaultCertificateSourceParameters.secretName', 'type': 'str'},
        'secret_version': {'key': 'keyVaultCertificateSourceParameters.secretVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomHttpsConfiguration, self).__init__(**kwargs)
        self.certificate_source = kwargs['certificate_source']
        self.protocol_type = kwargs['protocol_type']
        self.minimum_tls_version = kwargs['minimum_tls_version']
        self.certificate_type = kwargs.get('certificate_type', None)
        self.vault = kwargs.get('vault', None)
        self.secret_name = kwargs.get('secret_name', None)
        self.secret_version = kwargs.get('secret_version', None)


class CustomRule(msrest.serialization.Model):
    """Defines contents of a web application rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Describes the name of the rule.
    :type name: str
    :param priority: Required. Describes priority of the rule. Rules with a lower value will be
     evaluated before rules with a higher value.
    :type priority: int
    :param enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.CustomRuleEnabledState
    :param rule_type: Required. Describes type of rule. Possible values include: "MatchRule",
     "RateLimitRule".
    :type rule_type: str or ~azure.mgmt.frontdoor.models.RuleType
    :param rate_limit_duration_in_minutes: Time window for resetting the rate limit count. Default
     is 1 minute.
    :type rate_limit_duration_in_minutes: int
    :param rate_limit_threshold: Number of allowed requests per client within the time window.
    :type rate_limit_threshold: int
    :param match_conditions: Required. List of match conditions.
    :type match_conditions: list[~azure.mgmt.frontdoor.models.MatchCondition]
    :param action: Required. Describes what action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.frontdoor.models.ActionType
    """

    _validation = {
        'name': {'max_length': 128, 'min_length': 0},
        'priority': {'required': True},
        'rule_type': {'required': True},
        'rate_limit_duration_in_minutes': {'maximum': 5, 'minimum': 0},
        'rate_limit_threshold': {'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'rate_limit_duration_in_minutes': {'key': 'rateLimitDurationInMinutes', 'type': 'int'},
        'rate_limit_threshold': {'key': 'rateLimitThreshold', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.priority = kwargs['priority']
        self.enabled_state = kwargs.get('enabled_state', None)
        self.rule_type = kwargs['rule_type']
        self.rate_limit_duration_in_minutes = kwargs.get('rate_limit_duration_in_minutes', None)
        self.rate_limit_threshold = kwargs.get('rate_limit_threshold', None)
        self.match_conditions = kwargs['match_conditions']
        self.action = kwargs['action']


class CustomRuleList(msrest.serialization.Model):
    """Defines contents of custom rules.

    :param rules: List of rules.
    :type rules: list[~azure.mgmt.frontdoor.models.CustomRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[CustomRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomRuleList, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)


class Endpoint(msrest.serialization.Model):
    """Defines the endpoint properties.

    :param name: The name of the endpoint.
    :type name: str
    :param endpoint: The endpoint URL.
    :type endpoint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Endpoint, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.endpoint = kwargs.get('endpoint', None)


class Error(msrest.serialization.Model):
    """Error.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    :param details:
    :type details: list[~azure.mgmt.frontdoor.models.ErrorDetails]
    :param inner_error:
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.inner_error = kwargs.get('inner_error', None)


class ErrorDetails(msrest.serialization.Model):
    """ErrorDetails.

    :param code:
    :type code: str
    :param target:
    :type target: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)
        self.message = kwargs.get('message', None)


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Front Door service is not able to process the incoming request. The reason is provided in the error message.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None


class Resource(msrest.serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Experiment(Resource):
    """Defines the properties of an Experiment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of the details or intents of the Experiment.
    :type description: str
    :param endpoint_a: The endpoint A of an experiment.
    :type endpoint_a: ~azure.mgmt.frontdoor.models.Endpoint
    :param endpoint_b: The endpoint B of an experiment.
    :type endpoint_b: ~azure.mgmt.frontdoor.models.Endpoint
    :param enabled_state: The state of the Experiment. Possible values include: "Enabled",
     "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.NetworkExperimentResourceState
    :ivar status: The description of Experiment status from the server side.
    :vartype status: str
    :ivar script_file_uri: The uri to the Script used in the Experiment.
    :vartype script_file_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
        'status': {'readonly': True},
        'script_file_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'endpoint_a': {'key': 'properties.endpointA', 'type': 'Endpoint'},
        'endpoint_b': {'key': 'properties.endpointB', 'type': 'Endpoint'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'script_file_uri': {'key': 'properties.scriptFileUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Experiment, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.endpoint_a = kwargs.get('endpoint_a', None)
        self.endpoint_b = kwargs.get('endpoint_b', None)
        self.enabled_state = kwargs.get('enabled_state', None)
        self.resource_state = None
        self.status = None
        self.script_file_uri = None


class ExperimentList(msrest.serialization.Model):
    """Defines a list of Experiments. It contains a list of Experiment objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Experiments within a resource group.
    :vartype value: list[~azure.mgmt.frontdoor.models.Experiment]
    :param next_link: URL to get the next set of Experiment objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Experiment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExperimentList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class ExperimentUpdateModel(msrest.serialization.Model):
    """Defines modifiable attributes of an Experiment.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of the intent or details of the Experiment.
    :type description: str
    :param enabled_state: The state of the Experiment. Possible values include: "Enabled",
     "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExperimentUpdateModel, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.enabled_state = kwargs.get('enabled_state', None)


class RouteConfiguration(msrest.serialization.Model):
    """Base class for all types of Route.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ForwardingConfiguration, RedirectConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Constant filled by server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration': 'ForwardingConfiguration', '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration': 'RedirectConfiguration'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteConfiguration, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class ForwardingConfiguration(RouteConfiguration):
    """Describes Forwarding Route.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Constant filled by server.
    :type odata_type: str
    :param custom_forwarding_path: A custom path used to rewrite resource paths matched by this
     rule. Leave empty to use incoming path.
    :type custom_forwarding_path: str
    :param forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :type forwarding_protocol: str or ~azure.mgmt.frontdoor.models.FrontDoorForwardingProtocol
    :param cache_configuration: The caching configuration associated with this rule.
    :type cache_configuration: ~azure.mgmt.frontdoor.models.CacheConfiguration
    :param backend_pool: A reference to the BackendPool which this rule routes to.
    :type backend_pool: ~azure.mgmt.frontdoor.models.SubResource
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'custom_forwarding_path': {'key': 'customForwardingPath', 'type': 'str'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
        'cache_configuration': {'key': 'cacheConfiguration', 'type': 'CacheConfiguration'},
        'backend_pool': {'key': 'backendPool', 'type': 'SubResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ForwardingConfiguration, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'  # type: str
        self.custom_forwarding_path = kwargs.get('custom_forwarding_path', None)
        self.forwarding_protocol = kwargs.get('forwarding_protocol', None)
        self.cache_configuration = kwargs.get('cache_configuration', None)
        self.backend_pool = kwargs.get('backend_pool', None)


class FrontDoor(Resource):
    """Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how traffic is sent there.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param friendly_name: A friendly name for the frontDoor.
    :type friendly_name: str
    :param routing_rules: Routing rules associated with this Front Door.
    :type routing_rules: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param load_balancing_settings: Load balancing settings associated with this Front Door
     instance.
    :type load_balancing_settings: list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param health_probe_settings: Health probe settings associated with this Front Door instance.
    :type health_probe_settings: list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param backend_pools: Backend pools available to routing rules.
    :type backend_pools: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param frontend_endpoints: Frontend endpoints available to routing rules.
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.FrontendEndpoint]
    :param backend_pools_settings: Settings for all backendPools.
    :type backend_pools_settings: ~azure.mgmt.frontdoor.models.BackendPoolsSettings
    :param enabled_state: Operational status of the Front Door load balancer. Permitted values are
     'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    :ivar resource_state: Resource status of the Front Door. Possible values include: "Creating",
     "Enabling", "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :ivar provisioning_state: Provisioning state of the Front Door.
    :vartype provisioning_state: str
    :ivar cname: The host that each frontendEndpoint must CNAME to.
    :vartype cname: str
    :ivar frontdoor_id: The Id of the frontdoor.
    :vartype frontdoor_id: str
    :ivar rules_engines: Rules Engine Configurations available to routing rules.
    :vartype rules_engines: list[~azure.mgmt.frontdoor.models.RulesEngine]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'cname': {'readonly': True},
        'frontdoor_id': {'readonly': True},
        'rules_engines': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'routing_rules': {'key': 'properties.routingRules', 'type': '[RoutingRule]'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': '[LoadBalancingSettingsModel]'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': '[HealthProbeSettingsModel]'},
        'backend_pools': {'key': 'properties.backendPools', 'type': '[BackendPool]'},
        'frontend_endpoints': {'key': 'properties.frontendEndpoints', 'type': '[FrontendEndpoint]'},
        'backend_pools_settings': {'key': 'properties.backendPoolsSettings', 'type': 'BackendPoolsSettings'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'cname': {'key': 'properties.cname', 'type': 'str'},
        'frontdoor_id': {'key': 'properties.frontdoorId', 'type': 'str'},
        'rules_engines': {'key': 'properties.rulesEngines', 'type': '[RulesEngine]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontDoor, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.routing_rules = kwargs.get('routing_rules', None)
        self.load_balancing_settings = kwargs.get('load_balancing_settings', None)
        self.health_probe_settings = kwargs.get('health_probe_settings', None)
        self.backend_pools = kwargs.get('backend_pools', None)
        self.frontend_endpoints = kwargs.get('frontend_endpoints', None)
        self.backend_pools_settings = kwargs.get('backend_pools_settings', None)
        self.enabled_state = kwargs.get('enabled_state', None)
        self.resource_state = None
        self.provisioning_state = None
        self.cname = None
        self.frontdoor_id = None
        self.rules_engines = None


class FrontDoorListResult(msrest.serialization.Model):
    """Result of the request to list Front Doors. It contains a list of Front Door objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Front Doors within a resource group.
    :vartype value: list[~azure.mgmt.frontdoor.models.FrontDoor]
    :param next_link: URL to get the next set of Front Door objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FrontDoor]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontDoorListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class FrontDoorUpdateParameters(msrest.serialization.Model):
    """The properties needed to update a Front Door.

    :param friendly_name: A friendly name for the frontDoor.
    :type friendly_name: str
    :param routing_rules: Routing rules associated with this Front Door.
    :type routing_rules: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param load_balancing_settings: Load balancing settings associated with this Front Door
     instance.
    :type load_balancing_settings: list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param health_probe_settings: Health probe settings associated with this Front Door instance.
    :type health_probe_settings: list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param backend_pools: Backend pools available to routing rules.
    :type backend_pools: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param frontend_endpoints: Frontend endpoints available to routing rules.
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.FrontendEndpoint]
    :param backend_pools_settings: Settings for all backendPools.
    :type backend_pools_settings: ~azure.mgmt.frontdoor.models.BackendPoolsSettings
    :param enabled_state: Operational status of the Front Door load balancer. Permitted values are
     'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'routing_rules': {'key': 'routingRules', 'type': '[RoutingRule]'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': '[LoadBalancingSettingsModel]'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': '[HealthProbeSettingsModel]'},
        'backend_pools': {'key': 'backendPools', 'type': '[BackendPool]'},
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[FrontendEndpoint]'},
        'backend_pools_settings': {'key': 'backendPoolsSettings', 'type': 'BackendPoolsSettings'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontDoorUpdateParameters, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.routing_rules = kwargs.get('routing_rules', None)
        self.load_balancing_settings = kwargs.get('load_balancing_settings', None)
        self.health_probe_settings = kwargs.get('health_probe_settings', None)
        self.backend_pools = kwargs.get('backend_pools', None)
        self.frontend_endpoints = kwargs.get('frontend_endpoints', None)
        self.backend_pools_settings = kwargs.get('backend_pools_settings', None)
        self.enabled_state = kwargs.get('enabled_state', None)


class FrontDoorProperties(FrontDoorUpdateParameters):
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param friendly_name: A friendly name for the frontDoor.
    :type friendly_name: str
    :param routing_rules: Routing rules associated with this Front Door.
    :type routing_rules: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param load_balancing_settings: Load balancing settings associated with this Front Door
     instance.
    :type load_balancing_settings: list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param health_probe_settings: Health probe settings associated with this Front Door instance.
    :type health_probe_settings: list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param backend_pools: Backend pools available to routing rules.
    :type backend_pools: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param frontend_endpoints: Frontend endpoints available to routing rules.
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.FrontendEndpoint]
    :param backend_pools_settings: Settings for all backendPools.
    :type backend_pools_settings: ~azure.mgmt.frontdoor.models.BackendPoolsSettings
    :param enabled_state: Operational status of the Front Door load balancer. Permitted values are
     'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    :ivar resource_state: Resource status of the Front Door. Possible values include: "Creating",
     "Enabling", "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :ivar provisioning_state: Provisioning state of the Front Door.
    :vartype provisioning_state: str
    :ivar cname: The host that each frontendEndpoint must CNAME to.
    :vartype cname: str
    :ivar frontdoor_id: The Id of the frontdoor.
    :vartype frontdoor_id: str
    :ivar rules_engines: Rules Engine Configurations available to routing rules.
    :vartype rules_engines: list[~azure.mgmt.frontdoor.models.RulesEngine]
    """

    _validation = {
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'cname': {'readonly': True},
        'frontdoor_id': {'readonly': True},
        'rules_engines': {'readonly': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'routing_rules': {'key': 'routingRules', 'type': '[RoutingRule]'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': '[LoadBalancingSettingsModel]'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': '[HealthProbeSettingsModel]'},
        'backend_pools': {'key': 'backendPools', 'type': '[BackendPool]'},
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[FrontendEndpoint]'},
        'backend_pools_settings': {'key': 'backendPoolsSettings', 'type': 'BackendPoolsSettings'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'cname': {'key': 'cname', 'type': 'str'},
        'frontdoor_id': {'key': 'frontdoorId', 'type': 'str'},
        'rules_engines': {'key': 'rulesEngines', 'type': '[RulesEngine]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontDoorProperties, self).__init__(**kwargs)
        self.resource_state = None
        self.provisioning_state = None
        self.cname = None
        self.frontdoor_id = None
        self.rules_engines = None


class FrontendEndpoint(SubResource):
    """A frontend endpoint used for routing.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param host_name: The host name of the frontendEndpoint. Must be a domain name.
    :type host_name: str
    :param session_affinity_enabled_state: Whether to allow session affinity on this host. Valid
     options are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type session_affinity_enabled_state: str or
     ~azure.mgmt.frontdoor.models.SessionAffinityEnabledState
    :param session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in
     seconds for session affinity, if applicable.
    :type session_affinity_ttl_seconds: int
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     each host (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https of the
     frontendEndpoint. Possible values include: "Enabling", "Enabled", "Disabling", "Disabled",
     "Failed".
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the progress of custom
     HTTPS enabling/disabling process step by step. Possible values include:
     "SubmittingDomainControlValidationRequest", "PendingDomainControlValidationREquestApproval",
     "DomainControlValidationRequestApproved", "DomainControlValidationRequestRejected",
     "DomainControlValidationRequestTimedOut", "IssuingCertificate", "DeployingCertificate",
     "CertificateDeployed", "DeletingCertificate", "CertificateDeleted".
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningSubstate
    :ivar custom_https_configuration: The configuration specifying how to enable HTTPS.
    :vartype custom_https_configuration: ~azure.mgmt.frontdoor.models.CustomHttpsConfiguration
    """

    _validation = {
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'custom_https_configuration': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'session_affinity_enabled_state': {'key': 'properties.sessionAffinityEnabledState', 'type': 'str'},
        'session_affinity_ttl_seconds': {'key': 'properties.sessionAffinityTtlSeconds', 'type': 'int'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'properties.customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'properties.customHttpsProvisioningSubstate', 'type': 'str'},
        'custom_https_configuration': {'key': 'properties.customHttpsConfiguration', 'type': 'CustomHttpsConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendEndpoint, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.host_name = kwargs.get('host_name', None)
        self.session_affinity_enabled_state = kwargs.get('session_affinity_enabled_state', None)
        self.session_affinity_ttl_seconds = kwargs.get('session_affinity_ttl_seconds', None)
        self.web_application_firewall_policy_link = kwargs.get('web_application_firewall_policy_link', None)
        self.resource_state = None
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.custom_https_configuration = None


class FrontendEndpointLink(msrest.serialization.Model):
    """Defines the Resource ID for a Frontend Endpoint.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendEndpointLink, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class FrontendEndpointUpdateParameters(msrest.serialization.Model):
    """Frontend endpoint used in routing rule.

    :param host_name: The host name of the frontendEndpoint. Must be a domain name.
    :type host_name: str
    :param session_affinity_enabled_state: Whether to allow session affinity on this host. Valid
     options are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type session_affinity_enabled_state: str or
     ~azure.mgmt.frontdoor.models.SessionAffinityEnabledState
    :param session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in
     seconds for session affinity, if applicable.
    :type session_affinity_ttl_seconds: int
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     each host (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'session_affinity_enabled_state': {'key': 'sessionAffinityEnabledState', 'type': 'str'},
        'session_affinity_ttl_seconds': {'key': 'sessionAffinityTtlSeconds', 'type': 'int'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendEndpointUpdateParameters, self).__init__(**kwargs)
        self.host_name = kwargs.get('host_name', None)
        self.session_affinity_enabled_state = kwargs.get('session_affinity_enabled_state', None)
        self.session_affinity_ttl_seconds = kwargs.get('session_affinity_ttl_seconds', None)
        self.web_application_firewall_policy_link = kwargs.get('web_application_firewall_policy_link', None)


class FrontendEndpointProperties(FrontendEndpointUpdateParameters):
    """The JSON object that contains the properties required to create a frontend endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param host_name: The host name of the frontendEndpoint. Must be a domain name.
    :type host_name: str
    :param session_affinity_enabled_state: Whether to allow session affinity on this host. Valid
     options are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type session_affinity_enabled_state: str or
     ~azure.mgmt.frontdoor.models.SessionAffinityEnabledState
    :param session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in
     seconds for session affinity, if applicable.
    :type session_affinity_ttl_seconds: int
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     each host (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https of the
     frontendEndpoint. Possible values include: "Enabling", "Enabled", "Disabling", "Disabled",
     "Failed".
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the progress of custom
     HTTPS enabling/disabling process step by step. Possible values include:
     "SubmittingDomainControlValidationRequest", "PendingDomainControlValidationREquestApproval",
     "DomainControlValidationRequestApproved", "DomainControlValidationRequestRejected",
     "DomainControlValidationRequestTimedOut", "IssuingCertificate", "DeployingCertificate",
     "CertificateDeployed", "DeletingCertificate", "CertificateDeleted".
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningSubstate
    :ivar custom_https_configuration: The configuration specifying how to enable HTTPS.
    :vartype custom_https_configuration: ~azure.mgmt.frontdoor.models.CustomHttpsConfiguration
    """

    _validation = {
        'resource_state': {'readonly': True},
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'custom_https_configuration': {'readonly': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'session_affinity_enabled_state': {'key': 'sessionAffinityEnabledState', 'type': 'str'},
        'session_affinity_ttl_seconds': {'key': 'sessionAffinityTtlSeconds', 'type': 'int'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'customHttpsProvisioningSubstate', 'type': 'str'},
        'custom_https_configuration': {'key': 'customHttpsConfiguration', 'type': 'CustomHttpsConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendEndpointProperties, self).__init__(**kwargs)
        self.resource_state = None
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.custom_https_configuration = None


class FrontendEndpointsListResult(msrest.serialization.Model):
    """Result of the request to list frontend endpoints. It contains a list of Frontend endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Frontend endpoints within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.FrontendEndpoint]
    :param next_link: URL to get the next set of frontend endpoints if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FrontendEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendEndpointsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink(msrest.serialization.Model):
    """Defines the Web Application Firewall policy for each host (if applicable).

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class HeaderAction(msrest.serialization.Model):
    """An action that can manipulate an http header.

    All required parameters must be populated in order to send to Azure.

    :param header_action_type: Required. Which type of manipulation to apply to the header.
     Possible values include: "Append", "Delete", "Overwrite".
    :type header_action_type: str or ~azure.mgmt.frontdoor.models.HeaderActionType
    :param header_name: Required. The name of the header this action will apply to.
    :type header_name: str
    :param value: The value to update the given header name with. This value is not used if the
     actionType is Delete.
    :type value: str
    """

    _validation = {
        'header_action_type': {'required': True},
        'header_name': {'required': True},
    }

    _attribute_map = {
        'header_action_type': {'key': 'headerActionType', 'type': 'str'},
        'header_name': {'key': 'headerName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HeaderAction, self).__init__(**kwargs)
        self.header_action_type = kwargs['header_action_type']
        self.header_name = kwargs['header_name']
        self.value = kwargs.get('value', None)


class HealthProbeSettingsListResult(msrest.serialization.Model):
    """Result of the request to list HealthProbeSettings. It contains a list of HealthProbeSettings objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of HealthProbeSettings within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param next_link: URL to get the next set of HealthProbeSettings objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HealthProbeSettingsModel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthProbeSettingsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class HealthProbeSettingsModel(SubResource):
    """Load balancing settings for a backend pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param path: The path to use for the health probe. Default is /.
    :type path: str
    :param protocol: Protocol scheme to use for this probe. Possible values include: "Http",
     "Https".
    :type protocol: str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol
    :param interval_in_seconds: The number of seconds between health probes.
    :type interval_in_seconds: int
    :param health_probe_method: Configures which HTTP method to use to probe the backends defined
     under backendPools. Possible values include: "GET", "HEAD". Default value: "HEAD".
    :type health_probe_method: str or ~azure.mgmt.frontdoor.models.FrontDoorHealthProbeMethod
    :param enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.HealthProbeEnabled
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'health_probe_method': {'key': 'properties.healthProbeMethod', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthProbeSettingsModel, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.path = kwargs.get('path', None)
        self.protocol = kwargs.get('protocol', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.health_probe_method = kwargs.get('health_probe_method', "HEAD")
        self.enabled_state = kwargs.get('enabled_state', None)
        self.resource_state = None


class HealthProbeSettingsUpdateParameters(msrest.serialization.Model):
    """L7 health probe settings for a backend pool.

    :param path: The path to use for the health probe. Default is /.
    :type path: str
    :param protocol: Protocol scheme to use for this probe. Possible values include: "Http",
     "Https".
    :type protocol: str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol
    :param interval_in_seconds: The number of seconds between health probes.
    :type interval_in_seconds: int
    :param health_probe_method: Configures which HTTP method to use to probe the backends defined
     under backendPools. Possible values include: "GET", "HEAD". Default value: "HEAD".
    :type health_probe_method: str or ~azure.mgmt.frontdoor.models.FrontDoorHealthProbeMethod
    :param enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.HealthProbeEnabled
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'int'},
        'health_probe_method': {'key': 'healthProbeMethod', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthProbeSettingsUpdateParameters, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.protocol = kwargs.get('protocol', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.health_probe_method = kwargs.get('health_probe_method', "HEAD")
        self.enabled_state = kwargs.get('enabled_state', None)


class HealthProbeSettingsProperties(HealthProbeSettingsUpdateParameters):
    """The JSON object that contains the properties required to create a health probe settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param path: The path to use for the health probe. Default is /.
    :type path: str
    :param protocol: Protocol scheme to use for this probe. Possible values include: "Http",
     "Https".
    :type protocol: str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol
    :param interval_in_seconds: The number of seconds between health probes.
    :type interval_in_seconds: int
    :param health_probe_method: Configures which HTTP method to use to probe the backends defined
     under backendPools. Possible values include: "GET", "HEAD". Default value: "HEAD".
    :type health_probe_method: str or ~azure.mgmt.frontdoor.models.FrontDoorHealthProbeMethod
    :param enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.HealthProbeEnabled
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'int'},
        'health_probe_method': {'key': 'healthProbeMethod', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthProbeSettingsProperties, self).__init__(**kwargs)
        self.resource_state = None


class KeyVaultCertificateSourceParametersVault(msrest.serialization.Model):
    """The Key Vault containing the SSL certificate.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultCertificateSourceParametersVault, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class LatencyMetric(msrest.serialization.Model):
    """Defines the properties of a latency metric used in the latency scorecard.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the Latency Metric.
    :vartype name: str
    :ivar end_date_time_utc: The end time of the Latency Scorecard in UTC.
    :vartype end_date_time_utc: str
    :ivar a_value: The metric value of the A endpoint.
    :vartype a_value: float
    :ivar b_value: The metric value of the B endpoint.
    :vartype b_value: float
    :ivar delta: The difference in value between endpoint A and B.
    :vartype delta: float
    :ivar delta_percent: The percent difference between endpoint A and B.
    :vartype delta_percent: float
    :ivar a_c_lower95_ci: The lower end of the 95% confidence interval for endpoint A.
    :vartype a_c_lower95_ci: float
    :ivar a_h_upper95_ci: The upper end of the 95% confidence interval for endpoint A.
    :vartype a_h_upper95_ci: float
    :ivar b_c_lower95_ci: The lower end of the 95% confidence interval for endpoint B.
    :vartype b_c_lower95_ci: float
    :ivar b_upper95_ci: The upper end of the 95% confidence interval for endpoint B.
    :vartype b_upper95_ci: float
    """

    _validation = {
        'name': {'readonly': True},
        'end_date_time_utc': {'readonly': True},
        'a_value': {'readonly': True},
        'b_value': {'readonly': True},
        'delta': {'readonly': True},
        'delta_percent': {'readonly': True},
        'a_c_lower95_ci': {'readonly': True},
        'a_h_upper95_ci': {'readonly': True},
        'b_c_lower95_ci': {'readonly': True},
        'b_upper95_ci': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'end_date_time_utc': {'key': 'endDateTimeUTC', 'type': 'str'},
        'a_value': {'key': 'aValue', 'type': 'float'},
        'b_value': {'key': 'bValue', 'type': 'float'},
        'delta': {'key': 'delta', 'type': 'float'},
        'delta_percent': {'key': 'deltaPercent', 'type': 'float'},
        'a_c_lower95_ci': {'key': 'aCLower95CI', 'type': 'float'},
        'a_h_upper95_ci': {'key': 'aHUpper95CI', 'type': 'float'},
        'b_c_lower95_ci': {'key': 'bCLower95CI', 'type': 'float'},
        'b_upper95_ci': {'key': 'bUpper95CI', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LatencyMetric, self).__init__(**kwargs)
        self.name = None
        self.end_date_time_utc = None
        self.a_value = None
        self.b_value = None
        self.delta = None
        self.delta_percent = None
        self.a_c_lower95_ci = None
        self.a_h_upper95_ci = None
        self.b_c_lower95_ci = None
        self.b_upper95_ci = None


class LatencyScorecard(Resource):
    """Defines the LatencyScorecard.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar id_properties_id: The unique identifier of the Latency Scorecard.
    :vartype id_properties_id: str
    :ivar name_properties_name: The name of the Latency Scorecard.
    :vartype name_properties_name: str
    :ivar description: The description of the Latency Scorecard.
    :vartype description: str
    :ivar endpoint_a: The A endpoint in the scorecard.
    :vartype endpoint_a: str
    :ivar endpoint_b: The B endpoint in the scorecard.
    :vartype endpoint_b: str
    :ivar start_date_time_utc: The start time of the Latency Scorecard in UTC.
    :vartype start_date_time_utc: ~datetime.datetime
    :ivar end_date_time_utc: The end time of the Latency Scorecard in UTC.
    :vartype end_date_time_utc: ~datetime.datetime
    :ivar country: The country associated with the Latency Scorecard. Values are country ISO codes
     as specified here- https://www.iso.org/iso-3166-country-codes.html.
    :vartype country: str
    :param latency_metrics: The latency metrics of the Latency Scorecard.
    :type latency_metrics: list[~azure.mgmt.frontdoor.models.LatencyMetric]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id_properties_id': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'description': {'readonly': True},
        'endpoint_a': {'readonly': True},
        'endpoint_b': {'readonly': True},
        'start_date_time_utc': {'readonly': True},
        'end_date_time_utc': {'readonly': True},
        'country': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'endpoint_a': {'key': 'properties.endpointA', 'type': 'str'},
        'endpoint_b': {'key': 'properties.endpointB', 'type': 'str'},
        'start_date_time_utc': {'key': 'properties.startDateTimeUTC', 'type': 'iso-8601'},
        'end_date_time_utc': {'key': 'properties.endDateTimeUTC', 'type': 'iso-8601'},
        'country': {'key': 'properties.country', 'type': 'str'},
        'latency_metrics': {'key': 'properties.latencyMetrics', 'type': '[LatencyMetric]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LatencyScorecard, self).__init__(**kwargs)
        self.id_properties_id = None
        self.name_properties_name = None
        self.description = None
        self.endpoint_a = None
        self.endpoint_b = None
        self.start_date_time_utc = None
        self.end_date_time_utc = None
        self.country = None
        self.latency_metrics = kwargs.get('latency_metrics', None)


class LoadBalancingSettingsListResult(msrest.serialization.Model):
    """Result of the request to list load balancing settings. It contains a list of load balancing settings objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Backend Pools within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param next_link: URL to get the next set of LoadBalancingSettings objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancingSettingsModel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancingSettingsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class LoadBalancingSettingsModel(SubResource):
    """Load balancing settings for a backend pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param sample_size: The number of samples to consider for load balancing decisions.
    :type sample_size: int
    :param successful_samples_required: The number of samples within the sample period that must
     succeed.
    :type successful_samples_required: int
    :param additional_latency_milliseconds: The additional latency in milliseconds for probes to
     fall into the lowest latency bucket.
    :type additional_latency_milliseconds: int
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sample_size': {'key': 'properties.sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'properties.successfulSamplesRequired', 'type': 'int'},
        'additional_latency_milliseconds': {'key': 'properties.additionalLatencyMilliseconds', 'type': 'int'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancingSettingsModel, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.sample_size = kwargs.get('sample_size', None)
        self.successful_samples_required = kwargs.get('successful_samples_required', None)
        self.additional_latency_milliseconds = kwargs.get('additional_latency_milliseconds', None)
        self.resource_state = None


class LoadBalancingSettingsUpdateParameters(msrest.serialization.Model):
    """Round-Robin load balancing settings for a backend pool.

    :param sample_size: The number of samples to consider for load balancing decisions.
    :type sample_size: int
    :param successful_samples_required: The number of samples within the sample period that must
     succeed.
    :type successful_samples_required: int
    :param additional_latency_milliseconds: The additional latency in milliseconds for probes to
     fall into the lowest latency bucket.
    :type additional_latency_milliseconds: int
    """

    _attribute_map = {
        'sample_size': {'key': 'sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'successfulSamplesRequired', 'type': 'int'},
        'additional_latency_milliseconds': {'key': 'additionalLatencyMilliseconds', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancingSettingsUpdateParameters, self).__init__(**kwargs)
        self.sample_size = kwargs.get('sample_size', None)
        self.successful_samples_required = kwargs.get('successful_samples_required', None)
        self.additional_latency_milliseconds = kwargs.get('additional_latency_milliseconds', None)


class LoadBalancingSettingsProperties(LoadBalancingSettingsUpdateParameters):
    """The JSON object that contains the properties required to create load balancing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param sample_size: The number of samples to consider for load balancing decisions.
    :type sample_size: int
    :param successful_samples_required: The number of samples within the sample period that must
     succeed.
    :type successful_samples_required: int
    :param additional_latency_milliseconds: The additional latency in milliseconds for probes to
     fall into the lowest latency bucket.
    :type additional_latency_milliseconds: int
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'sample_size': {'key': 'sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'successfulSamplesRequired', 'type': 'int'},
        'additional_latency_milliseconds': {'key': 'additionalLatencyMilliseconds', 'type': 'int'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancingSettingsProperties, self).__init__(**kwargs)
        self.resource_state = None


class ManagedRuleDefinition(msrest.serialization.Model):
    """Describes a managed rule definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_id: Identifier for the managed rule.
    :vartype rule_id: str
    :ivar default_state: Describes the default state for the managed rule. Possible values include:
     "Disabled", "Enabled".
    :vartype default_state: str or ~azure.mgmt.frontdoor.models.ManagedRuleEnabledState
    :ivar default_action: Describes the default action to be applied when the managed rule matches.
     Possible values include: "Allow", "Block", "Log", "Redirect".
    :vartype default_action: str or ~azure.mgmt.frontdoor.models.ActionType
    :ivar description: Describes the functionality of the managed rule.
    :vartype description: str
    """

    _validation = {
        'rule_id': {'readonly': True},
        'default_state': {'readonly': True},
        'default_action': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'default_state': {'key': 'defaultState', 'type': 'str'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleDefinition, self).__init__(**kwargs)
        self.rule_id = None
        self.default_state = None
        self.default_action = None
        self.description = None


class ManagedRuleExclusion(msrest.serialization.Model):
    """Exclude variables from managed rule evaluation.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. The variable type to be excluded. Possible values include:
     "RequestHeaderNames", "RequestCookieNames", "QueryStringArgNames", "RequestBodyPostArgNames",
     "RequestBodyJsonArgNames".
    :type match_variable: str or ~azure.mgmt.frontdoor.models.ManagedRuleExclusionMatchVariable
    :param selector_match_operator: Required. Comparison operator to apply to the selector when
     specifying which elements in the collection this exclusion applies to. Possible values include:
     "Equals", "Contains", "StartsWith", "EndsWith", "EqualsAny".
    :type selector_match_operator: str or
     ~azure.mgmt.frontdoor.models.ManagedRuleExclusionSelectorMatchOperator
    :param selector: Required. Selector value for which elements in the collection this exclusion
     applies to.
    :type selector: str
    """

    _validation = {
        'match_variable': {'required': True},
        'selector_match_operator': {'required': True},
        'selector': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector_match_operator': {'key': 'selectorMatchOperator', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleExclusion, self).__init__(**kwargs)
        self.match_variable = kwargs['match_variable']
        self.selector_match_operator = kwargs['selector_match_operator']
        self.selector = kwargs['selector']


class ManagedRuleGroupDefinition(msrest.serialization.Model):
    """Describes a managed rule group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_group_name: Name of the managed rule group.
    :vartype rule_group_name: str
    :ivar description: Description of the managed rule group.
    :vartype description: str
    :ivar rules: List of rules within the managed rule group.
    :vartype rules: list[~azure.mgmt.frontdoor.models.ManagedRuleDefinition]
    """

    _validation = {
        'rule_group_name': {'readonly': True},
        'description': {'readonly': True},
        'rules': {'readonly': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleGroupDefinition, self).__init__(**kwargs)
        self.rule_group_name = None
        self.description = None
        self.rules = None


class ManagedRuleGroupOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. Describes the managed rule group to override.
    :type rule_group_name: str
    :param exclusions: Describes the exclusions that are applied to all rules in the group.
    :type exclusions: list[~azure.mgmt.frontdoor.models.ManagedRuleExclusion]
    :param rules: List of rules that will be disabled. If none specified, all rules in the group
     will be disabled.
    :type rules: list[~azure.mgmt.frontdoor.models.ManagedRuleOverride]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'exclusions': {'key': 'exclusions', 'type': '[ManagedRuleExclusion]'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleOverride]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleGroupOverride, self).__init__(**kwargs)
        self.rule_group_name = kwargs['rule_group_name']
        self.exclusions = kwargs.get('exclusions', None)
        self.rules = kwargs.get('rules', None)


class ManagedRuleOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. Identifier for the managed rule.
    :type rule_id: str
    :param enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults
     to Disabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.ManagedRuleEnabledState
    :param action: Describes the override action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.frontdoor.models.ActionType
    :param exclusions: Describes the exclusions that are applied to this specific rule.
    :type exclusions: list[~azure.mgmt.frontdoor.models.ManagedRuleExclusion]
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'exclusions': {'key': 'exclusions', 'type': '[ManagedRuleExclusion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleOverride, self).__init__(**kwargs)
        self.rule_id = kwargs['rule_id']
        self.enabled_state = kwargs.get('enabled_state', None)
        self.action = kwargs.get('action', None)
        self.exclusions = kwargs.get('exclusions', None)


class ManagedRuleSet(msrest.serialization.Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :param rule_set_type: Required. Defines the rule set type to use.
    :type rule_set_type: str
    :param rule_set_version: Required. Defines the version of the rule set to use.
    :type rule_set_version: str
    :param rule_set_action: Defines the action to take when a managed rule set score threshold is
     met. Possible values include: "Block", "Log", "Redirect".
    :type rule_set_action: str or ~azure.mgmt.frontdoor.models.ManagedRuleSetActionType
    :param exclusions: Describes the exclusions that are applied to all rules in the set.
    :type exclusions: list[~azure.mgmt.frontdoor.models.ManagedRuleExclusion]
    :param rule_group_overrides: Defines the rule group overrides to apply to the rule set.
    :type rule_group_overrides: list[~azure.mgmt.frontdoor.models.ManagedRuleGroupOverride]
    """

    _validation = {
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
    }

    _attribute_map = {
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'rule_set_action': {'key': 'ruleSetAction', 'type': 'str'},
        'exclusions': {'key': 'exclusions', 'type': '[ManagedRuleExclusion]'},
        'rule_group_overrides': {'key': 'ruleGroupOverrides', 'type': '[ManagedRuleGroupOverride]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleSet, self).__init__(**kwargs)
        self.rule_set_type = kwargs['rule_set_type']
        self.rule_set_version = kwargs['rule_set_version']
        self.rule_set_action = kwargs.get('rule_set_action', None)
        self.exclusions = kwargs.get('exclusions', None)
        self.rule_group_overrides = kwargs.get('rule_group_overrides', None)


class ManagedRuleSetDefinition(Resource):
    """Describes the a managed rule set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the managed rule set.
    :vartype provisioning_state: str
    :ivar rule_set_id: Id of the managed rule set.
    :vartype rule_set_id: str
    :ivar rule_set_type: Type of the managed rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: Version of the managed rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: Rule groups of the managed rule set.
    :vartype rule_groups: list[~azure.mgmt.frontdoor.models.ManagedRuleGroupDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'rule_set_id': {'readonly': True},
        'rule_set_type': {'readonly': True},
        'rule_set_version': {'readonly': True},
        'rule_groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_id': {'key': 'properties.ruleSetId', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ManagedRuleGroupDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleSetDefinition, self).__init__(**kwargs)
        self.provisioning_state = None
        self.rule_set_id = None
        self.rule_set_type = None
        self.rule_set_version = None
        self.rule_groups = None


class ManagedRuleSetDefinitionList(msrest.serialization.Model):
    """List of managed rule set definitions available for use in a policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of managed rule set definitions.
    :vartype value: list[~azure.mgmt.frontdoor.models.ManagedRuleSetDefinition]
    :param next_link: URL to retrieve next set of managed rule set definitions.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedRuleSetDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleSetDefinitionList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class ManagedRuleSetList(msrest.serialization.Model):
    """Defines the list of managed rule sets for the policy.

    :param managed_rule_sets: List of rule sets.
    :type managed_rule_sets: list[~azure.mgmt.frontdoor.models.ManagedRuleSet]
    """

    _attribute_map = {
        'managed_rule_sets': {'key': 'managedRuleSets', 'type': '[ManagedRuleSet]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleSetList, self).__init__(**kwargs)
        self.managed_rule_sets = kwargs.get('managed_rule_sets', None)


class MatchCondition(msrest.serialization.Model):
    """Define a match condition.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. Request variable to compare with. Possible values include:
     "RemoteAddr", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "Cookies", "SocketAddr".
    :type match_variable: str or ~azure.mgmt.frontdoor.models.MatchVariable
    :param selector: Match against a specific key from the QueryString, PostArgs, RequestHeader or
     Cookies variables. Default is null.
    :type selector: str
    :param operator: Required. Comparison type to use for matching with the variable value.
     Possible values include: "Any", "IPMatch", "GeoMatch", "Equal", "Contains", "LessThan",
     "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual", "BeginsWith", "EndsWith", "RegEx".
    :type operator: str or ~azure.mgmt.frontdoor.models.Operator
    :param negate_condition: Describes if the result of this condition should be negated.
    :type negate_condition: bool
    :param match_value: Required. List of possible match values.
    :type match_value: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.frontdoor.models.TransformType]
    """

    _validation = {
        'match_variable': {'required': True},
        'operator': {'required': True},
        'match_value': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_value': {'key': 'matchValue', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MatchCondition, self).__init__(**kwargs)
        self.match_variable = kwargs['match_variable']
        self.selector = kwargs.get('selector', None)
        self.operator = kwargs['operator']
        self.negate_condition = kwargs.get('negate_condition', None)
        self.match_value = kwargs['match_value']
        self.transforms = kwargs.get('transforms', None)


class PolicySettings(msrest.serialization.Model):
    """Defines top-level WebApplicationFirewallPolicy configuration settings.

    :param enabled_state: Describes if the policy is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.PolicyEnabledState
    :param mode: Describes if it is in detection mode or prevention mode at policy level. Possible
     values include: "Prevention", "Detection".
    :type mode: str or ~azure.mgmt.frontdoor.models.PolicyMode
    :param redirect_url: If action type is redirect, this field represents redirect URL for the
     client.
    :type redirect_url: str
    :param custom_block_response_status_code: If the action type is block, customer can override
     the response status code.
    :type custom_block_response_status_code: int
    :param custom_block_response_body: If the action type is block, customer can override the
     response body. The body must be specified in base64 encoding.
    :type custom_block_response_body: str
    :param request_body_check: Describes if policy managed rules will inspect the request body
     content. Possible values include: "Disabled", "Enabled".
    :type request_body_check: str or ~azure.mgmt.frontdoor.models.PolicyRequestBodyCheck
    """

    _validation = {
        'custom_block_response_body': {'pattern': r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$'},
    }

    _attribute_map = {
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'redirect_url': {'key': 'redirectUrl', 'type': 'str'},
        'custom_block_response_status_code': {'key': 'customBlockResponseStatusCode', 'type': 'int'},
        'custom_block_response_body': {'key': 'customBlockResponseBody', 'type': 'str'},
        'request_body_check': {'key': 'requestBodyCheck', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicySettings, self).__init__(**kwargs)
        self.enabled_state = kwargs.get('enabled_state', None)
        self.mode = kwargs.get('mode', None)
        self.redirect_url = kwargs.get('redirect_url', None)
        self.custom_block_response_status_code = kwargs.get('custom_block_response_status_code', None)
        self.custom_block_response_body = kwargs.get('custom_block_response_body', None)
        self.request_body_check = kwargs.get('request_body_check', None)


class PreconfiguredEndpoint(Resource):
    """Defines the properties of a preconfigured endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of the endpoint.
    :type description: str
    :param endpoint: The endpoint that is preconfigured.
    :type endpoint: str
    :param endpoint_type: The type of endpoint. Possible values include: "AFD", "AzureRegion",
     "CDN", "ATM".
    :type endpoint_type: str or ~azure.mgmt.frontdoor.models.EndpointType
    :param backend: The preconfigured endpoint backend.
    :type backend: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'endpoint_type': {'key': 'properties.endpointType', 'type': 'str'},
        'backend': {'key': 'properties.backend', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PreconfiguredEndpoint, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.endpoint = kwargs.get('endpoint', None)
        self.endpoint_type = kwargs.get('endpoint_type', None)
        self.backend = kwargs.get('backend', None)


class PreconfiguredEndpointList(msrest.serialization.Model):
    """Defines a list of preconfigured endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of PreconfiguredEndpoints supported by NetworkExperiment.
    :vartype value: list[~azure.mgmt.frontdoor.models.PreconfiguredEndpoint]
    :param next_link: URL to get the next set of PreconfiguredEndpoints if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PreconfiguredEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PreconfiguredEndpointList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class Profile(Resource):
    """Defines an Network Experiment Profile and lists of Experiments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.NetworkExperimentResourceState
    :param enabled_state: The state of the Experiment. Possible values include: "Enabled",
     "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Profile, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.resource_state = None
        self.enabled_state = kwargs.get('enabled_state', None)


class ProfileList(msrest.serialization.Model):
    """Defines a list of Profiles. It contains a list of Profile objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Profiles within a resource group.
    :vartype value: list[~azure.mgmt.frontdoor.models.Profile]
    :param next_link: URL to get the next set of Profile objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Profile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProfileList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class ProfileUpdateModel(msrest.serialization.Model):
    """Defines modifiable attributes of a Profile.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param enabled_state: The enabled state of the Profile. Possible values include: "Enabled",
     "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProfileUpdateModel, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.enabled_state = kwargs.get('enabled_state', None)


class PurgeParameters(msrest.serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be purged. Can describe a file path
     or a wild card directory.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PurgeParameters, self).__init__(**kwargs)
        self.content_paths = kwargs['content_paths']


class RedirectConfiguration(RouteConfiguration):
    """Describes Redirect Route.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. Constant filled by server.
    :type odata_type: str
    :param redirect_type: The redirect type the rule will use when redirecting traffic. Possible
     values include: "Moved", "Found", "TemporaryRedirect", "PermanentRedirect".
    :type redirect_type: str or ~azure.mgmt.frontdoor.models.FrontDoorRedirectType
    :param redirect_protocol: The protocol of the destination to where the traffic is redirected.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :type redirect_protocol: str or ~azure.mgmt.frontdoor.models.FrontDoorRedirectProtocol
    :param custom_host: Host to redirect. Leave empty to use the incoming host as the destination
     host.
    :type custom_host: str
    :param custom_path: The full path to redirect. Path cannot be empty and must start with /.
     Leave empty to use the incoming path as destination path.
    :type custom_path: str
    :param custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL
     that comes after #. Do not include the #.
    :type custom_fragment: str
    :param custom_query_string: The set of query strings to be placed in the redirect URL. Setting
     this value would replace any existing query string; leave empty to preserve the incoming query
     string. Query string must be in :code:`<key>`=:code:`<value>` format. The first ? and & will be
     added automatically so do not include them in the front, but do separate multiple query strings
     with &.
    :type custom_query_string: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'redirect_type': {'key': 'redirectType', 'type': 'str'},
        'redirect_protocol': {'key': 'redirectProtocol', 'type': 'str'},
        'custom_host': {'key': 'customHost', 'type': 'str'},
        'custom_path': {'key': 'customPath', 'type': 'str'},
        'custom_fragment': {'key': 'customFragment', 'type': 'str'},
        'custom_query_string': {'key': 'customQueryString', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RedirectConfiguration, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'  # type: str
        self.redirect_type = kwargs.get('redirect_type', None)
        self.redirect_protocol = kwargs.get('redirect_protocol', None)
        self.custom_host = kwargs.get('custom_host', None)
        self.custom_path = kwargs.get('custom_path', None)
        self.custom_fragment = kwargs.get('custom_fragment', None)
        self.custom_query_string = kwargs.get('custom_query_string', None)


class RoutingRule(SubResource):
    """A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID.
    :type id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param frontend_endpoints: Frontend endpoints associated with this rule.
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.SubResource]
    :param accepted_protocols: Protocol schemes to match for this rule.
    :type accepted_protocols: list[str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.RoutingRuleEnabledState
    :param route_configuration: A reference to the routing configuration.
    :type route_configuration: ~azure.mgmt.frontdoor.models.RouteConfiguration
    :param rules_engine: A reference to a specific Rules Engine Configuration to apply to this
     route.
    :type rules_engine: ~azure.mgmt.frontdoor.models.SubResource
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     each routing rule (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'frontend_endpoints': {'key': 'properties.frontendEndpoints', 'type': '[SubResource]'},
        'accepted_protocols': {'key': 'properties.acceptedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'properties.patternsToMatch', 'type': '[str]'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'route_configuration': {'key': 'properties.routeConfiguration', 'type': 'RouteConfiguration'},
        'rules_engine': {'key': 'properties.rulesEngine', 'type': 'SubResource'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingRule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None
        self.frontend_endpoints = kwargs.get('frontend_endpoints', None)
        self.accepted_protocols = kwargs.get('accepted_protocols', None)
        self.patterns_to_match = kwargs.get('patterns_to_match', None)
        self.enabled_state = kwargs.get('enabled_state', None)
        self.route_configuration = kwargs.get('route_configuration', None)
        self.rules_engine = kwargs.get('rules_engine', None)
        self.web_application_firewall_policy_link = kwargs.get('web_application_firewall_policy_link', None)
        self.resource_state = None


class RoutingRuleLink(msrest.serialization.Model):
    """Defines the Resource ID for a Routing Rule.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingRuleLink, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class RoutingRuleListResult(msrest.serialization.Model):
    """Result of the request to list Routing Rules. It contains a list of Routing Rule objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Routing Rules within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param next_link: URL to get the next set of RoutingRule objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoutingRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class RoutingRuleUpdateParameters(msrest.serialization.Model):
    """Routing rules to apply to an endpoint.

    :param frontend_endpoints: Frontend endpoints associated with this rule.
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.SubResource]
    :param accepted_protocols: Protocol schemes to match for this rule.
    :type accepted_protocols: list[str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.RoutingRuleEnabledState
    :param route_configuration: A reference to the routing configuration.
    :type route_configuration: ~azure.mgmt.frontdoor.models.RouteConfiguration
    :param rules_engine: A reference to a specific Rules Engine Configuration to apply to this
     route.
    :type rules_engine: ~azure.mgmt.frontdoor.models.SubResource
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     each routing rule (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[SubResource]'},
        'accepted_protocols': {'key': 'acceptedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'route_configuration': {'key': 'routeConfiguration', 'type': 'RouteConfiguration'},
        'rules_engine': {'key': 'rulesEngine', 'type': 'SubResource'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingRuleUpdateParameters, self).__init__(**kwargs)
        self.frontend_endpoints = kwargs.get('frontend_endpoints', None)
        self.accepted_protocols = kwargs.get('accepted_protocols', None)
        self.patterns_to_match = kwargs.get('patterns_to_match', None)
        self.enabled_state = kwargs.get('enabled_state', None)
        self.route_configuration = kwargs.get('route_configuration', None)
        self.rules_engine = kwargs.get('rules_engine', None)
        self.web_application_firewall_policy_link = kwargs.get('web_application_firewall_policy_link', None)


class RoutingRuleProperties(RoutingRuleUpdateParameters):
    """The JSON object that contains the properties required to create a routing rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param frontend_endpoints: Frontend endpoints associated with this rule.
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.SubResource]
    :param accepted_protocols: Protocol schemes to match for this rule.
    :type accepted_protocols: list[str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.RoutingRuleEnabledState
    :param route_configuration: A reference to the routing configuration.
    :type route_configuration: ~azure.mgmt.frontdoor.models.RouteConfiguration
    :param rules_engine: A reference to a specific Rules Engine Configuration to apply to this
     route.
    :type rules_engine: ~azure.mgmt.frontdoor.models.SubResource
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     each routing rule (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[SubResource]'},
        'accepted_protocols': {'key': 'acceptedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'route_configuration': {'key': 'routeConfiguration', 'type': 'RouteConfiguration'},
        'rules_engine': {'key': 'rulesEngine', 'type': 'SubResource'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingRuleProperties, self).__init__(**kwargs)
        self.resource_state = None


class RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink(msrest.serialization.Model):
    """Defines the Web Application Firewall policy for each routing rule (if applicable).

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class RulesEngine(msrest.serialization.Model):
    """A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request and response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id: Resource ID.
    :vartype id: str
    :param rules: A list of rules that define a particular Rules Engine Configuration.
    :type rules: list[~azure.mgmt.frontdoor.models.RulesEngineRule]
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'rules': {'key': 'properties.rules', 'type': '[RulesEngineRule]'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RulesEngine, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.id = None
        self.rules = kwargs.get('rules', None)
        self.resource_state = None


class RulesEngineAction(msrest.serialization.Model):
    """One or more actions that will execute, modifying the request and/or response.

    :param request_header_actions: A list of header actions to apply from the request from AFD to
     the origin.
    :type request_header_actions: list[~azure.mgmt.frontdoor.models.HeaderAction]
    :param response_header_actions: A list of header actions to apply from the response from AFD to
     the client.
    :type response_header_actions: list[~azure.mgmt.frontdoor.models.HeaderAction]
    :param route_configuration_override: Override the route configuration.
    :type route_configuration_override: ~azure.mgmt.frontdoor.models.RouteConfiguration
    """

    _attribute_map = {
        'request_header_actions': {'key': 'requestHeaderActions', 'type': '[HeaderAction]'},
        'response_header_actions': {'key': 'responseHeaderActions', 'type': '[HeaderAction]'},
        'route_configuration_override': {'key': 'routeConfigurationOverride', 'type': 'RouteConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RulesEngineAction, self).__init__(**kwargs)
        self.request_header_actions = kwargs.get('request_header_actions', None)
        self.response_header_actions = kwargs.get('response_header_actions', None)
        self.route_configuration_override = kwargs.get('route_configuration_override', None)


class RulesEngineListResult(msrest.serialization.Model):
    """Result of the request to list Rules Engine Configurations. It contains a list of RulesEngine objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of rulesEngines within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.RulesEngine]
    :param next_link: URL to get the next set of RulesEngine objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RulesEngine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RulesEngineListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class RulesEngineMatchCondition(msrest.serialization.Model):
    """Define a match condition.

    All required parameters must be populated in order to send to Azure.

    :param rules_engine_match_variable: Required. Match Variable. Possible values include:
     "IsMobile", "RemoteAddr", "RequestMethod", "QueryString", "PostArgs", "RequestUri",
     "RequestPath", "RequestFilename", "RequestFilenameExtension", "RequestHeader", "RequestBody",
     "RequestScheme".
    :type rules_engine_match_variable: str or ~azure.mgmt.frontdoor.models.RulesEngineMatchVariable
    :param selector: Name of selector in RequestHeader or RequestBody to be matched.
    :type selector: str
    :param rules_engine_operator: Required. Describes operator to apply to the match condition.
     Possible values include: "Any", "IPMatch", "GeoMatch", "Equal", "Contains", "LessThan",
     "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual", "BeginsWith", "EndsWith".
    :type rules_engine_operator: str or ~azure.mgmt.frontdoor.models.RulesEngineOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param rules_engine_match_value: Required. Match values to match against. The operator will
     apply to each value in here with OR semantics. If any of them match the variable with the given
     operator this match condition is considered a match.
    :type rules_engine_match_value: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.frontdoor.models.Transform]
    """

    _validation = {
        'rules_engine_match_variable': {'required': True},
        'rules_engine_operator': {'required': True},
        'rules_engine_match_value': {'required': True},
    }

    _attribute_map = {
        'rules_engine_match_variable': {'key': 'rulesEngineMatchVariable', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'rules_engine_operator': {'key': 'rulesEngineOperator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'rules_engine_match_value': {'key': 'rulesEngineMatchValue', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RulesEngineMatchCondition, self).__init__(**kwargs)
        self.rules_engine_match_variable = kwargs['rules_engine_match_variable']
        self.selector = kwargs.get('selector', None)
        self.rules_engine_operator = kwargs['rules_engine_operator']
        self.negate_condition = kwargs.get('negate_condition', None)
        self.rules_engine_match_value = kwargs['rules_engine_match_value']
        self.transforms = kwargs.get('transforms', None)


class RulesEngineUpdateParameters(msrest.serialization.Model):
    """Rules Engine Configuration to apply to a Routing Rule.

    :param rules: A list of rules that define a particular Rules Engine Configuration.
    :type rules: list[~azure.mgmt.frontdoor.models.RulesEngineRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[RulesEngineRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RulesEngineUpdateParameters, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)


class RulesEngineProperties(RulesEngineUpdateParameters):
    """The JSON object that contains the properties required to create a Rules Engine Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param rules: A list of rules that define a particular Rules Engine Configuration.
    :type rules: list[~azure.mgmt.frontdoor.models.RulesEngineRule]
    :ivar resource_state: Resource status. Possible values include: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    """

    _validation = {
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[RulesEngineRule]'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RulesEngineProperties, self).__init__(**kwargs)
        self.resource_state = None


class RulesEngineRule(msrest.serialization.Model):
    """Contains a list of match conditions, and an action on how to modify the request/response. If multiple rules match, the actions from one rule that conflict with a previous rule overwrite for a singular action, or append in the case of headers manipulation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A name to refer to this specific rule.
    :type name: str
    :param priority: Required. A priority assigned to this rule.
    :type priority: int
    :param action: Required. Actions to perform on the request and response if all of the match
     conditions are met.
    :type action: ~azure.mgmt.frontdoor.models.RulesEngineAction
    :param match_conditions: A list of match conditions that must meet in order for the actions of
     this rule to run. Having no match conditions means the actions will always run.
    :type match_conditions: list[~azure.mgmt.frontdoor.models.RulesEngineMatchCondition]
    :param match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :type match_processing_behavior: str or ~azure.mgmt.frontdoor.models.MatchProcessingBehavior
    """

    _validation = {
        'name': {'required': True},
        'priority': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'action': {'key': 'action', 'type': 'RulesEngineAction'},
        'match_conditions': {'key': 'matchConditions', 'type': '[RulesEngineMatchCondition]'},
        'match_processing_behavior': {'key': 'matchProcessingBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RulesEngineRule, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.priority = kwargs['priority']
        self.action = kwargs['action']
        self.match_conditions = kwargs.get('match_conditions', None)
        self.match_processing_behavior = kwargs.get('match_processing_behavior', None)


class SecurityPolicyLink(msrest.serialization.Model):
    """Defines the Resource ID for a Security Policy.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityPolicyLink, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class Sku(msrest.serialization.Model):
    """The pricing tier of the web application firewall policy.

    :param name: Name of the pricing tier. Possible values include: "Classic_AzureFrontDoor",
     "Standard_AzureFrontDoor", "Premium_AzureFrontDoor".
    :type name: str or ~azure.mgmt.frontdoor.models.SkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class Timeseries(Resource):
    """Defines the Timeseries.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param endpoint: The endpoint associated with the Timeseries data point.
    :type endpoint: str
    :param start_date_time_utc: The start DateTime of the Timeseries in UTC.
    :type start_date_time_utc: str
    :param end_date_time_utc: The end DateTime of the Timeseries in UTC.
    :type end_date_time_utc: str
    :param aggregation_interval: The aggregation interval of the Timeseries. Possible values
     include: "Hourly", "Daily".
    :type aggregation_interval: str or ~azure.mgmt.frontdoor.models.AggregationInterval
    :param timeseries_type: The type of Timeseries. Possible values include: "MeasurementCounts",
     "LatencyP50", "LatencyP75", "LatencyP95".
    :type timeseries_type: str or ~azure.mgmt.frontdoor.models.TimeseriesType
    :param country: The country associated with the Timeseries. Values are country ISO codes as
     specified here- https://www.iso.org/iso-3166-country-codes.html.
    :type country: str
    :param timeseries_data: The set of data points for the timeseries.
    :type timeseries_data: list[~azure.mgmt.frontdoor.models.TimeseriesDataPoint]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'start_date_time_utc': {'key': 'properties.startDateTimeUTC', 'type': 'str'},
        'end_date_time_utc': {'key': 'properties.endDateTimeUTC', 'type': 'str'},
        'aggregation_interval': {'key': 'properties.aggregationInterval', 'type': 'str'},
        'timeseries_type': {'key': 'properties.timeseriesType', 'type': 'str'},
        'country': {'key': 'properties.country', 'type': 'str'},
        'timeseries_data': {'key': 'properties.timeseriesData', 'type': '[TimeseriesDataPoint]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Timeseries, self).__init__(**kwargs)
        self.endpoint = kwargs.get('endpoint', None)
        self.start_date_time_utc = kwargs.get('start_date_time_utc', None)
        self.end_date_time_utc = kwargs.get('end_date_time_utc', None)
        self.aggregation_interval = kwargs.get('aggregation_interval', None)
        self.timeseries_type = kwargs.get('timeseries_type', None)
        self.country = kwargs.get('country', None)
        self.timeseries_data = kwargs.get('timeseries_data', None)


class TimeseriesDataPoint(msrest.serialization.Model):
    """Defines a timeseries datapoint used in a timeseries.

    :param date_time_utc: The DateTime of the Timeseries data point in UTC.
    :type date_time_utc: str
    :param value: The Value of the Timeseries data point.
    :type value: float
    """

    _attribute_map = {
        'date_time_utc': {'key': 'dateTimeUTC', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeseriesDataPoint, self).__init__(**kwargs)
        self.date_time_utc = kwargs.get('date_time_utc', None)
        self.value = kwargs.get('value', None)


class ValidateCustomDomainInput(msrest.serialization.Model):
    """Input of the custom domain to be validated for DNS mapping.

    All required parameters must be populated in order to send to Azure.

    :param host_name: Required. The host name of the custom domain. Must be a domain name.
    :type host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateCustomDomainInput, self).__init__(**kwargs)
        self.host_name = kwargs['host_name']


class ValidateCustomDomainOutput(msrest.serialization.Model):
    """Output of custom domain validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar custom_domain_validated: Indicates whether the custom domain is valid or not.
    :vartype custom_domain_validated: bool
    :ivar reason: The reason why the custom domain is not valid.
    :vartype reason: str
    :ivar message: Error message describing why the custom domain is not valid.
    :vartype message: str
    """

    _validation = {
        'custom_domain_validated': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'custom_domain_validated': {'key': 'customDomainValidated', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateCustomDomainOutput, self).__init__(**kwargs)
        self.custom_domain_validated = None
        self.reason = None
        self.message = None


class WebApplicationFirewallPolicy(Resource):
    """Defines web application firewall policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param sku: The pricing tier of web application firewall policy. Defaults to
     Classic_AzureFrontDoor if not specified.
    :type sku: ~azure.mgmt.frontdoor.models.Sku
    :param policy_settings: Describes settings for the policy.
    :type policy_settings: ~azure.mgmt.frontdoor.models.PolicySettings
    :param custom_rules: Describes custom rules inside the policy.
    :type custom_rules: ~azure.mgmt.frontdoor.models.CustomRuleList
    :param managed_rules: Describes managed rules inside the policy.
    :type managed_rules: ~azure.mgmt.frontdoor.models.ManagedRuleSetList
    :ivar frontend_endpoint_links: Describes Frontend Endpoints associated with this Web
     Application Firewall policy.
    :vartype frontend_endpoint_links: list[~azure.mgmt.frontdoor.models.FrontendEndpointLink]
    :ivar routing_rule_links: Describes Routing Rules associated with this Web Application Firewall
     policy.
    :vartype routing_rule_links: list[~azure.mgmt.frontdoor.models.RoutingRuleLink]
    :ivar security_policy_links: Describes Security Policy associated with this Web Application
     Firewall policy.
    :vartype security_policy_links: list[~azure.mgmt.frontdoor.models.SecurityPolicyLink]
    :ivar provisioning_state: Provisioning state of the policy.
    :vartype provisioning_state: str
    :ivar resource_state: Resource status of the policy. Possible values include: "Creating",
     "Enabling", "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.frontdoor.models.PolicyResourceState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'frontend_endpoint_links': {'readonly': True},
        'routing_rule_links': {'readonly': True},
        'security_policy_links': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'policy_settings': {'key': 'properties.policySettings', 'type': 'PolicySettings'},
        'custom_rules': {'key': 'properties.customRules', 'type': 'CustomRuleList'},
        'managed_rules': {'key': 'properties.managedRules', 'type': 'ManagedRuleSetList'},
        'frontend_endpoint_links': {'key': 'properties.frontendEndpointLinks', 'type': '[FrontendEndpointLink]'},
        'routing_rule_links': {'key': 'properties.routingRuleLinks', 'type': '[RoutingRuleLink]'},
        'security_policy_links': {'key': 'properties.securityPolicyLinks', 'type': '[SecurityPolicyLink]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebApplicationFirewallPolicy, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.sku = kwargs.get('sku', None)
        self.policy_settings = kwargs.get('policy_settings', None)
        self.custom_rules = kwargs.get('custom_rules', None)
        self.managed_rules = kwargs.get('managed_rules', None)
        self.frontend_endpoint_links = None
        self.routing_rule_links = None
        self.security_policy_links = None
        self.provisioning_state = None
        self.resource_state = None


class WebApplicationFirewallPolicyList(msrest.serialization.Model):
    """Defines a list of WebApplicationFirewallPolicies. It contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of WebApplicationFirewallPolicies within a resource group.
    :vartype value: list[~azure.mgmt.frontdoor.models.WebApplicationFirewallPolicy]
    :param next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there are
     any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebApplicationFirewallPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebApplicationFirewallPolicyList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)
