# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._container_service_client_enums import *


class SubResource(msrest.serialization.Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: VM size availability varies by region. If a node contains insufficient compute
     resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted
     VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    :type vm_size: str
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in the master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
     larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
     after creation. For more information see `Ephemeral OS
     <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Possible values
     include: "Managed", "Ephemeral".
    :type os_disk_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSDiskType
    :param kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime data
     root, and Kubelet ephemeral storage. Possible values include: "OS", "Temporary".
    :type kubelet_disk_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.KubeletDiskType
    :param workload_runtime: Determines the type of workload a node can run. Possible values
     include: "OCIContainer", "WasmWasi".
    :type workload_runtime: str or ~azure.mgmt.containerservice.v2021_09_01.models.WorkloadRuntime
    :param vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and used.
     If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just
     nodes. This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type vnet_subnet_id: str
    :param pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
     vnetSubnetID for more details). This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type pod_subnet_id: str
    :param max_pods: The maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: The operating system type. The default is Linux. Possible values include:
     "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSType
    :param os_sku: Specifies an OS SKU. This value must not be specified if OSType is Windows.
     Possible values include: "Ubuntu", "CBLMariner".
    :type os_sku: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSSKU
    :param max_count: The maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: The minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param scale_down_mode: This also effects the cluster autoscaler behavior. If not specified, it
     defaults to Delete. Possible values include: "Delete", "Deallocate".
    :type scale_down_mode: str or ~azure.mgmt.containerservice.v2021_09_01.models.ScaleDownMode
    :param type_properties_type: The type of Agent Pool. Possible values include:
     "VirtualMachineScaleSets", "AvailabilitySet".
    :type type_properties_type: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolType
    :param mode: A cluster must have at least one 'System' Agent Pool at all times. For additional
     information on agent pool restrictions and best practices, see:
     https://docs.microsoft.com/azure/aks/use-system-pools. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolMode
    :param orchestrator_version: As a best practice, you should upgrade all node pools in an AKS
     cluster to the same Kubernetes version. The node pool version must have the same major version
     as the control plane. The node pool minor version must be within two minor versions of the
     control plane version. The node pool version cannot be greater than the control plane version.
     For more information see `upgrading a node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
    :type orchestrator_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state.
    :vartype provisioning_state: str
    :param power_state: When an Agent Pool is first created it is initially Running. The Agent Pool
     can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and
     does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
     provisioning state is Succeeded.
    :type power_state: ~azure.mgmt.containerservice.v2021_09_01.models.PowerState
    :param availability_zones: The list of Availability zones to use for nodes. This can only be
     specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Some scenarios may require nodes in a node pool to receive their
     own dedicated public IP addresses. A common scenario is for gaming workloads, where a console
     needs to make a direct connection to a cloud virtual machine to minimize hops. For more
     information see `assigning a public IP per node
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.
     The default is false.
    :type enable_node_public_ip: bool
    :param node_public_ip_prefix_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
    :type node_public_ip_prefix_id: str
    :param scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the
     default is 'Regular'. Possible values include: "Spot", "Regular". Default value: "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
     'Spot'. If not specified, the default is 'Delete'. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: Possible values are any decimal value greater than zero or -1 which
     indicates the willingness to pay any on-demand price. For more details on spot pricing, see
     `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
    :type spot_max_price: float
    :param tags: A set of tags. The tags to be persisted on the agent pool virtual machine scale
     set.
    :type tags: dict[str, str]
    :param node_labels: The node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: The taints added to new nodes during node pool create and scale. For
     example, key=value:NoSchedule.
    :type node_taints: list[str]
    :param proximity_placement_group_id: The ID for Proximity Placement Group.
    :type proximity_placement_group_id: str
    :param kubelet_config: The Kubelet configuration on the agent pool nodes.
    :type kubelet_config: ~azure.mgmt.containerservice.v2021_09_01.models.KubeletConfig
    :param linux_os_config: The OS configuration of Linux agent nodes.
    :type linux_os_config: ~azure.mgmt.containerservice.v2021_09_01.models.LinuxOSConfig
    :param enable_encryption_at_host: This is only supported on certain VM sizes and in certain
     Azure regions. For more information, see:
     https://docs.microsoft.com/azure/aks/enable-host-encryption.
    :type enable_encryption_at_host: bool
    :param enable_ultra_ssd: Whether to enable UltraSSD.
    :type enable_ultra_ssd: bool
    :param enable_fips: See `Add a FIPS-enabled node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
     for more details.
    :type enable_fips: bool
    :param gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Possible values include: "MIG1g", "MIG2g", "MIG3g", "MIG4g", "MIG7g".
    :type gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.GPUInstanceProfile
    :param creation_data: CreationData to be used to specify the source Snapshot ID if the node
     pool will be created/upgraded using a snapshot.
    :type creation_data: ~azure.mgmt.containerservice.v2021_09_01.models.CreationData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'node_image_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'properties.osDiskSizeGB', 'type': 'int'},
        'os_disk_type': {'key': 'properties.osDiskType', 'type': 'str'},
        'kubelet_disk_type': {'key': 'properties.kubeletDiskType', 'type': 'str'},
        'workload_runtime': {'key': 'properties.workloadRuntime', 'type': 'str'},
        'vnet_subnet_id': {'key': 'properties.vnetSubnetID', 'type': 'str'},
        'pod_subnet_id': {'key': 'properties.podSubnetID', 'type': 'str'},
        'max_pods': {'key': 'properties.maxPods', 'type': 'int'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_sku': {'key': 'properties.osSKU', 'type': 'str'},
        'max_count': {'key': 'properties.maxCount', 'type': 'int'},
        'min_count': {'key': 'properties.minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'properties.enableAutoScaling', 'type': 'bool'},
        'scale_down_mode': {'key': 'properties.scaleDownMode', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
        'orchestrator_version': {'key': 'properties.orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'properties.nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'properties.upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'power_state': {'key': 'properties.powerState', 'type': 'PowerState'},
        'availability_zones': {'key': 'properties.availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'properties.enableNodePublicIP', 'type': 'bool'},
        'node_public_ip_prefix_id': {'key': 'properties.nodePublicIPPrefixID', 'type': 'str'},
        'scale_set_priority': {'key': 'properties.scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'properties.scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'properties.spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'properties.tags', 'type': '{str}'},
        'node_labels': {'key': 'properties.nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'properties.nodeTaints', 'type': '[str]'},
        'proximity_placement_group_id': {'key': 'properties.proximityPlacementGroupID', 'type': 'str'},
        'kubelet_config': {'key': 'properties.kubeletConfig', 'type': 'KubeletConfig'},
        'linux_os_config': {'key': 'properties.linuxOSConfig', 'type': 'LinuxOSConfig'},
        'enable_encryption_at_host': {'key': 'properties.enableEncryptionAtHost', 'type': 'bool'},
        'enable_ultra_ssd': {'key': 'properties.enableUltraSSD', 'type': 'bool'},
        'enable_fips': {'key': 'properties.enableFIPS', 'type': 'bool'},
        'gpu_instance_profile': {'key': 'properties.gpuInstanceProfile', 'type': 'str'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[str] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "KubeletDiskType"]] = None,
        workload_runtime: Optional[Union[str, "WorkloadRuntime"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Optional[Union[str, "OSType"]] = "Linux",
        os_sku: Optional[Union[str, "OSSKU"]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        scale_down_mode: Optional[Union[str, "ScaleDownMode"]] = None,
        type_properties_type: Optional[Union[str, "AgentPoolType"]] = None,
        mode: Optional[Union[str, "AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["AgentPoolUpgradeSettings"] = None,
        power_state: Optional["PowerState"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        node_public_ip_prefix_id: Optional[str] = None,
        scale_set_priority: Optional[Union[str, "ScaleSetPriority"]] = "Regular",
        scale_set_eviction_policy: Optional[Union[str, "ScaleSetEvictionPolicy"]] = "Delete",
        spot_max_price: Optional[float] = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["KubeletConfig"] = None,
        linux_os_config: Optional["LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        enable_ultra_ssd: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        gpu_instance_profile: Optional[Union[str, "GPUInstanceProfile"]] = None,
        creation_data: Optional["CreationData"] = None,
        **kwargs
    ):
        super(AgentPool, self).__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.os_disk_type = os_disk_type
        self.kubelet_disk_type = kubelet_disk_type
        self.workload_runtime = workload_runtime
        self.vnet_subnet_id = vnet_subnet_id
        self.pod_subnet_id = pod_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.os_sku = os_sku
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.scale_down_mode = scale_down_mode
        self.type_properties_type = type_properties_type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = None
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.power_state = power_state
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.node_public_ip_prefix_id = node_public_ip_prefix_id
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.proximity_placement_group_id = proximity_placement_group_id
        self.kubelet_config = kubelet_config
        self.linux_os_config = linux_os_config
        self.enable_encryption_at_host = enable_encryption_at_host
        self.enable_ultra_ssd = enable_ultra_ssd
        self.enable_fips = enable_fips
        self.gpu_instance_profile = gpu_instance_profile
        self.creation_data = creation_data


class AgentPoolAvailableVersions(msrest.serialization.Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the agent pool version list.
    :vartype id: str
    :ivar name: The name of the agent pool version list.
    :vartype name: str
    :ivar type: Type of the agent pool version list.
    :vartype type: str
    :param agent_pool_versions: List of versions available for agent pool.
    :type agent_pool_versions:
     list[~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'agent_pool_versions': {'key': 'properties.agentPoolVersions', 'type': '[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]'},
    }

    def __init__(
        self,
        *,
        agent_pool_versions: Optional[List["AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem"]] = None,
        **kwargs
    ):
        super(AgentPoolAvailableVersions, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = agent_pool_versions


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(msrest.serialization.Model):
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :param default: Whether this version is the default agent pool version.
    :type default: bool
    :param kubernetes_version: The Kubernetes version (major.minor.patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'bool'},
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        default: Optional[bool] = None,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        super(AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem, self).__init__(**kwargs)
        self.default = default
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolListResult(msrest.serialization.Model):
    """The response from the List Agent Pools operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of agent pools.
    :type value: list[~azure.mgmt.containerservice.v2021_09_01.models.AgentPool]
    :ivar next_link: The URL to get the next set of agent pool results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AgentPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AgentPool"]] = None,
        **kwargs
    ):
        super(AgentPoolListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AgentPoolUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: The name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: The type of the agent pool upgrade profile.
    :vartype type: str
    :param kubernetes_version: Required. The Kubernetes version (major.minor.patch).
    :type kubernetes_version: str
    :param os_type: Required. The operating system type. The default is Linux. Possible values
     include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    :param latest_node_image_version: The latest AKS supported node image version.
    :type latest_node_image_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'upgrades': {'key': 'properties.upgrades', 'type': '[AgentPoolUpgradeProfilePropertiesUpgradesItem]'},
        'latest_node_image_version': {'key': 'properties.latestNodeImageVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "OSType"] = "Linux",
        upgrades: Optional[List["AgentPoolUpgradeProfilePropertiesUpgradesItem"]] = None,
        latest_node_image_version: Optional[str] = None,
        **kwargs
    ):
        super(AgentPoolUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kubernetes_version
        self.os_type = os_type
        self.upgrades = upgrades
        self.latest_node_image_version = latest_node_image_version


class AgentPoolUpgradeProfilePropertiesUpgradesItem(msrest.serialization.Model):
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :param kubernetes_version: The Kubernetes version (major.minor.patch).
    :type kubernetes_version: str
    :param is_preview: Whether the Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        super(AgentPoolUpgradeProfilePropertiesUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolUpgradeSettings(msrest.serialization.Model):
    """Settings for upgrading an agentpool.

    :param max_surge: This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%').
     If a percentage is specified, it is the percentage of the total agent pool size at the time of
     the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is
     1. For more information, including best practices, see:
     https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade.
    :type max_surge: str
    """

    _attribute_map = {
        'max_surge': {'key': 'maxSurge', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        max_surge: Optional[str] = None,
        **kwargs
    ):
        super(AgentPoolUpgradeSettings, self).__init__(**kwargs)
        self.max_surge = max_surge


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Container service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.containerservice.v2021_09_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ContainerServiceDiagnosticsProfile(msrest.serialization.Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param vm_diagnostics: Required. Profile for diagnostics on the container service VMs.
    :type vm_diagnostics:
     ~azure.mgmt.containerservice.v2021_09_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        'vm_diagnostics': {'required': True},
    }

    _attribute_map = {
        'vm_diagnostics': {'key': 'vmDiagnostics', 'type': 'ContainerServiceVMDiagnostics'},
    }

    def __init__(
        self,
        *,
        vm_diagnostics: "ContainerServiceVMDiagnostics",
        **kwargs
    ):
        super(ContainerServiceDiagnosticsProfile, self).__init__(**kwargs)
        self.vm_diagnostics = vm_diagnostics


class ContainerServiceLinuxProfile(msrest.serialization.Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. The administrator username to use for Linux VMs.
    :type admin_username: str
    :param ssh: Required. The SSH configuration for Linux-based VMs running on Azure.
    :type ssh: ~azure.mgmt.containerservice.v2021_09_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[A-Za-z][-A-Za-z0-9_]*$'},
        'ssh': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'ssh': {'key': 'ssh', 'type': 'ContainerServiceSshConfiguration'},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        ssh: "ContainerServiceSshConfiguration",
        **kwargs
    ):
        super(ContainerServiceLinuxProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh = ssh


class ContainerServiceMasterProfile(msrest.serialization.Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of masters (VMs) in the container service cluster. Allowed values are 1,
     3, and 5. The default value is 1. Possible values include: 1, 3, 5. Default value: "1".
    :type count: str or ~azure.mgmt.containerservice.v2021_09_01.models.Count
    :param dns_prefix: Required. DNS prefix to be used to create the FQDN for the master pool.
    :type dns_prefix: str
    :param vm_size: Required. Size of agent VMs. Possible values include: "Standard_A1",
     "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2",
     "Standard_A2m_v2", "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2",
     "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2",
     "Standard_A8m_v2", "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo",
     "Standard_D12", "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :type vnet_subnet_id: str
    :param first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static
     ip of masters.
    :type first_consecutive_static_ip: str
    :param storage_profile: Storage profile specifies what kind of storage used. Choose from
     StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
     orchestrator choice. Possible values include: "StorageAccount", "ManagedDisks".
    :type storage_profile: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        'dns_prefix': {'required': True},
        'vm_size': {'required': True},
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'first_consecutive_static_ip': {'key': 'firstConsecutiveStaticIP', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dns_prefix: str,
        vm_size: Union[str, "ContainerServiceVMSizeTypes"],
        count: Optional[Union[int, "Count"]] = "1",
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        first_consecutive_static_ip: Optional[str] = "10.240.255.5",
        storage_profile: Optional[Union[str, "ContainerServiceStorageProfileTypes"]] = None,
        **kwargs
    ):
        super(ContainerServiceMasterProfile, self).__init__(**kwargs)
        self.count = count
        self.dns_prefix = dns_prefix
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.first_consecutive_static_ip = first_consecutive_static_ip
        self.storage_profile = storage_profile
        self.fqdn = None


class ContainerServiceNetworkProfile(msrest.serialization.Model):
    """Profile of network configuration.

    :param network_plugin: Network plugin used for building the Kubernetes network. Possible values
     include: "azure", "kubenet". Default value: "kubenet".
    :type network_plugin: str or ~azure.mgmt.containerservice.v2021_09_01.models.NetworkPlugin
    :param network_policy: Network policy used for building the Kubernetes network. Possible values
     include: "calico", "azure".
    :type network_policy: str or ~azure.mgmt.containerservice.v2021_09_01.models.NetworkPolicy
    :param network_mode: This cannot be specified if networkPlugin is anything other than 'azure'.
     Possible values include: "transparent", "bridge".
    :type network_mode: str or ~azure.mgmt.containerservice.v2021_09_01.models.NetworkMode
    :param pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
    :type pod_cidr: str
    :param service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :type service_cidr: str
    :param dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :type dns_service_ip: str
    :param docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :type docker_bridge_cidr: str
    :param outbound_type: This can only be set at cluster creation time and cannot be changed
     later. For more information see `egress outbound type
     <https://docs.microsoft.com/azure/aks/egress-outboundtype>`_. Possible values include:
     "loadBalancer", "userDefinedRouting", "managedNATGateway", "userAssignedNATGateway". Default
     value: "loadBalancer".
    :type outbound_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OutboundType
    :param load_balancer_sku: The default is 'standard'. See `Azure Load Balancer SKUs
     <https://docs.microsoft.com/azure/load-balancer/skus>`_ for more information about the
     differences between load balancer SKUs. Possible values include: "standard", "basic".
    :type load_balancer_sku: str or ~azure.mgmt.containerservice.v2021_09_01.models.LoadBalancerSku
    :param load_balancer_profile: Profile of the cluster load balancer.
    :type load_balancer_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterLoadBalancerProfile
    :param nat_gateway_profile: Profile of the cluster NAT gateway.
    :type nat_gateway_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterNATGatewayProfile
    """

    _validation = {
        'pod_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'network_plugin': {'key': 'networkPlugin', 'type': 'str'},
        'network_policy': {'key': 'networkPolicy', 'type': 'str'},
        'network_mode': {'key': 'networkMode', 'type': 'str'},
        'pod_cidr': {'key': 'podCidr', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
        'outbound_type': {'key': 'outboundType', 'type': 'str'},
        'load_balancer_sku': {'key': 'loadBalancerSku', 'type': 'str'},
        'load_balancer_profile': {'key': 'loadBalancerProfile', 'type': 'ManagedClusterLoadBalancerProfile'},
        'nat_gateway_profile': {'key': 'natGatewayProfile', 'type': 'ManagedClusterNATGatewayProfile'},
    }

    def __init__(
        self,
        *,
        network_plugin: Optional[Union[str, "NetworkPlugin"]] = "kubenet",
        network_policy: Optional[Union[str, "NetworkPolicy"]] = None,
        network_mode: Optional[Union[str, "NetworkMode"]] = None,
        pod_cidr: Optional[str] = "10.244.0.0/16",
        service_cidr: Optional[str] = "10.0.0.0/16",
        dns_service_ip: Optional[str] = "10.0.0.10",
        docker_bridge_cidr: Optional[str] = "172.17.0.1/16",
        outbound_type: Optional[Union[str, "OutboundType"]] = "loadBalancer",
        load_balancer_sku: Optional[Union[str, "LoadBalancerSku"]] = None,
        load_balancer_profile: Optional["ManagedClusterLoadBalancerProfile"] = None,
        nat_gateway_profile: Optional["ManagedClusterNATGatewayProfile"] = None,
        **kwargs
    ):
        super(ContainerServiceNetworkProfile, self).__init__(**kwargs)
        self.network_plugin = network_plugin
        self.network_policy = network_policy
        self.network_mode = network_mode
        self.pod_cidr = pod_cidr
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr
        self.outbound_type = outbound_type
        self.load_balancer_sku = load_balancer_sku
        self.load_balancer_profile = load_balancer_profile
        self.nat_gateway_profile = nat_gateway_profile


class ContainerServiceSshConfiguration(msrest.serialization.Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to Azure.

    :param public_keys: Required. The list of SSH public keys used to authenticate with Linux-based
     VMs. A maximum of 1 key may be specified.
    :type public_keys:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        'public_keys': {'required': True},
    }

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[ContainerServiceSshPublicKey]'},
    }

    def __init__(
        self,
        *,
        public_keys: List["ContainerServiceSshPublicKey"],
        **kwargs
    ):
        super(ContainerServiceSshConfiguration, self).__init__(**kwargs)
        self.public_keys = public_keys


class ContainerServiceSshPublicKey(msrest.serialization.Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to Azure.

    :param key_data: Required. Certificate public key used to authenticate with VMs through SSH.
     The certificate must be in PEM format with or without headers.
    :type key_data: str
    """

    _validation = {
        'key_data': {'required': True},
    }

    _attribute_map = {
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_data: str,
        **kwargs
    ):
        super(ContainerServiceSshPublicKey, self).__init__(**kwargs)
        self.key_data = key_data


class ContainerServiceVMDiagnostics(msrest.serialization.Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the VM diagnostic agent is provisioned on the VM.
    :type enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are stored.
    :vartype storage_uri: str
    """

    _validation = {
        'enabled': {'required': True},
        'storage_uri': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        **kwargs
    ):
        super(ContainerServiceVMDiagnostics, self).__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = None


class CreationData(msrest.serialization.Model):
    """Data used when creating a target resource from a source resource.

    :param source_resource_id: This is the ARM ID of the source object to be used to create the
     target object.
    :type source_resource_id: str
    """

    _attribute_map = {
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(CreationData, self).__init__(**kwargs)
        self.source_resource_id = source_resource_id


class CredentialResult(msrest.serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytearray
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResult, self).__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(msrest.serialization.Model):
    """The list credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.containerservice.v2021_09_01.models.CredentialResult]
    """

    _validation = {
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[CredentialResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResults, self).__init__(**kwargs)
        self.kubeconfigs = None


class EndpointDependency(msrest.serialization.Model):
    """A domain name that AKS agent nodes are reaching at.

    :param domain_name: The domain name of the dependency.
    :type domain_name: str
    :param endpoint_details: The Ports and Protocols used when connecting to domainName.
    :type endpoint_details: list[~azure.mgmt.containerservice.v2021_09_01.models.EndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["EndpointDetail"]] = None,
        **kwargs
    ):
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(msrest.serialization.Model):
    """connect information from the AKS agent nodes to a single endpoint.

    :param ip_address: An IP Address that Domain Name currently resolves to.
    :type ip_address: str
    :param port: The port an endpoint is connected to.
    :type port: int
    :param protocol: The protocol used for connection.
    :type protocol: str
    :param description: Description of the detail.
    :type description: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(EndpointDetail, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.protocol = protocol
        self.description = description


class ExtendedLocation(msrest.serialization.Model):
    """The complex type of the extended location.

    :param name: The name of the extended location.
    :type name: str
    :param type: The type of the extended location. Possible values include: "EdgeZone".
    :type type: str or ~azure.mgmt.containerservice.v2021_09_01.models.ExtendedLocationTypes
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "ExtendedLocationTypes"]] = None,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.type = type


class KubeletConfig(msrest.serialization.Model):
    """See `AKS custom node configuration <https://docs.microsoft.com/azure/aks/custom-node-configuration>`_ for more details.

    :param cpu_manager_policy: The default is 'none'. See `Kubernetes CPU management policies
     <https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies>`_
     for more information. Allowed values are 'none' and 'static'.
    :type cpu_manager_policy: str
    :param cpu_cfs_quota: The default is true.
    :type cpu_cfs_quota: bool
    :param cpu_cfs_quota_period: The default is '100ms.' Valid values are a sequence of decimal
     numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported
     units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
    :type cpu_cfs_quota_period: str
    :param image_gc_high_threshold: To disable image garbage collection, set to 100. The default is
     85%.
    :type image_gc_high_threshold: int
    :param image_gc_low_threshold: This cannot be set higher than imageGcHighThreshold. The default
     is 80%.
    :type image_gc_low_threshold: int
    :param topology_manager_policy: For more information see `Kubernetes Topology Manager
     <https://kubernetes.io/docs/tasks/administer-cluster/topology-manager>`_. The default is
     'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
    :type topology_manager_policy: str
    :param allowed_unsafe_sysctls: Allowed list of unsafe sysctls or unsafe sysctl patterns (ending
     in ``*``\ ).
    :type allowed_unsafe_sysctls: list[str]
    :param fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled
     on the node.
    :type fail_swap_on: bool
    :param container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before it
     is rotated.
    :type container_log_max_size_mb: int
    :param container_log_max_files: The maximum number of container log files that can be present
     for a container. The number must be ≥ 2.
    :type container_log_max_files: int
    :param pod_max_pids: The maximum number of processes per pod.
    :type pod_max_pids: int
    """

    _validation = {
        'container_log_max_files': {'minimum': 2},
    }

    _attribute_map = {
        'cpu_manager_policy': {'key': 'cpuManagerPolicy', 'type': 'str'},
        'cpu_cfs_quota': {'key': 'cpuCfsQuota', 'type': 'bool'},
        'cpu_cfs_quota_period': {'key': 'cpuCfsQuotaPeriod', 'type': 'str'},
        'image_gc_high_threshold': {'key': 'imageGcHighThreshold', 'type': 'int'},
        'image_gc_low_threshold': {'key': 'imageGcLowThreshold', 'type': 'int'},
        'topology_manager_policy': {'key': 'topologyManagerPolicy', 'type': 'str'},
        'allowed_unsafe_sysctls': {'key': 'allowedUnsafeSysctls', 'type': '[str]'},
        'fail_swap_on': {'key': 'failSwapOn', 'type': 'bool'},
        'container_log_max_size_mb': {'key': 'containerLogMaxSizeMB', 'type': 'int'},
        'container_log_max_files': {'key': 'containerLogMaxFiles', 'type': 'int'},
        'pod_max_pids': {'key': 'podMaxPids', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        cpu_manager_policy: Optional[str] = None,
        cpu_cfs_quota: Optional[bool] = None,
        cpu_cfs_quota_period: Optional[str] = None,
        image_gc_high_threshold: Optional[int] = None,
        image_gc_low_threshold: Optional[int] = None,
        topology_manager_policy: Optional[str] = None,
        allowed_unsafe_sysctls: Optional[List[str]] = None,
        fail_swap_on: Optional[bool] = None,
        container_log_max_size_mb: Optional[int] = None,
        container_log_max_files: Optional[int] = None,
        pod_max_pids: Optional[int] = None,
        **kwargs
    ):
        super(KubeletConfig, self).__init__(**kwargs)
        self.cpu_manager_policy = cpu_manager_policy
        self.cpu_cfs_quota = cpu_cfs_quota
        self.cpu_cfs_quota_period = cpu_cfs_quota_period
        self.image_gc_high_threshold = image_gc_high_threshold
        self.image_gc_low_threshold = image_gc_low_threshold
        self.topology_manager_policy = topology_manager_policy
        self.allowed_unsafe_sysctls = allowed_unsafe_sysctls
        self.fail_swap_on = fail_swap_on
        self.container_log_max_size_mb = container_log_max_size_mb
        self.container_log_max_files = container_log_max_files
        self.pod_max_pids = pod_max_pids


class LinuxOSConfig(msrest.serialization.Model):
    """See `AKS custom node configuration <https://docs.microsoft.com/azure/aks/custom-node-configuration>`_ for more details.

    :param sysctls: Sysctl settings for Linux agent nodes.
    :type sysctls: ~azure.mgmt.containerservice.v2021_09_01.models.SysctlConfig
    :param transparent_huge_page_enabled: Valid values are 'always', 'madvise', and 'never'. The
     default is 'always'. For more information see `Transparent Hugepages
     <https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge>`_.
    :type transparent_huge_page_enabled: str
    :param transparent_huge_page_defrag: Valid values are 'always', 'defer', 'defer+madvise',
     'madvise' and 'never'. The default is 'madvise'. For more information see `Transparent
     Hugepages
     <https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge>`_.
    :type transparent_huge_page_defrag: str
    :param swap_file_size_mb: The size in MB of a swap file that will be created on each node.
    :type swap_file_size_mb: int
    """

    _attribute_map = {
        'sysctls': {'key': 'sysctls', 'type': 'SysctlConfig'},
        'transparent_huge_page_enabled': {'key': 'transparentHugePageEnabled', 'type': 'str'},
        'transparent_huge_page_defrag': {'key': 'transparentHugePageDefrag', 'type': 'str'},
        'swap_file_size_mb': {'key': 'swapFileSizeMB', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        sysctls: Optional["SysctlConfig"] = None,
        transparent_huge_page_enabled: Optional[str] = None,
        transparent_huge_page_defrag: Optional[str] = None,
        swap_file_size_mb: Optional[int] = None,
        **kwargs
    ):
        super(LinuxOSConfig, self).__init__(**kwargs)
        self.sysctls = sysctls
        self.transparent_huge_page_enabled = transparent_huge_page_enabled
        self.transparent_huge_page_defrag = transparent_huge_page_defrag
        self.swap_file_size_mb = swap_file_size_mb


class MaintenanceConfiguration(SubResource):
    """See `planned maintenance <https://docs.microsoft.com/azure/aks/planned-maintenance>`_ for more information about planned maintenance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.containerservice.v2021_09_01.models.SystemData
    :param time_in_week: If two array entries specify the same day of the week, the applied
     configuration is the union of times in both entries.
    :type time_in_week: list[~azure.mgmt.containerservice.v2021_09_01.models.TimeInWeek]
    :param not_allowed_time: Time slots on which upgrade is not allowed.
    :type not_allowed_time: list[~azure.mgmt.containerservice.v2021_09_01.models.TimeSpan]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'time_in_week': {'key': 'properties.timeInWeek', 'type': '[TimeInWeek]'},
        'not_allowed_time': {'key': 'properties.notAllowedTime', 'type': '[TimeSpan]'},
    }

    def __init__(
        self,
        *,
        time_in_week: Optional[List["TimeInWeek"]] = None,
        not_allowed_time: Optional[List["TimeSpan"]] = None,
        **kwargs
    ):
        super(MaintenanceConfiguration, self).__init__(**kwargs)
        self.system_data = None
        self.time_in_week = time_in_week
        self.not_allowed_time = not_allowed_time


class MaintenanceConfigurationListResult(msrest.serialization.Model):
    """The response from the List maintenance configurations operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of maintenance configurations.
    :type value: list[~azure.mgmt.containerservice.v2021_09_01.models.MaintenanceConfiguration]
    :ivar next_link: The URL to get the next set of maintenance configuration results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MaintenanceConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MaintenanceConfiguration"]] = None,
        **kwargs
    ):
        super(MaintenanceConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ManagedCluster(Resource):
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The managed cluster SKU.
    :type sku: ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterSKU
    :param extended_location: The extended location of the Virtual Machine.
    :type extended_location: ~azure.mgmt.containerservice.v2021_09_01.models.ExtendedLocation
    :param identity: The identity of the managed cluster, if configured.
    :type identity: ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current provisioning state.
    :vartype provisioning_state: str
    :ivar power_state: The Power State of the cluster.
    :vartype power_state: ~azure.mgmt.containerservice.v2021_09_01.models.PowerState
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :param kubernetes_version: When you upgrade a supported AKS cluster, Kubernetes minor versions
     cannot be skipped. All upgrades must be performed sequentially by major version number. For
     example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x ->
     1.16.x is not allowed. See `upgrading an AKS cluster
     <https://docs.microsoft.com/azure/aks/upgrade-cluster>`_ for more details.
    :type kubernetes_version: str
    :param dns_prefix: This cannot be updated once the Managed Cluster has been created.
    :type dns_prefix: str
    :param fqdn_subdomain: This cannot be updated once the Managed Cluster has been created.
    :type fqdn_subdomain: str
    :ivar fqdn: The FQDN of the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: The FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar azure_portal_fqdn: The Azure Portal requires certain Cross-Origin Resource Sharing (CORS)
     headers to be sent in some responses, which Kubernetes APIServer doesn't handle by default.
     This special FQDN supports CORS, allowing the Azure Portal to function properly.
    :vartype azure_portal_fqdn: str
    :param agent_pool_profiles: The agent pool properties.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterAgentPoolProfile]
    :param linux_profile: The profile for Linux VMs in the Managed Cluster.
    :type linux_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ContainerServiceLinuxProfile
    :param windows_profile: The profile for Windows VMs in the Managed Cluster.
    :type windows_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterWindowsProfile
    :param service_principal_profile: Information about a service principal identity for the
     cluster to use for manipulating Azure APIs.
    :type service_principal_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterServicePrincipalProfile
    :param addon_profiles: The profile of managed cluster add-on.
    :type addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterAddonProfile]
    :param pod_identity_profile: See `use AAD pod identity
     <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity>`_ for more details on AAD pod
     identity integration.
    :type pod_identity_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentityProfile
    :param node_resource_group: The name of the resource group containing agent pool nodes.
    :type node_resource_group: str
    :param enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :type enable_rbac: bool
    :param enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :type enable_pod_security_policy: bool
    :param network_profile: The network configuration profile.
    :type network_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ContainerServiceNetworkProfile
    :param aad_profile: The Azure Active Directory configuration.
    :type aad_profile: ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterAADProfile
    :param auto_upgrade_profile: The auto upgrade configuration.
    :type auto_upgrade_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterAutoUpgradeProfile
    :param auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :type auto_scaler_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPropertiesAutoScalerProfile
    :param api_server_access_profile: The access profile for managed cluster API server.
    :type api_server_access_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterAPIServerAccessProfile
    :param disk_encryption_set_id: This is of the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'.
    :type disk_encryption_set_id: str
    :param identity_profile: Identities associated with the cluster.
    :type identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2021_09_01.models.UserAssignedIdentity]
    :param private_link_resources: Private link resources associated with the cluster.
    :type private_link_resources:
     list[~azure.mgmt.containerservice.v2021_09_01.models.PrivateLinkResource]
    :param disable_local_accounts: If set to true, getting static credentials will be disabled for
     this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details
     see `disable local accounts
     <https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview>`_.
    :type disable_local_accounts: bool
    :param http_proxy_config: Configurations for provisioning the cluster with HTTP proxy servers.
    :type http_proxy_config:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterHTTPProxyConfig
    :param security_profile: Security profile for the managed cluster.
    :type security_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterSecurityProfile
    :param public_network_access: Default value is 'Enabled' (case insensitive). Could be set to
     'Disabled' to enable private cluster. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'power_state': {'readonly': True},
        'max_agent_pools': {'readonly': True},
        'fqdn': {'readonly': True},
        'private_fqdn': {'readonly': True},
        'azure_portal_fqdn': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ManagedClusterSKU'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'identity': {'key': 'identity', 'type': 'ManagedClusterIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'power_state': {'key': 'properties.powerState', 'type': 'PowerState'},
        'max_agent_pools': {'key': 'properties.maxAgentPools', 'type': 'int'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'dns_prefix': {'key': 'properties.dnsPrefix', 'type': 'str'},
        'fqdn_subdomain': {'key': 'properties.fqdnSubdomain', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'private_fqdn': {'key': 'properties.privateFQDN', 'type': 'str'},
        'azure_portal_fqdn': {'key': 'properties.azurePortalFQDN', 'type': 'str'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterAgentPoolProfile]'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ManagedClusterWindowsProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ManagedClusterServicePrincipalProfile'},
        'addon_profiles': {'key': 'properties.addonProfiles', 'type': '{ManagedClusterAddonProfile}'},
        'pod_identity_profile': {'key': 'properties.podIdentityProfile', 'type': 'ManagedClusterPodIdentityProfile'},
        'node_resource_group': {'key': 'properties.nodeResourceGroup', 'type': 'str'},
        'enable_rbac': {'key': 'properties.enableRBAC', 'type': 'bool'},
        'enable_pod_security_policy': {'key': 'properties.enablePodSecurityPolicy', 'type': 'bool'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerServiceNetworkProfile'},
        'aad_profile': {'key': 'properties.aadProfile', 'type': 'ManagedClusterAADProfile'},
        'auto_upgrade_profile': {'key': 'properties.autoUpgradeProfile', 'type': 'ManagedClusterAutoUpgradeProfile'},
        'auto_scaler_profile': {'key': 'properties.autoScalerProfile', 'type': 'ManagedClusterPropertiesAutoScalerProfile'},
        'api_server_access_profile': {'key': 'properties.apiServerAccessProfile', 'type': 'ManagedClusterAPIServerAccessProfile'},
        'disk_encryption_set_id': {'key': 'properties.diskEncryptionSetID', 'type': 'str'},
        'identity_profile': {'key': 'properties.identityProfile', 'type': '{UserAssignedIdentity}'},
        'private_link_resources': {'key': 'properties.privateLinkResources', 'type': '[PrivateLinkResource]'},
        'disable_local_accounts': {'key': 'properties.disableLocalAccounts', 'type': 'bool'},
        'http_proxy_config': {'key': 'properties.httpProxyConfig', 'type': 'ManagedClusterHTTPProxyConfig'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'ManagedClusterSecurityProfile'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ManagedClusterSKU"] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        identity: Optional["ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        fqdn_subdomain: Optional[str] = None,
        agent_pool_profiles: Optional[List["ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "ManagedClusterAddonProfile"]] = None,
        pod_identity_profile: Optional["ManagedClusterPodIdentityProfile"] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["ManagedClusterAADProfile"] = None,
        auto_upgrade_profile: Optional["ManagedClusterAutoUpgradeProfile"] = None,
        auto_scaler_profile: Optional["ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        private_link_resources: Optional[List["PrivateLinkResource"]] = None,
        disable_local_accounts: Optional[bool] = None,
        http_proxy_config: Optional["ManagedClusterHTTPProxyConfig"] = None,
        security_profile: Optional["ManagedClusterSecurityProfile"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(ManagedCluster, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.extended_location = extended_location
        self.identity = identity
        self.provisioning_state = None
        self.power_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn_subdomain = fqdn_subdomain
        self.fqdn = None
        self.private_fqdn = None
        self.azure_portal_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.pod_identity_profile = pod_identity_profile
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_upgrade_profile = auto_upgrade_profile
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile
        self.private_link_resources = private_link_resources
        self.disable_local_accounts = disable_local_accounts
        self.http_proxy_config = http_proxy_config
        self.security_profile = security_profile
        self.public_network_access = public_network_access


class ManagedClusterAADProfile(msrest.serialization.Model):
    """For more details see `managed AAD on AKS <https://docs.microsoft.com/azure/aks/managed-aad>`_.

    :param managed: Whether to enable managed AAD.
    :type managed: bool
    :param enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
    :type enable_azure_rbac: bool
    :param admin_group_object_i_ds: The list of AAD group object IDs that will have admin role of
     the cluster.
    :type admin_group_object_i_ds: list[str]
    :param client_app_id: The client AAD application ID.
    :type client_app_id: str
    :param server_app_id: The server AAD application ID.
    :type server_app_id: str
    :param server_app_secret: The server AAD application secret.
    :type server_app_secret: str
    :param tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
     tenant of the deployment subscription.
    :type tenant_id: str
    """

    _attribute_map = {
        'managed': {'key': 'managed', 'type': 'bool'},
        'enable_azure_rbac': {'key': 'enableAzureRBAC', 'type': 'bool'},
        'admin_group_object_i_ds': {'key': 'adminGroupObjectIDs', 'type': '[str]'},
        'client_app_id': {'key': 'clientAppID', 'type': 'str'},
        'server_app_id': {'key': 'serverAppID', 'type': 'str'},
        'server_app_secret': {'key': 'serverAppSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantID', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        managed: Optional[bool] = None,
        enable_azure_rbac: Optional[bool] = None,
        admin_group_object_i_ds: Optional[List[str]] = None,
        client_app_id: Optional[str] = None,
        server_app_id: Optional[str] = None,
        server_app_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterAADProfile, self).__init__(**kwargs)
        self.managed = managed
        self.enable_azure_rbac = enable_azure_rbac
        self.admin_group_object_i_ds = admin_group_object_i_ds
        self.client_app_id = client_app_id
        self.server_app_id = server_app_id
        self.server_app_secret = server_app_secret
        self.tenant_id = tenant_id


class ManagedClusterAccessProfile(Resource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kube_config: Base64-encoded Kubernetes configuration file.
    :type kube_config: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kube_config': {'key': 'properties.kubeConfig', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kube_config: Optional[bytearray] = None,
        **kwargs
    ):
        super(ManagedClusterAccessProfile, self).__init__(location=location, tags=tags, **kwargs)
        self.kube_config = kube_config


class ManagedClusterAddonProfile(msrest.serialization.Model):
    """A Kubernetes add-on profile for a managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the add-on is enabled or not.
    :type enabled: bool
    :param config: Key-value pairs for configuring an add-on.
    :type config: dict[str, str]
    :ivar identity: Information of user assigned identity used by this add-on.
    :vartype identity:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterAddonProfileIdentity
    """

    _validation = {
        'enabled': {'required': True},
        'identity': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'config': {'key': 'config', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedClusterAddonProfileIdentity'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        config: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ManagedClusterAddonProfile, self).__init__(**kwargs)
        self.enabled = enabled
        self.config = config
        self.identity = None


class UserAssignedIdentity(msrest.serialization.Model):
    """Details about a user assigned identity.

    :param resource_id: The resource ID of the user assigned identity.
    :type resource_id: str
    :param client_id: The client ID of the user assigned identity.
    :type client_id: str
    :param object_id: The object ID of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs
    ):
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.client_id = client_id
        self.object_id = object_id


class ManagedClusterAddonProfileIdentity(UserAssignedIdentity):
    """Information of user assigned identity used by this add-on.

    :param resource_id: The resource ID of the user assigned identity.
    :type resource_id: str
    :param client_id: The client ID of the user assigned identity.
    :type client_id: str
    :param object_id: The object ID of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterAddonProfileIdentity, self).__init__(resource_id=resource_id, client_id=client_id, object_id=object_id, **kwargs)


class ManagedClusterAgentPoolProfileProperties(msrest.serialization.Model):
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: VM size availability varies by region. If a node contains insufficient compute
     resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted
     VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    :type vm_size: str
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in the master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
     larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
     after creation. For more information see `Ephemeral OS
     <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Possible values
     include: "Managed", "Ephemeral".
    :type os_disk_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSDiskType
    :param kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime data
     root, and Kubelet ephemeral storage. Possible values include: "OS", "Temporary".
    :type kubelet_disk_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.KubeletDiskType
    :param workload_runtime: Determines the type of workload a node can run. Possible values
     include: "OCIContainer", "WasmWasi".
    :type workload_runtime: str or ~azure.mgmt.containerservice.v2021_09_01.models.WorkloadRuntime
    :param vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and used.
     If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just
     nodes. This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type vnet_subnet_id: str
    :param pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
     vnetSubnetID for more details). This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type pod_subnet_id: str
    :param max_pods: The maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: The operating system type. The default is Linux. Possible values include:
     "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSType
    :param os_sku: Specifies an OS SKU. This value must not be specified if OSType is Windows.
     Possible values include: "Ubuntu", "CBLMariner".
    :type os_sku: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSSKU
    :param max_count: The maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: The minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param scale_down_mode: This also effects the cluster autoscaler behavior. If not specified, it
     defaults to Delete. Possible values include: "Delete", "Deallocate".
    :type scale_down_mode: str or ~azure.mgmt.containerservice.v2021_09_01.models.ScaleDownMode
    :param type: The type of Agent Pool. Possible values include: "VirtualMachineScaleSets",
     "AvailabilitySet".
    :type type: str or ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolType
    :param mode: A cluster must have at least one 'System' Agent Pool at all times. For additional
     information on agent pool restrictions and best practices, see:
     https://docs.microsoft.com/azure/aks/use-system-pools. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolMode
    :param orchestrator_version: As a best practice, you should upgrade all node pools in an AKS
     cluster to the same Kubernetes version. The node pool version must have the same major version
     as the control plane. The node pool minor version must be within two minor versions of the
     control plane version. The node pool version cannot be greater than the control plane version.
     For more information see `upgrading a node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
    :type orchestrator_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state.
    :vartype provisioning_state: str
    :param power_state: When an Agent Pool is first created it is initially Running. The Agent Pool
     can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and
     does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
     provisioning state is Succeeded.
    :type power_state: ~azure.mgmt.containerservice.v2021_09_01.models.PowerState
    :param availability_zones: The list of Availability zones to use for nodes. This can only be
     specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Some scenarios may require nodes in a node pool to receive their
     own dedicated public IP addresses. A common scenario is for gaming workloads, where a console
     needs to make a direct connection to a cloud virtual machine to minimize hops. For more
     information see `assigning a public IP per node
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.
     The default is false.
    :type enable_node_public_ip: bool
    :param node_public_ip_prefix_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
    :type node_public_ip_prefix_id: str
    :param scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the
     default is 'Regular'. Possible values include: "Spot", "Regular". Default value: "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
     'Spot'. If not specified, the default is 'Delete'. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: Possible values are any decimal value greater than zero or -1 which
     indicates the willingness to pay any on-demand price. For more details on spot pricing, see
     `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
    :type spot_max_price: float
    :param tags: A set of tags. The tags to be persisted on the agent pool virtual machine scale
     set.
    :type tags: dict[str, str]
    :param node_labels: The node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: The taints added to new nodes during node pool create and scale. For
     example, key=value:NoSchedule.
    :type node_taints: list[str]
    :param proximity_placement_group_id: The ID for Proximity Placement Group.
    :type proximity_placement_group_id: str
    :param kubelet_config: The Kubelet configuration on the agent pool nodes.
    :type kubelet_config: ~azure.mgmt.containerservice.v2021_09_01.models.KubeletConfig
    :param linux_os_config: The OS configuration of Linux agent nodes.
    :type linux_os_config: ~azure.mgmt.containerservice.v2021_09_01.models.LinuxOSConfig
    :param enable_encryption_at_host: This is only supported on certain VM sizes and in certain
     Azure regions. For more information, see:
     https://docs.microsoft.com/azure/aks/enable-host-encryption.
    :type enable_encryption_at_host: bool
    :param enable_ultra_ssd: Whether to enable UltraSSD.
    :type enable_ultra_ssd: bool
    :param enable_fips: See `Add a FIPS-enabled node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
     for more details.
    :type enable_fips: bool
    :param gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Possible values include: "MIG1g", "MIG2g", "MIG3g", "MIG4g", "MIG7g".
    :type gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.GPUInstanceProfile
    :param creation_data: CreationData to be used to specify the source Snapshot ID if the node
     pool will be created/upgraded using a snapshot.
    :type creation_data: ~azure.mgmt.containerservice.v2021_09_01.models.CreationData
    """

    _validation = {
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'node_image_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'os_disk_type': {'key': 'osDiskType', 'type': 'str'},
        'kubelet_disk_type': {'key': 'kubeletDiskType', 'type': 'str'},
        'workload_runtime': {'key': 'workloadRuntime', 'type': 'str'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'pod_subnet_id': {'key': 'podSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_sku': {'key': 'osSKU', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'scale_down_mode': {'key': 'scaleDownMode', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'power_state': {'key': 'powerState', 'type': 'PowerState'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'node_public_ip_prefix_id': {'key': 'nodePublicIPPrefixID', 'type': 'str'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
        'proximity_placement_group_id': {'key': 'proximityPlacementGroupID', 'type': 'str'},
        'kubelet_config': {'key': 'kubeletConfig', 'type': 'KubeletConfig'},
        'linux_os_config': {'key': 'linuxOSConfig', 'type': 'LinuxOSConfig'},
        'enable_encryption_at_host': {'key': 'enableEncryptionAtHost', 'type': 'bool'},
        'enable_ultra_ssd': {'key': 'enableUltraSSD', 'type': 'bool'},
        'enable_fips': {'key': 'enableFIPS', 'type': 'bool'},
        'gpu_instance_profile': {'key': 'gpuInstanceProfile', 'type': 'str'},
        'creation_data': {'key': 'creationData', 'type': 'CreationData'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[str] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "KubeletDiskType"]] = None,
        workload_runtime: Optional[Union[str, "WorkloadRuntime"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Optional[Union[str, "OSType"]] = "Linux",
        os_sku: Optional[Union[str, "OSSKU"]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        scale_down_mode: Optional[Union[str, "ScaleDownMode"]] = None,
        type: Optional[Union[str, "AgentPoolType"]] = None,
        mode: Optional[Union[str, "AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["AgentPoolUpgradeSettings"] = None,
        power_state: Optional["PowerState"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        node_public_ip_prefix_id: Optional[str] = None,
        scale_set_priority: Optional[Union[str, "ScaleSetPriority"]] = "Regular",
        scale_set_eviction_policy: Optional[Union[str, "ScaleSetEvictionPolicy"]] = "Delete",
        spot_max_price: Optional[float] = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["KubeletConfig"] = None,
        linux_os_config: Optional["LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        enable_ultra_ssd: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        gpu_instance_profile: Optional[Union[str, "GPUInstanceProfile"]] = None,
        creation_data: Optional["CreationData"] = None,
        **kwargs
    ):
        super(ManagedClusterAgentPoolProfileProperties, self).__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.os_disk_type = os_disk_type
        self.kubelet_disk_type = kubelet_disk_type
        self.workload_runtime = workload_runtime
        self.vnet_subnet_id = vnet_subnet_id
        self.pod_subnet_id = pod_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.os_sku = os_sku
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.scale_down_mode = scale_down_mode
        self.type = type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = None
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.power_state = power_state
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.node_public_ip_prefix_id = node_public_ip_prefix_id
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.proximity_placement_group_id = proximity_placement_group_id
        self.kubelet_config = kubelet_config
        self.linux_os_config = linux_os_config
        self.enable_encryption_at_host = enable_encryption_at_host
        self.enable_ultra_ssd = enable_ultra_ssd
        self.enable_fips = enable_fips
        self.gpu_instance_profile = gpu_instance_profile
        self.creation_data = creation_data


class ManagedClusterAgentPoolProfile(ManagedClusterAgentPoolProfileProperties):
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: VM size availability varies by region. If a node contains insufficient compute
     resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted
     VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    :type vm_size: str
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in the master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
     larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
     after creation. For more information see `Ephemeral OS
     <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Possible values
     include: "Managed", "Ephemeral".
    :type os_disk_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSDiskType
    :param kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime data
     root, and Kubelet ephemeral storage. Possible values include: "OS", "Temporary".
    :type kubelet_disk_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.KubeletDiskType
    :param workload_runtime: Determines the type of workload a node can run. Possible values
     include: "OCIContainer", "WasmWasi".
    :type workload_runtime: str or ~azure.mgmt.containerservice.v2021_09_01.models.WorkloadRuntime
    :param vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and used.
     If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just
     nodes. This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type vnet_subnet_id: str
    :param pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
     vnetSubnetID for more details). This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    :type pod_subnet_id: str
    :param max_pods: The maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: The operating system type. The default is Linux. Possible values include:
     "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSType
    :param os_sku: Specifies an OS SKU. This value must not be specified if OSType is Windows.
     Possible values include: "Ubuntu", "CBLMariner".
    :type os_sku: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSSKU
    :param max_count: The maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: The minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param scale_down_mode: This also effects the cluster autoscaler behavior. If not specified, it
     defaults to Delete. Possible values include: "Delete", "Deallocate".
    :type scale_down_mode: str or ~azure.mgmt.containerservice.v2021_09_01.models.ScaleDownMode
    :param type: The type of Agent Pool. Possible values include: "VirtualMachineScaleSets",
     "AvailabilitySet".
    :type type: str or ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolType
    :param mode: A cluster must have at least one 'System' Agent Pool at all times. For additional
     information on agent pool restrictions and best practices, see:
     https://docs.microsoft.com/azure/aks/use-system-pools. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolMode
    :param orchestrator_version: As a best practice, you should upgrade all node pools in an AKS
     cluster to the same Kubernetes version. The node pool version must have the same major version
     as the control plane. The node pool minor version must be within two minor versions of the
     control plane version. The node pool version cannot be greater than the control plane version.
     For more information see `upgrading a node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
    :type orchestrator_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2021_09_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state.
    :vartype provisioning_state: str
    :param power_state: When an Agent Pool is first created it is initially Running. The Agent Pool
     can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and
     does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
     provisioning state is Succeeded.
    :type power_state: ~azure.mgmt.containerservice.v2021_09_01.models.PowerState
    :param availability_zones: The list of Availability zones to use for nodes. This can only be
     specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Some scenarios may require nodes in a node pool to receive their
     own dedicated public IP addresses. A common scenario is for gaming workloads, where a console
     needs to make a direct connection to a cloud virtual machine to minimize hops. For more
     information see `assigning a public IP per node
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.
     The default is false.
    :type enable_node_public_ip: bool
    :param node_public_ip_prefix_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
    :type node_public_ip_prefix_id: str
    :param scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the
     default is 'Regular'. Possible values include: "Spot", "Regular". Default value: "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
     'Spot'. If not specified, the default is 'Delete'. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: Possible values are any decimal value greater than zero or -1 which
     indicates the willingness to pay any on-demand price. For more details on spot pricing, see
     `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
    :type spot_max_price: float
    :param tags: A set of tags. The tags to be persisted on the agent pool virtual machine scale
     set.
    :type tags: dict[str, str]
    :param node_labels: The node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: The taints added to new nodes during node pool create and scale. For
     example, key=value:NoSchedule.
    :type node_taints: list[str]
    :param proximity_placement_group_id: The ID for Proximity Placement Group.
    :type proximity_placement_group_id: str
    :param kubelet_config: The Kubelet configuration on the agent pool nodes.
    :type kubelet_config: ~azure.mgmt.containerservice.v2021_09_01.models.KubeletConfig
    :param linux_os_config: The OS configuration of Linux agent nodes.
    :type linux_os_config: ~azure.mgmt.containerservice.v2021_09_01.models.LinuxOSConfig
    :param enable_encryption_at_host: This is only supported on certain VM sizes and in certain
     Azure regions. For more information, see:
     https://docs.microsoft.com/azure/aks/enable-host-encryption.
    :type enable_encryption_at_host: bool
    :param enable_ultra_ssd: Whether to enable UltraSSD.
    :type enable_ultra_ssd: bool
    :param enable_fips: See `Add a FIPS-enabled node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
     for more details.
    :type enable_fips: bool
    :param gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Possible values include: "MIG1g", "MIG2g", "MIG3g", "MIG4g", "MIG7g".
    :type gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.GPUInstanceProfile
    :param creation_data: CreationData to be used to specify the source Snapshot ID if the node
     pool will be created/upgraded using a snapshot.
    :type creation_data: ~azure.mgmt.containerservice.v2021_09_01.models.CreationData
    :param name: Required. Windows agent pool names must be 6 characters or less.
    :type name: str
    """

    _validation = {
        'os_disk_size_gb': {'maximum': 2048, 'minimum': 0},
        'node_image_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name': {'required': True, 'pattern': r'^[a-z][a-z0-9]{0,11}$'},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'os_disk_type': {'key': 'osDiskType', 'type': 'str'},
        'kubelet_disk_type': {'key': 'kubeletDiskType', 'type': 'str'},
        'workload_runtime': {'key': 'workloadRuntime', 'type': 'str'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'pod_subnet_id': {'key': 'podSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_sku': {'key': 'osSKU', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'scale_down_mode': {'key': 'scaleDownMode', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'power_state': {'key': 'powerState', 'type': 'PowerState'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'node_public_ip_prefix_id': {'key': 'nodePublicIPPrefixID', 'type': 'str'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
        'proximity_placement_group_id': {'key': 'proximityPlacementGroupID', 'type': 'str'},
        'kubelet_config': {'key': 'kubeletConfig', 'type': 'KubeletConfig'},
        'linux_os_config': {'key': 'linuxOSConfig', 'type': 'LinuxOSConfig'},
        'enable_encryption_at_host': {'key': 'enableEncryptionAtHost', 'type': 'bool'},
        'enable_ultra_ssd': {'key': 'enableUltraSSD', 'type': 'bool'},
        'enable_fips': {'key': 'enableFIPS', 'type': 'bool'},
        'gpu_instance_profile': {'key': 'gpuInstanceProfile', 'type': 'str'},
        'creation_data': {'key': 'creationData', 'type': 'CreationData'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        count: Optional[int] = None,
        vm_size: Optional[str] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "KubeletDiskType"]] = None,
        workload_runtime: Optional[Union[str, "WorkloadRuntime"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Optional[Union[str, "OSType"]] = "Linux",
        os_sku: Optional[Union[str, "OSSKU"]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        scale_down_mode: Optional[Union[str, "ScaleDownMode"]] = None,
        type: Optional[Union[str, "AgentPoolType"]] = None,
        mode: Optional[Union[str, "AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["AgentPoolUpgradeSettings"] = None,
        power_state: Optional["PowerState"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        node_public_ip_prefix_id: Optional[str] = None,
        scale_set_priority: Optional[Union[str, "ScaleSetPriority"]] = "Regular",
        scale_set_eviction_policy: Optional[Union[str, "ScaleSetEvictionPolicy"]] = "Delete",
        spot_max_price: Optional[float] = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["KubeletConfig"] = None,
        linux_os_config: Optional["LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        enable_ultra_ssd: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        gpu_instance_profile: Optional[Union[str, "GPUInstanceProfile"]] = None,
        creation_data: Optional["CreationData"] = None,
        **kwargs
    ):
        super(ManagedClusterAgentPoolProfile, self).__init__(count=count, vm_size=vm_size, os_disk_size_gb=os_disk_size_gb, os_disk_type=os_disk_type, kubelet_disk_type=kubelet_disk_type, workload_runtime=workload_runtime, vnet_subnet_id=vnet_subnet_id, pod_subnet_id=pod_subnet_id, max_pods=max_pods, os_type=os_type, os_sku=os_sku, max_count=max_count, min_count=min_count, enable_auto_scaling=enable_auto_scaling, scale_down_mode=scale_down_mode, type=type, mode=mode, orchestrator_version=orchestrator_version, upgrade_settings=upgrade_settings, power_state=power_state, availability_zones=availability_zones, enable_node_public_ip=enable_node_public_ip, node_public_ip_prefix_id=node_public_ip_prefix_id, scale_set_priority=scale_set_priority, scale_set_eviction_policy=scale_set_eviction_policy, spot_max_price=spot_max_price, tags=tags, node_labels=node_labels, node_taints=node_taints, proximity_placement_group_id=proximity_placement_group_id, kubelet_config=kubelet_config, linux_os_config=linux_os_config, enable_encryption_at_host=enable_encryption_at_host, enable_ultra_ssd=enable_ultra_ssd, enable_fips=enable_fips, gpu_instance_profile=gpu_instance_profile, creation_data=creation_data, **kwargs)
        self.name = name


class ManagedClusterAPIServerAccessProfile(msrest.serialization.Model):
    """Access profile for managed cluster API server.

    :param authorized_ip_ranges: IP ranges are specified in CIDR format, e.g. 137.117.106.88/29.
     This feature is not compatible with clusters that use Public IP Per Node, or clusters that are
     using a Basic Load Balancer. For more information see `API server authorized IP ranges
     <https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges>`_.
    :type authorized_ip_ranges: list[str]
    :param enable_private_cluster: For more details, see `Creating a private AKS cluster
     <https://docs.microsoft.com/azure/aks/private-clusters>`_.
    :type enable_private_cluster: bool
    :param private_dns_zone: The default is System. For more details see `configure private DNS
     zone <https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone>`_.
     Allowed values are 'system' and 'none'.
    :type private_dns_zone: str
    :param enable_private_cluster_public_fqdn: Whether to create additional public FQDN for private
     cluster or not.
    :type enable_private_cluster_public_fqdn: bool
    :param disable_run_command: Whether to disable run command for the cluster or not.
    :type disable_run_command: bool
    """

    _attribute_map = {
        'authorized_ip_ranges': {'key': 'authorizedIPRanges', 'type': '[str]'},
        'enable_private_cluster': {'key': 'enablePrivateCluster', 'type': 'bool'},
        'private_dns_zone': {'key': 'privateDNSZone', 'type': 'str'},
        'enable_private_cluster_public_fqdn': {'key': 'enablePrivateClusterPublicFQDN', 'type': 'bool'},
        'disable_run_command': {'key': 'disableRunCommand', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        authorized_ip_ranges: Optional[List[str]] = None,
        enable_private_cluster: Optional[bool] = None,
        private_dns_zone: Optional[str] = None,
        enable_private_cluster_public_fqdn: Optional[bool] = None,
        disable_run_command: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedClusterAPIServerAccessProfile, self).__init__(**kwargs)
        self.authorized_ip_ranges = authorized_ip_ranges
        self.enable_private_cluster = enable_private_cluster
        self.private_dns_zone = private_dns_zone
        self.enable_private_cluster_public_fqdn = enable_private_cluster_public_fqdn
        self.disable_run_command = disable_run_command


class ManagedClusterAutoUpgradeProfile(msrest.serialization.Model):
    """Auto upgrade profile for a managed cluster.

    :param upgrade_channel: For more information see `setting the AKS cluster auto-upgrade channel
     <https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel>`_. Possible
     values include: "rapid", "stable", "patch", "node-image", "none".
    :type upgrade_channel: str or ~azure.mgmt.containerservice.v2021_09_01.models.UpgradeChannel
    """

    _attribute_map = {
        'upgrade_channel': {'key': 'upgradeChannel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        upgrade_channel: Optional[Union[str, "UpgradeChannel"]] = None,
        **kwargs
    ):
        super(ManagedClusterAutoUpgradeProfile, self).__init__(**kwargs)
        self.upgrade_channel = upgrade_channel


class ManagedClusterHTTPProxyConfig(msrest.serialization.Model):
    """Cluster HTTP proxy configuration.

    :param http_proxy: The HTTP proxy server endpoint to use.
    :type http_proxy: str
    :param https_proxy: The HTTPS proxy server endpoint to use.
    :type https_proxy: str
    :param no_proxy: The endpoints that should not go through proxy.
    :type no_proxy: list[str]
    :param trusted_ca: Alternative CA cert to use for connecting to proxy servers.
    :type trusted_ca: str
    """

    _attribute_map = {
        'http_proxy': {'key': 'httpProxy', 'type': 'str'},
        'https_proxy': {'key': 'httpsProxy', 'type': 'str'},
        'no_proxy': {'key': 'noProxy', 'type': '[str]'},
        'trusted_ca': {'key': 'trustedCa', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        http_proxy: Optional[str] = None,
        https_proxy: Optional[str] = None,
        no_proxy: Optional[List[str]] = None,
        trusted_ca: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterHTTPProxyConfig, self).__init__(**kwargs)
        self.http_proxy = http_proxy
        self.https_proxy = https_proxy
        self.no_proxy = no_proxy
        self.trusted_ca = trusted_ca


class ManagedClusterIdentity(msrest.serialization.Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity which is used by master
     components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is used by master
     components.
    :vartype tenant_id: str
    :param type: For more information see `use managed identities in AKS
     <https://docs.microsoft.com/azure/aks/use-managed-identity>`_. Possible values include:
     "SystemAssigned", "UserAssigned", "None".
    :type type: str or ~azure.mgmt.containerservice.v2021_09_01.models.ResourceIdentityType
    :param user_assigned_identities: The keys must be ARM resource IDs in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedServiceIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ManagedServiceIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "ManagedServiceIdentityUserAssignedIdentitiesValue"]] = None,
        **kwargs
    ):
        super(ManagedClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ManagedClusterListResult(msrest.serialization.Model):
    """The response from the List Managed Clusters operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of managed clusters.
    :type value: list[~azure.mgmt.containerservice.v2021_09_01.models.ManagedCluster]
    :ivar next_link: The URL to get the next set of managed cluster results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedCluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedCluster"]] = None,
        **kwargs
    ):
        super(ManagedClusterListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ManagedClusterLoadBalancerProfile(msrest.serialization.Model):
    """Profile of the managed cluster load balancer.

    :param managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
    :type managed_outbound_i_ps:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :param outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load
     balancer.
    :type outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :param outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
    :type outbound_i_ps:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :param effective_outbound_i_ps: The effective outbound IP resources of the cluster load
     balancer.
    :type effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ResourceReference]
    :param allocated_outbound_ports: The desired number of allocated SNAT ports per VM. Allowed
     values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in
     Azure dynamically allocating ports.
    :type allocated_outbound_ports: int
    :param idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
    :type idle_timeout_in_minutes: int
    :param enable_multiple_standard_load_balancers: Enable multiple standard load balancers per AKS
     cluster or not.
    :type enable_multiple_standard_load_balancers: bool
    """

    _validation = {
        'allocated_outbound_ports': {'maximum': 64000, 'minimum': 0},
        'idle_timeout_in_minutes': {'maximum': 120, 'minimum': 4},
    }

    _attribute_map = {
        'managed_outbound_i_ps': {'key': 'managedOutboundIPs', 'type': 'ManagedClusterLoadBalancerProfileManagedOutboundIPs'},
        'outbound_ip_prefixes': {'key': 'outboundIPPrefixes', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPPrefixes'},
        'outbound_i_ps': {'key': 'outboundIPs', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPs'},
        'effective_outbound_i_ps': {'key': 'effectiveOutboundIPs', 'type': '[ResourceReference]'},
        'allocated_outbound_ports': {'key': 'allocatedOutboundPorts', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'idleTimeoutInMinutes', 'type': 'int'},
        'enable_multiple_standard_load_balancers': {'key': 'enableMultipleStandardLoadBalancers', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        managed_outbound_i_ps: Optional["ManagedClusterLoadBalancerProfileManagedOutboundIPs"] = None,
        outbound_ip_prefixes: Optional["ManagedClusterLoadBalancerProfileOutboundIPPrefixes"] = None,
        outbound_i_ps: Optional["ManagedClusterLoadBalancerProfileOutboundIPs"] = None,
        effective_outbound_i_ps: Optional[List["ResourceReference"]] = None,
        allocated_outbound_ports: Optional[int] = 0,
        idle_timeout_in_minutes: Optional[int] = 30,
        enable_multiple_standard_load_balancers: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfile, self).__init__(**kwargs)
        self.managed_outbound_i_ps = managed_outbound_i_ps
        self.outbound_ip_prefixes = outbound_ip_prefixes
        self.outbound_i_ps = outbound_i_ps
        self.effective_outbound_i_ps = effective_outbound_i_ps
        self.allocated_outbound_ports = allocated_outbound_ports
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_multiple_standard_load_balancers = enable_multiple_standard_load_balancers


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(msrest.serialization.Model):
    """Desired managed outbound IPs for the cluster load balancer.

    :param count: The desired number of outbound IPs created/managed by Azure for the cluster load
     balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
    :type count: int
    """

    _validation = {
        'count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = 1,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileManagedOutboundIPs, self).__init__(**kwargs)
        self.count = count


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(msrest.serialization.Model):
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :param public_ip_prefixes: A list of public IP prefix resources.
    :type public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_ip_prefixes': {'key': 'publicIPPrefixes', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        *,
        public_ip_prefixes: Optional[List["ResourceReference"]] = None,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileOutboundIPPrefixes, self).__init__(**kwargs)
        self.public_ip_prefixes = public_ip_prefixes


class ManagedClusterLoadBalancerProfileOutboundIPs(msrest.serialization.Model):
    """Desired outbound IP resources for the cluster load balancer.

    :param public_i_ps: A list of public IP resources.
    :type public_i_ps: list[~azure.mgmt.containerservice.v2021_09_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_i_ps': {'key': 'publicIPs', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        *,
        public_i_ps: Optional[List["ResourceReference"]] = None,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileOutboundIPs, self).__init__(**kwargs)
        self.public_i_ps = public_i_ps


class ManagedClusterManagedOutboundIPProfile(msrest.serialization.Model):
    """Profile of the managed outbound IP resources of the managed cluster.

    :param count: The desired number of outbound IPs created/managed by Azure. Allowed values must
     be in the range of 1 to 16 (inclusive). The default value is 1.
    :type count: int
    """

    _validation = {
        'count': {'maximum': 16, 'minimum': 1},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = 1,
        **kwargs
    ):
        super(ManagedClusterManagedOutboundIPProfile, self).__init__(**kwargs)
        self.count = count


class ManagedClusterNATGatewayProfile(msrest.serialization.Model):
    """Profile of the managed cluster NAT gateway.

    :param managed_outbound_ip_profile: Profile of the managed outbound IP resources of the cluster
     NAT gateway.
    :type managed_outbound_ip_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterManagedOutboundIPProfile
    :param effective_outbound_i_ps: The effective outbound IP resources of the cluster NAT gateway.
    :type effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ResourceReference]
    :param idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
    :type idle_timeout_in_minutes: int
    """

    _validation = {
        'idle_timeout_in_minutes': {'maximum': 120, 'minimum': 4},
    }

    _attribute_map = {
        'managed_outbound_ip_profile': {'key': 'managedOutboundIPProfile', 'type': 'ManagedClusterManagedOutboundIPProfile'},
        'effective_outbound_i_ps': {'key': 'effectiveOutboundIPs', 'type': '[ResourceReference]'},
        'idle_timeout_in_minutes': {'key': 'idleTimeoutInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        managed_outbound_ip_profile: Optional["ManagedClusterManagedOutboundIPProfile"] = None,
        effective_outbound_i_ps: Optional[List["ResourceReference"]] = None,
        idle_timeout_in_minutes: Optional[int] = 4,
        **kwargs
    ):
        super(ManagedClusterNATGatewayProfile, self).__init__(**kwargs)
        self.managed_outbound_ip_profile = managed_outbound_ip_profile
        self.effective_outbound_i_ps = effective_outbound_i_ps
        self.idle_timeout_in_minutes = idle_timeout_in_minutes


class ManagedClusterPodIdentity(msrest.serialization.Model):
    """Details about the pod identity assigned to the Managed Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the pod identity.
    :type name: str
    :param namespace: Required. The namespace of the pod identity.
    :type namespace: str
    :param binding_selector: The binding selector to use for the AzureIdentityBinding resource.
    :type binding_selector: str
    :param identity: Required. The user assigned identity details.
    :type identity: ~azure.mgmt.containerservice.v2021_09_01.models.UserAssignedIdentity
    :ivar provisioning_state: The current provisioning state of the pod identity. Possible values
     include: "Assigned", "Updating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentityProvisioningState
    :ivar provisioning_info:
    :vartype provisioning_info:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentityProvisioningInfo
    """

    _validation = {
        'name': {'required': True},
        'namespace': {'required': True},
        'identity': {'required': True},
        'provisioning_state': {'readonly': True},
        'provisioning_info': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'binding_selector': {'key': 'bindingSelector', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'UserAssignedIdentity'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'provisioning_info': {'key': 'provisioningInfo', 'type': 'ManagedClusterPodIdentityProvisioningInfo'},
    }

    def __init__(
        self,
        *,
        name: str,
        namespace: str,
        identity: "UserAssignedIdentity",
        binding_selector: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterPodIdentity, self).__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.binding_selector = binding_selector
        self.identity = identity
        self.provisioning_state = None
        self.provisioning_info = None


class ManagedClusterPodIdentityException(msrest.serialization.Model):
    """See `disable AAD Pod Identity for a specific Pod/Application <https://azure.github.io/aad-pod-identity/docs/configure/application_exception/>`_ for more details.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the pod identity exception.
    :type name: str
    :param namespace: Required. The namespace of the pod identity exception.
    :type namespace: str
    :param pod_labels: Required. The pod labels to match.
    :type pod_labels: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'namespace': {'required': True},
        'pod_labels': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'pod_labels': {'key': 'podLabels', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        name: str,
        namespace: str,
        pod_labels: Dict[str, str],
        **kwargs
    ):
        super(ManagedClusterPodIdentityException, self).__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.pod_labels = pod_labels


class ManagedClusterPodIdentityProfile(msrest.serialization.Model):
    """See `use AAD pod identity <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity>`_ for more details on pod identity integration.

    :param enabled: Whether the pod identity addon is enabled.
    :type enabled: bool
    :param allow_network_plugin_kubenet: Running in Kubenet is disabled by default due to the
     security related nature of AAD Pod Identity and the risks of IP spoofing. See `using Kubenet
     network plugin with AAD Pod Identity
     <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities>`_
     for more information.
    :type allow_network_plugin_kubenet: bool
    :param user_assigned_identities: The pod identities to use in the cluster.
    :type user_assigned_identities:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentity]
    :param user_assigned_identity_exceptions: The pod identity exceptions to allow.
    :type user_assigned_identity_exceptions:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentityException]
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'allow_network_plugin_kubenet': {'key': 'allowNetworkPluginKubenet', 'type': 'bool'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '[ManagedClusterPodIdentity]'},
        'user_assigned_identity_exceptions': {'key': 'userAssignedIdentityExceptions', 'type': '[ManagedClusterPodIdentityException]'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        allow_network_plugin_kubenet: Optional[bool] = None,
        user_assigned_identities: Optional[List["ManagedClusterPodIdentity"]] = None,
        user_assigned_identity_exceptions: Optional[List["ManagedClusterPodIdentityException"]] = None,
        **kwargs
    ):
        super(ManagedClusterPodIdentityProfile, self).__init__(**kwargs)
        self.enabled = enabled
        self.allow_network_plugin_kubenet = allow_network_plugin_kubenet
        self.user_assigned_identities = user_assigned_identities
        self.user_assigned_identity_exceptions = user_assigned_identity_exceptions


class ManagedClusterPodIdentityProvisioningError(msrest.serialization.Model):
    """An error response from the pod identity provisioning.

    :param error: Details about the error.
    :type error:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentityProvisioningErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ManagedClusterPodIdentityProvisioningErrorBody'},
    }

    def __init__(
        self,
        *,
        error: Optional["ManagedClusterPodIdentityProvisioningErrorBody"] = None,
        **kwargs
    ):
        super(ManagedClusterPodIdentityProvisioningError, self).__init__(**kwargs)
        self.error = error


class ManagedClusterPodIdentityProvisioningErrorBody(msrest.serialization.Model):
    """An error response from the pod identity provisioning.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentityProvisioningErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ManagedClusterPodIdentityProvisioningErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["ManagedClusterPodIdentityProvisioningErrorBody"]] = None,
        **kwargs
    ):
        super(ManagedClusterPodIdentityProvisioningErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ManagedClusterPodIdentityProvisioningInfo(msrest.serialization.Model):
    """ManagedClusterPodIdentityProvisioningInfo.

    :param error: Pod identity assignment error (if any).
    :type error:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPodIdentityProvisioningError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ManagedClusterPodIdentityProvisioningError'},
    }

    def __init__(
        self,
        *,
        error: Optional["ManagedClusterPodIdentityProvisioningError"] = None,
        **kwargs
    ):
        super(ManagedClusterPodIdentityProvisioningInfo, self).__init__(**kwargs)
        self.error = error


class ManagedClusterPoolUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to Azure.

    :param kubernetes_version: Required. The Kubernetes version (major.minor.patch).
    :type kubernetes_version: str
    :param name: The Agent Pool name.
    :type name: str
    :param os_type: Required. The operating system type. The default is Linux. Possible values
     include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'upgrades': {'key': 'upgrades', 'type': '[ManagedClusterPoolUpgradeProfileUpgradesItem]'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "OSType"] = "Linux",
        name: Optional[str] = None,
        upgrades: Optional[List["ManagedClusterPoolUpgradeProfileUpgradesItem"]] = None,
        **kwargs
    ):
        super(ManagedClusterPoolUpgradeProfile, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.name = name
        self.os_type = os_type
        self.upgrades = upgrades


class ManagedClusterPoolUpgradeProfileUpgradesItem(msrest.serialization.Model):
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :param kubernetes_version: The Kubernetes version (major.minor.patch).
    :type kubernetes_version: str
    :param is_preview: Whether the Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedClusterPoolUpgradeProfileUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class ManagedClusterPropertiesAutoScalerProfile(msrest.serialization.Model):
    """Parameters to be applied to the cluster-autoscaler when enabled.

    :param balance_similar_node_groups: Valid values are 'true' and 'false'.
    :type balance_similar_node_groups: str
    :param expander: If not specified, the default is 'random'. See `expanders
     <https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders>`_
     for more information. Possible values include: "least-waste", "most-pods", "priority",
     "random".
    :type expander: str or ~azure.mgmt.containerservice.v2021_09_01.models.Expander
    :param max_empty_bulk_delete: The default is 10.
    :type max_empty_bulk_delete: str
    :param max_graceful_termination_sec: The default is 600.
    :type max_graceful_termination_sec: str
    :param max_node_provision_time: The default is '15m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :type max_node_provision_time: str
    :param max_total_unready_percentage: The default is 45. The maximum is 100 and the minimum is
     0.
    :type max_total_unready_percentage: str
    :param new_pod_scale_up_delay: For scenarios like burst/batch scale where you don't want CA to
     act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore
     unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer
     followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
    :type new_pod_scale_up_delay: str
    :param ok_total_unready_count: This must be an integer. The default is 3.
    :type ok_total_unready_count: str
    :param scan_interval: The default is '10'. Values must be an integer number of seconds.
    :type scan_interval: str
    :param scale_down_delay_after_add: The default is '10m'. Values must be an integer followed by
     an 'm'. No unit of time other than minutes (m) is supported.
    :type scale_down_delay_after_add: str
    :param scale_down_delay_after_delete: The default is the scan-interval. Values must be an
     integer followed by an 'm'. No unit of time other than minutes (m) is supported.
    :type scale_down_delay_after_delete: str
    :param scale_down_delay_after_failure: The default is '3m'. Values must be an integer followed
     by an 'm'. No unit of time other than minutes (m) is supported.
    :type scale_down_delay_after_failure: str
    :param scale_down_unneeded_time: The default is '10m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :type scale_down_unneeded_time: str
    :param scale_down_unready_time: The default is '20m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :type scale_down_unready_time: str
    :param scale_down_utilization_threshold: The default is '0.5'.
    :type scale_down_utilization_threshold: str
    :param skip_nodes_with_local_storage: The default is true.
    :type skip_nodes_with_local_storage: str
    :param skip_nodes_with_system_pods: The default is true.
    :type skip_nodes_with_system_pods: str
    """

    _attribute_map = {
        'balance_similar_node_groups': {'key': 'balance-similar-node-groups', 'type': 'str'},
        'expander': {'key': 'expander', 'type': 'str'},
        'max_empty_bulk_delete': {'key': 'max-empty-bulk-delete', 'type': 'str'},
        'max_graceful_termination_sec': {'key': 'max-graceful-termination-sec', 'type': 'str'},
        'max_node_provision_time': {'key': 'max-node-provision-time', 'type': 'str'},
        'max_total_unready_percentage': {'key': 'max-total-unready-percentage', 'type': 'str'},
        'new_pod_scale_up_delay': {'key': 'new-pod-scale-up-delay', 'type': 'str'},
        'ok_total_unready_count': {'key': 'ok-total-unready-count', 'type': 'str'},
        'scan_interval': {'key': 'scan-interval', 'type': 'str'},
        'scale_down_delay_after_add': {'key': 'scale-down-delay-after-add', 'type': 'str'},
        'scale_down_delay_after_delete': {'key': 'scale-down-delay-after-delete', 'type': 'str'},
        'scale_down_delay_after_failure': {'key': 'scale-down-delay-after-failure', 'type': 'str'},
        'scale_down_unneeded_time': {'key': 'scale-down-unneeded-time', 'type': 'str'},
        'scale_down_unready_time': {'key': 'scale-down-unready-time', 'type': 'str'},
        'scale_down_utilization_threshold': {'key': 'scale-down-utilization-threshold', 'type': 'str'},
        'skip_nodes_with_local_storage': {'key': 'skip-nodes-with-local-storage', 'type': 'str'},
        'skip_nodes_with_system_pods': {'key': 'skip-nodes-with-system-pods', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        balance_similar_node_groups: Optional[str] = None,
        expander: Optional[Union[str, "Expander"]] = None,
        max_empty_bulk_delete: Optional[str] = None,
        max_graceful_termination_sec: Optional[str] = None,
        max_node_provision_time: Optional[str] = None,
        max_total_unready_percentage: Optional[str] = None,
        new_pod_scale_up_delay: Optional[str] = None,
        ok_total_unready_count: Optional[str] = None,
        scan_interval: Optional[str] = None,
        scale_down_delay_after_add: Optional[str] = None,
        scale_down_delay_after_delete: Optional[str] = None,
        scale_down_delay_after_failure: Optional[str] = None,
        scale_down_unneeded_time: Optional[str] = None,
        scale_down_unready_time: Optional[str] = None,
        scale_down_utilization_threshold: Optional[str] = None,
        skip_nodes_with_local_storage: Optional[str] = None,
        skip_nodes_with_system_pods: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterPropertiesAutoScalerProfile, self).__init__(**kwargs)
        self.balance_similar_node_groups = balance_similar_node_groups
        self.expander = expander
        self.max_empty_bulk_delete = max_empty_bulk_delete
        self.max_graceful_termination_sec = max_graceful_termination_sec
        self.max_node_provision_time = max_node_provision_time
        self.max_total_unready_percentage = max_total_unready_percentage
        self.new_pod_scale_up_delay = new_pod_scale_up_delay
        self.ok_total_unready_count = ok_total_unready_count
        self.scan_interval = scan_interval
        self.scale_down_delay_after_add = scale_down_delay_after_add
        self.scale_down_delay_after_delete = scale_down_delay_after_delete
        self.scale_down_delay_after_failure = scale_down_delay_after_failure
        self.scale_down_unneeded_time = scale_down_unneeded_time
        self.scale_down_unready_time = scale_down_unready_time
        self.scale_down_utilization_threshold = scale_down_utilization_threshold
        self.skip_nodes_with_local_storage = skip_nodes_with_local_storage
        self.skip_nodes_with_system_pods = skip_nodes_with_system_pods


class ManagedClusterSecurityProfile(msrest.serialization.Model):
    """Security profile for the container service cluster.

    :param azure_defender: Azure Defender settings for the security profile.
    :type azure_defender:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterSecurityProfileAzureDefender
    """

    _attribute_map = {
        'azure_defender': {'key': 'azureDefender', 'type': 'ManagedClusterSecurityProfileAzureDefender'},
    }

    def __init__(
        self,
        *,
        azure_defender: Optional["ManagedClusterSecurityProfileAzureDefender"] = None,
        **kwargs
    ):
        super(ManagedClusterSecurityProfile, self).__init__(**kwargs)
        self.azure_defender = azure_defender


class ManagedClusterSecurityProfileAzureDefender(msrest.serialization.Model):
    """Azure Defender settings for the security profile.

    :param enabled: Whether to enable Azure Defender.
    :type enabled: bool
    :param log_analytics_workspace_resource_id: Resource ID of the Log Analytics workspace to be
     associated with Azure Defender.  When Azure Defender is enabled, this field is required and
     must be a valid workspace resource ID. When Azure Defender is disabled, leave the field empty.
    :type log_analytics_workspace_resource_id: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'log_analytics_workspace_resource_id': {'key': 'logAnalyticsWorkspaceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        log_analytics_workspace_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterSecurityProfileAzureDefender, self).__init__(**kwargs)
        self.enabled = enabled
        self.log_analytics_workspace_resource_id = log_analytics_workspace_resource_id


class ManagedClusterServicePrincipalProfile(msrest.serialization.Model):
    """Information about a service principal identity for the cluster to use for manipulating Azure APIs.

    All required parameters must be populated in order to send to Azure.

    :param client_id: Required. The ID for the service principal.
    :type client_id: str
    :param secret: The secret password associated with the service principal in plain text.
    :type secret: str
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        secret: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterServicePrincipalProfile, self).__init__(**kwargs)
        self.client_id = client_id
        self.secret = secret


class ManagedClusterSKU(msrest.serialization.Model):
    """The SKU of a Managed Cluster.

    :param name: The name of a managed cluster SKU. Possible values include: "Basic".
    :type name: str or ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterSKUName
    :param tier: If not specified, the default is 'Free'. See `uptime SLA
     <https://docs.microsoft.com/azure/aks/uptime-sla>`_ for more details. Possible values include:
     "Paid", "Free".
    :type tier: str or ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterSKUTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "ManagedClusterSKUName"]] = None,
        tier: Optional[Union[str, "ManagedClusterSKUTier"]] = None,
        **kwargs
    ):
        super(ManagedClusterSKU, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class ManagedClusterUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the upgrade profile.
    :vartype id: str
    :ivar name: The name of the upgrade profile.
    :vartype name: str
    :ivar type: The type of the upgrade profile.
    :vartype type: str
    :param control_plane_profile: Required. The list of available upgrade versions for the control
     plane.
    :type control_plane_profile:
     ~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPoolUpgradeProfile
    :param agent_pool_profiles: Required. The list of available upgrade versions for agent pools.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2021_09_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'control_plane_profile': {'required': True},
        'agent_pool_profiles': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'control_plane_profile': {'key': 'properties.controlPlaneProfile', 'type': 'ManagedClusterPoolUpgradeProfile'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterPoolUpgradeProfile]'},
    }

    def __init__(
        self,
        *,
        control_plane_profile: "ManagedClusterPoolUpgradeProfile",
        agent_pool_profiles: List["ManagedClusterPoolUpgradeProfile"],
        **kwargs
    ):
        super(ManagedClusterUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = control_plane_profile
        self.agent_pool_profiles = agent_pool_profiles


class ManagedClusterWindowsProfile(msrest.serialization.Model):
    """Profile for Windows VMs in the managed cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` **Restriction:** Cannot end in "." :code:`<br>`:code:`<br>`
     **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
     "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
     "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
     "sys", "test2", "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1
     character :code:`<br>`:code:`<br>` **Max-length:** 20 characters.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
     **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
     "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
    :type admin_password: str
    :param license_type: The license type to use for Windows VMs. See `Azure Hybrid User Benefits
     <https://azure.microsoft.com/pricing/hybrid-benefit/faq/>`_ for more details. Possible values
     include: "None", "Windows_Server".
    :type license_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.LicenseType
    :param enable_csi_proxy: For more details on CSI proxy, see the `CSI proxy GitHub repo
     <https://github.com/kubernetes-csi/csi-proxy>`_.
    :type enable_csi_proxy: bool
    :param gmsa_profile: The Windows gMSA Profile in the Managed Cluster.
    :type gmsa_profile: ~azure.mgmt.containerservice.v2021_09_01.models.WindowsGmsaProfile
    """

    _validation = {
        'admin_username': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'enable_csi_proxy': {'key': 'enableCSIProxy', 'type': 'bool'},
        'gmsa_profile': {'key': 'gmsaProfile', 'type': 'WindowsGmsaProfile'},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        admin_password: Optional[str] = None,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        enable_csi_proxy: Optional[bool] = None,
        gmsa_profile: Optional["WindowsGmsaProfile"] = None,
        **kwargs
    ):
        super(ManagedClusterWindowsProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.license_type = license_type
        self.enable_csi_proxy = enable_csi_proxy
        self.gmsa_profile = gmsa_profile


class ManagedServiceIdentityUserAssignedIdentitiesValue(msrest.serialization.Model):
    """ManagedServiceIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedServiceIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class OperationListResult(msrest.serialization.Model):
    """The List Operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of operations.
    :vartype value: list[~azure.mgmt.containerservice.v2021_09_01.models.OperationValue]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None


class OperationValue(msrest.serialization.Model):
    """Describes the properties of a Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the operation.
    :vartype origin: str
    :ivar name: The name of the operation.
    :vartype name: str
    :ivar operation: The display name of the operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class OSOptionProfile(msrest.serialization.Model):
    """The OS option profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the OS option resource.
    :vartype id: str
    :ivar name: The name of the OS option resource.
    :vartype name: str
    :ivar type: The type of the OS option resource.
    :vartype type: str
    :param os_option_property_list: Required. The list of OS options.
    :type os_option_property_list:
     list[~azure.mgmt.containerservice.v2021_09_01.models.OSOptionProperty]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'os_option_property_list': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'os_option_property_list': {'key': 'properties.osOptionPropertyList', 'type': '[OSOptionProperty]'},
    }

    def __init__(
        self,
        *,
        os_option_property_list: List["OSOptionProperty"],
        **kwargs
    ):
        super(OSOptionProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.os_option_property_list = os_option_property_list


class OSOptionProperty(msrest.serialization.Model):
    """OS option property.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. The OS type.
    :type os_type: str
    :param enable_fips_image: Required. Whether the image is FIPS-enabled.
    :type enable_fips_image: bool
    """

    _validation = {
        'os_type': {'required': True},
        'enable_fips_image': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'os-type', 'type': 'str'},
        'enable_fips_image': {'key': 'enable-fips-image', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        os_type: str,
        enable_fips_image: bool,
        **kwargs
    ):
        super(OSOptionProperty, self).__init__(**kwargs)
        self.os_type = os_type
        self.enable_fips_image = enable_fips_image


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """Egress endpoints which AKS agent nodes connect to for common purpose.

    :param category: The category of endpoints accessed by the AKS agent node, e.g.
     azure-resource-management, apiserver, etc.
    :type category: str
    :param endpoints: The endpoints that AKS agent nodes connect to.
    :type endpoints: list[~azure.mgmt.containerservice.v2021_09_01.models.EndpointDependency]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["EndpointDependency"]] = None,
        **kwargs
    ):
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of OutboundEnvironmentEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.containerservice.v2021_09_01.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["OutboundEnvironmentEndpoint"],
        **kwargs
    ):
        super(OutboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PowerState(msrest.serialization.Model):
    """Describes the Power State of the cluster.

    :param code: Tells whether the cluster is Running or Stopped. Possible values include:
     "Running", "Stopped".
    :type code: str or ~azure.mgmt.containerservice.v2021_09_01.models.Code
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[Union[str, "Code"]] = None,
        **kwargs
    ):
        super(PowerState, self).__init__(**kwargs)
        self.code = code


class PrivateEndpoint(msrest.serialization.Model):
    """Private endpoint which a connection belongs to.

    :param id: The resource ID of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(msrest.serialization.Model):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the private endpoint connection.
    :vartype id: str
    :ivar name: The name of the private endpoint connection.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar provisioning_state: The current provisioning state. Possible values include: "Succeeded",
     "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.PrivateEndpointConnectionProvisioningState
    :param private_endpoint: The resource of private endpoint.
    :type private_endpoint: ~azure.mgmt.containerservice.v2021_09_01.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.containerservice.v2021_09_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerservice.v2021_09_01.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkResource(msrest.serialization.Model):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The ID of the private link resource.
    :type id: str
    :param name: The name of the private link resource.
    :type name: str
    :param type: The resource type.
    :type type: str
    :param group_id: The group ID of the resource.
    :type group_id: str
    :param required_members: The RequiredMembers of the resource.
    :type required_members: list[str]
    :ivar private_link_service_id: The private link service ID of the resource, this field is
     exposed only to NRP internally.
    :vartype private_link_service_id: str
    """

    _validation = {
        'private_link_service_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'private_link_service_id': {'key': 'privateLinkServiceID', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.required_members = required_members
        self.private_link_service_id = None


class PrivateLinkResourcesListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerservice.v2021_09_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        super(PrivateLinkResourcesListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """The state of a private link service connection.

    :param status: The private link service connection status. Possible values include: "Pending",
     "Approved", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.containerservice.v2021_09_01.models.ConnectionStatus
    :param description: The private link service connection description.
    :type description: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "ConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description


class ResourceReference(msrest.serialization.Model):
    """A reference to an Azure resource.

    :param id: The fully qualified Azure resource id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id


class RunCommandRequest(msrest.serialization.Model):
    """A run command request.

    All required parameters must be populated in order to send to Azure.

    :param command: Required. The command to run.
    :type command: str
    :param context: A base64 encoded zip file containing the files required by the command.
    :type context: str
    :param cluster_token: AuthToken issued for AKS AAD Server App.
    :type cluster_token: str
    """

    _validation = {
        'command': {'required': True},
    }

    _attribute_map = {
        'command': {'key': 'command', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'cluster_token': {'key': 'clusterToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        command: str,
        context: Optional[str] = None,
        cluster_token: Optional[str] = None,
        **kwargs
    ):
        super(RunCommandRequest, self).__init__(**kwargs)
        self.command = command
        self.context = context
        self.cluster_token = cluster_token


class RunCommandResult(msrest.serialization.Model):
    """run command result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The command id.
    :vartype id: str
    :ivar provisioning_state: provisioning State.
    :vartype provisioning_state: str
    :ivar exit_code: The exit code of the command.
    :vartype exit_code: int
    :ivar started_at: The time when the command started.
    :vartype started_at: ~datetime.datetime
    :ivar finished_at: The time when the command finished.
    :vartype finished_at: ~datetime.datetime
    :ivar logs: The command output.
    :vartype logs: str
    :ivar reason: An explanation of why provisioningState is set to failed (if so).
    :vartype reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'exit_code': {'readonly': True},
        'started_at': {'readonly': True},
        'finished_at': {'readonly': True},
        'logs': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'exit_code': {'key': 'properties.exitCode', 'type': 'int'},
        'started_at': {'key': 'properties.startedAt', 'type': 'iso-8601'},
        'finished_at': {'key': 'properties.finishedAt', 'type': 'iso-8601'},
        'logs': {'key': 'properties.logs', 'type': 'str'},
        'reason': {'key': 'properties.reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunCommandResult, self).__init__(**kwargs)
        self.id = None
        self.provisioning_state = None
        self.exit_code = None
        self.started_at = None
        self.finished_at = None
        self.logs = None
        self.reason = None


class Snapshot(Resource):
    """A node pool snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: The system metadata relating to this snapshot.
    :vartype system_data: ~azure.mgmt.containerservice.v2021_09_01.models.SystemData
    :param creation_data: CreationData to be used to specify the source agent pool resource ID to
     create this snapshot.
    :type creation_data: ~azure.mgmt.containerservice.v2021_09_01.models.CreationData
    :param snapshot_type: The type of a snapshot. The default is NodePool. Possible values include:
     "NodePool". Default value: "NodePool".
    :type snapshot_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.SnapshotType
    :ivar kubernetes_version: The version of Kubernetes.
    :vartype kubernetes_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :ivar os_type: The operating system type. The default is Linux. Possible values include:
     "Linux", "Windows". Default value: "Linux".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSType
    :ivar os_sku: Specifies an OS SKU. This value must not be specified if OSType is Windows.
     Possible values include: "Ubuntu", "CBLMariner".
    :vartype os_sku: str or ~azure.mgmt.containerservice.v2021_09_01.models.OSSKU
    :ivar vm_size: The size of the VM.
    :vartype vm_size: str
    :ivar enable_fips: Whether to use a FIPS-enabled OS.
    :vartype enable_fips: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'kubernetes_version': {'readonly': True},
        'node_image_version': {'readonly': True},
        'os_type': {'readonly': True},
        'os_sku': {'readonly': True},
        'vm_size': {'readonly': True},
        'enable_fips': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
        'snapshot_type': {'key': 'properties.snapshotType', 'type': 'str'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'node_image_version': {'key': 'properties.nodeImageVersion', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_sku': {'key': 'properties.osSku', 'type': 'str'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'enable_fips': {'key': 'properties.enableFIPS', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        creation_data: Optional["CreationData"] = None,
        snapshot_type: Optional[Union[str, "SnapshotType"]] = "NodePool",
        **kwargs
    ):
        super(Snapshot, self).__init__(location=location, tags=tags, **kwargs)
        self.system_data = None
        self.creation_data = creation_data
        self.snapshot_type = snapshot_type
        self.kubernetes_version = None
        self.node_image_version = None
        self.os_type = None
        self.os_sku = None
        self.vm_size = None
        self.enable_fips = None


class SnapshotListResult(msrest.serialization.Model):
    """The response from the List Snapshots operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of snapshots.
    :type value: list[~azure.mgmt.containerservice.v2021_09_01.models.Snapshot]
    :ivar next_link: The URL to get the next set of snapshot results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Snapshot"]] = None,
        **kwargs
    ):
        super(SnapshotListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SysctlConfig(msrest.serialization.Model):
    """Sysctl settings for Linux agent nodes.

    :param net_core_somaxconn: Sysctl setting net.core.somaxconn.
    :type net_core_somaxconn: int
    :param net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
    :type net_core_netdev_max_backlog: int
    :param net_core_rmem_default: Sysctl setting net.core.rmem_default.
    :type net_core_rmem_default: int
    :param net_core_rmem_max: Sysctl setting net.core.rmem_max.
    :type net_core_rmem_max: int
    :param net_core_wmem_default: Sysctl setting net.core.wmem_default.
    :type net_core_wmem_default: int
    :param net_core_wmem_max: Sysctl setting net.core.wmem_max.
    :type net_core_wmem_max: int
    :param net_core_optmem_max: Sysctl setting net.core.optmem_max.
    :type net_core_optmem_max: int
    :param net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
    :type net_ipv4_tcp_max_syn_backlog: int
    :param net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
    :type net_ipv4_tcp_max_tw_buckets: int
    :param net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
    :type net_ipv4_tcp_fin_timeout: int
    :param net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
    :type net_ipv4_tcp_keepalive_time: int
    :param net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
    :type net_ipv4_tcp_keepalive_probes: int
    :param net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
    :type net_ipv4_tcpkeepalive_intvl: int
    :param net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
    :type net_ipv4_tcp_tw_reuse: bool
    :param net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
    :type net_ipv4_ip_local_port_range: str
    :param net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
    :type net_ipv4_neigh_default_gc_thresh1: int
    :param net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
    :type net_ipv4_neigh_default_gc_thresh2: int
    :param net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
    :type net_ipv4_neigh_default_gc_thresh3: int
    :param net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
    :type net_netfilter_nf_conntrack_max: int
    :param net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
    :type net_netfilter_nf_conntrack_buckets: int
    :param fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
    :type fs_inotify_max_user_watches: int
    :param fs_file_max: Sysctl setting fs.file-max.
    :type fs_file_max: int
    :param fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
    :type fs_aio_max_nr: int
    :param fs_nr_open: Sysctl setting fs.nr_open.
    :type fs_nr_open: int
    :param kernel_threads_max: Sysctl setting kernel.threads-max.
    :type kernel_threads_max: int
    :param vm_max_map_count: Sysctl setting vm.max_map_count.
    :type vm_max_map_count: int
    :param vm_swappiness: Sysctl setting vm.swappiness.
    :type vm_swappiness: int
    :param vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
    :type vm_vfs_cache_pressure: int
    """

    _attribute_map = {
        'net_core_somaxconn': {'key': 'netCoreSomaxconn', 'type': 'int'},
        'net_core_netdev_max_backlog': {'key': 'netCoreNetdevMaxBacklog', 'type': 'int'},
        'net_core_rmem_default': {'key': 'netCoreRmemDefault', 'type': 'int'},
        'net_core_rmem_max': {'key': 'netCoreRmemMax', 'type': 'int'},
        'net_core_wmem_default': {'key': 'netCoreWmemDefault', 'type': 'int'},
        'net_core_wmem_max': {'key': 'netCoreWmemMax', 'type': 'int'},
        'net_core_optmem_max': {'key': 'netCoreOptmemMax', 'type': 'int'},
        'net_ipv4_tcp_max_syn_backlog': {'key': 'netIpv4TcpMaxSynBacklog', 'type': 'int'},
        'net_ipv4_tcp_max_tw_buckets': {'key': 'netIpv4TcpMaxTwBuckets', 'type': 'int'},
        'net_ipv4_tcp_fin_timeout': {'key': 'netIpv4TcpFinTimeout', 'type': 'int'},
        'net_ipv4_tcp_keepalive_time': {'key': 'netIpv4TcpKeepaliveTime', 'type': 'int'},
        'net_ipv4_tcp_keepalive_probes': {'key': 'netIpv4TcpKeepaliveProbes', 'type': 'int'},
        'net_ipv4_tcpkeepalive_intvl': {'key': 'netIpv4TcpkeepaliveIntvl', 'type': 'int'},
        'net_ipv4_tcp_tw_reuse': {'key': 'netIpv4TcpTwReuse', 'type': 'bool'},
        'net_ipv4_ip_local_port_range': {'key': 'netIpv4IpLocalPortRange', 'type': 'str'},
        'net_ipv4_neigh_default_gc_thresh1': {'key': 'netIpv4NeighDefaultGcThresh1', 'type': 'int'},
        'net_ipv4_neigh_default_gc_thresh2': {'key': 'netIpv4NeighDefaultGcThresh2', 'type': 'int'},
        'net_ipv4_neigh_default_gc_thresh3': {'key': 'netIpv4NeighDefaultGcThresh3', 'type': 'int'},
        'net_netfilter_nf_conntrack_max': {'key': 'netNetfilterNfConntrackMax', 'type': 'int'},
        'net_netfilter_nf_conntrack_buckets': {'key': 'netNetfilterNfConntrackBuckets', 'type': 'int'},
        'fs_inotify_max_user_watches': {'key': 'fsInotifyMaxUserWatches', 'type': 'int'},
        'fs_file_max': {'key': 'fsFileMax', 'type': 'int'},
        'fs_aio_max_nr': {'key': 'fsAioMaxNr', 'type': 'int'},
        'fs_nr_open': {'key': 'fsNrOpen', 'type': 'int'},
        'kernel_threads_max': {'key': 'kernelThreadsMax', 'type': 'int'},
        'vm_max_map_count': {'key': 'vmMaxMapCount', 'type': 'int'},
        'vm_swappiness': {'key': 'vmSwappiness', 'type': 'int'},
        'vm_vfs_cache_pressure': {'key': 'vmVfsCachePressure', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        net_core_somaxconn: Optional[int] = None,
        net_core_netdev_max_backlog: Optional[int] = None,
        net_core_rmem_default: Optional[int] = None,
        net_core_rmem_max: Optional[int] = None,
        net_core_wmem_default: Optional[int] = None,
        net_core_wmem_max: Optional[int] = None,
        net_core_optmem_max: Optional[int] = None,
        net_ipv4_tcp_max_syn_backlog: Optional[int] = None,
        net_ipv4_tcp_max_tw_buckets: Optional[int] = None,
        net_ipv4_tcp_fin_timeout: Optional[int] = None,
        net_ipv4_tcp_keepalive_time: Optional[int] = None,
        net_ipv4_tcp_keepalive_probes: Optional[int] = None,
        net_ipv4_tcpkeepalive_intvl: Optional[int] = None,
        net_ipv4_tcp_tw_reuse: Optional[bool] = None,
        net_ipv4_ip_local_port_range: Optional[str] = None,
        net_ipv4_neigh_default_gc_thresh1: Optional[int] = None,
        net_ipv4_neigh_default_gc_thresh2: Optional[int] = None,
        net_ipv4_neigh_default_gc_thresh3: Optional[int] = None,
        net_netfilter_nf_conntrack_max: Optional[int] = None,
        net_netfilter_nf_conntrack_buckets: Optional[int] = None,
        fs_inotify_max_user_watches: Optional[int] = None,
        fs_file_max: Optional[int] = None,
        fs_aio_max_nr: Optional[int] = None,
        fs_nr_open: Optional[int] = None,
        kernel_threads_max: Optional[int] = None,
        vm_max_map_count: Optional[int] = None,
        vm_swappiness: Optional[int] = None,
        vm_vfs_cache_pressure: Optional[int] = None,
        **kwargs
    ):
        super(SysctlConfig, self).__init__(**kwargs)
        self.net_core_somaxconn = net_core_somaxconn
        self.net_core_netdev_max_backlog = net_core_netdev_max_backlog
        self.net_core_rmem_default = net_core_rmem_default
        self.net_core_rmem_max = net_core_rmem_max
        self.net_core_wmem_default = net_core_wmem_default
        self.net_core_wmem_max = net_core_wmem_max
        self.net_core_optmem_max = net_core_optmem_max
        self.net_ipv4_tcp_max_syn_backlog = net_ipv4_tcp_max_syn_backlog
        self.net_ipv4_tcp_max_tw_buckets = net_ipv4_tcp_max_tw_buckets
        self.net_ipv4_tcp_fin_timeout = net_ipv4_tcp_fin_timeout
        self.net_ipv4_tcp_keepalive_time = net_ipv4_tcp_keepalive_time
        self.net_ipv4_tcp_keepalive_probes = net_ipv4_tcp_keepalive_probes
        self.net_ipv4_tcpkeepalive_intvl = net_ipv4_tcpkeepalive_intvl
        self.net_ipv4_tcp_tw_reuse = net_ipv4_tcp_tw_reuse
        self.net_ipv4_ip_local_port_range = net_ipv4_ip_local_port_range
        self.net_ipv4_neigh_default_gc_thresh1 = net_ipv4_neigh_default_gc_thresh1
        self.net_ipv4_neigh_default_gc_thresh2 = net_ipv4_neigh_default_gc_thresh2
        self.net_ipv4_neigh_default_gc_thresh3 = net_ipv4_neigh_default_gc_thresh3
        self.net_netfilter_nf_conntrack_max = net_netfilter_nf_conntrack_max
        self.net_netfilter_nf_conntrack_buckets = net_netfilter_nf_conntrack_buckets
        self.fs_inotify_max_user_watches = fs_inotify_max_user_watches
        self.fs_file_max = fs_file_max
        self.fs_aio_max_nr = fs_aio_max_nr
        self.fs_nr_open = fs_nr_open
        self.kernel_threads_max = kernel_threads_max
        self.vm_max_map_count = vm_max_map_count
        self.vm_swappiness = vm_swappiness
        self.vm_vfs_cache_pressure = vm_vfs_cache_pressure


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.containerservice.v2021_09_01.models.CreatedByType
    :param created_at: The UTC timestamp of resource creation.
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.containerservice.v2021_09_01.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the resource.
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class TimeInWeek(msrest.serialization.Model):
    """Time in a week.

    :param day: The day of the week. Possible values include: "Sunday", "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday".
    :type day: str or ~azure.mgmt.containerservice.v2021_09_01.models.WeekDay
    :param hour_slots: Each integer hour represents a time range beginning at 0m after the hour
     ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00
     UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
    :type hour_slots: list[int]
    """

    _attribute_map = {
        'day': {'key': 'day', 'type': 'str'},
        'hour_slots': {'key': 'hourSlots', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        day: Optional[Union[str, "WeekDay"]] = None,
        hour_slots: Optional[List[int]] = None,
        **kwargs
    ):
        super(TimeInWeek, self).__init__(**kwargs)
        self.day = day
        self.hour_slots = hour_slots


class TimeSpan(msrest.serialization.Model):
    """For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.

    :param start: The start of a time span.
    :type start: ~datetime.datetime
    :param end: The end of a time span.
    :type end: ~datetime.datetime
    """

    _attribute_map = {
        'start': {'key': 'start', 'type': 'iso-8601'},
        'end': {'key': 'end', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        start: Optional[datetime.datetime] = None,
        end: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(TimeSpan, self).__init__(**kwargs)
        self.start = start
        self.end = end


class WindowsGmsaProfile(msrest.serialization.Model):
    """Windows gMSA Profile in the managed cluster.

    :param enabled: Specifies whether to enable Windows gMSA in the managed cluster.
    :type enabled: bool
    :param dns_server: Specifies the DNS server for Windows gMSA. :code:`<br>`:code:`<br>` Set it
     to empty if you have configured the DNS server in the vnet which is used to create the managed
     cluster.
    :type dns_server: str
    :param root_domain_name: Specifies the root domain name for Windows gMSA.
     :code:`<br>`:code:`<br>` Set it to empty if you have configured the DNS server in the vnet
     which is used to create the managed cluster.
    :type root_domain_name: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'dns_server': {'key': 'dnsServer', 'type': 'str'},
        'root_domain_name': {'key': 'rootDomainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        dns_server: Optional[str] = None,
        root_domain_name: Optional[str] = None,
        **kwargs
    ):
        super(WindowsGmsaProfile, self).__init__(**kwargs)
        self.enabled = enabled
        self.dns_server = dns_server
        self.root_domain_name = root_domain_name
