# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AzureResourceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the Azure resource the hostname is assigned to.
    """

    WEBSITE = "Website"
    TRAFFIC_MANAGER = "TrafficManager"

class CustomHostNameDnsRecordType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the DNS record.
    """

    C_NAME = "CName"
    A = "A"

class DnsType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current DNS type
    """

    AZURE_DNS = "AzureDns"
    DEFAULT_DOMAIN_REGISTRAR_DNS = "DefaultDomainRegistrarDns"

class DomainPatchResourcePropertiesDomainNotRenewableReasonsItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    REGISTRATION_STATUS_NOT_SUPPORTED_FOR_RENEWAL = "RegistrationStatusNotSupportedForRenewal"
    EXPIRATION_NOT_IN_RENEWAL_TIME_RANGE = "ExpirationNotInRenewalTimeRange"
    SUBSCRIPTION_NOT_ACTIVE = "SubscriptionNotActive"

class DomainPropertiesDomainNotRenewableReasonsItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    REGISTRATION_STATUS_NOT_SUPPORTED_FOR_RENEWAL = "RegistrationStatusNotSupportedForRenewal"
    EXPIRATION_NOT_IN_RENEWAL_TIME_RANGE = "ExpirationNotInRenewalTimeRange"
    SUBSCRIPTION_NOT_ACTIVE = "SubscriptionNotActive"

class DomainStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Domain registration status.
    """

    ACTIVE = "Active"
    AWAITING = "Awaiting"
    CANCELLED = "Cancelled"
    CONFISCATED = "Confiscated"
    DISABLED = "Disabled"
    EXCLUDED = "Excluded"
    EXPIRED = "Expired"
    FAILED = "Failed"
    HELD = "Held"
    LOCKED = "Locked"
    PARKED = "Parked"
    PENDING = "Pending"
    RESERVED = "Reserved"
    REVERTED = "Reverted"
    SUSPENDED = "Suspended"
    TRANSFERRED = "Transferred"
    UNKNOWN = "Unknown"
    UNLOCKED = "Unlocked"
    UNPARKED = "Unparked"
    UPDATED = "Updated"
    JSON_CONVERTER_FAILED = "JsonConverterFailed"

class DomainType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Valid values are Regular domain: Azure will charge the full price of domain registration,
    SoftDeleted: Purchasing this domain will simply restore it and this operation will not cost
    anything.
    """

    REGULAR = "Regular"
    SOFT_DELETED = "SoftDeleted"

class HostNameType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the hostname.
    """

    VERIFIED = "Verified"
    MANAGED = "Managed"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Domain provisioning state.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    IN_PROGRESS = "InProgress"
    DELETING = "Deleting"
