# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from azure.core.exceptions import HttpResponseError


class DetectedLanguage(Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Long name of a detected language (e.g. English,
     French).
    :type name: str
    :param iso6391_name: Required. A two letter representation of the detected
     language according to the ISO 639-1 standard (e.g. en, fr).
    :type iso6391_name: str
    :param score: Required. A confidence score between 0 and 1. Scores close
     to 1 indicate 100% certainty that the identified language is true.
    :type score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'score': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'iso6391_name': {'key': 'iso6391Name', 'type': 'str'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(DetectedLanguage, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.iso6391_name = kwargs.get('iso6391_name', None)
        self.score = kwargs.get('score', None)


class DocumentEntities(Model):
    """DocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Recognized entities in the document.
    :type entities: list[~azure.ai.textanalytics.models.Entity]
    :param statistics: if showStats=true was specified in the request this
     field will contain information about the document payload.
    :type statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(self, **kwargs):
        super(DocumentEntities, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.entities = kwargs.get('entities', None)
        self.statistics = kwargs.get('statistics', None)


class DocumentError(Model):
    """DocumentError.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Document Id.
    :type id: str
    :param error: Required. Document Error.
    :type error: ~azure.ai.textanalytics.models.TextAnalyticsError
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(self, **kwargs):
        super(DocumentError, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.error = kwargs.get('error', None)


class DocumentKeyPhrases(Model):
    """DocumentKeyPhrases.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param key_phrases: Required. A list of representative words or phrases.
     The number of key phrases returned is proportional to the number of words
     in the input document.
    :type key_phrases: list[str]
    :param statistics: if showStats=true was specified in the request this
     field will contain information about the document payload.
    :type statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'key_phrases': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key_phrases': {'key': 'keyPhrases', 'type': '[str]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(self, **kwargs):
        super(DocumentKeyPhrases, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.key_phrases = kwargs.get('key_phrases', None)
        self.statistics = kwargs.get('statistics', None)


class DocumentLanguage(Model):
    """DocumentLanguage.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param detected_languages: Required. A list of extracted languages.
    :type detected_languages:
     list[~azure.ai.textanalytics.models.DetectedLanguage]
    :param statistics: if showStats=true was specified in the request this
     field will contain information about the document payload.
    :type statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'detected_languages': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'detected_languages': {'key': 'detectedLanguages', 'type': '[DetectedLanguage]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(self, **kwargs):
        super(DocumentLanguage, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.detected_languages = kwargs.get('detected_languages', None)
        self.statistics = kwargs.get('statistics', None)


class DocumentLinkedEntities(Model):
    """DocumentLinkedEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Recognized well-known entities in the document.
    :type entities: list[~azure.ai.textanalytics.models.LinkedEntity]
    :param statistics: if showStats=true was specified in the request this
     field will contain information about the document payload.
    :type statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[LinkedEntity]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(self, **kwargs):
        super(DocumentLinkedEntities, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.entities = kwargs.get('entities', None)
        self.statistics = kwargs.get('statistics', None)


class DocumentSentiment(Model):
    """DocumentSentiment.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param sentiment: Required. Predicted sentiment for document (Negative,
     Neutral, Positive, or Mixed). Possible values include: 'positive',
     'neutral', 'negative', 'mixed'
    :type sentiment: str or
     ~azure.ai.textanalytics.models.DocumentSentimentValue
    :param statistics:
    :type statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :param document_scores: Required. Document level sentiment confidence
     scores between 0 and 1 for each sentiment class.
    :type document_scores:
     ~azure.ai.textanalytics.models.SentimentConfidenceScorePerLabel
    :param sentences: Required. Sentence level sentiment analysis.
    :type sentences: list[~azure.ai.textanalytics.models.SentenceSentiment]
    """

    _validation = {
        'id': {'required': True},
        'sentiment': {'required': True},
        'document_scores': {'required': True},
        'sentences': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'DocumentSentimentValue'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'document_scores': {'key': 'documentScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'sentences': {'key': 'sentences', 'type': '[SentenceSentiment]'},
    }

    def __init__(self, **kwargs):
        super(DocumentSentiment, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.sentiment = kwargs.get('sentiment', None)
        self.statistics = kwargs.get('statistics', None)
        self.document_scores = kwargs.get('document_scores', None)
        self.sentences = kwargs.get('sentences', None)


class DocumentStatistics(Model):
    """if showStats=true was specified in the request this field will contain
    information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :param characters_count: Required. Number of text elements recognized in
     the document.
    :type characters_count: int
    :param transactions_count: Required. Number of transactions for the
     document.
    :type transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'characters_count': {'key': 'charactersCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DocumentStatistics, self).__init__(**kwargs)
        self.characters_count = kwargs.get('characters_count', None)
        self.transactions_count = kwargs.get('transactions_count', None)


class EntitiesResult(Model):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document
    :type documents: list[~azure.ai.textanalytics.models.DocumentEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.models.DocumentError]
    :param statistics:
    :type statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used
     for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntitiesResult, self).__init__(**kwargs)
        self.documents = kwargs.get('documents', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs.get('model_version', None)


class Entity(Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param type: Required. Entity type, such as Person/Location/Org/SSN etc
    :type type: str
    :param subtype: Entity sub type, such as Age/Year/TimeRange etc
    :type subtype: str
    :param offset: Required. Start position (in Unicode characters) for the
     entity text.
    :type offset: int
    :param length: Required. Length (in Unicode characters) for the entity
     text.
    :type length: int
    :param score: Required. Confidence score between 0 and 1 of the extracted
     entity.
    :type score: float
    """

    _validation = {
        'text': {'required': True},
        'type': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subtype': {'key': 'subtype', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Entity, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.type = kwargs.get('type', None)
        self.subtype = kwargs.get('subtype', None)
        self.offset = kwargs.get('offset', None)
        self.length = kwargs.get('length', None)
        self.score = kwargs.get('score', None)


class EntityLinkingResult(Model):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document
    :type documents:
     list[~azure.ai.textanalytics.models.DocumentLinkedEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.models.DocumentError]
    :param statistics:
    :type statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used
     for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLinkedEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityLinkingResult, self).__init__(**kwargs)
        self.documents = kwargs.get('documents', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs.get('model_version', None)


class InnerError(Model):
    """InnerError.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include:
     'invalidParameterValue', 'invalidRequestBodyFormat', 'emptyRequest',
     'missingInputRecords', 'invalidDocument', 'modelVersionIncorrect',
     'invalidDocumentBatch', 'unsupportedLanguageCode', 'invalidCountryHint'
    :type code: str or ~azure.ai.textanalytics.models.InnerErrorCodeValue
    :param message: Required. Error message.
    :type message: str
    :param details: Error details.
    :type details: dict[str, str]
    :param target: Error target.
    :type target: str
    :param inner_error: Inner error contains more specific information.
    :type inner_error: ~azure.ai.textanalytics.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'InnerErrorCodeValue'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
        'inner_error': {'key': 'innerError', 'type': 'InnerError'},
    }

    def __init__(self, **kwargs):
        super(InnerError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)
        self.target = kwargs.get('target', None)
        self.inner_error = kwargs.get('inner_error', None)


class KeyPhraseResult(Model):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document
    :type documents: list[~azure.ai.textanalytics.models.DocumentKeyPhrases]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.models.DocumentError]
    :param statistics:
    :type statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used
     for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentKeyPhrases]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(KeyPhraseResult, self).__init__(**kwargs)
        self.documents = kwargs.get('documents', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs.get('model_version', None)


class LanguageBatchInput(Model):
    """LanguageBatchInput.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required.
    :type documents: list[~azure.ai.textanalytics.models.LanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[LanguageInput]'},
    }

    def __init__(self, **kwargs):
        super(LanguageBatchInput, self).__init__(**kwargs)
        self.documents = kwargs.get('documents', None)


class LanguageInput(Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param text: Required.
    :type text: str
    :param country_hint:
    :type country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'country_hint': {'key': 'countryHint', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LanguageInput, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.text = kwargs.get('text', None)
        self.country_hint = kwargs.get('country_hint', None)


class LanguageResult(Model):
    """LanguageResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document
    :type documents: list[~azure.ai.textanalytics.models.DocumentLanguage]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.models.DocumentError]
    :param statistics:
    :type statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used
     for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLanguage]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LanguageResult, self).__init__(**kwargs)
        self.documents = kwargs.get('documents', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs.get('model_version', None)


class LinkedEntity(Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Entity Linking formal name.
    :type name: str
    :param matches: Required. List of instances this entity appears in the
     text.
    :type matches: list[~azure.ai.textanalytics.models.Match]
    :param language: Required. Language used in the data source.
    :type language: str
    :param id: Unique identifier of the recognized entity from the data
     source.
    :type id: str
    :param url: Required. URL for the entity's page from the data source.
    :type url: str
    :param data_source: Required. Data source used to extract entity linking,
     such as Wiki/Bing etc.
    :type data_source: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'matches': {'key': 'matches', 'type': '[Match]'},
        'language': {'key': 'language', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LinkedEntity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.matches = kwargs.get('matches', None)
        self.language = kwargs.get('language', None)
        self.id = kwargs.get('id', None)
        self.url = kwargs.get('url', None)
        self.data_source = kwargs.get('data_source', None)


class Match(Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :param score: Required. If a well-known item is recognized, a decimal
     number denoting the confidence level between 0 and 1 will be returned.
    :type score: float
    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param offset: Required. Start position (in Unicode characters) for the
     entity match text.
    :type offset: int
    :param length: Required. Length (in Unicode characters) for the entity
     match text.
    :type length: int
    """

    _validation = {
        'score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'score': {'key': 'score', 'type': 'float'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Match, self).__init__(**kwargs)
        self.score = kwargs.get('score', None)
        self.text = kwargs.get('text', None)
        self.offset = kwargs.get('offset', None)
        self.length = kwargs.get('length', None)


class MultiLanguageBatchInput(Model):
    """Contains a set of input documents to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. The set of documents to process as part of
     this batch.
    :type documents: list[~azure.ai.textanalytics.models.MultiLanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[MultiLanguageInput]'},
    }

    def __init__(self, **kwargs):
        super(MultiLanguageBatchInput, self).__init__(**kwargs)
        self.documents = kwargs.get('documents', None)


class MultiLanguageInput(Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A unique, non-empty document identifier.
    :type id: str
    :param text: Required. The input text to process.
    :type text: str
    :param language: (Optional) This is the 2 letter ISO 639-1 representation
     of a language. For example, use "en" for English; "es" for Spanish etc. If
     not set, use "en" for English as default.
    :type language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MultiLanguageInput, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.text = kwargs.get('text', None)
        self.language = kwargs.get('language', None)


class RequestStatistics(Model):
    """if showStats=true was specified in the request this field will contain
    information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :param documents_count: Required. Number of documents submitted in the
     request.
    :type documents_count: int
    :param valid_documents_count: Required. Number of valid documents. This
     excludes empty, over-size limit or non-supported languages documents.
    :type valid_documents_count: int
    :param erroneous_documents_count: Required. Number of invalid documents.
     This includes empty, over-size limit or non-supported languages documents.
    :type erroneous_documents_count: int
    :param transactions_count: Required. Number of transactions for the
     request.
    :type transactions_count: long
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'documents_count': {'key': 'documentsCount', 'type': 'int'},
        'valid_documents_count': {'key': 'validDocumentsCount', 'type': 'int'},
        'erroneous_documents_count': {'key': 'erroneousDocumentsCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(RequestStatistics, self).__init__(**kwargs)
        self.documents_count = kwargs.get('documents_count', None)
        self.valid_documents_count = kwargs.get('valid_documents_count', None)
        self.erroneous_documents_count = kwargs.get('erroneous_documents_count', None)
        self.transactions_count = kwargs.get('transactions_count', None)


class SentenceSentiment(Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :param sentiment: Required. The predicted Sentiment for the sentence.
     Possible values include: 'positive', 'neutral', 'negative'
    :type sentiment: str or
     ~azure.ai.textanalytics.models.SentenceSentimentValue
    :param sentence_scores: Required. The sentiment confidence score between 0
     and 1 for the sentence for all classes.
    :type sentence_scores:
     ~azure.ai.textanalytics.models.SentimentConfidenceScorePerLabel
    :param offset: Required. The sentence offset from the start of the
     document.
    :type offset: int
    :param length: Required. The length of the sentence by Unicode standard.
    :type length: int
    :param warnings: The warnings generated for the sentence.
    :type warnings: list[str]
    """

    _validation = {
        'sentiment': {'required': True},
        'sentence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'SentenceSentimentValue'},
        'sentence_scores': {'key': 'sentenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'warnings': {'key': 'warnings', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SentenceSentiment, self).__init__(**kwargs)
        self.sentiment = kwargs.get('sentiment', None)
        self.sentence_scores = kwargs.get('sentence_scores', None)
        self.offset = kwargs.get('offset', None)
        self.length = kwargs.get('length', None)
        self.warnings = kwargs.get('warnings', None)


class SentimentConfidenceScorePerLabel(Model):
    """Represents the confidence scores between 0 and 1 across all sentiment
    classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :param positive: Required.
    :type positive: float
    :param neutral: Required.
    :type neutral: float
    :param negative: Required.
    :type negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'neutral': {'key': 'neutral', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(SentimentConfidenceScorePerLabel, self).__init__(**kwargs)
        self.positive = kwargs.get('positive', None)
        self.neutral = kwargs.get('neutral', None)
        self.negative = kwargs.get('negative', None)


class SentimentResponse(Model):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Sentiment analysis per document.
    :type documents: list[~azure.ai.textanalytics.models.DocumentSentiment]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.models.DocumentError]
    :param statistics:
    :type statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used
     for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentSentiment]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SentimentResponse, self).__init__(**kwargs)
        self.documents = kwargs.get('documents', None)
        self.errors = kwargs.get('errors', None)
        self.statistics = kwargs.get('statistics', None)
        self.model_version = kwargs.get('model_version', None)


class TextAnalyticsError(Model):
    """TextAnalyticsError.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include:
     'invalidRequest', 'invalidArgument', 'internalServerError',
     'serviceUnavailable'
    :type code: str or ~azure.ai.textanalytics.models.ErrorCodeValue
    :param message: Required. Error message.
    :type message: str
    :param target: Error target.
    :type target: str
    :param inner_error: Inner error contains more specific information.
    :type inner_error: ~azure.ai.textanalytics.models.InnerError
    :param details: Details about specific errors that led to this reported
     error.
    :type details: list[~azure.ai.textanalytics.models.TextAnalyticsError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'ErrorCodeValue'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'inner_error': {'key': 'innerError', 'type': 'InnerError'},
        'details': {'key': 'details', 'type': '[TextAnalyticsError]'},
    }

    def __init__(self, **kwargs):
        super(TextAnalyticsError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.inner_error = kwargs.get('inner_error', None)
        self.details = kwargs.get('details', None)


class TextAnalyticsErrorException(HttpResponseError):
    """Server responsed with exception of type: 'TextAnalyticsError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, response, deserialize, *args):

      model_name = 'TextAnalyticsError'
      self.error = deserialize(model_name, response)
      if self.error is None:
          self.error = deserialize.dependencies[model_name]()
      super(TextAnalyticsErrorException, self).__init__(response=response)
