# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobProperties(Model):
    """JobProperties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param start_time: Gets or sets the job start time.
    :type start_time: datetime
    :param action: Gets or sets the job action.
    :type action: ~azure.mgmt.scheduler.models.JobAction
    :param recurrence: Gets or sets the job recurrence.
    :type recurrence: ~azure.mgmt.scheduler.models.JobRecurrence
    :param state: Gets or set the job state. Possible values include:
     'Enabled', 'Disabled', 'Faulted', 'Completed'
    :type state: str or ~azure.mgmt.scheduler.models.JobState
    :ivar status: Gets the job status.
    :vartype status: ~azure.mgmt.scheduler.models.JobStatus
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'JobAction'},
        'recurrence': {'key': 'recurrence', 'type': 'JobRecurrence'},
        'state': {'key': 'state', 'type': 'JobState'},
        'status': {'key': 'status', 'type': 'JobStatus'},
    }

    def __init__(self, *, start_time=None, action=None, recurrence=None, state=None, **kwargs) -> None:
        super(JobProperties, self).__init__(**kwargs)
        self.start_time = start_time
        self.action = action
        self.recurrence = recurrence
        self.state = state
        self.status = None
